/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.asi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.dao.assessment.AttachmentData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.qti.asi.ASIBaseClass;
import org.sakaiproject.tool.assessment.qti.constants.QTIVersion;
import org.sakaiproject.tool.assessment.qti.helper.QTIHelperFactory;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Item
extends ASIBaseClass {
    private static Log log = LogFactory.getLog(Item.class);
    private int qtiVersion;
    private ItemHelperIfc helper;
    private static final long serialVersionUID = 1L;
    private String basePath;
    private String identity;

    public Item(int qtiVersion) {
        this.initVersion(qtiVersion);
    }

    public Item(Document document, int qtiVersion) {
        super(document);
        this.initVersion(qtiVersion);
    }

    private void initVersion(int qtiVersion) {
        if (!QTIVersion.isValid((int)qtiVersion)) {
            throw new IllegalArgumentException("Invalid Item QTI version.");
        }
        this.qtiVersion = qtiVersion;
        switch (qtiVersion) {
            case 1: {
                this.basePath = "item";
                this.identity = "ident";
                break;
            }
            case 2: {
                this.basePath = "assessmentItem";
                this.identity = "identifier";
                break;
            }
            default: {
                this.basePath = "item";
                this.identity = "ident";
            }
        }
        QTIHelperFactory factory = new QTIHelperFactory();
        this.helper = factory.getItemHelperInstance(qtiVersion);
        log.debug((Object)"Item XML class.initVersion(int qtiVersion)");
        log.debug((Object)("qtiVersion=" + qtiVersion));
        log.debug((Object)("basePath=" + this.basePath));
        log.debug((Object)("identity=" + this.identity));
    }

    public void setIdent(String ident) {
        String xpath = this.basePath;
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.setAttribute(this.identity, ident);
        }
    }

    public void setTitle(String title) {
        String xpath = this.basePath;
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.setAttribute("title", Item.escapeXml(title));
        }
    }

    public void update(ItemDataIfc item) {
        if (item == null) {
            return;
        }
        this.setFieldentry("ITEM_OBJECTIVE", item.getItemMetaDataByLabel("OBJECTIVE"));
        this.setFieldentry("ITEM_KEYWORD", item.getItemMetaDataByLabel("KEYWORD"));
        this.setFieldentry("ITEM_RUBRIC", item.getItemMetaDataByLabel("RUBRIC"));
        this.setFieldentry("ATTACHMENT", this.getAttachment(item));
        if (item.getDuration() != null) {
            this.setFieldentry("TIMEALLOWED", item.getDuration().toString());
        }
        if (item.getTriesAllowed() != null) {
            this.setFieldentry("NUM_OF_ATTEMPTS", item.getTriesAllowed().toString());
        }
        if ((item.getTypeId().equals(TypeIfc.TRUE_FALSE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION)) && item.getHasRationale() != null) {
            this.setFieldentry("hasRationale", item.getHasRationale().toString());
        }
        if (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) && item.getPartialCreditFlag().booleanValue()) {
            this.setFieldentry("PARTIAL_CREDIT", "TRUE");
        } else {
            this.setFieldentry("PARTIAL_CREDIT", "FALSE");
        }
        if (!this.isSurvey() && !this.isMXSURVEY()) {
            this.helper.addMaxScore(item.getScore(), this);
            this.helper.addMinScore(item.getDiscount(), this);
        }
        if (item != null && item.getTypeId().equals(TypeIfc.FILL_IN_BLANK)) {
            this.setFieldentry("MUTUALLY_EXCLUSIVE", item.getItemMetaDataByLabel("MUTUALLY_EXCLUSIVE"));
            this.setFieldentry("CASE_SENSITIVE", item.getItemMetaDataByLabel("CASE_SENSITIVE"));
        }
        if (item != null && (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION))) {
            this.setFieldentry("RANDOMIZE", item.getItemMetaDataByLabel("RANDOMIZE"));
        }
        String instruction = item.getInstruction();
        if ((this.isMatching() || this.isFIB() || this.isFIN() || this.isMXSURVEY()) && instruction != null) {
            this.helper.setItemText(instruction, this);
        }
        ArrayList itemTexts = item.getItemTextArraySorted();
        this.setItemTexts(itemTexts);
        if (this.isTrueFalse()) {
            Boolean isTrue = item.getIsTrue();
            if (isTrue == null) {
                isTrue = Boolean.FALSE;
            }
            this.setAnswerTrueFalse(isTrue);
        } else {
            this.setAnswers(itemTexts);
        }
        this.setFeedback(itemTexts);
    }

    public void setAnswerTrueFalse(boolean isTrue) {
        log.debug((Object)("isTrue=" + isTrue));
        if (isTrue) {
            this.helper.addCorrectAnswer("A", this);
            this.helper.addIncorrectAnswer("B", this);
        } else {
            this.helper.addCorrectAnswer("B", this);
            this.helper.addIncorrectAnswer("A", this);
        }
    }

    public String getFieldentry(String fieldlabel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getFieldentry(String " + fieldlabel + ")"));
        }
        String xpath = this.helper.getMetaLabelXPath(fieldlabel);
        return super.getFieldentry(xpath);
    }

    public void setFieldentry(String fieldlabel, String setValue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setFieldentry(String " + fieldlabel + ", String " + setValue + ")"));
        }
        String xpath = this.helper.getMetaLabelXPath(fieldlabel);
        super.setFieldentry(xpath, setValue);
    }

    public void createFieldentry(String fieldlabel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createFieldentry(String " + fieldlabel + ")"));
        }
        String xpath = this.helper.getMetaXPath();
        super.createFieldentry(xpath, fieldlabel);
    }

    public String getItemType() {
        String type = this.getFieldentry("qmd_itemtype");
        return type;
    }

    public void setItemTexts(ArrayList itemTextList) {
        this.helper.setItemTexts(itemTextList, this);
    }

    public boolean isEssay() {
        boolean essay = "Short Answers/Essay".equals(this.getItemType()) || "Essay".equals(this.getItemType());
        return essay;
    }

    public boolean isSurvey() {
        return "Multiple Choice Survey".equals(this.getItemType());
    }

    public boolean isMXSURVEY() {
        return "Survey Matrix".equals(this.getItemType());
    }

    public boolean isAudio() {
        return "Audio Recording".equals(this.getItemType());
    }

    public boolean isFile() {
        return "File Upload".equals(this.getItemType());
    }

    public boolean isMatching() {
        return "Matching".equals(this.getItemType());
    }

    public boolean isFIB() {
        return "Fill In the Blank".equals(this.getItemType());
    }

    public boolean isFIN() {
        return "Numeric Response".equals(this.getItemType());
    }

    public boolean isMCMC() {
        return "Multiple Correct Answer".equals(this.getItemType());
    }

    public boolean isMCMCSS() {
        return "Multiple Correct Single Selection".equals(this.getItemType());
    }

    public boolean isMCSC() {
        return "Multiple Choice".equals(this.getItemType());
    }

    private boolean isTrueFalse() {
        return "True False".equals(this.getItemType());
    }

    public void setAnswers(ArrayList itemTextList) {
        this.helper.setAnswers(itemTextList, this);
    }

    public void setFeedback(ArrayList itemTextList) {
        this.helper.setFeedback(itemTextList, this);
    }

    public String getItemText() {
        return this.helper.getText(this);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private String getAttachment(ItemDataIfc item) {
        Set attachmentSet = item.getItemAttachmentSet();
        if (attachmentSet != null && attachmentSet.size() != 0) {
            Iterator iter = attachmentSet.iterator();
            AttachmentData attachmentData = null;
            StringBuffer attachment = new StringBuffer();
            while (iter.hasNext()) {
                attachmentData = (AttachmentData)iter.next();
                attachment.append(attachmentData.getResourceId().replaceAll(" ", ""));
                attachment.append("|");
                attachment.append(attachmentData.getFilename());
                attachment.append("|");
                attachment.append(attachmentData.getMimeType());
                attachment.append("\n");
            }
            return attachment.toString();
        }
        return null;
    }
}

