/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.qti.asi.Item;
import org.sakaiproject.tool.assessment.qti.constants.AuthoringConstantStrings;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringXml;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperBase;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;

public class ItemHelper12Impl
extends ItemHelperBase
implements ItemHelperIfc {
    private static Log log = LogFactory.getLog(ItemHelper12Impl.class);
    private static final String MATCH_XPATH = "item/presentation/flow/response_grp/render_choice";
    private static final String NBSP = "&#160;";
    protected String[] itemTypes = AuthoringConstantStrings.itemTypes;
    private AuthoringXml authoringXml;
    private List allIdents;
    private Float currentMaxScore = Float.valueOf(0.0f);
    private Float currentMinScore = Float.valueOf(0.0f);
    private float currentPerItemScore = 0.0f;
    private float currentPerItemDiscount = 0.0f;

    public ItemHelper12Impl() {
        this.authoringXml = new AuthoringXml(this.getQtiVersion());
        this.allIdents = new ArrayList();
        log.debug((Object)"ItemHelper12Impl");
    }

    protected AuthoringXml getAuthoringXml() {
        return this.authoringXml;
    }

    protected int getQtiVersion() {
        return 1;
    }

    public void addMaxScore(Float score, Item itemXml) {
        String xPath = "item/resprocessing/outcomes/decvar/@maxvalue";
        if (score == null) {
            score = Float.valueOf(0.0f);
        }
        this.currentMaxScore = score;
        this.updateItemXml(itemXml, xPath, "" + score.toString());
    }

    public void addMinScore(Float discount, Item itemXml) {
        String xPath = "item/resprocessing/outcomes/decvar/@minvalue";
        if (discount == null) {
            discount = Float.valueOf(0.0f);
        }
        this.currentMinScore = discount;
        this.updateItemXml(itemXml, xPath, "" + discount.toString());
    }

    public void addCorrectAnswer(String correctAnswerLabel, Item itemXml) {
        this.flagAnswerCorrect(correctAnswerLabel, itemXml, true);
    }

    public void addIncorrectAnswer(String incorrectAnswerLabel, Item itemXml) {
        this.flagAnswerCorrect(incorrectAnswerLabel, itemXml, false);
    }

    public void flagAnswerCorrect(String answerLabel, Item itemXml, boolean correct) {
        if (answerLabel == null) {
            answerLabel = "";
        }
        String flag = correct ? "Correct" : "InCorrect";
        String respProcBaseXPath = "item/resprocessing/respcondition";
        String respProcCondXPath = "/conditionvar/varequal";
        String respProcFeedbackXPath = "/displayfeedback/@linkrefid";
        int respSize = 0;
        List resp = itemXml.selectNodes(respProcBaseXPath);
        if (resp != null && resp.size() > 0) {
            respSize = resp.size();
        }
        for (int i = 1; i <= respSize; ++i) {
            String index = "[" + i + "]";
            String answerVar = itemXml.selectSingleValue(respProcBaseXPath + index + respProcCondXPath, "element");
            if (!answerLabel.equals(answerVar)) continue;
            String xPath = respProcBaseXPath + index + "/@title";
            String xfPath = respProcBaseXPath + index + respProcFeedbackXPath;
            this.updateItemXml(itemXml, xPath, flag);
            this.updateItemXml(itemXml, xfPath, flag);
            break;
        }
    }

    public void addResponseEntry(Item itemXml, String xpath, String value, boolean isInsert, String responseNo, String responseLabel) {
        if (isInsert) {
            String nextNode = "response_label[" + responseNo + "]";
            itemXml.insertElement(nextNode, xpath, "response_label");
            itemXml.add(xpath + "/response_label[" + responseNo + "]", "material/mattext");
        } else {
            itemXml.add(xpath, "response_label/material/mattext");
        }
        try {
            log.debug((Object)("putting CDATA around : " + value));
            if (value == null) {
                value = "";
            }
            value = XmlUtil.convertStrforCDATA(value);
            itemXml.update(xpath + "/response_label[" + responseNo + "]/material/mattext", value);
        }
        catch (Exception ex) {
            log.error((Object)("Cannot update value in addResponselEntry(): " + ex));
        }
        String newPath = xpath + "/response_label[" + responseNo + "]";
        itemXml.addAttribute(newPath, "ident");
        newPath = xpath + "/response_label[" + responseNo + "]/@ident";
        this.updateItemXml(itemXml, newPath, responseLabel);
    }

    private void addItemfeedback(Item itemXml, String value, boolean isInsert, String responseNo, String responseLabel) {
        String xpath = "item";
        String nextNode = "itemfeedback[" + responseNo + "]";
        if (isInsert) {
            itemXml.insertElement(nextNode, xpath, "itemfeedback");
            itemXml.add(xpath + "/itemfeedback[" + responseNo + "]", "flow_mat/material/mattext");
        }
        try {
            if (value == null) {
                value = "";
            }
            value = XmlUtil.convertStrforCDATA(value);
            itemXml.update(xpath + "/itemfeedback[" + responseNo + "]/flow_mat/material/mattext", value);
        }
        catch (Exception ex) {
            log.error((Object)("Cannot update value in addItemfeedback(): " + ex));
        }
        String newPath = xpath + "/itemfeedback[" + responseNo + "]";
        itemXml.addAttribute(newPath, "ident");
        newPath = xpath + "/itemfeedback[" + responseNo + "]/@ident";
        String feedbackIdent = responseLabel;
        this.updateItemXml(itemXml, newPath, feedbackIdent);
    }

    public String getMetaXPath() {
        String xpath = "item/itemmetadata/qtimetadata";
        return xpath;
    }

    public String getMetaLabelXPath(String fieldlabel) {
        String xpath = "item/itemmetadata/qtimetadata/qtimetadatafield/fieldlabel[text()='" + fieldlabel + "']/following-sibling::fieldentry";
        return xpath;
    }

    public String getText(Item itemXml) {
        String xpath = "item/presentation/flow/material/mattext";
        String itemType = itemXml.getItemType();
        if (itemType.equals("Matching")) {
            xpath = "item/presentation/flow//mattext";
        }
        return this.makeItemNodeText(itemXml, xpath);
    }

    private void setItemTextMatching(List itemTextList, Item itemXml) {
        String xpath = MATCH_XPATH;
        HashMap<String, String> allTargets = new HashMap<String, String>();
        itemXml.add(xpath, "response_label");
        String randomNumber = ("" + Math.random()).substring(2);
        Iterator iter = itemTextList.iterator();
        float itSize = itemTextList.size();
        if (itSize > 0.0f) {
            this.currentPerItemScore = this.currentMaxScore.floatValue() / itSize;
            this.currentPerItemDiscount = this.currentMinScore.floatValue();
        }
        int respCondCount = 0;
        while (iter.hasNext()) {
            ItemTextIfc itemText = (ItemTextIfc)iter.next();
            String text = itemText.getText();
            Long sequence = itemText.getSequence();
            String responseLabelIdent = "MS-" + randomNumber + "-" + sequence;
            ArrayList answerList = itemText.getAnswerArray();
            Iterator aiter = answerList.iterator();
            int noSources = answerList.size();
            while (aiter.hasNext()) {
                ++respCondCount;
                AnswerIfc answer = (AnswerIfc)aiter.next();
                String answerText = answer.getText();
                String label = answer.getLabel();
                Long answerSequence = answer.getSequence();
                Boolean correct = answer.getIsCorrect();
                String responseFeedback = "";
                responseFeedback = correct != false ? answer.getAnswerFeedback("Correct Feedback") : answer.getAnswerFeedback("InCorrect Feedback");
                if (responseFeedback == null) {
                    responseFeedback = "";
                }
                String responseNo = "" + (answerSequence - (long)noSources + 1L);
                String respIdent = "MT-" + randomNumber + "-" + label;
                String respCondNo = "" + respCondCount;
                responseFeedback = XmlUtil.convertStrforCDATA(responseFeedback);
                if (Boolean.TRUE.equals(correct)) {
                    log.debug((Object)"Matching: matched.");
                    this.allIdents.add(respIdent);
                    allTargets.put(respIdent, answerText);
                    this.addMatchingRespcondition(true, itemXml, respCondNo, respIdent, responseLabelIdent, responseFeedback);
                    continue;
                }
                log.debug((Object)"Matching: NOT matched.");
                this.addMatchingRespcondition(false, itemXml, respCondNo, respIdent, responseLabelIdent, responseFeedback);
            }
            String responseNo = "" + sequence;
            this.addMatchingResponseLabelSource(itemXml, responseNo, responseLabelIdent, text, 1);
        }
        for (int i = 0; i < this.allIdents.size(); ++i) {
            String respIdent = (String)this.allIdents.get(i);
            String answerText = (String)allTargets.get(respIdent);
            String responseNo = "" + (i + 1);
            this.addMatchingResponseLabelTarget(itemXml, responseNo, respIdent, answerText);
        }
        this.updateAllSourceMatchGroup(itemXml);
    }

    private void setItemTextMatrix(List itemTextList, Item itemXml) {
        ItemTextIfc itemText;
        String xpath = MATCH_XPATH;
        HashMap allTargets = new HashMap();
        itemXml.add(xpath, "response_label");
        String randomNumber = ("" + Math.random()).substring(2);
        Iterator iter = itemTextList.iterator();
        float itSize = itemTextList.size();
        while (iter.hasNext()) {
            itemText = (ItemTextIfc)iter.next();
            String text = itemText.getText();
            Long sequence = itemText.getSequence();
            String responseIdent = "MT-" + randomNumber + "-" + sequence;
            String responseNo = "" + (sequence + 1L);
            this.addMatchingResponseLabelTarget(itemXml, responseNo, responseIdent, text);
        }
        if (itemTextList.size() > 0) {
            itemText = (ItemTextIfc)itemTextList.get(0);
            ArrayList answerList = itemText.getAnswerArray();
            int numTexts = itemTextList.size();
            int matchmax = itemTextList.size();
            if (matchmax < 2) {
                matchmax = 2;
            }
            for (int i = 0; i < answerList.size(); ++i) {
                AnswerIfc answer = (AnswerIfc)answerList.get(i);
                String answerText = answer.getText();
                String responseNo = "" + (answer.getSequence() + (long)numTexts + 1L);
                String responseIdent = "MS-" + randomNumber + "-" + responseNo;
                this.addMatchingResponseLabelSource(itemXml, responseNo, responseIdent, answerText, matchmax);
            }
        }
        this.updateAllSourceMatchGroup(itemXml);
    }

    private void setItemTextFIB(String fibAns, Item itemXml) {
        if (fibAns != null && fibAns.trim().length() > 0) {
            List fibList = ItemHelper12Impl.parseFillInBlank(fibAns);
            Map valueMap = null;
            String mattext = null;
            String respStr = null;
            String xpath = "item/presentation/flow/flow";
            if (fibList != null && fibList.size() > 0) {
                for (int i = 0; i < fibList.size(); ++i) {
                    String newXpath;
                    valueMap = (Map)fibList.get(i);
                    if (valueMap == null || valueMap.size() <= 0) continue;
                    mattext = (String)valueMap.get("text");
                    if ((mattext = XmlUtil.convertStrforCDATA(mattext)) != null) {
                        itemXml.add(xpath, "material/mattext");
                        newXpath = xpath + "/material[" + Integer.toString(i + 1) + "]/mattext";
                        this.updateItemXml(itemXml, newXpath, mattext);
                    }
                    if ((respStr = (String)valueMap.get("ans")) == null) continue;
                    itemXml.add(xpath, "response_str/render_fib");
                    newXpath = xpath + "/response_str[" + Integer.toString(i + 1) + "]";
                    itemXml.addAttribute(newXpath, "ident");
                    String ident = "FIB0" + i;
                    this.updateItemXml(itemXml, newXpath + "/@ident", ident);
                    itemXml.addAttribute(newXpath, "rcardinality");
                    this.updateItemXml(itemXml, newXpath + "/@rcardinality", "Ordered");
                    newXpath = newXpath + "/render_fib";
                    itemXml.addAttribute(newXpath, "fibtype");
                    this.updateItemXml(itemXml, newXpath + "/@fibtype", "String");
                    itemXml.addAttribute(newXpath, "prompt");
                    this.updateItemXml(itemXml, newXpath + "/@prompt", "Box");
                    itemXml.addAttribute(newXpath, "columns");
                    this.updateItemXml(itemXml, newXpath + "/@columns", Integer.toString(respStr.length() + 5));
                    itemXml.addAttribute(newXpath, "rows");
                    this.updateItemXml(itemXml, newXpath + "/@rows", "1");
                    this.allIdents.add(ident);
                }
            }
        }
    }

    private static String padFibWithNonbreakSpacesText(String fib) {
        if (fib.startsWith("{")) {
            fib = NBSP + fib;
        }
        return fib.replaceAll("\\}\\{", "}&#160;{");
    }

    private Item addFIBRespconditionNotMutuallyExclusive(Item itemXml, String responseCondNo, String respIdent, String points, String[] responses) {
        String xpath = "item/resprocessing";
        itemXml.add(xpath, "respcondition");
        String respCond = "item/resprocessing/respcondition[" + responseCondNo + "]";
        itemXml.addAttribute(respCond, "continue");
        this.updateItemXml(itemXml, respCond + "/@continue", "Yes");
        String or = "";
        itemXml.add(respCond, "conditionvar/or");
        or = respCond + "/conditionvar/or";
        for (int i = 0; i < responses.length; ++i) {
            itemXml.add(or, "varequal");
            int iString = i + 1;
            String varequal = or + "/varequal[" + iString + "]";
            itemXml.addAttribute(varequal, "case");
            itemXml.addAttribute(varequal, "respident");
            this.updateItemXml(itemXml, varequal + "/@case", "No");
            this.updateItemXml(itemXml, varequal + "/@respident", respIdent);
            String wrapcdata_response = XmlUtil.convertStrforCDATA(responses[i]);
            this.updateItemXml(itemXml, varequal, wrapcdata_response);
        }
        itemXml.add(respCond, "setvar");
        itemXml.addAttribute(respCond + "/setvar", "action");
        this.updateItemXml(itemXml, respCond + "/setvar/@action", "Add");
        itemXml.addAttribute(respCond + "/setvar", "varname");
        this.updateItemXml(itemXml, respCond + "/setvar/@varname", "SCORE");
        this.updateItemXml(itemXml, respCond + "/setvar", points);
        return itemXml;
    }

    private void setItemTextFIN(String finAns, Item itemXml) {
        if (finAns != null && finAns.trim().length() > 0) {
            List finList = ItemHelper12Impl.parseFillInNumeric(finAns);
            Map valueMap = null;
            Object newSet = null;
            String mattext = null;
            String respStr = null;
            String xpath = "item/presentation/flow/flow";
            Object position = null;
            Object responses = null;
            if (finList != null && finList.size() > 0) {
                ArrayList idsAndResponses = new ArrayList();
                for (int i = 0; i < finList.size(); ++i) {
                    String newXpath;
                    valueMap = (Map)finList.get(i);
                    if (valueMap == null || valueMap.size() <= 0) continue;
                    mattext = (String)valueMap.get("text");
                    if ((mattext = XmlUtil.convertStrforCDATA(mattext)) != null) {
                        itemXml.add(xpath, "material/mattext");
                        newXpath = xpath + "/material[" + Integer.toString(i + 1) + "]/mattext";
                        this.updateItemXml(itemXml, newXpath, mattext);
                    }
                    if ((respStr = (String)valueMap.get("ans")) == null) continue;
                    itemXml.add(xpath, "response_str/render_fin");
                    newXpath = xpath + "/response_str[" + Integer.toString(i + 1) + "]";
                    itemXml.addAttribute(newXpath, "ident");
                    String ident = "FIN0" + i;
                    this.updateItemXml(itemXml, newXpath + "/@ident", ident);
                    itemXml.addAttribute(newXpath, "rcardinality");
                    this.updateItemXml(itemXml, newXpath + "/@rcardinality", "Ordered");
                    newXpath = newXpath + "/render_fin";
                    itemXml.addAttribute(newXpath, "fintype");
                    this.updateItemXml(itemXml, newXpath + "/@fintype", "String");
                    itemXml.addAttribute(newXpath, "prompt");
                    this.updateItemXml(itemXml, newXpath + "/@prompt", "Box");
                    itemXml.addAttribute(newXpath, "columns");
                    this.updateItemXml(itemXml, newXpath + "/@columns", Integer.toString(respStr.length() + 5));
                    itemXml.addAttribute(newXpath, "rows");
                    this.updateItemXml(itemXml, newXpath + "/@rows", "1");
                    this.allIdents.add(ident);
                }
            }
        }
    }

    private static String padFinWithNonbreakSpacesText(String fin) {
        if (fin.startsWith("{")) {
            fin = NBSP + fin;
        }
        return fin.replaceAll("\\}\\{", "}&#160;{");
    }

    private Item addFINRespconditionNotMutuallyExclusive(Item itemXml, String responseCondNo, String respIdent, String points, String[] responses) {
        String xpath = "item/resprocessing";
        itemXml.add(xpath, "respcondition");
        String respCond = "item/resprocessing/respcondition[" + responseCondNo + "]";
        itemXml.addAttribute(respCond, "continue");
        this.updateItemXml(itemXml, respCond + "/@continue", "Yes");
        String or = "";
        itemXml.add(respCond, "conditionvar/or");
        or = respCond + "/conditionvar/or";
        for (int i = 0; i < responses.length; ++i) {
            itemXml.add(or, "varequal");
            int iString = i + 1;
            String varequal = or + "/varequal[" + iString + "]";
            itemXml.addAttribute(varequal, "case");
            itemXml.addAttribute(varequal, "respident");
            this.updateItemXml(itemXml, varequal + "/@case", "No");
            this.updateItemXml(itemXml, varequal + "/@respident", respIdent);
            String wrapcdata_response = XmlUtil.convertStrforCDATA(responses[i]);
            this.updateItemXml(itemXml, varequal, wrapcdata_response);
        }
        itemXml.add(respCond, "setvar");
        itemXml.addAttribute(respCond + "/setvar", "action");
        this.updateItemXml(itemXml, respCond + "/setvar/@action", "Add");
        itemXml.addAttribute(respCond + "/setvar", "varname");
        this.updateItemXml(itemXml, respCond + "/setvar/@varname", "SCORE");
        this.updateItemXml(itemXml, respCond + "/setvar", points);
        return itemXml;
    }

    private static List parseFillInBlank(String input) {
        input = ItemHelper12Impl.padFibWithNonbreakSpacesText(input);
        HashMap<String, String> tempMap = null;
        ArrayList storeParts = new ArrayList();
        if (input == null) {
            return storeParts;
        }
        StringTokenizer st = new StringTokenizer(input, "}");
        String tempToken = "";
        String[] splitArray = null;
        while (st.hasMoreTokens()) {
            tempToken = st.nextToken();
            tempMap = new HashMap<String, String>();
            splitArray = tempToken.trim().split("\\{", 2);
            tempMap.put("text", splitArray[0].trim());
            if (splitArray.length > 1) {
                tempMap.put("ans", splitArray[1]);
            } else {
                tempMap.put("ans", null);
            }
            storeParts.add(tempMap);
        }
        return storeParts;
    }

    private static List parseFillInNumeric(String input) {
        input = ItemHelper12Impl.padFinWithNonbreakSpacesText(input);
        HashMap<String, String> tempMap = null;
        ArrayList storeParts = new ArrayList();
        if (input == null) {
            return storeParts;
        }
        StringTokenizer st = new StringTokenizer(input, "}");
        String tempToken = "";
        String[] splitArray = null;
        while (st.hasMoreTokens()) {
            tempToken = st.nextToken();
            tempMap = new HashMap<String, String>();
            splitArray = tempToken.trim().split("\\{", 2);
            tempMap.put("text", splitArray[0].trim());
            if (splitArray.length > 1) {
                tempMap.put("ans", splitArray[1]);
            } else {
                tempMap.put("ans", null);
            }
            storeParts.add(tempMap);
        }
        return storeParts;
    }

    public void setItemText(String itemText, Item itemXml) {
        String xpath = "item/presentation/flow/material/mattext";
        List list = itemXml.selectNodes(xpath);
        log.debug((Object)("in ItemHelper12Impl.java: setItemText() text = " + itemText));
        itemText = XmlUtil.convertStrforCDATA(itemText);
        log.debug((Object)("in ItemHelperBase.java: setItemText() wrapped CDATA text is = " + itemText));
        try {
            itemXml.update(xpath, itemText);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setItemTexts(ArrayList itemTextList, Item itemXml) {
        if (itemTextList.size() < 1) {
            return;
        }
        if (itemXml.isMatching()) {
            this.setItemTextMatching(itemTextList, itemXml);
            return;
        }
        if (itemXml.isMXSURVEY()) {
            this.setItemTextMatrix(itemTextList, itemXml);
            return;
        }
        String text = ((ItemTextIfc)itemTextList.get(0)).getText();
        if (itemXml.isFIB()) {
            this.setItemTextFIB(text, itemXml);
            return;
        }
        if (itemXml.isFIN()) {
            this.setItemTextFIN(text, itemXml);
            return;
        }
        this.setItemText(text, itemXml);
    }

    public String getItemType(Item itemXml) {
        String type = itemXml.getFieldentry("qmd_itemtype");
        return type;
    }

    public void setAnswers(ArrayList itemTextList, Item itemXml) {
        log.debug((Object)"entered setAnswers()");
        log.debug((Object)("size=" + itemTextList.size()));
        if (!(itemXml.isFIB() || itemXml.isMCSC() || itemXml.isFIN() || itemXml.isMCMC() || itemXml.isMCMCSS() || itemXml.isEssay() || itemXml.isSurvey())) {
            return;
        }
        String xpath = "item/presentation/flow/response_lid/render_choice";
        List list = itemXml.selectNodes(xpath);
        Iterator nodeIter = list.iterator();
        Iterator iter = itemTextList.iterator();
        Set answerSet = new HashSet();
        char label = 'A';
        int xpathIndex = 1;
        int respIdentCount = 0;
        while (iter.hasNext()) {
            answerSet = ((ItemTextIfc)iter.next()).getAnswerSet();
            log.debug((Object)("answersize=" + answerSet.size()));
            for (AnswerIfc answer : answerSet) {
                String[] responses;
                if (Boolean.TRUE.equals(answer.getIsCorrect())) {
                    this.addCorrectAnswer("" + label, itemXml);
                }
                String value = answer.getText();
                log.debug((Object)("\n\n***The answer is: " + value));
                if (itemXml.isFIB()) {
                    responses = new String[]{value};
                    String respIdent = (String)this.allIdents.get(respIdentCount++);
                    this.addFIBRespconditionNotMutuallyExclusive(itemXml, "" + xpathIndex, respIdent, "0", responses);
                    label = (char)(label + '\u0001');
                    ++xpathIndex;
                    continue;
                }
                if (itemXml.isFIN()) {
                    responses = new String[]{value};
                    String respIdent = (String)this.allIdents.get(respIdentCount++);
                    this.addFINRespconditionNotMutuallyExclusive(itemXml, "" + xpathIndex, respIdent, "0", responses);
                    label = (char)(label + '\u0001');
                    ++xpathIndex;
                    continue;
                }
                Object node = null;
                try {
                    boolean isInsert = true;
                    if (nodeIter.hasNext()) {
                        isInsert = false;
                    }
                    this.addResponseEntry(itemXml, xpath, value, isInsert, "" + xpathIndex, "" + label);
                }
                catch (Exception ex) {
                    log.error((Object)"Cannot process source document.", (Throwable)ex);
                }
                label = (char)(label + '\u0001');
                ++xpathIndex;
            }
        }
    }

    public void setFeedback(ArrayList itemTextList, Item itemXml) {
        boolean hasAnswerLevelFeedback = itemXml.isMCMC() || itemXml.isMCSC() || itemXml.isMCMCSS();
        String xpath = "item/itemfeedback/flow/response_lid/render_choice";
        int xpathIndex = 1;
        List list = itemXml.selectNodes(xpath);
        Iterator nodeIter = list.iterator();
        Iterator iter = itemTextList.iterator();
        Set answerSet = new HashSet();
        char label = 'A';
        boolean first = true;
        while (iter.hasNext()) {
            ItemTextIfc itemTextIfc = (ItemTextIfc)iter.next();
            if (first) {
                this.addCorrectAndIncorrectFeedback(itemXml, itemTextIfc);
                xpathIndex = 1;
                first = false;
            }
            if (hasAnswerLevelFeedback) {
                log.debug((Object)"Setting answer level feedback");
                answerSet = itemTextIfc.getAnswerSet();
                log.debug((Object)("answerSet.size(): " + answerSet.size()));
                for (AnswerIfc answer : answerSet) {
                    String value = answer.getGeneralAnswerFeedback();
                    boolean isInsert = true;
                    if (nodeIter.hasNext()) {
                        isInsert = false;
                    }
                    if (itemXml.isMCSC()) {
                        if (answer.getIsCorrect().booleanValue()) {
                            answer.setPartialCredit(Float.valueOf(100.0f));
                        }
                        if (answer.getItem().getPartialCreditFlag().booleanValue()) {
                            Float partialCredit = Float.valueOf(100.0f);
                            try {
                                partialCredit = Float.valueOf(answer.getItem().getScore().floatValue() * answer.getPartialCredit().floatValue() / 100.0f);
                            }
                            catch (Exception e) {
                                log.error((Object)("Could not compute partial value for id: " + answer.getId()));
                            }
                            this.addAnswerFeedbackPartialCredit(itemXml, value, isInsert, xpathIndex, "" + label, partialCredit);
                        }
                    } else {
                        this.addAnswerFeedback(itemXml, value, isInsert, xpathIndex, "" + label);
                    }
                    label = (char)(label + 1);
                    ++xpathIndex;
                }
            }
            this.addGeneralFeedback(itemXml, xpathIndex, itemTextIfc);
        }
    }

    private void addCorrectAndIncorrectFeedback(Item itemXml, ItemTextIfc itemTextIfc) {
        String correctFeedback = itemTextIfc.getItem().getCorrectItemFeedback();
        String incorrectFeedback = itemTextIfc.getItem().getInCorrectItemFeedback();
        log.debug((Object)("CORRECT FEEDBACK: " + correctFeedback));
        if (correctFeedback != null) {
            this.addItemfeedback(itemXml, correctFeedback, false, "1", "Correct");
        }
        log.debug((Object)("INCORRECT FEEDBACK: " + incorrectFeedback));
        if (incorrectFeedback != null) {
            this.addItemfeedback(itemXml, incorrectFeedback, false, "2", "InCorrect");
        }
    }

    private void addGeneralFeedback(Item itemXml, int xpathIndex, ItemTextIfc itemTextIfc) {
        log.debug((Object)"\nDebug add in General Feedback");
        String generalFeedback = itemTextIfc.getItem().getGeneralItemFeedback();
        String itemId = itemTextIfc.getItem().getItemIdString();
        if (generalFeedback != null) {
            this.addItemfeedback(itemXml, generalFeedback, true, "" + xpathIndex++, itemId);
        }
    }

    private void addAnswerFeedback(Item itemXml, String value, boolean isInsert, int responseNo, String responseLabel) {
        log.debug((Object)"addAnswerFeedback()");
        log.debug((Object)("answer feedback value: " + value));
        value = value == null ? "<![CDATA[]]>" : XmlUtil.convertStrforCDATA(value);
        String respCond = "item/resprocessing/respcondition[" + responseNo + "]";
        this.updateItemXml(itemXml, respCond + "/setvar", "" + this.currentPerItemScore);
        this.updateItemXml(itemXml, respCond + "/displayfeedback[2]/@linkrefid", "AnswerFeedback");
        this.updateItemXml(itemXml, respCond + "/displayfeedback[2]", value);
    }

    private void addMatchingResponseLabelTarget(Item itemXml, String responseNo, String respIdent, String value) {
        String xpath = MATCH_XPATH;
        this.insertResponseLabelMattext(itemXml, responseNo, value, xpath);
        String newPath = xpath + "/response_label[" + responseNo + "]";
        itemXml.addAttribute(newPath, "ident");
        newPath = xpath + "/response_label[" + responseNo + "]/@ident";
        this.updateItemXml(itemXml, newPath, respIdent);
    }

    private void addMatchingResponseLabelSource(Item itemXml, String responseNo, String responseLabelIdent, String value, int matchMax) {
        String xpath = MATCH_XPATH;
        this.insertResponseLabelMattext(itemXml, responseNo, value, xpath);
        itemXml.addAttribute(xpath + "/response_label[" + responseNo + "]", "match_max");
        itemXml.addAttribute(xpath + "/response_label[" + responseNo + "]", "match_group");
        this.updateItemXml(itemXml, xpath + "/response_label[" + responseNo + "]" + "/@match_max", Integer.toString(matchMax));
        String newPath = xpath + "/response_label[" + responseNo + "]";
        itemXml.addAttribute(newPath, "ident");
        newPath = xpath + "/response_label[" + responseNo + "]/@ident";
        this.updateItemXml(itemXml, newPath, responseLabelIdent);
    }

    private void insertResponseLabelMattext(Item itemXml, String responseNo, String value, String xpath) {
        String nextNode = "response_label[" + responseNo + "]";
        itemXml.insertElement(nextNode, xpath, "response_label");
        itemXml.add(xpath + "/response_label[" + responseNo + "]", "material/mattext");
        try {
            log.debug((Object)("in ItemHelper12Impl.java: insertResponseLabelMattext() text = " + value));
            value = XmlUtil.convertStrforCDATA(value);
            log.debug((Object)("in ItemHelperBase.java: insertResponseLabelMattext() wrapped CDATA text is = " + value));
            itemXml.update(xpath + "/response_label[" + responseNo + "]/material/mattext", value);
        }
        catch (Exception ex) {
            log.warn((Object)("Unable to set mattext in '" + xpath + "/response_label[" + responseNo + "]' to '" + value + "'"));
        }
    }

    private void addMatchingRespcondition(boolean correct, Item itemXml, String responseNo, String respident, String responseLabelIdent, String responseFeedback) {
        String xpath = "item/resprocessing";
        itemXml.add(xpath, "respcondition/conditionvar/varequal");
        String respCond = "item/resprocessing/respcondition[" + responseNo + "]";
        itemXml.addAttribute(respCond, "continue");
        this.updateItemXml(itemXml, respCond + "/@continue", "No");
        itemXml.addAttribute(respCond + "/conditionvar/varequal", "case");
        this.updateItemXml(itemXml, respCond + "/conditionvar/varequal/@case", "Yes");
        itemXml.addAttribute(respCond + "/conditionvar/varequal", "respident");
        itemXml.addAttribute(respCond + "/conditionvar/varequal", "index");
        this.updateItemXml(itemXml, respCond + "/conditionvar/varequal/@index", responseNo);
        if (respident != null) {
            this.updateItemXml(itemXml, respCond + "/conditionvar/varequal/@respident", respident);
        }
        this.updateItemXml(itemXml, respCond + "/conditionvar/varequal", responseLabelIdent);
        itemXml.add(respCond, "setvar");
        itemXml.addAttribute(respCond + "/setvar", "action");
        this.updateItemXml(itemXml, respCond + "/setvar/@action", "Add");
        itemXml.addAttribute(respCond + "/setvar", "varname");
        this.updateItemXml(itemXml, respCond + "/setvar/@varname", "SCORE");
        itemXml.add(respCond, "displayfeedback");
        itemXml.addAttribute(respCond + "/displayfeedback", "feedbacktype");
        this.updateItemXml(itemXml, respCond + "/displayfeedback/@feedbacktype", "Response");
        itemXml.addAttribute(respCond + "/displayfeedback", "linkrefid");
        if (correct) {
            this.updateItemXml(itemXml, respCond + "/setvar", "" + this.currentPerItemScore);
            this.updateItemXml(itemXml, respCond + "/displayfeedback/@linkrefid", "CorrectMatch");
        } else {
            this.updateItemXml(itemXml, respCond + "/setvar", "0");
            this.updateItemXml(itemXml, respCond + "/displayfeedback/@linkrefid", "InCorrectMatch");
        }
        this.updateItemXml(itemXml, respCond + "/displayfeedback", responseFeedback);
    }

    private void updateAllSourceMatchGroup(Item itemXml) {
        String matchGroupsXpath = "item/presentation/flow/response_grp/render_choice/response_label[(@match_group)]";
        if (this.allIdents.size() > 0) {
            Iterator iter = this.allIdents.iterator();
            String targetIdent = null;
            String match_group = null;
            while (iter.hasNext()) {
                targetIdent = (String)iter.next();
                if (match_group == null) {
                    match_group = targetIdent;
                    continue;
                }
                match_group = match_group + "," + targetIdent;
            }
            if (match_group != null) {
                int noOfSources = itemXml.selectNodes(matchGroupsXpath).size();
                for (int i = 1; i <= noOfSources; ++i) {
                    String xpath = "item/presentation/flow/response_grp/render_choice/response_label[" + i + "]/@match_group";
                    this.updateItemXml(itemXml, xpath, match_group);
                }
            }
        }
    }

    private void addAnswerFeedbackPartialCredit(Item itemXml, String value, boolean isInsert, int responseNo, String responseLabel, Float partialCredit) {
        log.debug((Object)"addAnswerFeedback()");
        log.debug((Object)("answer feedback value: " + value));
        value = value == null ? "<![CDATA[]]>" : XmlUtil.convertStrforCDATA(value);
        String respCond = "item/resprocessing/respcondition[" + responseNo + "]";
        this.updateItemXml(itemXml, respCond + "/setvar", "" + partialCredit);
        this.updateItemXml(itemXml, respCond + "/displayfeedback[2]/@linkrefid", "AnswerFeedback");
        this.updateItemXml(itemXml, respCond + "/displayfeedback[2]", value);
    }
}

