/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper;

import java.io.Serializable;
import org.sakaiproject.tool.assessment.qti.helper.assessment.AssessmentHelper12Impl;
import org.sakaiproject.tool.assessment.qti.helper.assessment.AssessmentHelper20Impl;
import org.sakaiproject.tool.assessment.qti.helper.assessment.AssessmentHelperIfc;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelper12Impl;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelper20Impl;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.sakaiproject.tool.assessment.qti.helper.section.SectionHelper12Impl;
import org.sakaiproject.tool.assessment.qti.helper.section.SectionHelper20Impl;
import org.sakaiproject.tool.assessment.qti.helper.section.SectionHelperIfc;

public class QTIHelperFactory
implements Serializable {
    private String VERSION_SUPPORTED_STRING = "Version Codes supported: QTIVersion.VERSION_1_2, QTIVersion.VERSION_2_0";

    public ItemHelperIfc getItemHelperInstance(int versionCode) {
        switch (versionCode) {
            case 1: {
                return new ItemHelper12Impl();
            }
            case 2: {
                return new ItemHelper20Impl();
            }
        }
        throw new IllegalArgumentException(this.VERSION_SUPPORTED_STRING);
    }

    public SectionHelperIfc getSectionHelperInstance(int versionCode) {
        switch (versionCode) {
            case 1: {
                return new SectionHelper12Impl();
            }
            case 2: {
                return new SectionHelper20Impl();
            }
        }
        throw new IllegalArgumentException(this.VERSION_SUPPORTED_STRING);
    }

    public AssessmentHelperIfc getAssessmentHelperInstance(int versionCode) {
        switch (versionCode) {
            case 1: {
                return new AssessmentHelper12Impl();
            }
            case 2: {
                return new AssessmentHelper20Impl();
            }
        }
        throw new IllegalArgumentException(this.VERSION_SUPPORTED_STRING);
    }
}

