/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.asi;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.qti.asi.ASIBaseClass;
import org.sakaiproject.tool.assessment.qti.asi.Item;
import org.sakaiproject.tool.assessment.qti.constants.QTIVersion;
import org.sakaiproject.tool.assessment.qti.helper.QTIHelperFactory;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.sakaiproject.util.api.FormattedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Section
extends ASIBaseClass {
    private static final Logger log = LoggerFactory.getLogger(Section.class);
    public String basePath;
    private static final long serialVersionUID = 1L;
    private int qtiVersion;

    public Section() {
        this.basePath = "section";
    }

    public Section(Document document, int qtiVersion) {
        super(document);
        if (!QTIVersion.isValid((int)qtiVersion)) {
            throw new IllegalArgumentException("Invalid Section QTI version.");
        }
        this.qtiVersion = qtiVersion;
        this.basePath = "section";
    }

    public void setIdent(String ident) {
        String xpath = "section";
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.setAttribute("ident", ident);
        }
    }

    public void setTitle(String title) {
        String xpath = "section";
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.setAttribute("title", Section.escapeXml(title));
        }
    }

    public void update(SectionDataIfc section) {
        this.setIdent("" + section.getSectionId());
        this.setTitle(((FormattedText)ComponentManager.get(FormattedText.class)).convertFormattedTextToPlaintext(section.getTitle()));
        this.setFieldentry("SECTION_INFORMATION", section.getDescription());
        this.setFieldentry("SECTION_OBJECTIVE", section.getSectionMetaDataByLabel("SECTION_OBJECTIVES"));
        this.setFieldentry("SECTION_KEYWORD", section.getSectionMetaDataByLabel("SECTION_KEYWORDS"));
        this.setFieldentry("SECTION_RUBRIC", section.getSectionMetaDataByLabel("SECTION_RUBRICS"));
        this.setFieldentry("ATTACHMENT", this.getAttachment(section));
        this.setFieldentry("QUESTIONS_ORDERING", section.getSectionMetaDataByLabel("QUESTIONS_ORDERING"));
        this.addItems(section.getItemArray());
    }

    private void addItems(List<ItemDataIfc> items) {
        if (log.isDebugEnabled()) {
            log.debug("addItems(ArrayList " + items + ")");
        }
        QTIHelperFactory factory = new QTIHelperFactory();
        ItemHelperIfc itemHelper = factory.getItemHelperInstance(this.qtiVersion);
        try {
            String xpath = this.basePath;
            for (ItemDataIfc item : items) {
                Item itemXml;
                Long type = item.getTypeId();
                if (TypeIfc.IMAGEMAP_QUESTION.equals(type)) continue;
                if (TypeIfc.MULTIPLE_CHOICE_SURVEY.equals(type)) {
                    String scale = item.getItemMetaDataByLabel("SCALENAME");
                    if (scale == null) {
                        scale = item.getItemMetaDataByLabel("PREDEFINED_SCALE");
                    }
                    itemXml = itemHelper.readTypeSurveyItem(scale);
                } else {
                    itemXml = itemHelper.readTypeXMLItem(type);
                }
                itemXml.setIdent(item.getItemIdString());
                itemXml.update(item);
                Element itemElement = itemXml.getDocument().getDocumentElement();
                log.debug("Item ident is: " + itemElement.getAttribute("ident"));
                this.addElement(xpath, itemElement);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getFieldentry(String fieldlabel) {
        if (log.isDebugEnabled()) {
            log.debug("getFieldentry(String " + fieldlabel + ")");
        }
        String xpath = "section/qtimetadata/qtimetadatafield/fieldlabel[text()='" + fieldlabel + "']/following-sibling::fieldentry";
        return super.getFieldentry(xpath);
    }

    @Override
    public void setFieldentry(String fieldlabel, String setValue) {
        if (log.isDebugEnabled()) {
            log.debug("setFieldentry(String " + fieldlabel + ", String " + setValue + ")");
        }
        String xpath = "section/qtimetadata/qtimetadatafield/fieldlabel[text()='" + fieldlabel + "']/following-sibling::fieldentry";
        super.setFieldentry(xpath, setValue);
    }

    public void createFieldentry(String fieldlabel) {
        if (log.isDebugEnabled()) {
            log.debug("createFieldentry(String " + fieldlabel + ")");
        }
        String xpath = "section/qtimetadata";
        super.createFieldentry(xpath, fieldlabel);
    }

    public void addItemRef(String itemId) {
        if (log.isDebugEnabled()) {
            log.debug("addItem(String " + itemId + ")");
        }
        try {
            String xpath = this.basePath;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element element = document.createElement("itemref");
            element.setAttribute("linkrefid", itemId);
            this.addElement(xpath, element);
        }
        catch (ParserConfigurationException pce) {
            log.error("Exception thrown from addItemRef() : " + pce.getMessage());
        }
    }

    public void removeItemRef(String itemId) {
        if (log.isDebugEnabled()) {
            log.debug("removeItem(String " + itemId + ")");
        }
        String xpath = this.basePath + "/itemref[@linkrefid=\"" + itemId + "\"]";
        this.removeElement(xpath);
    }

    public void addSectionRef(String sectionId) {
        if (log.isDebugEnabled()) {
            log.debug("addSection(String " + sectionId + ")");
        }
        try {
            String xpath = this.basePath;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.newDocument();
            Element element = document.createElement("sectionref");
            element.setAttribute("linkrefid", sectionId);
            this.addElement(xpath, element);
        }
        catch (ParserConfigurationException pce) {
            log.error("Exception thrown from addSectionRef() : " + pce.getMessage());
        }
    }

    public void removeSectionRef(String sectionId) {
        if (log.isDebugEnabled()) {
            log.debug("removeSection(String " + sectionId + ")");
        }
        String xpath = this.basePath + "/sectionref[@linkrefid=" + sectionId + "]";
        this.removeElement(xpath);
    }

    public void orderItemRefs(List<String> itemRefIds) {
        if (log.isDebugEnabled()) {
            log.debug("orderItemRefs(ArrayList " + itemRefIds + ")");
        }
        this.removeItemRefs();
        int size = itemRefIds.size();
        for (int i = 0; i < size; ++i) {
            this.addItemRef(itemRefIds.get(i));
        }
    }

    private void removeItemRefs() {
        log.debug("removeItems()");
        String xpath = this.basePath + "/itemref";
        this.removeElement(xpath);
    }

    public List<Element> getSectionRefs() {
        log.debug("getSectionRefs()");
        String xpath = this.basePath + "/sectionref";
        return this.selectNodes(xpath);
    }

    public List<String> getSectionRefIds() {
        List<Element> refs = this.getSectionRefs();
        ArrayList<String> ids = new ArrayList<String>();
        int size = refs.size();
        for (int i = 0; i < size; ++i) {
            Element ref = refs.get(0);
            String idString = ref.getAttribute("linkrefid");
            ids.add(idString);
        }
        return ids;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private String getAttachment(SectionDataIfc section) {
        Set attachmentSet = section.getSectionAttachmentSet();
        StringBuilder attachment = new StringBuilder();
        for (SectionAttachmentIfc attachmentData : attachmentSet) {
            attachment.append(attachmentData.getResourceId().replaceAll(" ", ""));
            attachment.append("|");
            attachment.append(attachmentData.getFilename());
            attachment.append("|");
            attachment.append(attachmentData.getMimeType());
            attachment.append("\n");
        }
        return attachment.toString();
    }
}

