/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.asi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTagIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.qti.asi.ASIBaseClass;
import org.sakaiproject.tool.assessment.qti.constants.QTIVersion;
import org.sakaiproject.tool.assessment.qti.helper.QTIHelperFactory;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Item
extends ASIBaseClass {
    private static final Logger log = LoggerFactory.getLogger(Item.class);
    private ItemHelperIfc helper;
    private static final long serialVersionUID = 1L;
    private String basePath;
    private String identity;

    public Item(int qtiVersion) {
        this.initVersion(qtiVersion);
    }

    public Item(Document document, int qtiVersion) {
        super(document);
        this.initVersion(qtiVersion);
    }

    private void initVersion(int qtiVersion) {
        if (!QTIVersion.isValid((int)qtiVersion)) {
            throw new IllegalArgumentException("Invalid Item QTI version.");
        }
        switch (qtiVersion) {
            case 1: {
                this.basePath = "item";
                this.identity = "ident";
                break;
            }
            case 2: {
                this.basePath = "assessmentItem";
                this.identity = "identifier";
                break;
            }
            default: {
                this.basePath = "item";
                this.identity = "ident";
            }
        }
        QTIHelperFactory factory = new QTIHelperFactory();
        this.helper = factory.getItemHelperInstance(qtiVersion);
        log.debug("Item XML class.initVersion(int qtiVersion)");
        log.debug("qtiVersion=" + qtiVersion);
        log.debug("basePath=" + this.basePath);
        log.debug("identity=" + this.identity);
    }

    public void setIdent(String ident) {
        String xpath = this.basePath;
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.setAttribute(this.identity, ident);
        }
    }

    public void setTitle(String title) {
        String xpath = this.basePath;
        List list = this.selectNodes(xpath);
        if (list.size() > 0) {
            Element element = (Element)list.get(0);
            element.setAttribute("title", Item.escapeXml(title));
        }
    }

    public void update(ItemDataIfc item) {
        if (item == null) {
            return;
        }
        this.setFieldentry("ITEM_OBJECTIVE", item.getItemMetaDataByLabel("OBJECTIVE"));
        this.setFieldentry("ITEM_KEYWORD", item.getItemMetaDataByLabel("KEYWORD"));
        this.setFieldentry("ITEM_RUBRIC", item.getItemMetaDataByLabel("RUBRIC"));
        Set tagIfcSet = item.getItemTagSet();
        Object tagsString = "";
        Boolean first = true;
        for (ItemTagIfc tagIfc : tagIfcSet) {
            if (!first.booleanValue()) {
                tagsString = (String)tagsString + ", ";
            }
            tagsString = (String)tagsString + tagIfc.getTagLabel();
            tagsString = !tagIfc.getTagCollectionName().isEmpty() ? (String)tagsString + " (" + tagIfc.getTagCollectionName() + ")" : (String)tagsString + " (No tag collection)";
            first = false;
        }
        this.setFieldentry("ITEM_TAGS", (String)tagsString);
        this.setFieldentry("ATTACHMENT", this.getAttachment(item));
        if (item.getDuration() != null) {
            this.setFieldentry("TIMEALLOWED", item.getDuration().toString());
        }
        if (item.getTriesAllowed() != null) {
            this.setFieldentry("NUM_OF_ATTEMPTS", item.getTriesAllowed().toString());
        }
        if ((item.getTypeId().equals(TypeIfc.TRUE_FALSE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION)) && item.getHasRationale() != null) {
            this.setFieldentry("hasRationale", item.getHasRationale().toString());
        }
        if (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) && item.getPartialCreditFlag().booleanValue()) {
            this.setFieldentry("PARTIAL_CREDIT", "TRUE");
        } else {
            this.setFieldentry("PARTIAL_CREDIT", "FALSE");
        }
        if (!this.isSurvey() && !this.isMXSURVEY()) {
            this.helper.addMaxScore(item.getScore(), this);
            this.helper.addMinScore(item.getDiscount(), this);
        }
        if (item != null && item.getTypeId().equals(TypeIfc.FILL_IN_BLANK)) {
            this.setFieldentry("MUTUALLY_EXCLUSIVE", item.getItemMetaDataByLabel("MUTUALLY_EXCLUSIVE"));
            this.setFieldentry("CASE_SENSITIVE", item.getItemMetaDataByLabel("CASE_SENSITIVE"));
            String markers_pair = item.getItemMetaDataByLabel("MARKERS_PAIR");
            if (markers_pair != null) {
                this.setFieldentry("MARKERS_PAIR", markers_pair);
            } else {
                this.setFieldentry("MARKERS_PAIR", "{}");
            }
            this.setFieldentry("IGNORE_SPACES", item.getItemMetaDataByLabel("IGNORE_SPACES"));
        }
        if (item != null && (item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT) || item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION))) {
            this.setFieldentry("RANDOMIZE", item.getItemMetaDataByLabel("RANDOMIZE"));
            this.setFieldentry("MCMS_PARTIAL_CREDIT", item.getItemMetaDataByLabel("MCMS_PARTIAL_CREDIT"));
        }
        if (this.isMXSURVEY()) {
            this.setFieldentry("FORCE_RANKING", item.getItemMetaDataByLabel("FORCE_RANKING"));
            this.setFieldentry("ADD_COMMENT_MATRIX", item.getItemMetaDataByLabel("ADD_COMMENT_MATRIX"));
            this.setFieldentry("MX_SURVEY_QUESTION_COMMENTFIELD", item.getItemMetaDataByLabel("MX_SURVEY_QUESTION_COMMENTFIELD"));
            this.setFieldentry("MX_SURVEY_RELATIVE_WIDTH", item.getItemMetaDataByLabel("MX_SURVEY_RELATIVE_WIDTH"));
        }
        String instruction = item.getInstruction();
        if ((this.isMatching() || this.isFIB() || this.isFIN() || this.isMXSURVEY() || this.isCalculatedQuestion() || this.isImageMapQuestion()) && instruction != null) {
            this.helper.setItemText(instruction, this);
        }
        if (this.isEMI()) {
            this.helper.setItemLabel(StringEscapeUtils.escapeXml10((String)item.getThemeText()), this);
            this.helper.setPresentationLabel(item.getIsAnswerOptionsSimple() ? "Simple" : "Rich", this);
            String ident = "EMI" + item.getSequence();
            this.helper.setPresentationFlowResponseIdent(ident, this);
            this.helper.setAttachments(item.getItemAttachmentSet(), this);
            if (item.getIsAnswerOptionsSimple()) {
                this.setItemTexts(Collections.singletonList(item.getItemTextBySequence(ItemTextIfc.EMI_ANSWER_OPTIONS_SEQUENCE)));
            } else {
                ItemText it = new ItemText();
                it.setSequence(ItemTextIfc.EMI_ANSWER_OPTIONS_SEQUENCE);
                it.setText(item.getEmiAnswerOptionsRichText());
                HashSet<Answer> answerSet = new HashSet<Answer>();
                String labels = item.getEmiAnswerOptionLabels();
                for (int i = 0; i < item.getAnswerOptionsRichCount(); ++i) {
                    Answer a = new Answer();
                    a.setSequence(Long.valueOf(i));
                    a.setLabel(labels.substring(i, i + 1));
                    answerSet.add(a);
                }
                it.setAnswerSet(answerSet);
                this.setItemTexts(Collections.singletonList(it));
            }
            this.helper.setItemText(item.getLeadInText(), "Leadin", this);
            this.setAnswers(item.getEmiQuestionAnswerCombinations());
            return;
        }
        List itemTexts = item.getItemTextArraySorted();
        this.setItemTexts(itemTexts);
        if (this.isTrueFalse()) {
            Boolean isTrue = item.getIsTrue();
            if (isTrue == null) {
                isTrue = Boolean.FALSE;
            }
            this.setAnswerTrueFalse(isTrue);
        } else {
            this.setAnswers(itemTexts);
        }
        this.setFeedback(itemTexts);
    }

    public void setAnswerTrueFalse(boolean isTrue) {
        log.debug("isTrue=" + isTrue);
        if (isTrue) {
            this.helper.addCorrectAnswer("A", this);
            this.helper.addIncorrectAnswer("B", this);
        } else {
            this.helper.addCorrectAnswer("B", this);
            this.helper.addIncorrectAnswer("A", this);
        }
    }

    @Override
    public String getFieldentry(String fieldlabel) {
        if (log.isDebugEnabled()) {
            log.debug("getFieldentry(String " + fieldlabel + ")");
        }
        String xpath = this.helper.getMetaLabelXPath(fieldlabel);
        return super.getFieldentry(xpath);
    }

    @Override
    public void setFieldentry(String fieldlabel, String setValue) {
        if (log.isDebugEnabled()) {
            log.debug("setFieldentry(String " + fieldlabel + ", String " + setValue + ")");
        }
        String xpath = this.helper.getMetaLabelXPath(fieldlabel);
        super.setFieldentry(xpath, setValue);
    }

    public void createFieldentry(String fieldlabel) {
        if (log.isDebugEnabled()) {
            log.debug("createFieldentry(String " + fieldlabel + ")");
        }
        String xpath = this.helper.getMetaXPath();
        super.createFieldentry(xpath, fieldlabel);
    }

    public String getItemType() {
        String type = this.getFieldentry("qmd_itemtype");
        return type;
    }

    public void setItemTexts(List<ItemTextIfc> itemTextList) {
        this.helper.setItemTexts(itemTextList, this);
    }

    public boolean isEssay() {
        boolean essay = "Short Answers/Essay".equals(this.getItemType()) || "Essay".equals(this.getItemType());
        return essay;
    }

    public boolean isSurvey() {
        return "Multiple Choice Survey".equals(this.getItemType());
    }

    public boolean isMXSURVEY() {
        return "Survey Matrix".equals(this.getItemType());
    }

    public boolean isAudio() {
        return "Audio Recording".equals(this.getItemType());
    }

    public boolean isFile() {
        return "File Upload".equals(this.getItemType());
    }

    public boolean isMatching() {
        return "Matching".equals(this.getItemType());
    }

    public boolean isFIB() {
        return "Fill In the Blank".equals(this.getItemType());
    }

    public boolean isFIN() {
        return "Numeric Response".equals(this.getItemType());
    }

    public boolean isMCMC() {
        return "Multiple Correct Answer".equals(this.getItemType());
    }

    public boolean isMCMCSS() {
        return "Multiple Correct Single Selection".equals(this.getItemType());
    }

    public boolean isMCSC() {
        return "Multiple Choice".equals(this.getItemType());
    }

    private boolean isTrueFalse() {
        return "True False".equals(this.getItemType());
    }

    public boolean isEMI() {
        return "Extended Matching Items".equals(this.getItemType());
    }

    public boolean isCalculatedQuestion() {
        return "Calculated Question".equals(this.getItemType());
    }

    public boolean isImageMapQuestion() {
        return "Image Map Question".equals(this.getItemType());
    }

    public void setAnswers(List<ItemTextIfc> itemTextList) {
        this.helper.setAnswers(itemTextList, this);
    }

    public void setFeedback(List<ItemTextIfc> itemTextList) {
        this.helper.setFeedback(itemTextList, this);
    }

    public String getItemText() {
        return this.helper.getText(this);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    private String getAttachment(ItemDataIfc item) {
        Set attachmentSet = item.getItemAttachmentSet();
        if (attachmentSet != null && attachmentSet.size() != 0) {
            Iterator iter = attachmentSet.iterator();
            ItemAttachmentIfc attachmentData = null;
            StringBuilder attachment = new StringBuilder();
            while (iter.hasNext()) {
                attachmentData = (ItemAttachmentIfc)iter.next();
                attachment.append(attachmentData.getResourceId().replaceAll(" ", ""));
                attachment.append("|");
                attachment.append(attachmentData.getFilename());
                attachment.append("|");
                attachment.append(attachmentData.getMimeType());
                attachment.append("\n");
            }
            return attachment.toString();
        }
        return null;
    }
}

