/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper;

import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.tags.api.TagCollection;
import org.sakaiproject.tags.api.TagService;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataList {
    private static final Logger log = LoggerFactory.getLogger(MetaDataList.class);
    private static final TagService tagService = (TagService)ComponentManager.get(TagService.class);
    private static final String[] editableKeys = new String[]{"assessmentAuthor_isInstructorEditable", "assessmentCreator_isInstructorEditable", "description_isInstructorEditable", "dueDate_isInstructorEditable", "retractDate_isInstructorEditable", "anonymousRelease_isInstructorEditable", "authenticatedRelease_isInstructorEditable", "ipAccessType_isInstructorEditable", "passwordRequired_isInstructorEditable", "lockedBrowser_isInstructorEditable", "timedAssessment_isInstructorEditable", "timedAssessmentAutoSubmit_isInstructorEditable", "itemAccessType_isInstructorEditable", "displayChunking_isInstructorEditable", "displayNumbering_isInstructorEditable", "displayScores_isInstructorEditable", "submissionModel_isInstructorEditable", "lateHandling_isInstructorEditable", "autoSave_isInstructorEditable", "submissionMessage_isInstructorEditable", "finalPageURL_isInstructorEditable", "feedbackType_isInstructorEditable", "feedbackAuthoring_isInstructorEditable", "feedbackComponents_isInstructorEditable", "testeeIdentity_isInstructorEditable", "toGradebook_isInstructorEditable", "recordedScore_isInstructorEditable", "bgColor_isInstructorEditable", "bgImage_isInstructorEditable", "metadataAssess_isInstructorEditable", "metadataParts_isInstructorEditable", "metadataQuestions_isInstructorEditable", "honorpledge_isInstructorEditable"};
    private List metadataList;

    public MetaDataList(List metadataList) {
        this.setMetadataList(metadataList);
    }

    public void addTo(ItemFacade item) {
        if (this.metadataList == null) {
            return;
        }
        for (int i = 0; i < this.metadataList.size(); ++i) {
            String meta = (String)this.metadataList.get(i);
            StringTokenizer st = new StringTokenizer(meta, "|");
            String key = null;
            String value = null;
            if (st.hasMoreTokens()) {
                key = st.nextToken().trim();
            }
            if (!st.hasMoreTokens()) continue;
            value = st.nextToken().trim();
            if (key.equalsIgnoreCase("TIMEALLOWED")) {
                item.setDuration(new Integer(value));
                continue;
            }
            if (key.equalsIgnoreCase("NUM_OF_ATTEMPTS")) {
                item.setTriesAllowed(new Integer(value));
                continue;
            }
            if (key.equalsIgnoreCase("ITEM_KEYWORD")) {
                item.addItemMetaData("KEYWORD", value);
                continue;
            }
            if (key.equalsIgnoreCase("ITEM_OBJECTIVE")) {
                item.addItemMetaData("OBJECTIVE", value);
                continue;
            }
            if (key.equalsIgnoreCase("ITEM_RUBRIC")) {
                item.addItemMetaData("RUBRIC", value);
                continue;
            }
            if (key.equalsIgnoreCase("ATTACHMENT")) {
                value = meta.substring(meta.indexOf("|") + 1);
                item.addItemAttachmentMetaData(value);
                continue;
            }
            if (key.equalsIgnoreCase("ITEM_TAGS")) {
                String[] tagList;
                for (String tagString : tagList = value.split("\\),")) {
                    Optional collection;
                    String tagCollectionName;
                    Object tagLabel = tagString.trim();
                    if (!((String)tagLabel).substring(((String)tagLabel).length() - 1).equals(")")) {
                        tagLabel = (String)tagLabel + ")";
                    }
                    try {
                        tagCollectionName = ((String)tagLabel).substring(((String)tagLabel).lastIndexOf("(") + 1, ((String)tagLabel).lastIndexOf(")"));
                    }
                    catch (Exception e) {
                        tagCollectionName = "Not assigned collection";
                        tagLabel = "No label needed";
                    }
                    try {
                        tagLabel = ((String)tagLabel).substring(0, ((String)tagLabel).lastIndexOf("(") - 1).trim();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (tagCollectionName.equals("Not assigned collection") || !(collection = tagService.getTagCollections().getForExternalSourceName(tagCollectionName)).isPresent()) continue;
                    TagCollection tagCollection = (TagCollection)collection.get();
                    List potentialTags = tagService.getTags().getTagsByExactLabel(((String)tagLabel).trim());
                    potentialTags.stream().filter(t -> t.getCollectionName().equals(tagCollection.getName())).forEach(t -> item.addItemTag(t.getTagId(), t.getTagLabel(), t.getTagCollectionId(), t.getCollectionName()));
                }
                continue;
            }
            log.debug("key now is " + key);
            item.addItemMetaData(key, value);
        }
    }

    public String getSubmissionMessage() {
        String submissionMsg = null;
        if (this.metadataList == null) {
            return null;
        }
        for (int i = 0; i < this.metadataList.size(); ++i) {
            String meta = (String)this.metadataList.get(i);
            StringTokenizer st = new StringTokenizer(meta, "|");
            String key = null;
            String value = null;
            if (st.hasMoreTokens()) {
                key = st.nextToken().trim();
            }
            if (!"SUBMISSION_MESSAGE".equalsIgnoreCase(key) || !st.hasMoreTokens()) continue;
            submissionMsg = value = st.nextToken().trim();
        }
        return submissionMsg;
    }

    public void addTo(AssessmentFacade assessment) {
        if (this.metadataList == null) {
            return;
        }
        for (int i = 0; i < this.metadataList.size(); ++i) {
            String meta = (String)this.metadataList.get(i);
            StringTokenizer st = new StringTokenizer(meta, "|");
            String key = "";
            String value = "";
            if (st.hasMoreTokens()) {
                key = st.nextToken().trim();
            }
            if ("AUTHORS".equals(key)) {
                key = "ASSESSMENT_AUTHORS";
                value = meta.substring(meta.indexOf("|") + 1);
                assessment.addAssessmentMetaData(key, value);
                continue;
            }
            if ("ASSESSMENT_KEYWORDS".equals(key)) {
                key = "ASSESSMENT_KEYWORDS";
                value = meta.substring(meta.indexOf("|") + 1);
                assessment.addAssessmentMetaData(key, value);
                continue;
            }
            if ("ASSESSMENT_OBJECTIVES".equals(key)) {
                key = "ASSESSMENT_OBJECTIVES";
                value = meta.substring(meta.indexOf("|") + 1);
                assessment.addAssessmentMetaData(key, value);
                continue;
            }
            if ("ASSESSMENT_RUBRICS".equals(key)) {
                key = "ASSESSMENT_RUBRICS";
                value = meta.substring(meta.indexOf("|") + 1);
                assessment.addAssessmentMetaData(key, value);
                continue;
            }
            if ("BGCOLOR".equals(key)) {
                key = "ASSESSMENT_BGCOLOR";
                value = meta.substring(meta.indexOf("|") + 1);
                assessment.addAssessmentMetaData(key, value);
                continue;
            }
            if ("BGIMG".equals(key)) {
                key = "ASSESSMENT_BGIMAGE";
                value = meta.substring(meta.indexOf("|") + 1);
                assessment.addAssessmentMetaData(key, value);
                continue;
            }
            if ("COLLECT_ITEM_METADATA".equals(key)) {
                key = "hasMetaDataForQuestions";
                value = meta.substring(meta.indexOf("|") + 1);
                assessment.addAssessmentMetaData(key, value);
                continue;
            }
            if ("ASSESSMENT_RELEASED_TO".equals(key) && value != null && value.indexOf("Authenticated Users") > -1) {
                log.debug("Fixing obsolete reference to 'Authenticated Users', setting released to 'Anonymous Users'.");
                value = "Anonymous Users";
                continue;
            }
            if ("SUBMISSION_MESSAGE".equalsIgnoreCase(key)) continue;
            if ("ATTACHMENT".equalsIgnoreCase(key)) {
                value = meta.substring(meta.indexOf("|") + 1);
                assessment.addAssessmentAttachmentMetaData(value);
                continue;
            }
            if (!st.hasMoreTokens()) continue;
            value = st.nextToken().trim();
            assessment.addAssessmentMetaData(key, value);
        }
    }

    public void setDefaults(AssessmentFacade assessment) {
        assessment.addAssessmentMetaData("templateInfo_isInstructorEditable", "false");
        for (int i = 0; i < editableKeys.length; ++i) {
            assessment.addAssessmentMetaData(editableKeys[i], "true");
        }
    }

    public List getMetadataList() {
        return this.metadataList;
    }

    public void setMetadataList(List metadataList) {
        this.metadataList = metadataList;
    }
}

