/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.helper.item;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.qti.asi.Item;
import org.sakaiproject.tool.assessment.qti.constants.AuthoringConstantStrings;
import org.sakaiproject.tool.assessment.qti.helper.AuthoringXml;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperBase;
import org.sakaiproject.tool.assessment.qti.helper.item.ItemHelperIfc;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ItemHelper12Impl
extends ItemHelperBase
implements ItemHelperIfc {
    private static final Logger log = LoggerFactory.getLogger(ItemHelper12Impl.class);
    private static final String MATCH_XPATH = "item/presentation/flow/response_grp/render_choice";
    private static final String NBSP = "&#160;";
    protected String[] itemTypes = AuthoringConstantStrings.itemTypes;
    private AuthoringXml authoringXml = new AuthoringXml(this.getQtiVersion());
    private List allIdents = new ArrayList();
    private Double currentMaxScore = 0.0;
    private Double currentMinScore = 0.0;
    private double currentPerItemScore = 0.0;
    private double currentPerItemDiscount = 0.0;

    public ItemHelper12Impl() {
        log.debug("ItemHelper12Impl");
    }

    @Override
    protected AuthoringXml getAuthoringXml() {
        return this.authoringXml;
    }

    @Override
    protected int getQtiVersion() {
        return 1;
    }

    @Override
    public void addMaxScore(Double score, Item itemXml) {
        String xPath = "item/resprocessing/outcomes/decvar/@maxvalue";
        if (score == null) {
            score = 0.0;
        }
        this.currentMaxScore = score;
        this.updateItemXml(itemXml, xPath, score.toString());
    }

    @Override
    public void addMinScore(Double discount, Item itemXml) {
        String xPath = "item/resprocessing/outcomes/decvar/@minvalue";
        if (discount == null) {
            discount = 0.0;
        }
        this.currentMinScore = discount;
        this.updateItemXml(itemXml, xPath, discount.toString());
    }

    @Override
    public void addCorrectAnswer(String correctAnswerLabel, Item itemXml) {
        this.flagAnswerCorrect(correctAnswerLabel, itemXml, true);
    }

    @Override
    public void addIncorrectAnswer(String incorrectAnswerLabel, Item itemXml) {
        this.flagAnswerCorrect(incorrectAnswerLabel, itemXml, false);
    }

    public void flagAnswerCorrect(String answerLabel, Item itemXml, boolean correct) {
        if (answerLabel == null) {
            answerLabel = "";
        }
        String flag = correct ? "Correct" : "InCorrect";
        String respProcBaseXPath = "item/resprocessing/respcondition";
        String respProcCondXPath = "/conditionvar/varequal";
        String respProcFeedbackXPath = "/displayfeedback/@linkrefid";
        int respSize = 0;
        List resp = itemXml.selectNodes(respProcBaseXPath);
        if (resp != null && resp.size() > 0) {
            respSize = resp.size();
        }
        for (int i = 1; i <= respSize; ++i) {
            String index = "[" + i + "]";
            String answerVar = itemXml.selectSingleValue(respProcBaseXPath + index + respProcCondXPath, "element");
            if (!answerLabel.equals(answerVar)) continue;
            String xPath = respProcBaseXPath + index + "/@title";
            String xfPath = respProcBaseXPath + index + respProcFeedbackXPath;
            this.updateItemXml(itemXml, xPath, flag);
            this.updateItemXml(itemXml, xfPath, flag);
            break;
        }
    }

    public void addResponseEntry(Item itemXml, String xpath, String value, boolean isInsert, String responseNo, String responseLabel) {
        if (isInsert) {
            String nextNode = "response_label[" + responseNo + "]";
            itemXml.insertElement(nextNode, xpath, "response_label");
            itemXml.add(xpath + "/response_label[" + responseNo + "]", "material/mattext");
        } else {
            itemXml.add(xpath, "response_label/material/mattext");
        }
        try {
            log.debug("putting CDATA around : " + value);
            if (value == null) {
                value = "";
            }
            value = XmlUtil.convertToSingleCDATA(value);
            itemXml.update(xpath + "/response_label[" + responseNo + "]/material/mattext", value);
        }
        catch (Exception ex) {
            log.error("Cannot update value in addResponselEntry(): " + ex);
        }
        String newPath = xpath + "/response_label[" + responseNo + "]";
        itemXml.addAttribute(newPath, "ident");
        newPath = xpath + "/response_label[" + responseNo + "]/@ident";
        this.updateItemXml(itemXml, newPath, responseLabel);
    }

    private void addItemfeedback(Item itemXml, String value, boolean isInsert, String responseNo, String responseLabel) {
        String xpath = "item";
        String nextNode = "itemfeedback[" + responseNo + "]";
        if (isInsert) {
            itemXml.insertElement(nextNode, xpath, "itemfeedback");
            itemXml.add(xpath + "/itemfeedback[" + responseNo + "]", "flow_mat/material/mattext");
        }
        try {
            if (value == null) {
                value = "";
            }
            value = XmlUtil.convertToSingleCDATA(value);
            itemXml.update(xpath + "/itemfeedback[" + responseNo + "]/flow_mat/material/mattext", value);
        }
        catch (Exception ex) {
            log.error("Cannot update value in addItemfeedback(): " + ex);
        }
        String newPath = xpath + "/itemfeedback[" + responseNo + "]";
        itemXml.addAttribute(newPath, "ident");
        newPath = xpath + "/itemfeedback[" + responseNo + "]/@ident";
        String feedbackIdent = responseLabel;
        this.updateItemXml(itemXml, newPath, feedbackIdent);
    }

    @Override
    public String getMetaXPath() {
        String xpath = "item/itemmetadata/qtimetadata";
        return xpath;
    }

    @Override
    public String getMetaLabelXPath(String fieldlabel) {
        String xpath = "item/itemmetadata/qtimetadata/qtimetadatafield/fieldlabel[text()='" + fieldlabel + "']/following-sibling::fieldentry";
        return xpath;
    }

    @Override
    public String getText(Item itemXml) {
        String xpath = "item/presentation/flow/material/mattext";
        String itemType = itemXml.getItemType();
        if (itemType.equals("Matching")) {
            xpath = "item/presentation/flow//mattext";
        }
        return this.makeItemNodeText(itemXml, xpath);
    }

    private void setItemTextMatching(List<ItemTextIfc> itemTextList, Item itemXml) {
        String xpath = MATCH_XPATH;
        HashMap<CallSite, String> allTargets = new HashMap<CallSite, String>();
        itemXml.add(xpath, "response_label");
        String randomNumber = ("" + Math.random()).substring(2);
        Iterator<ItemTextIfc> iter = itemTextList.iterator();
        double itSize = itemTextList.size();
        if (itSize > 0.0) {
            this.currentPerItemScore = this.currentMaxScore / itSize;
            this.currentPerItemDiscount = this.currentMinScore;
        }
        int respCondCount = 0;
        while (iter.hasNext()) {
            ItemTextIfc itemText = iter.next();
            String text = itemText.getText();
            Long sequence = itemText.getSequence();
            String responseLabelIdent = "MS-" + randomNumber + "-" + sequence;
            List answerList = itemText.getAnswerArray();
            Iterator aiter = answerList.iterator();
            int noSources = answerList.size();
            while (aiter.hasNext()) {
                ++respCondCount;
                AnswerIfc answer = (AnswerIfc)aiter.next();
                String answerText = answer.getText();
                String label = answer.getLabel();
                Long answerSequence = answer.getSequence();
                Boolean correct = answer.getIsCorrect();
                String responseFeedback = "";
                responseFeedback = correct != false ? answer.getAnswerFeedback("Correct Feedback") : answer.getAnswerFeedback("InCorrect Feedback");
                if (responseFeedback == null) {
                    responseFeedback = "";
                }
                String responseNo = "" + (answerSequence - (long)noSources + 1L);
                String respIdent = "MT-" + randomNumber + "-" + label;
                String respCondNo = "" + respCondCount;
                responseFeedback = XmlUtil.convertStrforCDATA(responseFeedback);
                if (Boolean.TRUE.equals(correct)) {
                    log.debug("Matching: matched.");
                    if (!this.allIdents.contains(respIdent)) {
                        this.allIdents.add(respIdent);
                    }
                    allTargets.put((CallSite)((Object)respIdent), answerText);
                    this.addMatchingRespcondition(true, itemXml, respCondNo, respIdent, responseLabelIdent, responseFeedback);
                    continue;
                }
                log.debug("Matching: NOT matched.");
                this.addMatchingRespcondition(false, itemXml, respCondNo, respIdent, responseLabelIdent, responseFeedback);
            }
            String responseNo = "" + sequence;
            this.addMatchingResponseLabelSource(itemXml, responseNo, responseLabelIdent, text, 1);
        }
        for (int i = 0; i < this.allIdents.size(); ++i) {
            String respIdent = (String)this.allIdents.get(i);
            String answerText = (String)allTargets.get(respIdent);
            String responseNo = "" + (i + 1);
            this.addMatchingResponseLabelTarget(itemXml, responseNo, respIdent, answerText);
        }
    }

    private void setItemTextMatrix(List<ItemTextIfc> itemTextList, Item itemXml) {
        ItemTextIfc itemText;
        String xpath = MATCH_XPATH;
        itemXml.add(xpath, "response_label");
        String randomNumber = ("" + Math.random()).substring(2);
        Iterator<ItemTextIfc> iter = itemTextList.iterator();
        double itSize = itemTextList.size();
        while (iter.hasNext()) {
            itemText = iter.next();
            String text = itemText.getText();
            Long sequence = itemText.getSequence();
            String responseIdent = "MT-" + randomNumber + "-" + sequence;
            String responseNo = "" + sequence;
            this.addMatchingResponseLabelTarget(itemXml, responseNo, responseIdent, text);
        }
        if (itemTextList.size() > 0) {
            itemText = itemTextList.get(0);
            List answerList = itemText.getAnswerArray();
            int numTexts = itemTextList.size();
            int matchmax = itemTextList.size();
            if (matchmax < 2) {
                matchmax = 2;
            }
            for (int i = 0; i < answerList.size(); ++i) {
                AnswerIfc answer = (AnswerIfc)answerList.get(i);
                String answerText = answer.getText();
                String responseNo = "" + (answer.getSequence() + (long)numTexts);
                String responseIdent = "MS-" + randomNumber + "-" + responseNo;
                this.addMatchingResponseLabelSource(itemXml, responseNo, responseIdent, answerText, matchmax);
            }
        }
        this.updateAllSourceMatchGroup(itemXml);
    }

    private void setItemTextCalculatedQuestion(List<ItemTextIfc> itemTextList, Item itemXml) {
        String xpath = "item/presentation/flow";
        itemXml.add(xpath, "variables");
        itemXml.add(xpath, "formulas");
        GradingService gs = new GradingService();
        String instructions = itemXml.getItemText();
        List formulaNames = gs.extractFormulas(instructions);
        List variableNames = gs.extractVariables(instructions);
        for (ItemTextIfc itemText : itemTextList) {
            if (variableNames.contains(itemText.getText())) {
                this.addCalculatedQuestionVariable(itemText, itemXml, xpath + "/variables");
                continue;
            }
            if (formulaNames.contains(itemText.getText())) {
                this.addCalculatedQuestionFormula(itemText, itemXml, xpath + "/formulas");
                continue;
            }
            log.error("Calculated Question export failed, '" + itemText.getText() + "'was not identified as either a variable or formula, so there must be an error with the Calculated Question definition, question id: " + itemText.getItem().getItemIdString());
        }
    }

    private void addCalculatedQuestionVariable(ItemTextIfc itemText, Item itemXml, String xpath) {
        itemXml.add(xpath, "variable");
        String updatedXpath = xpath + "/variable[last()]";
        try {
            List answers = itemText.getAnswerArray();
            for (AnswerIfc answer : answers) {
                if (!answer.getIsCorrect().booleanValue()) continue;
                String text = answer.getText();
                String min = text.substring(0, text.indexOf("|"));
                String max = text.substring(text.indexOf("|") + 1, text.indexOf(","));
                String decimalPlaces = text.substring(text.indexOf(",") + 1);
                itemXml.add(updatedXpath, "name");
                itemXml.update(updatedXpath + "/name", itemText.getText());
                itemXml.add(updatedXpath, "min");
                itemXml.update(updatedXpath + "/min", min);
                itemXml.add(updatedXpath, "max");
                itemXml.update(updatedXpath + "/max", max);
                itemXml.add(updatedXpath, "decimalPlaces");
                itemXml.update(updatedXpath + "/decimalPlaces", decimalPlaces);
                break;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addCalculatedQuestionFormula(ItemTextIfc itemText, Item itemXml, String xpath) {
        itemXml.add(xpath, "formula");
        String updatedXpath = xpath + "/formula[last()]";
        try {
            List answers = itemText.getAnswerArray();
            for (AnswerIfc answer : answers) {
                if (!answer.getIsCorrect().booleanValue()) continue;
                String text = answer.getText();
                String[] partsText = text.split("\\|");
                if (partsText != null && partsText.length == 2) {
                    String formula = partsText[0];
                    String[] partsTolDp = partsText[1].split(",");
                    if (partsTolDp != null && partsTolDp.length == 2) {
                        String tolerance = partsTolDp[0];
                        String decimalPlaces = partsTolDp[1];
                        itemXml.add(updatedXpath, "name");
                        itemXml.update(updatedXpath + "/name", itemText.getText());
                        itemXml.add(updatedXpath, "formula");
                        itemXml.update(updatedXpath + "/formula", formula);
                        itemXml.add(updatedXpath, "tolerance");
                        itemXml.update(updatedXpath + "/tolerance", tolerance);
                        itemXml.add(updatedXpath, "decimalPlaces");
                        itemXml.update(updatedXpath + "/decimalPlaces", decimalPlaces);
                        break;
                    }
                    log.error("Calculated question answer text {} is not formatted correctly.", (Object)text);
                    continue;
                }
                log.error("Calculated question answer text {} is not formatted correctly.", (Object)text);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setItemTextEMI(List<ItemTextIfc> itemTextList, Item itemXml) {
        for (ItemTextIfc itemText : itemTextList) {
            if (!ItemTextIfc.EMI_ANSWER_OPTIONS_SEQUENCE.equals(itemText.getSequence())) continue;
            if (itemText.getText() != null && !itemText.getText().trim().isEmpty()) {
                this.addEMIOptionText(itemText.getText(), itemXml);
            }
            for (AnswerIfc answer : itemText.getAnswerArraySorted()) {
                this.addEMIOption(answer.getLabel(), answer.getText(), itemXml);
            }
        }
    }

    private void addEMIOptionText(String text, Item itemXml) {
        this.updateItemXml(itemXml, "item/presentation/flow[@class='Options']/material/mattext", XmlUtil.convertToSingleCDATA(text));
    }

    private void addEMIOption(String ident, String text, Item itemXml) {
        Element response_label = this.createElement("response_label", itemXml);
        response_label.setAttribute("ident", ident);
        Element material = this.createElement("material", itemXml);
        response_label.appendChild(material);
        Element mattext = this.createElement("mattext", itemXml);
        material.appendChild(mattext);
        if (text != null) {
            mattext.setTextContent(XmlUtil.convertToSingleCDATA(text));
        }
        itemXml.addElement("item/presentation/flow[@class='Options']/response_lid/render_choice", response_label);
    }

    private Element createElement(String name, Item itemXml) {
        try {
            return itemXml.getDocument().createElement(name);
        }
        catch (Exception e) {
            log.error("Could not create element!", (Throwable)e);
            return null;
        }
    }

    private void setAnswersEMI(List<ItemTextIfc> itemTextList, Item itemXml) {
        String ident = itemXml.getValueOf("item/presentation/flow/response_lid/@ident");
        for (ItemTextIfc itemText : itemTextList) {
            if (!itemText.isEmiQuestionItemText()) continue;
            this.addEMIItem(ident, itemText, itemXml);
        }
    }

    private void addEMIItem(String ident, ItemTextIfc itemText, Item itemXml) {
        Element resprocessing = this.createElement("resprocessing", itemXml);
        itemXml.addElement("item", resprocessing);
        Element outcomes = this.createElement("outcomes", itemXml);
        resprocessing.appendChild(outcomes);
        Element decvarScore = this.createElement("decvar", itemXml);
        decvarScore.setAttribute("defaultval", "0");
        decvarScore.setAttribute("varname", "SCORE");
        decvarScore.setAttribute("vartype", "Double");
        outcomes.appendChild(decvarScore);
        Element decvarRequired = this.createElement("decvar", itemXml);
        decvarRequired.setAttribute("defaultval", String.valueOf(itemText.getEmiCorrectOptionLabels().length()));
        decvarRequired.setAttribute("maxvalue", itemText.getRequiredOptionsCount().toString());
        decvarRequired.setAttribute("minvalue", "0");
        decvarRequired.setAttribute("varname", "requiredOptionsCount");
        decvarRequired.setAttribute("vartype", "Integer");
        outcomes.appendChild(decvarRequired);
        Element decvarScoreUserSet = this.createElement("decvar", itemXml);
        decvarScoreUserSet.setAttribute("varname", "scoreUserSet");
        decvarScoreUserSet.setAttribute("vartype", "String");
        outcomes.appendChild(decvarScoreUserSet);
        Element interpretvar = this.createElement("interpretvar", itemXml);
        outcomes.appendChild(interpretvar);
        Element material = this.createElement("material", itemXml);
        interpretvar.appendChild(material);
        Element mattext = this.createElement("mattext", itemXml);
        mattext.setTextContent(XmlUtil.convertToSingleCDATA(itemText.getText()));
        material.appendChild(mattext);
        if (itemText.getHasAttachment()) {
            this.setAttachments(itemText.getItemTextAttachmentSet(), itemXml, material);
        }
        double score = 0.0;
        double discount = 0.0;
        for (AnswerIfc answer : itemText.getAnswerArraySorted()) {
            decvarScoreUserSet.setAttribute("defaultval", answer.getGrade());
            Element respcondition = this.createElement("respcondition", itemXml);
            respcondition.setAttribute("continue", "Yes");
            respcondition.setAttribute("title", answer.getIsCorrect() != false ? "CORRECT" : "INCORRECT");
            resprocessing.appendChild(respcondition);
            Element conditionvar = this.createElement("conditionvar", itemXml);
            respcondition.appendChild(conditionvar);
            Element varequal = this.createElement("varequal", itemXml);
            varequal.setAttribute("case", "Yes");
            varequal.setAttribute("respident", ident);
            varequal.setTextContent(answer.getLabel());
            conditionvar.appendChild(varequal);
            Element setvar = this.createElement("setvar", itemXml);
            if (answer.getIsCorrect().booleanValue()) {
                setvar.setAttribute("action", "Add");
                setvar.setTextContent(String.valueOf(this.getDouble(answer.getScore())));
                score += this.getDouble(answer.getScore());
            } else {
                setvar.setAttribute("action", "Subtract");
                setvar.setTextContent(String.valueOf(Math.abs(this.getDouble(answer.getDiscount()))));
                discount += this.getDouble(answer.getDiscount());
            }
            setvar.setAttribute("varname", "SCORE");
            respcondition.appendChild(setvar);
        }
        decvarScore.setAttribute("maxvalue", String.valueOf(this.getDouble(score)));
        decvarScore.setAttribute("minvalue", "0");
    }

    private double getDouble(Double d) {
        return d == null ? 0.0 : d;
    }

    private void setItemTextFIB(String fibAns, Item itemXml) {
        if (fibAns != null && fibAns.trim().length() > 0) {
            String markers_pair = StringEscapeUtils.unescapeHtml4((String)itemXml.getFieldentry("MARKERS_PAIR"));
            if (StringUtils.isEmpty((CharSequence)markers_pair) || markers_pair.length() != 2) {
                markers_pair = "{}";
            }
            GradingService gradingService = new GradingService();
            List fibList = gradingService.parseFillInBlank(fibAns, markers_pair);
            Map valueMap = null;
            String mattext = null;
            String respStr = null;
            String xpath = "item/presentation/flow/flow";
            if (fibList != null && fibList.size() > 0) {
                for (int i = 0; i < fibList.size(); ++i) {
                    String newXpath;
                    valueMap = (Map)fibList.get(i);
                    if (valueMap == null || valueMap.size() <= 0) continue;
                    mattext = (String)valueMap.get("text");
                    if ((mattext = XmlUtil.convertStrforCDATA(mattext)) != null) {
                        itemXml.add(xpath, "material/mattext");
                        newXpath = xpath + "/material[" + Integer.toString(i + 1) + "]/mattext";
                        this.updateItemXml(itemXml, newXpath, mattext);
                    }
                    if ((respStr = (String)valueMap.get("ans")) == null) continue;
                    itemXml.add(xpath, "response_str/render_fib");
                    newXpath = xpath + "/response_str[" + Integer.toString(i + 1) + "]";
                    itemXml.addAttribute(newXpath, "ident");
                    String ident = "FIB0" + i;
                    this.updateItemXml(itemXml, newXpath + "/@ident", ident);
                    itemXml.addAttribute(newXpath, "rcardinality");
                    this.updateItemXml(itemXml, newXpath + "/@rcardinality", "Ordered");
                    newXpath = newXpath + "/render_fib";
                    itemXml.addAttribute(newXpath, "fibtype");
                    this.updateItemXml(itemXml, newXpath + "/@fibtype", "String");
                    itemXml.addAttribute(newXpath, "prompt");
                    this.updateItemXml(itemXml, newXpath + "/@prompt", "Box");
                    itemXml.addAttribute(newXpath, "columns");
                    this.updateItemXml(itemXml, newXpath + "/@columns", Integer.toString(respStr.length() + 5));
                    itemXml.addAttribute(newXpath, "rows");
                    this.updateItemXml(itemXml, newXpath + "/@rows", "1");
                    this.allIdents.add(ident);
                }
            }
        }
    }

    private Item addFIBRespconditionNotMutuallyExclusive(Item itemXml, String responseCondNo, String respIdent, String points, String[] responses) {
        String xpath = "item/resprocessing";
        itemXml.add(xpath, "respcondition");
        String respCond = "item/resprocessing/respcondition[" + responseCondNo + "]";
        itemXml.addAttribute(respCond, "continue");
        this.updateItemXml(itemXml, respCond + "/@continue", "Yes");
        Object or = "";
        itemXml.add(respCond, "conditionvar/or");
        or = respCond + "/conditionvar/or";
        for (int i = 0; i < responses.length; ++i) {
            itemXml.add((String)or, "varequal");
            int iString = i + 1;
            String varequal = (String)or + "/varequal[" + iString + "]";
            itemXml.addAttribute(varequal, "case");
            itemXml.addAttribute(varequal, "respident");
            this.updateItemXml(itemXml, varequal + "/@case", "No");
            this.updateItemXml(itemXml, varequal + "/@respident", respIdent);
            String wrapcdata_response = XmlUtil.convertStrforCDATA(responses[i]);
            this.updateItemXml(itemXml, varequal, wrapcdata_response);
        }
        itemXml.add(respCond, "setvar");
        itemXml.addAttribute(respCond + "/setvar", "action");
        this.updateItemXml(itemXml, respCond + "/setvar/@action", "Add");
        itemXml.addAttribute(respCond + "/setvar", "varname");
        this.updateItemXml(itemXml, respCond + "/setvar/@varname", "SCORE");
        this.updateItemXml(itemXml, respCond + "/setvar", points);
        return itemXml;
    }

    private void setItemTextFIN(String finAns, Item itemXml) {
        if (finAns != null && finAns.trim().length() > 0) {
            List finList = ItemHelper12Impl.parseFillInNumeric(finAns);
            Map valueMap = null;
            Object newSet = null;
            String mattext = null;
            String respStr = null;
            String xpath = "item/presentation/flow/flow";
            Object position = null;
            Object responses = null;
            if (finList != null && finList.size() > 0) {
                for (int i = 0; i < finList.size(); ++i) {
                    String newXpath;
                    valueMap = (Map)finList.get(i);
                    if (valueMap == null || valueMap.size() <= 0) continue;
                    mattext = (String)valueMap.get("text");
                    if ((mattext = XmlUtil.convertStrforCDATA(mattext)) != null) {
                        itemXml.add(xpath, "material/mattext");
                        newXpath = xpath + "/material[" + Integer.toString(i + 1) + "]/mattext";
                        this.updateItemXml(itemXml, newXpath, mattext);
                    }
                    if ((respStr = (String)valueMap.get("ans")) == null) continue;
                    itemXml.add(xpath, "response_str/render_fin");
                    newXpath = xpath + "/response_str[" + Integer.toString(i + 1) + "]";
                    itemXml.addAttribute(newXpath, "ident");
                    String ident = "FIN0" + i;
                    this.updateItemXml(itemXml, newXpath + "/@ident", ident);
                    itemXml.addAttribute(newXpath, "rcardinality");
                    this.updateItemXml(itemXml, newXpath + "/@rcardinality", "Ordered");
                    newXpath = newXpath + "/render_fin";
                    itemXml.addAttribute(newXpath, "fintype");
                    this.updateItemXml(itemXml, newXpath + "/@fintype", "String");
                    itemXml.addAttribute(newXpath, "prompt");
                    this.updateItemXml(itemXml, newXpath + "/@prompt", "Box");
                    itemXml.addAttribute(newXpath, "columns");
                    this.updateItemXml(itemXml, newXpath + "/@columns", Integer.toString(respStr.length() + 5));
                    itemXml.addAttribute(newXpath, "rows");
                    this.updateItemXml(itemXml, newXpath + "/@rows", "1");
                    this.allIdents.add(ident);
                }
            }
        }
    }

    private static String padFinWithNonbreakSpacesText(String fin) {
        if (((String)fin).startsWith("{")) {
            fin = NBSP + (String)fin;
        }
        return ((String)fin).replaceAll("\\}\\{", "}&#160;{");
    }

    private Item addFINRespconditionNotMutuallyExclusive(Item itemXml, String responseCondNo, String respIdent, String points, String[] responses) {
        String xpath = "item/resprocessing";
        itemXml.add(xpath, "respcondition");
        String respCond = "item/resprocessing/respcondition[" + responseCondNo + "]";
        itemXml.addAttribute(respCond, "continue");
        this.updateItemXml(itemXml, respCond + "/@continue", "Yes");
        Object or = "";
        itemXml.add(respCond, "conditionvar/or");
        or = respCond + "/conditionvar/or";
        for (int i = 0; i < responses.length; ++i) {
            itemXml.add((String)or, "varequal");
            int iString = i + 1;
            String varequal = (String)or + "/varequal[" + iString + "]";
            itemXml.addAttribute(varequal, "case");
            itemXml.addAttribute(varequal, "respident");
            this.updateItemXml(itemXml, varequal + "/@case", "No");
            this.updateItemXml(itemXml, varequal + "/@respident", respIdent);
            String wrapcdata_response = XmlUtil.convertStrforCDATA(responses[i]);
            this.updateItemXml(itemXml, varequal, wrapcdata_response);
        }
        itemXml.add(respCond, "setvar");
        itemXml.addAttribute(respCond + "/setvar", "action");
        this.updateItemXml(itemXml, respCond + "/setvar/@action", "Add");
        itemXml.addAttribute(respCond + "/setvar", "varname");
        this.updateItemXml(itemXml, respCond + "/setvar/@varname", "SCORE");
        this.updateItemXml(itemXml, respCond + "/setvar", points);
        return itemXml;
    }

    private static List parseFillInNumeric(String input) {
        input = ItemHelper12Impl.padFinWithNonbreakSpacesText(input);
        HashMap<String, String> tempMap = null;
        ArrayList storeParts = new ArrayList();
        if (input == null) {
            return storeParts;
        }
        StringTokenizer st = new StringTokenizer(input, "}");
        String tempToken = "";
        String[] splitArray = null;
        while (st.hasMoreTokens()) {
            tempToken = st.nextToken();
            tempMap = new HashMap<String, String>();
            splitArray = tempToken.trim().split("\\{", 2);
            tempMap.put("text", splitArray[0].trim());
            if (splitArray.length > 1) {
                tempMap.put("ans", splitArray[1]);
            } else {
                tempMap.put("ans", null);
            }
            storeParts.add(tempMap);
        }
        return storeParts;
    }

    @Override
    public void setItemLabel(String itemLabel, Item itemXml) {
        try {
            itemXml.update("item/@label", itemLabel);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setPresentationLabel(String presentationLabel, Item itemXml) {
        try {
            itemXml.update("item/presentation/@label", presentationLabel);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setPresentationFlowResponseIdent(String presentationFlowResponseIdent, Item itemXml) {
        try {
            itemXml.update("item/presentation/flow/response_lid/@ident", presentationFlowResponseIdent);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setItemText(String itemText, Item itemXml) {
        this.setItemText(itemText, null, itemXml);
    }

    @Override
    public void setItemText(String itemText, String flowClass, Item itemXml) {
        String xpath = "item/presentation/flow" + (String)(flowClass == null ? "" : "[@class='" + flowClass + "']") + "/material/mattext";
        log.debug("in ItemHelper12Impl.java: setItemText() text = " + itemText);
        itemText = XmlUtil.convertToSingleCDATA(itemText);
        log.debug("in ItemHelperBase.java: setItemText() wrapped CDATA text is = " + itemText);
        try {
            itemXml.update(xpath, itemText);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void setItemTexts(List<ItemTextIfc> itemTextList, Item itemXml) {
        if (itemTextList.size() < 1) {
            return;
        }
        if (itemXml.isMatching()) {
            this.setItemTextMatching(itemTextList, itemXml);
        } else if (itemXml.isMXSURVEY()) {
            this.setItemTextMatrix(itemTextList, itemXml);
        } else if (itemXml.isEMI()) {
            this.setItemTextEMI(itemTextList, itemXml);
        } else {
            if (itemXml.isCalculatedQuestion()) {
                this.setItemTextCalculatedQuestion(itemTextList, itemXml);
                return;
            }
            if (itemXml.isFIB()) {
                this.setItemTextFIB(itemTextList.get(0).getText(), itemXml);
            } else if (itemXml.isFIN()) {
                this.setItemTextFIN(itemTextList.get(0).getText(), itemXml);
            } else {
                this.setItemText(itemTextList.get(0).getText(), itemXml);
            }
        }
    }

    @Override
    public String getItemType(Item itemXml) {
        String type = itemXml.getFieldentry("qmd_itemtype");
        return type;
    }

    @Override
    public void setAnswers(List<ItemTextIfc> itemTextList, Item itemXml) {
        log.debug("entered setAnswers()");
        log.debug("size=" + itemTextList.size());
        if (itemXml.isEMI()) {
            this.setAnswersEMI(itemTextList, itemXml);
            return;
        }
        if (!(itemXml.isFIB() || itemXml.isMCSC() || itemXml.isFIN() || itemXml.isMCMC() || itemXml.isMCMCSS() || itemXml.isEssay() || itemXml.isSurvey())) {
            return;
        }
        String xpath = "item/presentation/flow/response_lid/render_choice";
        List list = itemXml.selectNodes(xpath);
        Iterator nodeIter = list.iterator();
        Iterator<ItemTextIfc> iter = itemTextList.iterator();
        Set answerSet = new HashSet();
        char label = 'A';
        int xpathIndex = 1;
        int respIdentCount = 0;
        while (iter.hasNext()) {
            answerSet = iter.next().getAnswerSet();
            log.debug("answersize=" + answerSet.size());
            for (AnswerIfc answer : answerSet) {
                String[] responses;
                if (Boolean.TRUE.equals(answer.getIsCorrect())) {
                    this.addCorrectAnswer("" + label, itemXml);
                }
                String value = answer.getText();
                log.debug("\n\n***The answer is: " + value);
                if (itemXml.isFIB()) {
                    responses = new String[]{value};
                    String respIdent = (String)this.allIdents.get(respIdentCount++);
                    this.addFIBRespconditionNotMutuallyExclusive(itemXml, "" + xpathIndex, respIdent, "0", responses);
                    label = (char)(label + '\u0001');
                    ++xpathIndex;
                    continue;
                }
                if (itemXml.isFIN()) {
                    responses = new String[]{value};
                    String respIdent = (String)this.allIdents.get(respIdentCount++);
                    this.addFINRespconditionNotMutuallyExclusive(itemXml, "" + xpathIndex, respIdent, "0", responses);
                    label = (char)(label + '\u0001');
                    ++xpathIndex;
                    continue;
                }
                Object node = null;
                try {
                    boolean isInsert = true;
                    if (nodeIter.hasNext()) {
                        isInsert = false;
                    }
                    this.addResponseEntry(itemXml, xpath, value, isInsert, "" + xpathIndex, "" + label);
                }
                catch (Exception ex) {
                    log.error("Cannot process source document.", (Throwable)ex);
                }
                label = (char)(label + '\u0001');
                ++xpathIndex;
            }
        }
    }

    @Override
    public void setFeedback(List<ItemTextIfc> itemTextList, Item itemXml) {
        boolean hasAnswerLevelFeedback = itemXml.isMCMC() || itemXml.isMCSC() || itemXml.isMCMCSS();
        String xpath = "item/itemfeedback/flow/response_lid/render_choice";
        int xpathIndex = 1;
        List list = itemXml.selectNodes(xpath);
        Iterator nodeIter = list.iterator();
        Iterator<ItemTextIfc> iter = itemTextList.iterator();
        Set answerSet = new HashSet();
        char label = 'A';
        boolean first = true;
        while (iter.hasNext()) {
            ItemTextIfc itemTextIfc = iter.next();
            if (first) {
                this.addCorrectAndIncorrectFeedback(itemXml, itemTextIfc);
                xpathIndex = 1;
                first = false;
            }
            if (hasAnswerLevelFeedback) {
                log.debug("Setting answer level feedback");
                answerSet = itemTextIfc.getAnswerSet();
                log.debug("answerSet.size(): " + answerSet.size());
                for (AnswerIfc answer : answerSet) {
                    String value = answer.getGeneralAnswerFeedback();
                    boolean isInsert = true;
                    if (nodeIter.hasNext()) {
                        isInsert = false;
                    }
                    if (itemXml.isMCSC()) {
                        if (answer.getIsCorrect().booleanValue()) {
                            answer.setPartialCredit(Double.valueOf(100.0));
                        }
                        if (answer.getItem().getPartialCreditFlag().booleanValue()) {
                            Double partialCredit = 100.0;
                            try {
                                partialCredit = answer.getItem().getScore() * answer.getPartialCredit() / 100.0;
                            }
                            catch (Exception e) {
                                log.error("Could not compute partial value for id: " + answer.getId());
                            }
                            this.addAnswerFeedbackPartialCredit(itemXml, value, isInsert, xpathIndex, "" + label, partialCredit);
                        } else {
                            this.addAnswerFeedback(itemXml, value, isInsert, xpathIndex, "" + label);
                        }
                    } else {
                        this.addAnswerFeedback(itemXml, value, isInsert, xpathIndex, "" + label);
                    }
                    label = (char)(label + '\u0001');
                    ++xpathIndex;
                }
            }
            this.addGeneralFeedback(itemXml, xpathIndex, itemTextIfc);
        }
    }

    private void addCorrectAndIncorrectFeedback(Item itemXml, ItemTextIfc itemTextIfc) {
        String correctFeedback = itemTextIfc.getItem().getCorrectItemFeedback();
        String incorrectFeedback = itemTextIfc.getItem().getInCorrectItemFeedback();
        log.debug("CORRECT FEEDBACK: " + correctFeedback);
        if (correctFeedback != null) {
            this.addItemfeedback(itemXml, correctFeedback, false, "1", "Correct");
        }
        log.debug("INCORRECT FEEDBACK: " + incorrectFeedback);
        if (incorrectFeedback != null) {
            this.addItemfeedback(itemXml, incorrectFeedback, false, "2", "InCorrect");
        }
    }

    private void addGeneralFeedback(Item itemXml, int xpathIndex, ItemTextIfc itemTextIfc) {
        log.debug("\nDebug add in General Feedback");
        String generalFeedback = itemTextIfc.getItem().getGeneralItemFeedback();
        String itemId = itemTextIfc.getItem().getItemIdString();
        if (generalFeedback != null) {
            this.addItemfeedback(itemXml, generalFeedback, true, "" + xpathIndex++, itemId);
        }
    }

    private void addAnswerFeedback(Item itemXml, String value, boolean isInsert, int responseNo, String responseLabel) {
        log.debug("addAnswerFeedback()");
        log.debug("answer feedback value: " + value);
        value = value == null ? "<![CDATA[]]>" : XmlUtil.convertStrforCDATA(value);
        String respCond = "item/resprocessing/respcondition[" + responseNo + "]";
        this.updateItemXml(itemXml, respCond + "/setvar", "" + this.currentPerItemScore);
        this.updateItemXml(itemXml, respCond + "/displayfeedback[2]/@linkrefid", "AnswerFeedback");
        this.updateItemXml(itemXml, respCond + "/displayfeedback[2]", value);
    }

    private void addMatchingResponseLabelTarget(Item itemXml, String responseNo, String respIdent, String value) {
        String xpath = MATCH_XPATH;
        this.insertResponseLabelMattext(itemXml, responseNo, value, xpath);
        String newPath = xpath + "/response_label[" + responseNo + "]";
        itemXml.addAttribute(newPath, "ident");
        newPath = xpath + "/response_label[" + responseNo + "]/@ident";
        this.updateItemXml(itemXml, newPath, respIdent);
    }

    private void addMatchingResponseLabelSource(Item itemXml, String responseNo, String responseLabelIdent, String value, int matchMax) {
        String xpath = MATCH_XPATH;
        this.insertResponseLabelMattext(itemXml, responseNo, value, xpath);
        itemXml.addAttribute(xpath + "/response_label[" + responseNo + "]", "match_max");
        itemXml.addAttribute(xpath + "/response_label[" + responseNo + "]", "match_group");
        this.updateItemXml(itemXml, xpath + "/response_label[" + responseNo + "]/@match_max", Integer.toString(matchMax));
        String newPath = xpath + "/response_label[" + responseNo + "]";
        itemXml.addAttribute(newPath, "ident");
        newPath = xpath + "/response_label[" + responseNo + "]/@ident";
        this.updateItemXml(itemXml, newPath, responseLabelIdent);
    }

    private void insertResponseLabelMattext(Item itemXml, String responseNo, String value, String xpath) {
        String nextNode = "response_label[" + responseNo + "]";
        itemXml.insertElement(nextNode, xpath, "response_label");
        itemXml.add(xpath + "/response_label[" + responseNo + "]", "material/mattext");
        try {
            log.debug("in ItemHelper12Impl.java: insertResponseLabelMattext() text = " + value);
            value = XmlUtil.convertStrforCDATA(value);
            log.debug("in ItemHelperBase.java: insertResponseLabelMattext() wrapped CDATA text is = " + value);
            itemXml.update(xpath + "/response_label[" + responseNo + "]/material/mattext", value);
        }
        catch (Exception ex) {
            log.warn("Unable to set mattext in '" + xpath + "/response_label[" + responseNo + "]' to '" + value + "'");
        }
    }

    private void addMatchingRespcondition(boolean correct, Item itemXml, String responseNo, String respident, String responseLabelIdent, String responseFeedback) {
        String xpath = "item/resprocessing";
        itemXml.add(xpath, "respcondition/conditionvar/varequal");
        String respCond = "item/resprocessing/respcondition[" + responseNo + "]";
        itemXml.addAttribute(respCond, "continue");
        this.updateItemXml(itemXml, respCond + "/@continue", "No");
        itemXml.addAttribute(respCond + "/conditionvar/varequal", "case");
        this.updateItemXml(itemXml, respCond + "/conditionvar/varequal/@case", "Yes");
        itemXml.addAttribute(respCond + "/conditionvar/varequal", "respident");
        itemXml.addAttribute(respCond + "/conditionvar/varequal", "index");
        this.updateItemXml(itemXml, respCond + "/conditionvar/varequal/@index", responseNo);
        if (respident != null) {
            this.updateItemXml(itemXml, respCond + "/conditionvar/varequal/@respident", respident);
        }
        this.updateItemXml(itemXml, respCond + "/conditionvar/varequal", responseLabelIdent);
        itemXml.add(respCond, "setvar");
        itemXml.addAttribute(respCond + "/setvar", "action");
        this.updateItemXml(itemXml, respCond + "/setvar/@action", "Add");
        itemXml.addAttribute(respCond + "/setvar", "varname");
        this.updateItemXml(itemXml, respCond + "/setvar/@varname", "SCORE");
        itemXml.add(respCond, "displayfeedback");
        itemXml.addAttribute(respCond + "/displayfeedback", "feedbacktype");
        this.updateItemXml(itemXml, respCond + "/displayfeedback/@feedbacktype", "Response");
        itemXml.addAttribute(respCond + "/displayfeedback", "linkrefid");
        if (correct) {
            this.updateItemXml(itemXml, respCond + "/setvar", "" + this.currentPerItemScore);
            this.updateItemXml(itemXml, respCond + "/displayfeedback/@linkrefid", "CorrectMatch");
        } else {
            this.updateItemXml(itemXml, respCond + "/setvar", "0");
            this.updateItemXml(itemXml, respCond + "/displayfeedback/@linkrefid", "InCorrectMatch");
        }
        this.updateItemXml(itemXml, respCond + "/displayfeedback", responseFeedback);
    }

    private void updateAllSourceMatchGroup(Item itemXml) {
        String matchGroupsXpath = "item/presentation/flow/response_grp/render_choice/response_label[(@match_group)]";
        if (this.allIdents.size() > 0) {
            Iterator iter = this.allIdents.iterator();
            String targetIdent = null;
            Object match_group = null;
            while (iter.hasNext()) {
                targetIdent = (String)iter.next();
                if (match_group == null) {
                    match_group = targetIdent;
                    continue;
                }
                match_group = (String)match_group + "," + targetIdent;
            }
            if (match_group != null) {
                int noOfSources = itemXml.selectNodes(matchGroupsXpath).size();
                for (int i = 1; i <= noOfSources; ++i) {
                    String xpath = "item/presentation/flow/response_grp/render_choice/response_label[" + i + "]/@match_group";
                    this.updateItemXml(itemXml, xpath, (String)match_group);
                }
            }
        }
    }

    private void addAnswerFeedbackPartialCredit(Item itemXml, String value, boolean isInsert, int responseNo, String responseLabel, Double partialCredit) {
        log.debug("addAnswerFeedback()");
        log.debug("answer feedback value: " + value);
        value = value == null ? "<![CDATA[]]>" : XmlUtil.convertStrforCDATA(value);
        String respCond = "item/resprocessing/respcondition[" + responseNo + "]";
        this.updateItemXml(itemXml, respCond + "/setvar", "" + partialCredit);
        this.updateItemXml(itemXml, respCond + "/displayfeedback[2]/@linkrefid", "AnswerFeedback");
        this.updateItemXml(itemXml, respCond + "/displayfeedback[2]", value);
    }

    @Override
    public void setAttachments(Set<? extends AttachmentIfc> attachmentSet, Item itemXml) {
        if (attachmentSet == null || attachmentSet.isEmpty()) {
            return;
        }
        List nodeList = itemXml.selectNodes("//item/presentation/flow[position()=1]/material");
        Element material = (Element)nodeList.get(0);
        this.setAttachments(attachmentSet, itemXml, material);
    }

    private void setAttachments(Set<? extends AttachmentIfc> attachmentSet, Item itemXml, Element material) {
        for (AttachmentIfc attachmentIfc : attachmentSet) {
            Element mat = null;
            if (attachmentIfc.getMimeType().startsWith("text")) {
                mat = this.createElement("mattext", itemXml);
                mat.setAttribute("texttype", attachmentIfc.getMimeType());
            } else if (attachmentIfc.getMimeType().startsWith("image")) {
                mat = this.createElement("matimage", itemXml);
                mat.setAttribute("imagtype", attachmentIfc.getMimeType());
            } else if (attachmentIfc.getMimeType().startsWith("audio")) {
                mat = this.createElement("mataudio", itemXml);
                mat.setAttribute("audiotype", attachmentIfc.getMimeType());
            } else if (attachmentIfc.getMimeType().startsWith("video")) {
                mat = this.createElement("matvideo", itemXml);
                mat.setAttribute("videotype", attachmentIfc.getMimeType());
            } else if (attachmentIfc.getMimeType().startsWith("application")) {
                mat = this.createElement("matapplication", itemXml);
                mat.setAttribute("apptype", attachmentIfc.getMimeType());
            } else {
                throw new IllegalArgumentException("Don't know this Mime-type: " + attachmentIfc.getMimeType());
            }
            mat.setAttribute("label", attachmentIfc.getFilename());
            mat.setAttribute("size", String.valueOf(attachmentIfc.getFileSize()));
            mat.setAttribute("uri", attachmentIfc.getLocation());
            material.appendChild(mat);
        }
    }
}

