/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.qti.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.sakaiproject.tool.assessment.qti.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMapper {
    private static final Logger log = LoggerFactory.getLogger(XmlMapper.class);
    public static final String ATTRIBUTE_PREFIX = "attribute_";

    public static Map map(Document doc) {
        return XmlMapper.hashNode(doc);
    }

    public static void populateBeanFromDoc(Serializable bean, Document doc) {
        try {
            Map m = XmlMapper.map(doc);
            BeanUtils.populate((Object)bean, (Map)m);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static HashMap hashNode(Node node) {
        int i;
        HashMap hNode = new HashMap();
        short nType = node.getNodeType();
        NodeList nodes = node.getChildNodes();
        NamedNodeMap attributes = node.getAttributes();
        String name = node.getNodeName();
        if (nType == 9 && nodes != null) {
            for (i = 0; i < nodes.getLength(); ++i) {
                Node rnode = nodes.item(i);
                if (rnode.getNodeType() != 1) continue;
                hNode = XmlMapper.hashNode(rnode);
                break;
            }
        }
        if (nType == 1) {
            if (nodes != null) {
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node cnode = nodes.item(j);
                    if (cnode.getNodeType() != 1) continue;
                    String cname = cnode.getNodeName();
                    String ctext = "";
                    String ctype = XmlMapper.getTypeAttribute(cnode);
                    StringBuilder ctextbuf = new StringBuilder();
                    if ("list".equals(ctype)) {
                        ArrayList list = hNode.get(cname) instanceof ArrayList ? (ArrayList)hNode.get(cname) : new ArrayList();
                        NodeList ccnodes = cnode.getChildNodes();
                        for (int n = 0; n < ccnodes.getLength(); ++n) {
                            ctextbuf.append(XmlUtil.getDOMString(ccnodes.item(n)));
                        }
                        ctext = ctextbuf.toString();
                        list.add(ctext);
                        hNode.put(cname, list);
                        continue;
                    }
                    NodeList ccnodes = cnode.getChildNodes();
                    for (int n = 0; n < ccnodes.getLength(); ++n) {
                        ctextbuf.append(XmlUtil.getDOMString(ccnodes.item(n)));
                    }
                    ctext = ctextbuf.toString();
                    hNode.put(cname, ctext);
                }
            }
            if (attributes != null) {
                for (i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    hNode.put(ATTRIBUTE_PREFIX + current.getNodeName(), current.getNodeValue());
                }
            }
        }
        return hNode;
    }

    private static String getTypeAttribute(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node current = attributes.item(i);
                if (!"type".equals(current.getNodeName())) continue;
                return current.getNodeValue();
            }
        }
        return "scalar";
    }
}

