/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.spring;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class SpringBeanLocator {
    private static Object waitLock = new Object();
    private static WebApplicationContext waCtx = null;
    private static ConfigurableApplicationContext caCtx = null;
    private static boolean inWebContext = false;
    private static SpringBeanLocator instance = null;

    public static SpringBeanLocator getInstance() {
        return new SpringBeanLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationContext(WebApplicationContext context) {
        Object object = waitLock;
        synchronized (object) {
            waCtx = context;
            inWebContext = true;
            waitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfigurableApplicationContext(ConfigurableApplicationContext ca) {
        Object object = waitLock;
        synchronized (object) {
            caCtx = ca;
            inWebContext = false;
            waitLock.notifyAll();
        }
    }

    public Object getBean(String name) {
        if (waCtx == null && caCtx == null) {
            try {
                waitLock.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Got interrupted waiting for bean to be setup.", e);
            }
        }
        if (inWebContext) {
            return waCtx.getBean(name);
        }
        return caCtx.getBean(name);
    }
}

