/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.sakaiproject.tool.assessment.data.ifc.shared.AgentDataIfc;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.AgentHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.AgentImpl;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentFacade
implements Serializable,
AgentDataIfc {
    private static final long serialVersionUID = 1L;
    private Logger log = LoggerFactory.getLogger(AgentFacade.class);
    private static final AgentHelper helper = IntegrationContextFactory.getInstance().getAgentHelper();
    private static final boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
    private AgentImpl agent;
    private String agentString;
    private String eid;
    private boolean accessViaUrl;
    private String displayId;
    private String displayIdString;

    public AgentFacade(String agentId) {
        this.agent = new AgentImpl(agentId, null, new IdImpl(agentId));
        this.agentString = agentId;
        this.eid = helper.getEid(agentId);
        this.displayId = helper.getDisplayId(agentId);
    }

    public AgentFacade() {
        String agentId = helper.getAgentString("UNASSIGNED");
        this.agent = new AgentImpl(agentId, null, new IdImpl(agentId));
        this.agentString = agentId;
        this.eid = helper.getEid("UNASSIGNED");
    }

    public static AgentImpl getAgent() {
        return helper.getAgent();
    }

    public static String getAgentString() {
        AgentFacade facade = new AgentFacade();
        return facade.agentString;
    }

    public static String getEid() {
        AgentFacade facade = new AgentFacade();
        return facade.eid;
    }

    public String getAgentInstanceString() {
        return this.agentString;
    }

    public String getEidString() {
        this.log.debug("agentfacade.getEid(agentS) agentString = " + this.agentString);
        return helper.getEidById(this.agentString);
    }

    public static String getDisplayName(String agentS) {
        return helper.getDisplayName(agentS);
    }

    public String getDisplayName() {
        return helper.getDisplayName(this.agentString);
    }

    public String getFirstName() {
        return helper.getFirstName(this.agentString);
    }

    public String getLastName() {
        return helper.getLastName(this.agentString);
    }

    public String getEmail() {
        return helper.getEmail(this.agentString);
    }

    public String getRole() {
        return helper.getRoleForCurrentAgent(this.agentString);
    }

    public static String getRole(String agentString) {
        return helper.getRole(agentString);
    }

    public static String getCurrentSiteId() {
        AgentFacade facade = new AgentFacade();
        boolean accessViaUrl = facade.isAccessViaUrl();
        return helper.getCurrentSiteId(accessViaUrl);
    }

    public static String getCurrentSiteName() {
        AgentFacade facade = new AgentFacade();
        boolean accessViaUrl = facade.isAccessViaUrl();
        return helper.getCurrentSiteName(accessViaUrl);
    }

    public static String getSiteName(String siteId) {
        return helper.getSiteName(siteId);
    }

    public String getIdString() {
        return this.agentString;
    }

    public static String getDisplayNameByAgentId(String agentId) {
        return helper.getDisplayNameByAgentId(agentId);
    }

    public static String createAnonymous() {
        AgentFacade facade = new AgentFacade();
        return helper.createAnonymous(facade);
    }

    public static boolean isIntegratedEnvironment() {
        return integrated;
    }

    public static String getAnonymousId() {
        AgentFacade facade = new AgentFacade();
        String agentString = facade.getAgentInstanceString();
        return helper.getAnonymousId(agentString);
    }

    public void setIdString(String idString) {
        this.agentString = idString;
    }

    public static Map getUserRolesFromContextRealm(Collection inUsers) {
        return helper.getUserRolesFromContextRealm(inUsers);
    }

    public static String getRoleForAgentAndSite(String agentString, String siteId) {
        return helper.getRoleForAgentAndSite(agentString, siteId);
    }

    public boolean isAccessViaUrl() {
        return this.agentString.startsWith("anonymous_");
    }

    public void setAccessViaUrl(boolean accessViaUrl) {
        this.accessViaUrl = accessViaUrl;
    }

    public void setAgentInstanceString(String agentInstanceString) {
        this.agentString = agentInstanceString;
    }

    public static boolean isFileUploadAvailable() {
        return helper.isFileUploadAvailable();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.agentString == null ? 0 : this.agentString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentFacade other = (AgentFacade)obj;
        return !(this.agentString == null ? other.agentString != null : !this.agentString.equals(other.agentString));
    }

    public static String getDisplayId() {
        AgentFacade facade = new AgentFacade();
        return facade.displayId;
    }

    public String getDisplayIdString() {
        return helper.getDisplayId(this.agentString);
    }
}

