/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.osid.assessment.Assessment;
import org.osid.assessment.AssessmentException;
import org.osid.shared.Id;
import org.osid.shared.Type;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.assessment.impl.AssessmentImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssessmentBaseFacade
implements Serializable,
AssessmentBaseIfc {
    private Logger log = LoggerFactory.getLogger(AssessmentBaseFacade.class);
    private AssessmentImpl assessmentImpl = new AssessmentImpl();
    protected Assessment assessment = this.assessmentImpl;
    private static final long serialVersionUID = 7526471155622776147L;
    private Id id;
    private String displayName;
    private String description;
    private AssessmentBaseIfc data;
    private Type assessmentType;
    private Long assessmentId;
    private Boolean isTemplate;
    private String title;
    private Long typeId;
    private Long parentId;
    private Integer instructorNotification;
    private Integer testeeNotification;
    private Integer multipartAllowed;
    private Integer status;
    private String comments;
    private String createdBy;
    private Date createdDate;
    private String lastModifiedBy;
    private Date lastModifiedDate;
    private AssessmentAccessControlIfc assessmentAccessControl;
    private EvaluationModelIfc evaluationModel;
    private AssessmentFeedbackIfc assessmentFeedback;
    private Set assessmentMetaDataSet = new HashSet();
    private HashMap assessmentMetaDataMap = new HashMap();
    private Set securedIPAddressSet;
    private String assessmentAttachmentMetaData;

    public AssessmentBaseFacade() {
        this.data = new AssessmentBaseData();
        try {
            this.assessment.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public AssessmentBaseFacade(AssessmentBaseIfc data) {
        try {
            this.setData(data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    Id getId() {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return PersistenceService.getInstance().getAssessmentFacadeQueries().getId(this.data.getAssessmentBaseId());
    }

    Type getAssessmentType() {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeById(this.data.getTypeId());
    }

    public TypeIfc getType() {
        return this.getAssessmentTypeFacade();
    }

    public TypeFacade getAssessmentTypeFacade() {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeFacadeById(this.data.getTypeId());
    }

    public AssessmentBaseIfc getData() {
        return this.data;
    }

    public void updateData(AssessmentBaseIfc data) {
        try {
            this.setData(data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public void setData(AssessmentBaseIfc data) throws AssessmentException {
        this.data = data;
        try {
            this.assessment.updateData((Serializable)data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.id = this.getId();
        this.displayName = this.getDisplayName();
        this.description = this.getDescription();
        this.typeId = this.getTypeId();
        this.parentId = this.getParentId();
        this.assessmentType = this.getAssessmentType();
        this.assessmentId = this.getAssessmentBaseId();
        this.isTemplate = this.getIsTemplate();
        this.title = this.getTitle();
        this.comments = this.getComments();
        this.assessmentMetaDataSet = this.getAssessmentMetaDataSet();
        this.instructorNotification = this.getInstructorNotification();
        this.testeeNotification = this.getTesteeNotification();
        this.multipartAllowed = this.getMultipartAllowed();
        this.status = this.getStatus();
        this.createdBy = this.getCreatedBy();
        this.createdDate = this.getCreatedDate();
        this.lastModifiedBy = this.getLastModifiedBy();
        this.lastModifiedDate = this.getLastModifiedDate();
        this.assessmentAccessControl = this.getAssessmentAccessControl();
        this.assessmentFeedback = this.getAssessmentFeedback();
        this.evaluationModel = this.getEvaluationModel();
        this.assessmentMetaDataMap = this.getAssessmentMetaDataMap(this.assessmentMetaDataSet);
        this.securedIPAddressSet = this.getSecuredIPAddressSet();
    }

    public Long getAssessmentBaseId() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAssessmentBaseId();
    }

    public void setAssessmentBaseId(Long assessmentId) {
        this.assessmentId = assessmentId;
        this.data.setAssessmentBaseId(assessmentId);
    }

    public Boolean getIsTemplate() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getIsTemplate();
    }

    public void setIsTemplate(Boolean isTemplate) {
        this.isTemplate = isTemplate;
        this.data.setIsTemplate(isTemplate);
    }

    public String getDisplayName() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDescription();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.data.setTitle(displayName);
    }

    public String getDescription() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.description = description;
        this.data.setDescription(description);
    }

    public Long getTypeId() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTypeId();
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
        this.data.setTypeId(typeId);
    }

    public Long getParentId() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getParentId();
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
        this.data.setParentId(parentId);
    }

    public String getTitle() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTitle();
    }

    public void setTitle(String title) {
        this.title = title;
        this.data.setTitle(title);
    }

    public void setComments(String comments) {
        this.comments = comments;
        this.data.setComments(comments);
    }

    public String getComments() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getComments();
    }

    public void setInstructorNotification(Integer instructorNotification) {
        this.instructorNotification = instructorNotification;
        this.data.setInstructorNotification(instructorNotification);
    }

    public Integer getInstructorNotification() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getInstructorNotification();
    }

    public void setTesteeNotification(Integer testeeNotification) {
        this.testeeNotification = testeeNotification;
        this.data.setTesteeNotification(testeeNotification);
    }

    public Integer getTesteeNotification() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTesteeNotification();
    }

    public void setMultipartAllowed(Integer multipartAllowed) {
        this.multipartAllowed = multipartAllowed;
        this.data.setMultipartAllowed(multipartAllowed);
    }

    public Integer getMultipartAllowed() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getMultipartAllowed();
    }

    public Integer getStatus() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getStatus();
    }

    public void setStatus(Integer status) {
        this.status = status;
        this.data.setStatus(status);
    }

    public String getCreatedBy() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getCreatedBy();
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        this.data.setCreatedBy(createdBy);
    }

    public Date getCreatedDate() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getCreatedDate();
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
        this.data.setCreatedDate(createdDate);
    }

    public String getLastModifiedBy() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedBy();
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        this.data.setLastModifiedBy(lastModifiedBy);
    }

    public Date getLastModifiedDate() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedDate();
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        this.data.setLastModifiedDate(lastModifiedDate);
    }

    public AssessmentAccessControlIfc getAssessmentAccessControl() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAssessmentAccessControl();
    }

    public void setAssessmentAccessControl(AssessmentAccessControlIfc assessmentAccessControl) {
        this.assessmentAccessControl = assessmentAccessControl;
        this.data.setAssessmentAccessControl(assessmentAccessControl);
    }

    public EvaluationModelIfc getEvaluationModel() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getEvaluationModel();
    }

    public void setEvaluationModel(EvaluationModelIfc evaluationModel) {
        this.evaluationModel = evaluationModel;
        this.data.setEvaluationModel(evaluationModel);
    }

    public AssessmentFeedbackIfc getAssessmentFeedback() {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAssessmentFeedback();
    }

    public void setAssessmentFeedback(AssessmentFeedbackIfc assessmentFeedback) {
        this.assessmentFeedback = assessmentFeedback;
        this.data.setAssessmentFeedback(assessmentFeedback);
    }

    public Set getSecuredIPAddressSet() {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getSecuredIPAddressSet();
    }

    public void setSecuredIPAddressSet(Set securedIPAddressSet) {
        this.securedIPAddressSet = securedIPAddressSet;
        this.data.setSecuredIPAddressSet(securedIPAddressSet);
    }

    public Set getAssessmentMetaDataSet() throws DataFacadeException {
        try {
            this.data = (AssessmentBaseIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAssessmentMetaDataSet();
    }

    public void setAssessmentMetaDataSet(Set assessmentMetaDataSet) {
        this.assessmentMetaDataSet = assessmentMetaDataSet;
        this.data.setAssessmentMetaDataSet(assessmentMetaDataSet);
        this.assessmentMetaDataMap = this.getAssessmentMetaDataMap(assessmentMetaDataSet);
    }

    public HashMap getAssessmentMetaDataMap(Set assessmentMetaDataSet) {
        HashMap<String, String> assessmentMetaDataMap = new HashMap<String, String>();
        if (assessmentMetaDataSet != null) {
            for (AssessmentMetaData assessmentMetaData : assessmentMetaDataSet) {
                assessmentMetaDataMap.put(assessmentMetaData.getLabel(), assessmentMetaData.getEntry());
            }
        }
        return assessmentMetaDataMap;
    }

    public HashMap getAssessmentMetaDataMap() {
        HashMap<String, String> assessmentMetaDataMap = new HashMap<String, String>();
        if (this.assessmentMetaDataSet != null) {
            for (AssessmentMetaData assessmentMetaData : this.assessmentMetaDataSet) {
                assessmentMetaDataMap.put(assessmentMetaData.getLabel(), assessmentMetaData.getEntry());
            }
        }
        return assessmentMetaDataMap;
    }

    public String getAssessmentMetaDataByLabel(String label) {
        if (this.assessmentMetaDataMap.get(label) == null) {
            return "";
        }
        return (String)this.assessmentMetaDataMap.get(label);
    }

    public String getMetaDataQuestions_isInstructorEditable() {
        return (String)this.assessmentMetaDataMap.get("metadataQuestions_isInstructorEditable");
    }

    public String getHasMetaDataForQuestions() {
        return (String)this.assessmentMetaDataMap.get("hasMetaDataForQuestions");
    }

    public String getShowFeedbackAuthoring() {
        return (String)this.assessmentMetaDataMap.get("showFeedbackAuthoring");
    }

    public void addAssessmentMetaData(String label, String entry) {
        this.assessmentMetaDataMap = this.getAssessmentMetaDataMap();
        if (this.assessmentMetaDataMap.get(label) != null) {
            for (AssessmentMetaData metadata : this.assessmentMetaDataSet) {
                if (!metadata.getLabel().equals(label)) continue;
                metadata.setEntry(entry);
            }
        } else {
            AssessmentMetaData metadata = null;
            if (entry != null && !"".equals(entry)) {
                metadata = new AssessmentMetaData(this.data, label, entry);
                this.assessmentMetaDataSet.add(metadata);
            }
            this.setAssessmentMetaDataSet(this.assessmentMetaDataSet);
        }
    }

    public void updateAssessmentMetaData(String label, String entry) {
        this.addAssessmentMetaData(label, entry);
    }

    public void addAssessmentAttachmentMetaData(String entry) {
        this.assessmentAttachmentMetaData = entry;
    }

    public String getAssessmentAttachmentMetaData() {
        return this.assessmentAttachmentMetaData;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

