/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAccessControl;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentBaseData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentTemplateData;
import org.sakaiproject.tool.assessment.data.dao.assessment.AttachmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTextAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemTextAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SecuredIPAddress;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAccessControlIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentTemplateIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.AssessmentTemplateFacade;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.util.PagingUtilQueriesAPI;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.QuestionPoolService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateQueryException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class AssessmentFacadeQueries
extends HibernateDaoSupport
implements AssessmentFacadeQueriesAPI {
    private Logger log = LoggerFactory.getLogger(AssessmentFacadeQueries.class);
    public static final String TITLE = "title";

    @Override
    public IdImpl getId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getId(long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentId(long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getAssessmentTemplateId(long id) {
        return new IdImpl(id);
    }

    @Override
    public Long addTemplate() {
        AssessmentTemplateData assessmentTemplate = new AssessmentTemplateData(Long.valueOf(0L), TITLE, "description", "comments", TypeD.HOMEWORK, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "1", new Date(), "1", new Date());
        AssessmentAccessControl s = new AssessmentAccessControl(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), new Date(), new Date(), new Date(), new Date(), new Date(), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "Thanks for submitting", "anonymous");
        s.setAssessmentBase((AssessmentBaseIfc)assessmentTemplate);
        assessmentTemplate.setAssessmentAccessControl((AssessmentAccessControlIfc)s);
        assessmentTemplate.addAssessmentMetaData("ASSESSMENTTEMPLATE_OBJECTIVES", " assesmentT: the objective is to ...");
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)assessmentTemplate);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem saving template: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        return assessmentTemplate.getAssessmentTemplateId();
    }

    @Override
    public void removeTemplate(Long assessmentId) {
        AssessmentTemplateData assessment = (AssessmentTemplateData)this.getHibernateTemplate().load(AssessmentTemplateData.class, (Serializable)assessmentId);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem delete template: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public Long addAssessment(Long assessmentTemplateId) {
        AssessmentData assessment = new AssessmentData(Long.valueOf(0L), "assessment title", "assessment description", "assessment acomments", assessmentTemplateId, TypeD.HOMEWORK, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "1", new Date(), "1", new Date());
        AssessmentAccessControl s = new AssessmentAccessControl(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), new Date(), new Date(), new Date(), new Date(), new Date(), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1), "Thanks for submitting", "anonymous");
        s.setAssessmentBase((AssessmentBaseIfc)assessment);
        assessment.setAssessmentAccessControl((AssessmentAccessControlIfc)s);
        assessment.addAssessmentMetaData("ASSESSMENT_OBJECTIVES", " assesment: the objective is to ...");
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem saving assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        return assessment.getAssessmentId();
    }

    @Override
    public AssessmentBaseData load(Long id) {
        AssessmentBaseData a = (AssessmentBaseData)this.getHibernateTemplate().load(AssessmentBaseData.class, (Serializable)id);
        if (a.getIsTemplate().equals(Boolean.TRUE)) {
            return (AssessmentTemplateData)a;
        }
        return (AssessmentData)a;
    }

    @Override
    public AssessmentTemplateData loadTemplate(Long assessmentTemplateId) {
        return (AssessmentTemplateData)this.getHibernateTemplate().load(AssessmentTemplateData.class, (Serializable)assessmentTemplateId);
    }

    @Override
    public AssessmentData loadAssessment(Long assessmentId) {
        return (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
    }

    @Override
    public AssessmentTemplateFacade getAssessmentTemplate(Long assessmentTemplateId) {
        AssessmentTemplateData template = (AssessmentTemplateData)this.getHibernateTemplate().load(AssessmentTemplateData.class, (Serializable)assessmentTemplateId);
        return new AssessmentTemplateFacade((AssessmentTemplateIfc)template);
    }

    @Override
    public ArrayList getAllAssessmentTemplates() {
        final String agent = AgentFacade.getAgentString();
        final Long typeId = TypeD.TEMPLATE_SYSTEM_DEFINED;
        String query = "select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.typeId) from AssessmentTemplateData a where a.assessmentBaseId=? or a.createdBy=? or a.typeId=? order by a.title";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.typeId) from AssessmentTemplateData a where a.assessmentBaseId=? or a.createdBy=? or a.typeId=? order by a.title");
                q.setLong(0, Long.valueOf(1L).longValue());
                q.setString(1, agent);
                q.setLong(2, typeId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentTemplateFacade> templateList = new ArrayList<AssessmentTemplateFacade>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentTemplateData a = (AssessmentTemplateData)list.get(i);
            AssessmentTemplateFacade f = new AssessmentTemplateFacade((AssessmentTemplateIfc)a);
            templateList.add(f);
        }
        return templateList;
    }

    @Override
    public ArrayList getAllActiveAssessmentTemplates() {
        final String agent = AgentFacade.getAgentString();
        final Long typeId = TypeD.TEMPLATE_SYSTEM_DEFINED;
        String query = "select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.typeId) from AssessmentTemplateData a where a.status=? and (a.assessmentBaseId=? or a.createdBy=? or a.typeId=?) order by a.title";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.typeId) from AssessmentTemplateData a where a.status=? and (a.assessmentBaseId=? or a.createdBy=? or a.typeId=?) order by a.title");
                q.setInteger(0, 1);
                q.setLong(1, Long.valueOf(1L).longValue());
                q.setString(2, agent);
                q.setLong(3, typeId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentTemplateFacade> templateList = new ArrayList<AssessmentTemplateFacade>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentTemplateData a = (AssessmentTemplateData)list.get(i);
            AssessmentTemplateFacade f = new AssessmentTemplateFacade((AssessmentTemplateIfc)a);
            templateList.add(f);
        }
        return templateList;
    }

    @Override
    public ArrayList getTitleOfAllActiveAssessmentTemplates() {
        final String agent = AgentFacade.getAgentString();
        final Long typeId = TypeD.TEMPLATE_SYSTEM_DEFINED;
        String query = "select new AssessmentTemplateData(a.assessmentBaseId, a.title)  from AssessmentTemplateData a where a.status=? and  (a.assessmentBaseId=? or a.createdBy=? or typeId=?) order by a.title";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentTemplateData(a.assessmentBaseId, a.title)  from AssessmentTemplateData a where a.status=? and  (a.assessmentBaseId=? or a.createdBy=? or typeId=?) order by a.title");
                q.setInteger(0, 1);
                q.setLong(1, Long.valueOf(1L).longValue());
                q.setString(2, agent);
                q.setLong(3, typeId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentTemplateFacade> templateList = new ArrayList<AssessmentTemplateFacade>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentTemplateData a = (AssessmentTemplateData)list.get(i);
            a.setAssessmentTemplateId(a.getAssessmentBaseId());
            AssessmentTemplateFacade f = new AssessmentTemplateFacade(a.getAssessmentBaseId(), a.getTitle());
            templateList.add(f);
        }
        return templateList;
    }

    @Override
    public AssessmentFacade getAssessment(Long assessmentId) {
        try {
            AssessmentData assessment = (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
            assessment.setSectionSet((Set)this.getSectionSetForAssessment(assessment));
            return new AssessmentFacade((AssessmentIfc)assessment);
        }
        catch (DataAccessException e) {
            this.log.warn("error retieving assemement: " + assessmentId.toString() + " " + e.getMessage());
            return null;
        }
    }

    private HashSet getSectionSetForAssessment(AssessmentData assessment) {
        List sectionList = this.getHibernateTemplate().find("from SectionData s where s.assessment.assessmentBaseId=?", (Object)assessment.getAssessmentBaseId());
        HashSet<SectionData> set = new HashSet<SectionData>();
        for (int j = 0; j < sectionList.size(); ++j) {
            set.add((SectionData)sectionList.get(j));
        }
        return set;
    }

    @Override
    public void removeAssessment(final Long assessmentId) {
        Iterator iter;
        int i;
        List count = this.getHibernateTemplate().find("select count(p) from PublishedAssessmentData p where p.assessmentId=?", (Object)assessmentId);
        if (this.log.isDebugEnabled()) {
            this.log.debug("removeAssesment: no. of pub Assessment =" + count.size());
        }
        if ((i = ((Integer)(iter = count.iterator()).next()).intValue()) < 1) {
            AssessmentData assessment = (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
            AssessmentService s = new AssessmentService();
            List resourceIdList = s.getAssessmentResourceIdList((AssessmentIfc)assessment);
            if (this.log.isDebugEnabled()) {
                this.log.debug("*** we have no. of resource in assessment=" + resourceIdList.size());
            }
            s.deleteResources(resourceIdList);
        }
        String softDeleteQuery = "update AssessmentData set status=? WHERE assessmentBaseId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("update AssessmentData set status=? WHERE assessmentBaseId=?");
                q.setInteger(0, AssessmentIfc.DEAD_STATUS.intValue());
                q.setLong(1, assessmentId.longValue());
                return q.executeUpdate();
            }
        };
        this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public AssessmentData cloneAssessmentFromTemplate(AssessmentTemplateData t) {
        AssessmentData assessment = new AssessmentData(t.getParentId(), "Assessment created with" + t.getTitle(), t.getDescription(), t.getComments(), t.getAssessmentTemplateId(), TypeD.HOMEWORK, t.getInstructorNotification(), t.getTesteeNotification(), t.getMultipartAllowed(), t.getStatus(), AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        try {
            EvaluationModel evalOrig;
            AssessmentFeedback feedbackOrig;
            AssessmentAccessControl controlOrig = (AssessmentAccessControl)t.getAssessmentAccessControl();
            if (controlOrig != null) {
                AssessmentAccessControl control = (AssessmentAccessControl)controlOrig.clone();
                control.setAssessmentBase((AssessmentBaseIfc)assessment);
                assessment.setAssessmentAccessControl((AssessmentAccessControlIfc)control);
            }
            if ((feedbackOrig = (AssessmentFeedback)t.getAssessmentFeedback()) != null) {
                AssessmentFeedback feedback = (AssessmentFeedback)feedbackOrig.clone();
                feedback.setAssessmentBase((AssessmentBaseIfc)assessment);
                assessment.setAssessmentFeedback((AssessmentFeedbackIfc)feedback);
            }
            if ((evalOrig = (EvaluationModel)t.getEvaluationModel()) != null) {
                EvaluationModel eval = (EvaluationModel)evalOrig.clone();
                eval.setAssessmentBase((AssessmentBaseIfc)assessment);
                assessment.setEvaluationModel((EvaluationModelIfc)eval);
            }
            HashSet<AssessmentMetaData> h = new HashSet<AssessmentMetaData>();
            Set s = t.getAssessmentMetaDataSet();
            for (AssessmentMetaData mOrig : s) {
                if (mOrig.getLabel() == null) continue;
                AssessmentMetaData m = new AssessmentMetaData((AssessmentBaseIfc)assessment, mOrig.getLabel(), mOrig.getEntry());
                h.add(m);
            }
            assessment.setAssessmentMetaDataSet(h);
            HashSet<SectionData> sh = new HashSet<SectionData>();
            SectionData section = new SectionData(null, new Integer("1"), "Default", "", TypeD.DEFAULT_SECTION, SectionData.ACTIVE_STATUS, AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
            section.setAssessment((AssessmentIfc)assessment);
            section.addSectionMetaData("AUTHOR_TYPE", SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString());
            section.addSectionMetaData("QUESTIONS_ORDERING", SectionDataIfc.AS_LISTED_ON_ASSESSMENT_PAGE.toString());
            sh.add(section);
            assessment.setSectionSet(sh);
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return assessment;
    }

    @Override
    public AssessmentFacade createAssessmentWithoutDefaultSection(String title, String description, Long typeId, Long templateId) throws Exception {
        return this.createAssessmentWithoutDefaultSection(title, description, typeId, templateId, null);
    }

    @Override
    public AssessmentFacade createAssessmentWithoutDefaultSection(String title, String description, Long typeId, Long templateId, String siteId) throws Exception {
        AssessmentData assessment = null;
        try {
            assessment = this.prepareAssessment(title, description, typeId, templateId, siteId);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        assessment.setSectionSet(new HashSet());
        this.getHibernateTemplate().save((Object)assessment);
        this.registerWithSite(assessment.getAssessmentId().toString(), siteId);
        return new AssessmentFacade((AssessmentIfc)assessment);
    }

    private AssessmentData prepareAssessment(String title, String description, Long typeId, Long templateId, String siteId) throws Exception {
        AssessmentTemplateFacade template = this.getAssessmentTemplate(templateId);
        AssessmentData assessment = this.cloneAssessmentFromTemplate((AssessmentTemplateData)template.getData());
        assessment.setTitle(title);
        assessment.setDescription(description);
        assessment.setTypeId(typeId);
        AssessmentAccessControl control = (AssessmentAccessControl)assessment.getAssessmentAccessControl();
        if (control == null) {
            control = new AssessmentAccessControl();
        }
        control.setTimedAssessment(Integer.valueOf(0));
        control.setTimeLimit(Integer.valueOf(0));
        String defaultReleaseTo = template.getAssessmentMetaDataByLabel("releaseTo");
        if ("ANONYMOUS_USERS".equals(defaultReleaseTo)) {
            control.setReleaseTo("Anonymous Users");
        } else if (siteId == null || siteId.length() == 0) {
            control.setReleaseTo(AgentFacade.getCurrentSiteName());
        } else {
            control.setReleaseTo(AgentFacade.getSiteName(siteId));
        }
        EvaluationModel evaluation = (EvaluationModel)assessment.getEvaluationModel();
        if (evaluation == null) {
            evaluation = new EvaluationModel();
        }
        GradebookExternalAssessmentService g = null;
        boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
        try {
            GradebookServiceHelper gbsHelper;
            if (integrated) {
                g = (GradebookExternalAssessmentService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookExternalAssessmentService");
            }
            if (!(gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper()).gradebookExists(GradebookFacade.getGradebookUId(siteId), g)) {
                evaluation.setToGradeBook(EvaluationModelIfc.GRADEBOOK_NOT_AVAILABLE.toString());
            }
        }
        catch (HibernateQueryException e) {
            this.log.warn("Gradebook Error: " + e.getMessage());
            evaluation.setToGradeBook(EvaluationModelIfc.GRADEBOOK_NOT_AVAILABLE.toString());
            throw new Exception(e);
        }
        return assessment;
    }

    @Override
    public AssessmentFacade createAssessment(String title, String description, Long typeId, Long templateId) throws Exception {
        return this.createAssessment(title, description, typeId, templateId, null);
    }

    @Override
    public AssessmentFacade createAssessment(String title, String description, Long typeId, Long templateId, String siteId) throws Exception {
        AssessmentData assessment = null;
        try {
            assessment = this.prepareAssessment(title, description, typeId, templateId, siteId);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem saving assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        this.registerWithSite(assessment.getAssessmentId().toString(), siteId);
        return new AssessmentFacade((AssessmentIfc)assessment);
    }

    private void registerWithSite(String qualifierIdString, String siteId) {
        if (siteId == null || siteId.length() == 0) {
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(AgentFacade.getCurrentSiteId(), "EDIT_ASSESSMENT", qualifierIdString);
        } else {
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(siteId, "EDIT_ASSESSMENT", qualifierIdString);
        }
    }

    private void registerWithCurrentSite(String qualifierIdString) {
        this.registerWithSite(qualifierIdString, null);
    }

    @Override
    public ArrayList getAllAssessments(String orderBy) {
        List list = this.getHibernateTemplate().find("from AssessmentData a order by a." + orderBy);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentData a = (AssessmentData)list.get(i);
            AssessmentFacade f = new AssessmentFacade((AssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public ArrayList getAllActiveAssessments(String orderBy) {
        List list = this.getHibernateTemplate().find("from AssessmentData a where a.status=? order by a." + orderBy, (Object)1);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentData a = (AssessmentData)list.get(i);
            a.setSectionSet((Set)this.getSectionSetForAssessment(a));
            AssessmentFacade f = new AssessmentFacade((AssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public ArrayList getBasicInfoOfAllActiveAssessments(String orderBy, boolean ascending) {
        String query = "select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate)from AssessmentData a where a.status=? order by a." + orderBy;
        query = ascending ? query + " asc" : query + " desc";
        List list = this.getHibernateTemplate().find(query, (Object)1);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentData a = (AssessmentData)list.get(i);
            AssessmentFacade f = new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate());
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public ArrayList getBasicInfoOfAllActiveAssessmentsByAgent(String orderBy, final String siteAgentId, boolean ascending) {
        StringBuilder sb = new StringBuilder("select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.lastModifiedBy) ");
        sb.append("from AssessmentData a, AuthorizationData z where a.status=? and ");
        sb.append("a.assessmentBaseId=z.qualifierId and z.functionId=? ");
        sb.append("and z.agentIdString=? order by a.");
        sb.append(orderBy);
        String query = sb.toString();
        query = ascending ? query + " asc" : query + " desc";
        final String hql = query;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setInteger(0, 1);
                q.setString(1, "EDIT_ASSESSMENT");
                q.setString(2, siteAgentId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        HashMap<Object, Object> questionSizeMap = new HashMap<Object, Object>();
        HibernateCallback hcb2 = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                StringBuilder sb2 = new StringBuilder("select a.assessmentBaseId, count(*) ");
                sb2.append("from ItemData i, SectionData s,  AssessmentData a, AuthorizationData z ");
                sb2.append("where a = s.assessment and s = i.section and a.assessmentBaseId = z.qualifierId ");
                sb2.append("and z.functionId=? and z.agentIdString=? ");
                sb2.append("group by a.assessmentBaseId ");
                Query q2 = session.createQuery(sb2.toString());
                q2.setString(0, "EDIT_ASSESSMENT");
                q2.setString(1, siteAgentId);
                return q2.list();
            }
        };
        List questionSizeList = this.getHibernateTemplate().executeFind(hcb2);
        for (Object[] o : questionSizeList) {
            questionSizeMap.put(o[0], o[1]);
        }
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        String lastModifiedBy = "";
        AgentFacade agent = null;
        for (int i = 0; i < list.size(); ++i) {
            AssessmentData a = (AssessmentData)list.get(i);
            agent = new AgentFacade(a.getLastModifiedBy());
            if (agent != null) {
                lastModifiedBy = agent.getDisplayName();
            }
            int questionSize = 0;
            if (questionSizeMap.get(a.getAssessmentBaseId()) != null) {
                questionSize = (Integer)questionSizeMap.get(a.getAssessmentBaseId());
            }
            AssessmentFacade f = new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate(), lastModifiedBy, questionSize);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public ArrayList getBasicInfoOfAllActiveAssessmentsByAgent(String orderBy, final String siteAgentId) {
        final String query = "select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate)  from AssessmentData a, AuthorizationData z where a.status=? and  a.assessmentBaseId=z.qualifierId and z.functionId=?  and z.agentIdString=? order by a." + orderBy;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(query);
                q.setInteger(0, 1);
                q.setString(1, "EDIT_ASSESSMENT");
                q.setString(2, siteAgentId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentData a = (AssessmentData)list.get(i);
            AssessmentFacade f = new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate());
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public AssessmentFacade getBasicInfoOfAnAssessment(Long assessmentId) {
        AssessmentData a = (AssessmentData)this.getHibernateTemplate().load(AssessmentData.class, (Serializable)assessmentId);
        AssessmentFacade f = new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate());
        f.setCreatedBy(a.getCreatedBy());
        return f;
    }

    @Override
    public AssessmentFacade getBasicInfoOfAnAssessmentFromSectionId(Long sectionId) {
        SectionData section = this.loadSection(sectionId);
        AssessmentData a = (AssessmentData)section.getAssessment();
        AssessmentFacade f = new AssessmentFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate());
        f.setCreatedBy(a.getCreatedBy());
        return f;
    }

    @Override
    public ArrayList getSettingsOfAllActiveAssessments(String orderBy) {
        List list = this.getHibernateTemplate().find("from AssessmentData a where a.status=? order by a." + orderBy, (Object)1);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        Boolean loadSection = Boolean.FALSE;
        for (int i = 0; i < list.size(); ++i) {
            AssessmentData a = (AssessmentData)list.get(i);
            AssessmentFacade f = new AssessmentFacade((AssessmentIfc)a, loadSection);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public ArrayList getAllAssessments(int pageSize, int pageNumber, String orderBy) {
        String queryString = "from AssessmentData a order by a." + orderBy;
        PagingUtilQueriesAPI pagingUtilQueries = PersistenceService.getInstance().getPagingUtilQueries();
        List pageList = pagingUtilQueries.getAll(pageSize, pageNumber, queryString);
        ArrayList<AssessmentFacade> assessmentList = new ArrayList<AssessmentFacade>();
        for (int i = 0; i < pageList.size(); ++i) {
            AssessmentData a = (AssessmentData)pageList.get(i);
            AssessmentFacade f = new AssessmentFacade((AssessmentIfc)a);
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public int getQuestionSize(final Long assessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(i) from ItemData i, SectionData s,  AssessmentData a where a = s.assessment and s = i.section and a.assessmentBaseId=?");
                q.setLong(0, assessmentId.longValue());
                return q.list();
            }
        };
        List size = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = size.iterator();
        if (iter.hasNext()) {
            int i = (Integer)iter.next();
            return i;
        }
        return 0;
    }

    @Override
    public void deleteAllSecuredIP(AssessmentIfc assessment) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                Long assessmentId = assessment.getAssessmentId();
                List ip = this.getHibernateTemplate().find("from SecuredIPAddress s where s.assessment.assessmentBaseId=?", (Object)assessmentId);
                if (ip.size() > 0) {
                    SecuredIPAddress s = (SecuredIPAddress)ip.get(0);
                    AssessmentData a = (AssessmentData)s.getAssessment();
                    a.setSecuredIPAddressSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)ip);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem deleting ip address: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdate(AssessmentFacade assessment) {
        AssessmentData data = (AssessmentData)assessment.getData();
        data.setLastModifiedBy(AgentFacade.getAgentString());
        data.setLastModifiedDate(new Date());
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem save new settings: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deleteAllMetaData(AssessmentBaseIfc t) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                List metadatas = this.getHibernateTemplate().find("from AssessmentMetaData a where a.assessment.assessmentBaseId = ?", (Object)t.getAssessmentBaseId());
                if (metadatas.size() > 0) {
                    AssessmentMetaDataIfc m = (AssessmentMetaDataIfc)metadatas.get(0);
                    AssessmentBaseIfc a = m.getAssessment();
                    a.setAssessmentMetaDataSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)metadatas);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem deleting metadata: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdate(AssessmentTemplateData template) {
        template.setLastModifiedBy(AgentFacade.getAgentString());
        template.setLastModifiedDate(new Date());
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)template);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem save or update template: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deleteTemplate(Long templateId) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)this.getAssessmentTemplate(templateId).getData());
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem delete template: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public SectionFacade addSection(Long assessmentId) {
        AssessmentData assessment = this.loadAssessment(assessmentId);
        HashSet sectionSet = this.getSectionSetForAssessment(assessment);
        assessment.setSectionSet((Set)sectionSet);
        SectionData section = new SectionData(null, Integer.valueOf(sectionSet.size() + 1), "", "", TypeD.DEFAULT_SECTION, SectionData.ACTIVE_STATUS, AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        section.setAssessment((AssessmentIfc)assessment);
        section.setAssessmentId(assessment.getAssessmentId());
        section.addSectionMetaData("AUTHOR_TYPE", SectionDataIfc.QUESTIONS_AUTHORED_ONE_BY_ONE.toString());
        section.addSectionMetaData("QUESTIONS_ORDERING", SectionDataIfc.AS_LISTED_ON_ASSESSMENT_PAGE.toString());
        sectionSet.add(section);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)section);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem save or update assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        return new SectionFacade((SectionDataIfc)section);
    }

    @Override
    public SectionFacade getSection(Long sectionId) {
        SectionData section = (SectionData)this.getHibernateTemplate().load(SectionData.class, (Serializable)sectionId);
        return new SectionFacade((SectionDataIfc)section);
    }

    @Override
    public void removeSection(Long sectionId) {
        SectionData section = this.loadSection(sectionId);
        if (section != null) {
            QuestionPoolService qpService = new QuestionPoolService();
            HashMap h = qpService.getQuestionPoolItemMap();
            this.checkForQuestionPoolItem(section, h);
            AssessmentData assessment = (AssessmentData)section.getAssessment();
            assessment.setLastModifiedBy(AgentFacade.getAgentString());
            assessment.setLastModifiedDate(new Date());
            HashSet sectionSet = this.getSectionSetForAssessment(assessment);
            assessment.setSectionSet((Set)sectionSet);
            ArrayList sections = assessment.getSectionArraySorted();
            HashSet<SectionData> set = new HashSet<SectionData>();
            int count = 1;
            for (int i = 0; i < sections.size(); ++i) {
                SectionData s = (SectionData)sections.get(i);
                if (s.getSectionId().equals(section.getSectionId())) continue;
                s.setSequence(Integer.valueOf(count++));
                set.add(s);
            }
            assessment.setSectionSet(set);
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().update((Object)assessment);
                    retryCount = 0;
                }
                catch (Exception e) {
                    this.log.warn("problem updating asssessment: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
            AssessmentService service = new AssessmentService();
            List sectionAttachmentList = service.getSectionResourceIdList((SectionDataIfc)section);
            service.deleteResources(sectionAttachmentList);
            retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().delete((Object)section);
                    retryCount = 0;
                }
                catch (Exception e) {
                    this.log.warn("problem deletint section: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
        }
    }

    @Override
    public SectionData loadSection(Long sectionId) {
        return (SectionData)this.getHibernateTemplate().load(SectionData.class, (Serializable)sectionId);
    }

    @Override
    public void saveOrUpdateSection(SectionFacade section) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)section.getData());
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem save or update section: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    private List loadAllItems(Long sectionId) {
        return this.getHibernateTemplate().find("from ItemData i where i.section.sectionId=" + sectionId);
    }

    @Override
    public void moveAllItems(Long sourceSectionId, Long destSectionId) {
        SectionData destSection = this.loadSection(destSectionId);
        List list = this.loadAllItems(sourceSectionId);
        HashSet<ItemDataIfc> set = destSection.getItemSet();
        if (set == null) {
            set = new HashSet<ItemDataIfc>();
        }
        int itemNum = set.size();
        for (int i = 0; i < list.size(); ++i) {
            ItemDataIfc a = (ItemDataIfc)list.get(i);
            a.setSection((SectionDataIfc)destSection);
            a.setSequence(Integer.valueOf(++itemNum));
            set.add(a);
        }
        destSection.setItemSet(set);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)destSection);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem updating section: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void removeAllItems(Long sourceSectionId) {
        SectionData section = this.loadSection(sourceSectionId);
        AssessmentData assessment = (AssessmentData)section.getAssessment();
        assessment.setLastModifiedBy(AgentFacade.getAgentString());
        assessment.setLastModifiedDate(new Date());
        Set itemSet = section.getItemSet();
        for (ItemData item : itemSet) {
            item.setSection(null);
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().update((Object)item);
                    retryCount = 0;
                }
                catch (Exception e) {
                    this.log.warn("problem updating item: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
        }
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem updating asssessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public ArrayList getBasicInfoOfAllActiveAssessmentTemplates(String orderBy) {
        final String agent = AgentFacade.getAgentString();
        final Long typeId = TypeD.TEMPLATE_SYSTEM_DEFINED;
        final String query = "select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate, a.typeId) from AssessmentTemplateData a where a.status=1 and (a.assessmentBaseId=? or a.createdBy=? or typeId=?) order by a." + orderBy;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(query);
                q.setLong(0, Long.valueOf(1L).longValue());
                q.setString(1, agent);
                q.setLong(2, typeId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentTemplateFacade> assessmentList = new ArrayList<AssessmentTemplateFacade>();
        for (int i = 0; i < list.size(); ++i) {
            AssessmentTemplateData a = (AssessmentTemplateData)list.get(i);
            AssessmentTemplateFacade f = new AssessmentTemplateFacade(a.getAssessmentBaseId(), a.getTitle(), a.getLastModifiedDate(), a.getTypeId());
            assessmentList.add(f);
        }
        return assessmentList;
    }

    @Override
    public void checkForQuestionPoolItem(AssessmentData assessment, HashMap qpItemHash) {
        HashSet sectionSet = this.getSectionSetForAssessment(assessment);
        for (SectionData s : sectionSet) {
            this.checkForQuestionPoolItem(s, qpItemHash);
        }
    }

    @Override
    public void checkForQuestionPoolItem(SectionData section, HashMap qpItemHash) {
        Set itemSet = section.getItemSet();
        HashSet<ItemData> newItemSet = new HashSet<ItemData>();
        for (ItemData item : itemSet) {
            if (qpItemHash.get(item.getItemId().toString()) != null) {
                item.setSection(null);
                int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)item);
                        retryCount = 0;
                    }
                    catch (Exception e) {
                        this.log.warn("problem updating item: " + e.getMessage());
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                    }
                }
                continue;
            }
            newItemSet.add(item);
        }
        section.setItemSet(newItemSet);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)section);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem updating section: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public boolean assessmentTitleIsUnique(final Long assessmentBaseId, String title, Boolean isTemplate) {
        List list;
        Object hcb;
        String titlef;
        String hql;
        title = title.trim();
        final String currentSiteId = AgentFacade.getCurrentSiteId();
        final String agentString = AgentFacade.getAgentString();
        boolean isUnique = true;
        String query = "";
        if (isTemplate.booleanValue()) {
            hql = query = "select new AssessmentTemplateData(a.assessmentBaseId, a.title, a.lastModifiedDate) from AssessmentTemplateData a, AuthorizationData z where  a.title=? and a.assessmentBaseId!=? and a.createdBy=? and a.status=?";
            titlef = title;
            hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery(hql);
                    q.setString(0, titlef);
                    q.setLong(1, assessmentBaseId.longValue());
                    q.setString(2, agentString);
                    q.setInteger(3, 1);
                    return q.list();
                }
            };
            list = this.getHibernateTemplate().executeFind(hcb);
        } else {
            hql = query = "select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate) from AssessmentData a, AuthorizationData z where  a.title=? and a.assessmentBaseId!=? and z.functionId=? and  a.assessmentBaseId=z.qualifierId and z.agentIdString=? and a.status=?";
            titlef = title;
            hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery(hql);
                    q.setString(0, titlef);
                    q.setLong(1, assessmentBaseId.longValue());
                    q.setString(2, "EDIT_ASSESSMENT");
                    q.setString(3, currentSiteId);
                    q.setInteger(4, 1);
                    return q.list();
                }
            };
            list = this.getHibernateTemplate().executeFind(hcb);
        }
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                AssessmentBaseIfc a = (AssessmentBaseIfc)list.get(i);
                if (!title.equals(a.getTitle().trim())) continue;
                isUnique = false;
                break;
            }
        }
        return isUnique;
    }

    @Override
    public List getAssessmentByTemplate(final Long templateId) {
        String query = "select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate)  from AssessmentData a where a.assessmentTemplateId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentData(a.assessmentBaseId, a.title, a.lastModifiedDate)  from AssessmentData a where a.assessmentTemplateId=?");
                q.setLong(0, templateId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List getDefaultMetaDataSet() {
        String query = " from AssessmentMetaData m where m.assessment.assessmentBaseId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(" from AssessmentMetaData m where m.assessment.assessmentBaseId=?");
                q.setLong(0, 1L);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public long fileSizeInKB(long fileSize) {
        return fileSize / 1024L;
    }

    public String getRelativePath(String url, String protocol) {
        int index = (url = this.replaceSpace(url)).lastIndexOf(protocol);
        if (index == 0) {
            url = url.substring(protocol.length());
        }
        return url;
    }

    private String replaceSpace(String tempString) {
        String newString = "";
        char[] oneChar = new char[1];
        for (int i = 0; i < tempString.length(); ++i) {
            if (tempString.charAt(i) != ' ') {
                oneChar[0] = tempString.charAt(i);
                String concatString = new String(oneChar);
                newString = newString.concat(concatString);
                continue;
            }
            newString = newString.concat("%20");
        }
        return newString;
    }

    @Override
    public void removeItemAttachment(Long itemAttachmentId) {
        ItemAttachment itemAttachment = (ItemAttachment)this.getHibernateTemplate().load(ItemAttachment.class, (Serializable)itemAttachmentId);
        ItemDataIfc item = itemAttachment.getItem();
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item == null) continue;
                Set set = item.getItemAttachmentSet();
                set.remove(itemAttachment);
                this.getHibernateTemplate().delete((Object)itemAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem delete itemAttachment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void removeItemTextAttachment(Long itemTextAttachmentId) {
        ItemTextAttachment itemTextAttachment = (ItemTextAttachment)this.getHibernateTemplate().load(ItemTextAttachment.class, (Serializable)itemTextAttachmentId);
        ItemTextIfc itemText = itemTextAttachment.getItemText();
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                if (itemText == null) continue;
                Set set = itemText.getItemTextAttachmentSet();
                set.remove(itemTextAttachment);
                this.getHibernateTemplate().delete((Object)itemTextAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem delete itemAttachment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void updateAssessmentLastModifiedInfo(AssessmentFacade assessment) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        AssessmentData data = (AssessmentData)assessment.getData();
        data.setLastModifiedBy(AgentFacade.getAgentString());
        data.setLastModifiedDate(new Date());
        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().update((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem update assessment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public ItemAttachmentIfc createItemAttachment(ItemDataIfc item, String resourceId, String filename, String protocol, boolean isEditPendingAssessmentFlow) {
        Object attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = isEditPendingAssessmentFlow ? new ItemAttachment() : new PublishedItemAttachment();
                attach.setItem(item);
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(ItemAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            pe.printStackTrace();
        }
        catch (IdUnusedException ie) {
            ie.printStackTrace();
        }
        catch (TypeException te) {
            te.printStackTrace();
        }
        return attach;
    }

    @Override
    public ItemTextAttachmentIfc createItemTextAttachment(ItemTextIfc itemText, String resourceId, String filename, String protocol, boolean isEditPendingAssessmentFlow) {
        Object attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = isEditPendingAssessmentFlow ? new ItemTextAttachment() : new PublishedItemTextAttachment();
                attach.setItemText(itemText);
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(ItemAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            pe.printStackTrace();
        }
        catch (IdUnusedException ie) {
            ie.printStackTrace();
        }
        catch (TypeException te) {
            te.printStackTrace();
        }
        return attach;
    }

    @Override
    public SectionAttachmentIfc createSectionAttachment(SectionDataIfc section, String resourceId, String filename, String protocol) {
        SectionAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new SectionAttachment();
                attach.setSection(section);
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(SectionAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            pe.printStackTrace();
        }
        catch (IdUnusedException ie) {
            ie.printStackTrace();
        }
        catch (TypeException te) {
            te.printStackTrace();
        }
        return attach;
    }

    @Override
    public void removeSectionAttachment(Long sectionAttachmentId) {
        SectionAttachment sectionAttachment = (SectionAttachment)this.getHibernateTemplate().load(SectionAttachment.class, (Serializable)sectionAttachmentId);
        SectionDataIfc section = sectionAttachment.getSection();
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (section == null) continue;
                Set set = section.getSectionAttachmentSet();
                set.remove(sectionAttachment);
                this.getHibernateTemplate().delete((Object)sectionAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem delete sectionAttachment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public AssessmentAttachmentIfc createAssessmentAttachment(AssessmentIfc assessment, String resourceId, String filename, String protocol) {
        AssessmentAttachment attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new AssessmentAttachment();
                attach.setAssessment(assessment);
                attach.setResourceId(resourceId);
                attach.setFilename(filename);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(AssessmentAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            pe.printStackTrace();
        }
        catch (IdUnusedException ie) {
            ie.printStackTrace();
        }
        catch (TypeException te) {
            te.printStackTrace();
        }
        return attach;
    }

    @Override
    public void removeAssessmentAttachment(Long assessmentAttachmentId) {
        AssessmentAttachment assessmentAttachment = (AssessmentAttachment)this.getHibernateTemplate().load(AssessmentAttachment.class, (Serializable)assessmentAttachmentId);
        AssessmentIfc assessment = assessmentAttachment.getAssessment();
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (assessment == null) continue;
                Set set = assessment.getAssessmentAttachmentSet();
                set.remove(assessmentAttachment);
                this.getHibernateTemplate().delete((Object)assessmentAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem delete assessmentAttachment: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public AttachmentData createEmailAttachment(String resourceId, String filename, String protocol) {
        AttachmentData attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = AssessmentService.getContentHostingService().getResource(resourceId);
            if (cr != null) {
                ResourceProperties p = cr.getProperties();
                attach = new AttachmentData();
                attach.setResourceId(resourceId);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(this.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(SectionAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(this.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (PermissionException pe) {
            pe.printStackTrace();
        }
        catch (IdUnusedException ie) {
            ie.printStackTrace();
        }
        catch (TypeException te) {
            te.printStackTrace();
        }
        return attach;
    }

    @Override
    public void saveOrUpdateAttachments(List<AttachmentIfc> list) {
        for (AttachmentIfc attachment : list) {
            this.getHibernateTemplate().saveOrUpdate((Object)attachment);
        }
    }

    @Override
    public List getAllActiveAssessmentsByAgent(final String siteAgentId) {
        String query = "select a  from AssessmentData a,AuthorizationData z where a.status=? and a.assessmentBaseId=z.qualifierId and z.functionId=?  and z.agentIdString=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a  from AssessmentData a,AuthorizationData z where a.status=? and a.assessmentBaseId=z.qualifierId and z.functionId=?  and z.agentIdString=?");
                q.setInteger(0, 1);
                q.setString(1, "EDIT_ASSESSMENT");
                q.setString(2, siteAgentId);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public void copyAllAssessments(String fromContext, String toContext, Map<String, String> transversalMap) {
        AssessmentData a;
        List list = this.getAllActiveAssessmentsByAgent(fromContext);
        ArrayList<AssessmentData> newList = new ArrayList<AssessmentData>();
        HashMap<AssessmentData, String> assessmentMap = new HashMap<AssessmentData, String>();
        for (int i = 0; i < list.size(); ++i) {
            a = (AssessmentData)list.get(i);
            this.log.debug("****protocol:" + ServerConfigurationService.getServerUrl());
            AssessmentData new_a = this.prepareAssessment(a, ServerConfigurationService.getServerUrl(), toContext);
            newList.add(new_a);
            assessmentMap.put(new_a, "sam_core/" + a.getAssessmentBaseId());
        }
        for (AssessmentData assessmentData : newList) {
            this.getHibernateTemplate().saveOrUpdate((Object)assessmentData);
        }
        for (int i = 0; i < newList.size(); ++i) {
            a = (AssessmentData)newList.get(i);
            PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(toContext, "EDIT_ASSESSMENT", a.getAssessmentId().toString());
            HashMap assessmentMetaDataMap = a.getAssessmentMetaDataMap();
            if (!assessmentMetaDataMap.containsKey("markForReview_isInstructorEditable")) {
                a.addAssessmentMetaData("markForReview_isInstructorEditable", "true");
                a.getAssessmentAccessControl().setMarkForReview(Integer.valueOf(1));
            }
            Set sectionSet = a.getSectionSet();
            for (SectionData section : sectionSet) {
                Set itemSet = section.getItemSet();
                for (ItemData item : itemSet) {
                    Set itemMetaDataSet = item.getItemMetaDataSet();
                    for (ItemMetaData itemMetaData : itemMetaDataSet) {
                        if (itemMetaData.getLabel() == null || !itemMetaData.getLabel().equals("PARTID")) continue;
                        this.log.debug("sectionId = " + section.getSectionId());
                        itemMetaData.setEntry(section.getSectionId().toString());
                    }
                }
            }
        }
        for (AssessmentData assessmentData : newList) {
            this.getHibernateTemplate().saveOrUpdate((Object)assessmentData);
        }
        for (AssessmentData data : newList) {
            String oldRef = (String)assessmentMap.get(data);
            if (oldRef == null || data.getAssessmentBaseId() == null) continue;
            transversalMap.put(oldRef, "sam_core/" + data.getAssessmentBaseId());
        }
    }

    @Override
    public void copyAssessment(String assessmentId, String apepndCopyTitle) {
        AssessmentData assessmentData = this.loadAssessment(Long.valueOf(assessmentId));
        assessmentData.setSectionSet((Set)this.getSectionSetForAssessment(assessmentData));
        AssessmentData newAssessmentData = this.prepareAssessment(assessmentData, ServerConfigurationService.getServerUrl(), AgentFacade.getCurrentSiteId());
        this.updateTitleForCopy(newAssessmentData, apepndCopyTitle);
        this.getHibernateTemplate().saveOrUpdate((Object)newAssessmentData);
        PersistenceService.getInstance().getAuthzQueriesFacade().createAuthorization(AgentFacade.getCurrentSiteId(), "EDIT_ASSESSMENT", newAssessmentData.getAssessmentId().toString());
        Set sectionSet = newAssessmentData.getSectionSet();
        for (SectionData section : sectionSet) {
            Set itemSet = section.getItemSet();
            for (ItemData item : itemSet) {
                Set itemMetaDataSet = item.getItemMetaDataSet();
                for (ItemMetaData itemMetaData : itemMetaDataSet) {
                    if (itemMetaData.getLabel() == null || !itemMetaData.getLabel().equals("PARTID")) continue;
                    this.log.debug("sectionId = " + section.getSectionId());
                    itemMetaData.setEntry(section.getSectionId().toString());
                }
            }
        }
        this.getHibernateTemplate().saveOrUpdate((Object)newAssessmentData);
    }

    private void updateTitleForCopy(AssessmentData assessmentData, String apepndCopyTitle) {
        StringBuffer sb = new StringBuffer(assessmentData.getTitle());
        sb.append(" ");
        sb.append(apepndCopyTitle);
        if (sb.length() >= 255) {
            String appendCopyText = "... " + apepndCopyTitle;
            String titleCut = sb.substring(0, 255 - appendCopyText.length() - 1);
            this.log.debug("titleCut = " + titleCut);
            sb = new StringBuffer(titleCut);
            sb.append(appendCopyText);
        }
        String newTitle = this.getNewAssessmentTitleForCopy(sb.toString());
        assessmentData.setTitle(newTitle);
    }

    private String getNewAssessmentTitleForCopy(String title) {
        String query;
        title = title.trim();
        this.log.debug(title);
        final String currentSiteId = AgentFacade.getCurrentSiteId();
        final String hql = query = "select a.title from AssessmentData a, AuthorizationData z where  a.title like ? and z.functionId='EDIT_ASSESSMENT' and  a.assessmentBaseId=z.qualifierId and z.agentIdString=?";
        final String titlef = title + "%";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString(0, titlef);
                q.setString(1, currentSiteId);
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        int startIndex = title.length();
        int maxNumCopy = 0;
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String existingTitle = ((String)list.get(i)).trim();
                if (!existingTitle.startsWith(title)) continue;
                try {
                    int numCopy = Integer.parseInt(existingTitle.substring(startIndex));
                    if (numCopy <= maxNumCopy) continue;
                    maxNumCopy = numCopy;
                    continue;
                }
                catch (NumberFormatException e) {
                    this.log.error("existingTitle = " + existingTitle + ", title = " + title + ", startIndex = " + startIndex + ", error message: " + e.getMessage());
                }
            }
        }
        this.log.debug("maxNumCopy = " + maxNumCopy);
        int nextNumCopy = maxNumCopy + 1;
        String newAssessmentTitle = title + nextNumCopy;
        return newAssessmentTitle;
    }

    public AssessmentData prepareAssessment(AssessmentData a, String protocol, String toContext) {
        AssessmentData newAssessment = new AssessmentData(new Long("0"), a.getTitle(), a.getDescription(), a.getComments(), a.getAssessmentTemplateId(), TypeFacade.HOMEWORK, a.getInstructorNotification(), a.getTesteeNotification(), a.getMultipartAllowed(), a.getStatus(), AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
        Set newSectionSet = this.prepareSectionSet(newAssessment, a.getSectionSet(), protocol, toContext);
        newAssessment.setSectionSet(newSectionSet);
        AssessmentAccessControl newAccessControl = this.prepareAssessmentAccessControl(newAssessment, (AssessmentAccessControl)a.getAssessmentAccessControl());
        newAssessment.setAssessmentAccessControl((AssessmentAccessControlIfc)newAccessControl);
        EvaluationModel newEvaluationModel = this.prepareEvaluationModel(newAssessment, (EvaluationModel)a.getEvaluationModel());
        newAssessment.setEvaluationModel((EvaluationModelIfc)newEvaluationModel);
        AssessmentFeedback newFeedback = this.prepareAssessmentFeedback(newAssessment, (AssessmentFeedback)a.getAssessmentFeedback());
        newAssessment.setAssessmentFeedback((AssessmentFeedbackIfc)newFeedback);
        Set newMetaDataSet = this.prepareAssessmentMetaDataSet(newAssessment, a.getAssessmentMetaDataSet());
        this.log.debug(" metadata set" + a.getAssessmentMetaDataSet());
        this.log.debug(" new metadata set" + newMetaDataSet);
        newAssessment.setAssessmentMetaDataSet(newMetaDataSet);
        String releaseTo = newAccessControl.getReleaseTo();
        if (releaseTo != null) {
            boolean anonymousAllowed;
            boolean bl = anonymousAllowed = releaseTo.indexOf("Anonymous Users") > -1;
            if (anonymousAllowed) {
                String alias = AgentFacade.getAgentString() + new Date().getTime();
                AssessmentMetaData meta = new AssessmentMetaData((AssessmentBaseIfc)newAssessment, "ALIAS", alias);
                newMetaDataSet.add(meta);
                newAssessment.setAssessmentMetaDataSet(newMetaDataSet);
            } else if (toContext != null) {
                releaseTo = toContext;
                try {
                    Site toSite = SiteService.getSite((String)toContext);
                    releaseTo = toSite.getTitle();
                }
                catch (IdUnusedException e) {
                    this.log.debug("IdUnusedException: " + e.getMessage());
                }
                newAccessControl.setReleaseTo(releaseTo);
            }
        } else {
            releaseTo = toContext;
            try {
                Site toSite = SiteService.getSite((String)toContext);
                releaseTo = toSite.getTitle();
            }
            catch (IdUnusedException e) {
                this.log.debug("IdUnusedException: " + e.getMessage());
            }
            newAccessControl.setReleaseTo(releaseTo);
        }
        Set newIPSet = this.prepareSecuredIPSet(newAssessment, a.getSecuredIPAddressSet());
        newAssessment.setSecuredIPAddressSet(newIPSet);
        Set newAssessmentAttachmentSet = this.prepareAssessmentAttachmentSet(newAssessment, a.getAssessmentAttachmentSet(), protocol, toContext);
        newAssessment.setAssessmentAttachmentSet(newAssessmentAttachmentSet);
        return newAssessment;
    }

    public AssessmentData prepareAssessment(AssessmentData a, String protocol) {
        return this.prepareAssessment(a, protocol, null);
    }

    public AssessmentFeedback prepareAssessmentFeedback(AssessmentData p, AssessmentFeedback a) {
        if (a == null) {
            return null;
        }
        AssessmentFeedback newFeedback = new AssessmentFeedback(a.getFeedbackDelivery(), a.getFeedbackComponentOption(), a.getFeedbackAuthoring(), a.getEditComponents(), a.getShowQuestionText(), a.getShowStudentResponse(), a.getShowCorrectResponse(), a.getShowStudentScore(), a.getShowStudentQuestionScore(), a.getShowQuestionLevelFeedback(), a.getShowSelectionLevelFeedback(), a.getShowGraderComments(), a.getShowStatistics());
        newFeedback.setAssessmentBase((AssessmentBaseIfc)p);
        return newFeedback;
    }

    public AssessmentAccessControl prepareAssessmentAccessControl(AssessmentData p, AssessmentAccessControl a) {
        if (a == null) {
            return new AssessmentAccessControl();
        }
        AssessmentAccessControl newAccessControl = new AssessmentAccessControl(a.getSubmissionsAllowed(), a.getSubmissionsSaved(), a.getAssessmentFormat(), a.getBookMarkingItem(), a.getTimeLimit(), a.getTimedAssessment(), a.getRetryAllowed(), a.getLateHandling(), a.getInstructorNotification(), a.getStartDate(), a.getDueDate(), a.getScoreDate(), a.getFeedbackDate(), a.getRetractDate(), a.getAutoSubmit(), a.getItemNavigation(), a.getItemNumbering(), a.getDisplayScoreDuringAssessments(), a.getSubmissionMessage(), a.getReleaseTo());
        newAccessControl.setPassword(a.getPassword());
        newAccessControl.setFinalPageUrl(a.getFinalPageUrl());
        newAccessControl.setUnlimitedSubmissions(a.getUnlimitedSubmissions());
        newAccessControl.setAssessmentBase((AssessmentBaseIfc)p);
        newAccessControl.setMarkForReview(a.getMarkForReview());
        newAccessControl.setHonorPledge(a.getHonorPledge());
        return newAccessControl;
    }

    public EvaluationModel prepareEvaluationModel(AssessmentData p, EvaluationModel e) {
        if (e == null) {
            return null;
        }
        EvaluationModel newEvaluationModel = new EvaluationModel(e.getEvaluationComponents(), e.getScoringType(), e.getNumericModelId(), e.getFixedTotalScore(), e.getGradeAvailable(), e.getIsStudentIdPublic(), e.getAnonymousGrading(), e.getAutoScoring(), e.getToGradeBook());
        newEvaluationModel.setAssessmentBase((AssessmentBaseIfc)p);
        return newEvaluationModel;
    }

    public Set prepareAssessmentMetaDataSet(AssessmentData p, Set metaDataSet) {
        HashSet<AssessmentMetaData> h = new HashSet<AssessmentMetaData>();
        for (AssessmentMetaData metaData : metaDataSet) {
            AssessmentMetaData newMetaData = new AssessmentMetaData((AssessmentBaseIfc)p, metaData.getLabel(), metaData.getEntry());
            h.add(newMetaData);
        }
        return h;
    }

    public Set prepareSecuredIPSet(AssessmentData p, Set ipSet) {
        HashSet<SecuredIPAddress> h = new HashSet<SecuredIPAddress>();
        for (SecuredIPAddress ip : ipSet) {
            SecuredIPAddress newIP = new SecuredIPAddress((AssessmentBaseIfc)p, ip.getHostname(), ip.getIpAddress());
            h.add(newIP);
        }
        return h;
    }

    public Set prepareSectionSet(AssessmentData newAssessment, Set sectionSet, String protocol, String toContext) {
        this.log.debug("new section size = " + sectionSet.size());
        HashSet<SectionData> h = new HashSet<SectionData>();
        for (SectionData section : sectionSet) {
            SectionData newSection = new SectionData(section.getDuration(), section.getSequence(), section.getTitle(), section.getDescription(), section.getTypeId(), section.getStatus(), section.getCreatedBy(), section.getCreatedDate(), section.getLastModifiedBy(), section.getLastModifiedDate());
            Set newSectionAttachmentSet = this.prepareSectionAttachmentSet(newSection, section.getSectionAttachmentSet(), protocol, toContext);
            newSection.setSectionAttachmentSet(newSectionAttachmentSet);
            Set newItemSet = this.prepareItemSet(newSection, section.getItemSet(), protocol, toContext);
            newSection.setItemSet(newItemSet);
            Set newMetaDataSet = this.prepareSectionMetaDataSet(newSection, section.getSectionMetaDataSet());
            newSection.setSectionMetaDataSet(newMetaDataSet);
            newSection.setAssessment((AssessmentIfc)newAssessment);
            h.add(newSection);
        }
        return h;
    }

    public Set prepareSectionSet(AssessmentData newAssessment, Set sectionSet, String protocol) {
        return this.prepareSectionSet(newAssessment, sectionSet, protocol, null);
    }

    public Set prepareSectionMetaDataSet(SectionData newSection, Set metaDataSet) {
        HashSet<SectionMetaData> h = new HashSet<SectionMetaData>();
        for (SectionMetaData sectionMetaData : metaDataSet) {
            SectionMetaData newSectionMetaData = new SectionMetaData((SectionDataIfc)newSection, sectionMetaData.getLabel(), sectionMetaData.getEntry());
            h.add(newSectionMetaData);
        }
        return h;
    }

    public Set prepareItemSet(SectionData newSection, Set itemSet, String protocol, String toContext) {
        this.log.debug("new item size = " + itemSet.size());
        HashSet<ItemData> h = new HashSet<ItemData>();
        for (ItemData item : itemSet) {
            ItemData newItem = new ItemData((SectionDataIfc)newSection, item.getSequence(), item.getDuration(), item.getInstruction(), item.getDescription(), item.getTypeId(), item.getGrade(), item.getScore(), item.getScoreDisplayFlag(), item.getDiscount(), item.getMinScore(), item.getHint(), item.getHasRationale(), item.getStatus(), item.getCreatedBy(), item.getCreatedDate(), item.getLastModifiedBy(), item.getLastModifiedDate(), null, null, null, item.getTriesAllowed(), item.getPartialCreditFlag());
            Set newItemTextSet = this.prepareItemTextSet(newItem, item.getItemTextSet(), protocol, toContext);
            Set newItemMetaDataSet = this.prepareItemMetaDataSet(newItem, item.getItemMetaDataSet());
            Set newItemFeedbackSet = this.prepareItemFeedbackSet(newItem, item.getItemFeedbackSet());
            Set newItemAttachmentSet = this.prepareItemAttachmentSet(newItem, item.getItemAttachmentSet(), protocol, toContext);
            newItem.setItemTextSet(newItemTextSet);
            newItem.setItemMetaDataSet(newItemMetaDataSet);
            newItem.setItemFeedbackSet(newItemFeedbackSet);
            newItem.setItemAttachmentSet(newItemAttachmentSet);
            newItem.setAnswerOptionsRichCount(item.getAnswerOptionsRichCount());
            newItem.setAnswerOptionsSimpleOrRich(item.getAnswerOptionsSimpleOrRich());
            h.add(newItem);
        }
        return h;
    }

    public Set prepareItemSet(SectionData newSection, Set itemSet, String protocol) {
        return this.prepareItemSet(newSection, itemSet, protocol, null);
    }

    public Set prepareItemTextSet(ItemData newItem, Set itemTextSet, String protocol, String toContext) {
        this.log.debug("new item text size = " + itemTextSet.size());
        HashSet<ItemText> h = new HashSet<ItemText>();
        for (ItemText itemText : itemTextSet) {
            this.log.debug("item text id =" + itemText.getId());
            ItemText newItemText = new ItemText(newItem, itemText.getSequence(), itemText.getText(), null);
            Set newAnswerSet = this.prepareAnswerSet(newItemText, itemText.getAnswerSet());
            newItemText.setAnswerSet(newAnswerSet);
            Set itemTextAttachmentSet = this.prepareItemTextAttachmentSet(newItemText, itemText.getItemTextAttachmentSet(), protocol, toContext);
            newItemText.setItemTextAttachmentSet(itemTextAttachmentSet);
            newItemText.setRequiredOptionsCount(itemText.getRequiredOptionsCount());
            h.add(newItemText);
        }
        return h;
    }

    public Set prepareItemMetaDataSet(ItemData newItem, Set itemMetaDataSet) {
        HashSet<ItemMetaData> h = new HashSet<ItemMetaData>();
        for (ItemMetaData itemMetaData : itemMetaDataSet) {
            ItemMetaData newItemMetaData = new ItemMetaData((ItemDataIfc)newItem, itemMetaData.getLabel(), itemMetaData.getEntry());
            h.add(newItemMetaData);
        }
        return h;
    }

    public Set prepareItemFeedbackSet(ItemData newItem, Set itemFeedbackSet) {
        HashSet<ItemFeedback> h = new HashSet<ItemFeedback>();
        for (ItemFeedback itemFeedback : itemFeedbackSet) {
            ItemFeedback newItemFeedback = new ItemFeedback(newItem, itemFeedback.getTypeId(), itemFeedback.getText());
            h.add(newItemFeedback);
        }
        return h;
    }

    public Set prepareItemAttachmentSet(ItemData newItem, Set itemAttachmentSet, String protocol, String toContext) {
        HashSet<ItemAttachment> h = new HashSet<ItemAttachment>();
        for (ItemAttachment itemAttachment : itemAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemAttachment.getResourceId(), itemAttachment.getFilename(), toContext);
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                ItemAttachment newItemAttachment = new ItemAttachment(null, (ItemDataIfc)newItem, cr_copy.getId(), itemAttachment.getFilename(), itemAttachment.getMimeType(), itemAttachment.getFileSize(), itemAttachment.getDescription(), url, itemAttachment.getIsLink(), itemAttachment.getStatus(), itemAttachment.getCreatedBy(), itemAttachment.getCreatedDate(), itemAttachment.getLastModifiedBy(), itemAttachment.getLastModifiedDate());
                h.add(newItemAttachment);
            }
            catch (Exception e) {
                this.log.warn(e.getMessage());
            }
        }
        return h;
    }

    public Set prepareItemTextAttachmentSet(ItemText newItemText, Set itemTextAttachmentSet, String protocol, String toContext) {
        HashSet<ItemTextAttachment> h = new HashSet<ItemTextAttachment>();
        for (ItemTextAttachment itemTextAttachment : itemTextAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemTextAttachment.getResourceId(), itemTextAttachment.getFilename(), toContext);
                String url = this.getRelativePath(cr_copy.getUrl(), protocol);
                ItemTextAttachment newItemTextAttachment = new ItemTextAttachment(null, (ItemTextIfc)newItemText, cr_copy.getId(), itemTextAttachment.getFilename(), itemTextAttachment.getMimeType(), itemTextAttachment.getFileSize(), itemTextAttachment.getDescription(), url, itemTextAttachment.getIsLink(), itemTextAttachment.getStatus(), itemTextAttachment.getCreatedBy(), itemTextAttachment.getCreatedDate(), itemTextAttachment.getLastModifiedBy(), itemTextAttachment.getLastModifiedDate());
                h.add(newItemTextAttachment);
            }
            catch (Exception e) {
                this.log.warn(e.getMessage());
            }
        }
        return h;
    }

    public Set prepareItemAttachmentSet(ItemData newItem, Set itemAttachmentSet, String protocol) {
        return this.prepareItemAttachmentSet(newItem, itemAttachmentSet, protocol, null);
    }

    public Set prepareSectionAttachmentSet(SectionData newSection, Set sectionAttachmentSet, String protocol, String toContext) {
        HashSet<SectionAttachment> h = new HashSet<SectionAttachment>();
        for (SectionAttachment sectionAttachment : sectionAttachmentSet) {
            AssessmentService service = new AssessmentService();
            ContentResource cr_copy = service.createCopyOfContentResource(sectionAttachment.getResourceId(), sectionAttachment.getFilename(), toContext);
            String url = this.getRelativePath(cr_copy.getUrl(), protocol);
            SectionAttachment newSectionAttachment = new SectionAttachment(null, (SectionDataIfc)newSection, cr_copy.getId(), sectionAttachment.getFilename(), sectionAttachment.getMimeType(), sectionAttachment.getFileSize(), sectionAttachment.getDescription(), url, sectionAttachment.getIsLink(), sectionAttachment.getStatus(), sectionAttachment.getCreatedBy(), sectionAttachment.getCreatedDate(), sectionAttachment.getLastModifiedBy(), sectionAttachment.getLastModifiedDate());
            h.add(newSectionAttachment);
        }
        return h;
    }

    public Set prepareSectionAttachmentSet(SectionData newSection, Set sectionAttachmentSet, String protocol) {
        return this.prepareSectionAttachmentSet(newSection, sectionAttachmentSet, protocol, null);
    }

    public Set prepareAssessmentAttachmentSet(AssessmentData newAssessment, Set assessmentAttachmentSet, String protocol, String toContext) {
        HashSet<AssessmentAttachment> h = new HashSet<AssessmentAttachment>();
        for (AssessmentAttachment assessmentAttachment : assessmentAttachmentSet) {
            AssessmentService service = new AssessmentService();
            ContentResource cr_copy = service.createCopyOfContentResource(assessmentAttachment.getResourceId(), assessmentAttachment.getFilename(), toContext);
            String url = this.getRelativePath(cr_copy.getUrl(), protocol);
            AssessmentAttachment newAssessmentAttachment = new AssessmentAttachment(null, (AssessmentIfc)newAssessment, cr_copy.getId(), assessmentAttachment.getFilename(), assessmentAttachment.getMimeType(), assessmentAttachment.getFileSize(), assessmentAttachment.getDescription(), url, assessmentAttachment.getIsLink(), assessmentAttachment.getStatus(), assessmentAttachment.getCreatedBy(), assessmentAttachment.getCreatedDate(), assessmentAttachment.getLastModifiedBy(), assessmentAttachment.getLastModifiedDate());
            h.add(newAssessmentAttachment);
        }
        return h;
    }

    public Set prepareAssessmentAttachmentSet(AssessmentData newAssessment, Set assessmentAttachmentSet, String protocol) {
        return this.prepareAssessmentAttachmentSet(newAssessment, assessmentAttachmentSet, protocol, null);
    }

    public Set prepareAnswerSet(ItemText newItemText, Set answerSet) {
        this.log.debug("new answer size = " + answerSet.size());
        HashSet<Answer> h = new HashSet<Answer>();
        for (Answer answer : answerSet) {
            Answer newAnswer = new Answer((ItemTextIfc)newItemText, answer.getText(), answer.getSequence(), answer.getLabel(), answer.getIsCorrect(), answer.getGrade(), answer.getScore(), answer.getPartialCredit(), answer.getDiscount(), null);
            Set newAnswerFeedbackSet = this.prepareAnswerFeedbackSet(newAnswer, answer.getAnswerFeedbackSet());
            newAnswer.setAnswerFeedbackSet(newAnswerFeedbackSet);
            h.add(newAnswer);
        }
        return h;
    }

    public Set prepareAnswerFeedbackSet(Answer newAnswer, Set answerFeedbackSet) {
        HashSet<AnswerFeedback> h = new HashSet<AnswerFeedback>();
        for (AnswerFeedback answerFeedback : answerFeedbackSet) {
            AnswerFeedback newAnswerFeedback = new AnswerFeedback((AnswerIfc)newAnswer, answerFeedback.getTypeId(), answerFeedback.getText());
            h.add(newAnswerFeedback);
        }
        return h;
    }

    @Override
    public String getAssessmentSiteId(String assessmentId) {
        String query = "select a from AuthorizationData a where  a.functionId=? and a.qualifierId=?";
        Object[] values = new Object[]{"EDIT_ASSESSMENT", assessmentId};
        List l = this.getHibernateTemplate().find(query, values);
        if (l.size() > 0) {
            AuthorizationData a = (AuthorizationData)l.get(0);
            return a.getAgentIdString();
        }
        return null;
    }

    @Override
    public String getAssessmentCreatedBy(String assessmentId) {
        String query = "select a from AssessmentData a where a.assessmentBaseId = ?";
        List l = this.getHibernateTemplate().find(query, (Object)Long.valueOf(assessmentId));
        if (l.size() > 0) {
            AssessmentData a = (AssessmentData)l.get(0);
            return a.getCreatedBy();
        }
        return null;
    }

    @Override
    public Set copyItemAttachmentSet(ItemData newItem, Set itemAttachmentSet) {
        HashSet<ItemAttachment> h = new HashSet<ItemAttachment>();
        for (ItemAttachment itemAttachment : itemAttachmentSet) {
            try {
                AssessmentService service = new AssessmentService();
                ContentResource cr_copy = service.createCopyOfContentResource(itemAttachment.getResourceId(), itemAttachment.getFilename());
                String url = this.getRelativePath(cr_copy.getUrl(), ServerConfigurationService.getServerUrl());
                ItemAttachment newItemAttachment = new ItemAttachment(null, (ItemDataIfc)newItem, cr_copy.getId(), itemAttachment.getFilename(), itemAttachment.getMimeType(), itemAttachment.getFileSize(), itemAttachment.getDescription(), url, itemAttachment.getIsLink(), itemAttachment.getStatus(), AgentFacade.getAgentString(), new Date(), AgentFacade.getAgentString(), new Date());
                h.add(newItemAttachment);
            }
            catch (Exception e) {
                this.log.warn(e.getMessage());
            }
        }
        return h;
    }
}

