/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.sakaiproject.antivirus.api.VirusFoundException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.assessment.EvaluationModel;
import org.sakaiproject.tool.assessment.data.dao.assessment.EventLogData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedSectionData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingAttachment;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.GradingAttachmentData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingAttachment;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.dao.grading.StudentGradingSummaryData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.StudentGradingSummaryIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.AssessmentFacadeQueries;
import org.sakaiproject.tool.assessment.facade.AssessmentGradingFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.EventLogFacade;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.AutoSubmitAssessmentsJob;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceHelper;
import org.sakaiproject.tool.assessment.services.assessment.EventLogService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class AssessmentGradingFacadeQueries
extends HibernateDaoSupport
implements AssessmentGradingFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(AssessmentGradingFacadeQueries.class);
    private ContentHostingService contentHostingService;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;
    private PersistenceHelper persistenceHelper;

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setPersistenceHelper(PersistenceHelper persistenceHelper) {
        this.persistenceHelper = persistenceHelper;
    }

    @Override
    public List getTotalScores(String publishedId, String which) {
        return this.getTotalScores(publishedId, which, true);
    }

    @Override
    public List getTotalScores(final String publishedId, String which, final boolean getSubmittedOnly) {
        try {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Query q;
                    if (getSubmittedOnly) {
                        q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId ASC, a.finalScore DESC, a.submittedDate DESC");
                        q.setLong(0, Long.parseLong(publishedId));
                        q.setBoolean(1, true);
                    } else {
                        q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId ASC, a.finalScore DESC, a.submittedDate DESC");
                        q.setLong(0, Long.parseLong(publishedId));
                        q.setBoolean(1, true);
                        q.setBoolean(2, false);
                        q.setInteger(3, AssessmentGradingData.NO_SUBMISSION.intValue());
                    }
                    return q.list();
                }
            };
            List list = this.getHibernateTemplate().executeFind(hcb);
            Map<Long, List<AssessmentGradingAttachment>> attachmentMap = this.getAssessmentGradingAttachmentMap(Long.valueOf(publishedId));
            for (AssessmentGradingData data : list) {
                if (attachmentMap.get(data.getAssessmentGradingId()) != null) {
                    data.setAssessmentGradingAttachmentList(attachmentMap.get(data.getAssessmentGradingId()));
                    continue;
                }
                data.setAssessmentGradingAttachmentList(new ArrayList());
            }
            if (which.equals(EvaluationModelIfc.LAST_SCORE.toString())) {
                HibernateCallback hcb2 = new HibernateCallback(){

                    public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                        Query q;
                        if (getSubmittedOnly) {
                            q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId ASC, a.submittedDate DESC");
                            q.setLong(0, Long.parseLong(publishedId));
                            q.setBoolean(1, true);
                        } else {
                            q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId ASC, a.submittedDate DESC");
                            q.setLong(0, Long.parseLong(publishedId));
                            q.setBoolean(1, true);
                            q.setBoolean(2, false);
                            q.setInteger(3, AssessmentGradingData.NO_SUBMISSION.intValue());
                        }
                        return q.list();
                    }
                };
                list = this.getHibernateTemplate().executeFind(hcb2);
            }
            if (which.equals(EvaluationModelIfc.ALL_SCORE.toString()) || which.equals(EvaluationModelIfc.AVERAGE_SCORE.toString())) {
                return list;
            }
            if (list.isEmpty()) {
                return new ArrayList();
            }
            Iterator items = list.iterator();
            ArrayList<AssessmentGradingData> newlist = new ArrayList<AssessmentGradingData>();
            AssessmentGradingData data = (AssessmentGradingData)items.next();
            data.setPublishedAssessmentId(Long.valueOf(publishedId));
            String agentid = data.getAgentId();
            newlist.add(data);
            block3: while (items.hasNext()) {
                while (items.hasNext()) {
                    data = (AssessmentGradingData)items.next();
                    if (data.getAgentId().equals(agentid)) continue;
                    agentid = data.getAgentId();
                    newlist.add(data);
                    continue block3;
                }
            }
            return newlist;
        }
        catch (RuntimeException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new ArrayList();
        }
    }

    @Override
    public List getAllSubmissions(final String publishedId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=?");
                q.setLong(0, Long.parseLong(publishedId));
                q.setBoolean(1, true);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List getAllAssessmentGradingData(final Long publishedId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.status <> ? order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedId.longValue());
                q.setInteger(1, AssessmentGradingData.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        for (AssessmentGradingData adata : list) {
            Set itemGradingSet = this.getItemGradingSet(adata.getAssessmentGradingId());
            adata.setItemGradingSet(itemGradingSet);
        }
        return list;
    }

    @Override
    public HashMap getItemScores(Long publishedId, Long itemId, String which) {
        List scores = this.getTotalScores(publishedId.toString(), which);
        return this.getItemScores(itemId, scores, false);
    }

    @Override
    public HashMap getItemScores(Long publishedId, Long itemId, String which, boolean loadItemGradingAttachment) {
        List scores = this.getTotalScores(publishedId.toString(), which);
        return this.getItemScores(itemId, scores, loadItemGradingAttachment);
    }

    @Override
    public HashMap getItemScores(final Long itemId, List scores, boolean loadItemGradingAttachment) {
        try {
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            final Iterator iter = scores.iterator();
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Criteria criteria = session.createCriteria(ItemGradingData.class);
                    Disjunction disjunction = Expression.disjunction();
                    ArrayList<Long> gradingIdList = new ArrayList<Long>();
                    while (iter.hasNext()) {
                        AssessmentGradingData data = (AssessmentGradingData)iter.next();
                        gradingIdList.add(data.getAssessmentGradingId());
                    }
                    for (int i = 0; i < gradingIdList.size(); i += 50) {
                        List tempList;
                        if (i + 50 > gradingIdList.size()) {
                            tempList = gradingIdList.subList(i, gradingIdList.size());
                            disjunction.add(Expression.in((String)"assessmentGradingId", tempList));
                            continue;
                        }
                        tempList = gradingIdList.subList(i, i + 50);
                        disjunction.add(Expression.in((String)"assessmentGradingId", tempList));
                    }
                    if (itemId.equals(0L)) {
                        criteria.add((Criterion)disjunction);
                    } else {
                        SimpleExpression pubCriterion = Expression.eq((String)"publishedItemId", (Object)itemId);
                        criteria.add((Criterion)Expression.and((Criterion)pubCriterion, (Criterion)disjunction));
                    }
                    criteria.addOrder(Order.asc((String)"agentId"));
                    criteria.addOrder(Order.desc((String)"submittedDate"));
                    return criteria.list();
                }
            };
            List temp = (List)this.getHibernateTemplate().execute(hcb);
            HashMap<Object, Object> attachmentMap = new HashMap();
            if (loadItemGradingAttachment) {
                attachmentMap = this.getItemGradingAttachmentMap(itemId);
            }
            for (ItemGradingData data : temp) {
                ArrayList<ItemGradingData> thisone;
                if (loadItemGradingAttachment) {
                    if (attachmentMap.get(data.getItemGradingId()) != null) {
                        data.setItemGradingAttachmentList((List)((ArrayList)attachmentMap.get(data.getItemGradingId())));
                    } else {
                        data.setItemGradingAttachmentList(new ArrayList());
                    }
                }
                if ((thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId())) == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    @Override
    public HashMap getLastItemGradingData(final Long publishedId, final String agentId) {
        try {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? and a.status<>? order by a.submittedDate DESC");
                    q.setLong(0, publishedId.longValue());
                    q.setString(1, agentId);
                    q.setBoolean(2, false);
                    q.setInteger(3, AssessmentGradingData.NO_SUBMISSION.intValue());
                    return q.list();
                }
            };
            List scores = this.getHibernateTemplate().executeFind(hcb);
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            if (scores.isEmpty()) {
                return new HashMap();
            }
            AssessmentGradingData gdata = (AssessmentGradingData)scores.toArray()[0];
            gdata.setItemGradingSet(this.getItemGradingSet(gdata.getAssessmentGradingId()));
            if (gdata.getForGrade().booleanValue()) {
                return new HashMap();
            }
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    @Override
    public HashMap getStudentGradingData(String assessmentGradingId) {
        return this.getStudentGradingData(assessmentGradingId, true);
    }

    public HashMap getStudentGradingData(String assessmentGradingId, boolean loadGradingAttachment) {
        try {
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            AssessmentGradingData gdata = this.load(new Long(assessmentGradingId), loadGradingAttachment);
            log.debug("****#6, gdata=" + gdata);
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    @Override
    public HashMap getSubmitData(final Long publishedId, final String agentId, final Integer scoringoption, final Long assessmentGradingId) {
        try {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    log.debug("scoringoption = " + scoringoption);
                    if (EvaluationModelIfc.LAST_SCORE.equals(scoringoption)) {
                        Query q;
                        if (assessmentGradingId == null) {
                            q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.submittedDate DESC");
                            q.setLong(0, publishedId.longValue());
                            q.setString(1, agentId);
                            q.setBoolean(2, true);
                        } else {
                            q = session.createQuery("from AssessmentGradingData a where a.assessmentGradingId=? ");
                            q.setLong(0, assessmentGradingId.longValue());
                        }
                        return q.list();
                    }
                    Query q1 = null;
                    if (assessmentGradingId == null) {
                        q1 = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.finalScore DESC, a.submittedDate DESC");
                        q1.setLong(0, publishedId.longValue());
                        q1.setString(1, agentId);
                        q1.setBoolean(2, true);
                    } else {
                        q1 = session.createQuery("from AssessmentGradingData a where a.assessmentGradingId=? ");
                        q1.setLong(0, assessmentGradingId.longValue());
                    }
                    return q1.list();
                }
            };
            List scores = this.getHibernateTemplate().executeFind(hcb);
            HashMap<Long, ArrayList<ItemGradingData>> map = new HashMap<Long, ArrayList<ItemGradingData>>();
            if (scores.isEmpty()) {
                return new HashMap();
            }
            AssessmentGradingData gdata = (AssessmentGradingData)scores.toArray()[0];
            HashMap<Long, ArrayList<ItemGradingAttachment>> attachmentMap = this.getItemGradingAttachmentMapByAssessmentGradingId(gdata.getAssessmentGradingId());
            gdata.setItemGradingSet(this.getItemGradingSet(gdata.getAssessmentGradingId()));
            for (ItemGradingData data : gdata.getItemGradingSet()) {
                if (attachmentMap.get(data.getItemGradingId()) != null) {
                    data.setItemGradingAttachmentList(attachmentMap.get(data.getItemGradingId()));
                } else {
                    data.setItemGradingAttachmentList(new ArrayList());
                }
                ArrayList<ItemGradingData> thisone = (ArrayList<ItemGradingData>)map.get(data.getPublishedItemId());
                if (thisone == null) {
                    thisone = new ArrayList<ItemGradingData>();
                }
                thisone.add(data);
                map.put(data.getPublishedItemId(), thisone);
            }
            return map;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    @Override
    public Long add(AssessmentGradingData a) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)a);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem adding assessmentGrading: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
        return a.getAssessmentGradingId();
    }

    @Override
    public int getSubmissionSizeOfPublishedAssessment(Long publishedAssessmentId) {
        Object[] values = new Object[]{true, publishedAssessmentId};
        List size = this.getHibernateTemplate().find("select count(a) from AssessmentGradingData a where a.forGrade=? and a.publishedAssessmentId=?", values);
        Iterator iter = size.iterator();
        if (iter.hasNext()) {
            int i = (Integer)iter.next();
            return i;
        }
        return 0;
    }

    @Override
    public Long saveMedia(byte[] media, String mimeType) {
        MediaData mediaData = new MediaData(media, mimeType);
        mediaData.setFileSize(Long.valueOf(media.length));
        return this.saveMedia(mediaData);
    }

    protected void pushAdvisor() {
        this.securityService.pushAdvisor(new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        });
    }

    protected void popAdvisor() {
        this.securityService.popAdvisor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkMediaCollection(String id) {
        this.pushAdvisor();
        try {
            this.contentHostingService.checkCollection(id);
        }
        catch (IdUnusedException | PermissionException | TypeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.popAdvisor();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ensureMediaCollection(String id) {
        this.pushAdvisor();
        try {
            ContentCollection contentCollection = this.contentHostingService.getCollection(id);
        }
        catch (IdUnusedException ie) {
            log.debug("Creating collection: " + id);
            String name = id;
            if (name.endsWith("/")) {
                name = id.substring(0, id.length() - 1);
            }
            name = name.substring(name.lastIndexOf(47) + 1);
            try {
                ContentCollectionEdit edit = this.contentHostingService.addCollection(id);
                ResourcePropertiesEdit props = edit.getPropertiesEdit();
                props.addProperty("DAV:displayname", name);
                this.contentHostingService.commitCollection(edit);
            }
            catch (IdInvalidException | IdUsedException | InconsistentException | PermissionException collex) {
                log.warn("[Samigo Media Attachments] Exception while creating collection (" + id + "): " + collex.toString());
                boolean bl = false;
                return bl;
            }
        }
        catch (PermissionException | TypeException e) {
            log.warn("[Samigo Media Attachments] General exception while ensuring collection: " + e.toString());
        }
        finally {
            this.popAdvisor();
        }
        return true;
    }

    protected boolean ensureMediaPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("[Samigo Media Attachments] Relative media paths are not acceptable. (" + path + ")");
        }
        int lastSlash = path.lastIndexOf("/");
        if (lastSlash != 0 && this.checkMediaCollection(path.substring(0, lastSlash + 1))) {
            return true;
        }
        int slash = 1;
        while (slash != lastSlash) {
            if (this.ensureMediaCollection(path.substring(0, (slash = path.indexOf("/", slash + 1)) + 1))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String saveMediaToContent(MediaData mediaData) {
        String mediaPath = this.getMediaPath(mediaData);
        if (mediaData.getMedia() != null && this.ensureMediaPath(mediaPath)) {
            log.debug("=====> Saving media: " + mediaPath);
            this.pushAdvisor();
            boolean newResource = true;
            try {
                this.contentHostingService.checkResource(mediaPath);
                newResource = false;
            }
            catch (IdUnusedException | PermissionException | TypeException throwable) {
                // empty catch block
            }
            try {
                ContentResource chsMedia;
                if (newResource) {
                    ContentResourceEdit edit = this.contentHostingService.addResource(mediaPath);
                    edit.setContentType(mediaData.getMimeType());
                    edit.setContent(mediaData.getMedia());
                    ResourcePropertiesEdit props = edit.getPropertiesEdit();
                    props.addProperty("DAV:displayname", mediaData.getFilename());
                    this.contentHostingService.commitResource(edit);
                    chsMedia = this.contentHostingService.getResource(mediaPath);
                } else {
                    chsMedia = this.contentHostingService.updateResource(mediaPath, mediaData.getMimeType(), mediaData.getMedia());
                }
                mediaData.setDbMedia(null);
                mediaData.setContentResource(chsMedia);
                String string = mediaPath;
                return string;
            }
            catch (VirusFoundException | IdInvalidException | IdUnusedException | IdUsedException | InUseException | InconsistentException | OverQuotaException | PermissionException | ServerOverloadException | TypeException e) {
                log.warn("Exception while saving media to content: " + e.toString());
            }
            finally {
                this.popAdvisor();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContentResource getMediaContentResource(MediaData mediaData) {
        if (mediaData.getContentResource() != null) {
            return mediaData.getContentResource();
        }
        String id = this.getMediaPath(mediaData);
        log.debug("=====> Reading media: " + id);
        if (id != null) {
            this.pushAdvisor();
            try {
                ContentResource res;
                ContentResource contentResource = res = this.contentHostingService.getResource(id);
                return contentResource;
            }
            catch (IdUnusedException ie) {
                log.info("Nonexistent resource when trying to load media (id: " + mediaData.getMediaId() + "): " + id);
            }
            catch (PermissionException | TypeException e) {
                log.debug("Exception while reading media from content (" + mediaData.getMediaId() + "):" + e.toString());
            }
            finally {
                this.popAdvisor();
            }
        }
        return null;
    }

    protected String getMediaPath(MediaData mediaData) {
        String mediaBase = "/private/samigo/";
        String mediaPath = null;
        ItemGradingData itemGrading = mediaData.getItemGradingData();
        if (itemGrading != null) {
            PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
            PublishedAssessmentIfc assessment = this.getPublishedAssessmentByAssessmentGradingId(itemGrading.getAssessmentGradingId());
            String assessmentId = assessment.getPublishedAssessmentId().toString();
            String siteId = publishedAssessmentService.getPublishedAssessmentSiteId(assessmentId);
            String userId = itemGrading.getAgentId();
            String questionId = itemGrading.getPublishedItemId().toString();
            if (questionId != null && assessmentId != null) {
                mediaPath = mediaBase + siteId + "/" + assessmentId + "/" + userId + "/" + questionId + "_" + mediaData.getFilename();
            }
        }
        return mediaPath;
    }

    @Override
    public Long saveMedia(MediaData mediaData) {
        log.debug("****" + mediaData.getFilename() + " saving media...size=" + mediaData.getFileSize() + " " + new Date());
        int retryCount = this.persistenceHelper.getRetryCount();
        this.getMediaPath(mediaData);
        while (retryCount > 0) {
            try {
                this.saveMediaToContent(mediaData);
                this.getHibernateTemplate().saveOrUpdate((Object)mediaData);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving media: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
        log.debug("****" + mediaData.getFilename() + " saved media." + new Date());
        return mediaData.getMediaId();
    }

    @Override
    public void removeMediaById(Long mediaId) {
        this.removeMediaById(mediaId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediaById(Long mediaId, Long itemGradingId) {
        File mediaFile;
        String mediaLocation = null;
        Session session = null;
        Connection conn = null;
        ResultSet rs = null;
        Statement statement = null;
        Statement statement0 = null;
        try {
            session = this.getSessionFactory().openSession();
            conn = session.connection();
            log.debug("****Connection=" + conn);
            String query0 = "select LOCATION from SAM_MEDIA_T where MEDIAID=?";
            statement0 = conn.prepareStatement(query0);
            statement0.setLong(1, mediaId);
            rs = statement0.executeQuery();
            if (rs.next()) {
                mediaLocation = rs.getString("LOCATION");
            }
            log.debug("****mediaLocation=" + mediaLocation);
            String query = "delete from SAM_MEDIA_T where MEDIAID=?";
            statement = conn.prepareStatement(query);
            statement.setLong(1, mediaId);
            statement.executeUpdate();
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
        }
        catch (SQLException | HibernateException e) {
            log.warn(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
            if (statement0 != null) {
                try {
                    statement0.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        if (mediaLocation != null && (mediaFile = new File(mediaLocation)).delete()) {
            log.warn("problem removing file. mediaLocation = {}", mediaLocation);
        }
        if (itemGradingId != null) {
            ItemGradingData itemGradingData = this.getItemGrading(itemGradingId);
            itemGradingData.setAutoScore(Double.valueOf(0.0));
            this.saveItemGrading(itemGradingData);
        }
    }

    @Override
    public MediaData getMedia(Long mediaId) {
        MediaData mediaData = (MediaData)this.getHibernateTemplate().load(MediaData.class, (Serializable)mediaId);
        if (mediaData.getLocation() == null && mediaData.getDbMedia() == null) {
            mediaData.setContentResource(this.getMediaContentResource(mediaData));
        }
        return mediaData;
    }

    @Override
    public ArrayList getMediaArray(final Long itemGradingId) {
        log.debug("*** itemGradingId =" + itemGradingId);
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from MediaData m where m.itemGradingData.itemGradingId=?");
                q.setLong(0, itemGradingId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        for (int i = 0; i < list.size(); ++i) {
            MediaData mediaData = (MediaData)list.get(i);
            mediaData.setContentResource(this.getMediaContentResource(mediaData));
            a.add(mediaData);
        }
        log.debug("*** no. of media = {}", (Object)a.size());
        return a;
    }

    @Override
    public ArrayList getMediaArray2(final Long itemGradingId) {
        log.debug("*** itemGradingId =" + itemGradingId);
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new MediaData(m.mediaId, m.filename, m.fileSize, m.duration, m.createdDate)  from MediaData m where m.itemGradingData.itemGradingId=?");
                q.setLong(0, itemGradingId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        for (int i = 0; i < list.size(); ++i) {
            MediaData mediaData = (MediaData)list.get(i);
            mediaData.setContentResource(this.getMediaContentResource(mediaData));
            a.add(mediaData);
        }
        log.debug("*** no. of media = {}", (Object)a.size());
        return a;
    }

    @Override
    public HashMap getMediaItemGradingHash(final Long assessmentGradingId) {
        log.debug("*** assessmentGradingId = {}", (Object)assessmentGradingId);
        HashMap map = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i from MediaData m, ItemGradingData i where m.itemGradingData.itemGradingId = i.itemGradingId and i.assessmentGradingId = ? ");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        for (int i = 0; i < list.size(); ++i) {
            ItemGradingData itemGradingData = (ItemGradingData)list.get(i);
            ArrayList<ItemGradingData> al = new ArrayList<ItemGradingData>();
            al.add(itemGradingData);
            map.put(itemGradingData.getPublishedItemId(), al);
        }
        log.debug("*** no. of media = {}", (Object)map.size());
        return map;
    }

    @Override
    public ArrayList getMediaArray(ItemGradingData item) {
        ArrayList<MediaData> a = new ArrayList<MediaData>();
        List list = this.getHibernateTemplate().find("from MediaData m where m.itemGradingData=?", (Object)item);
        for (int i = 0; i < list.size(); ++i) {
            MediaData mediaData = (MediaData)list.get(i);
            mediaData.setContentResource(this.getMediaContentResource(mediaData));
            a.add(mediaData);
        }
        log.debug("*** no. of media = {}", (Object)a.size());
        return a;
    }

    @Override
    public List getMediaArray(Long publishedId, Long publishedItemId, String which) {
        try {
            HashMap itemScores = this.getItemScores(publishedId, publishedItemId, which);
            final List list = (List)itemScores.get(publishedItemId);
            log.debug("list size list.size() = " + list.size());
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Criteria criteria = session.createCriteria(MediaData.class);
                    Disjunction disjunction = Expression.disjunction();
                    ArrayList<Long> itemGradingIdList = new ArrayList<Long>();
                    for (int i = 0; i < list.size(); ++i) {
                        ItemGradingData itemGradingData = (ItemGradingData)list.get(i);
                        itemGradingIdList.add(itemGradingData.getItemGradingId());
                    }
                    for (int i = 0; i < itemGradingIdList.size(); i += 50) {
                        List tempList;
                        if (i + 50 > itemGradingIdList.size()) {
                            tempList = itemGradingIdList.subList(i, itemGradingIdList.size());
                            disjunction.add(Expression.in((String)"itemGradingData.itemGradingId", tempList));
                            continue;
                        }
                        tempList = itemGradingIdList.subList(i, i + 50);
                        disjunction.add(Expression.in((String)"itemGradingData.itemGradingId", tempList));
                    }
                    criteria.add((Criterion)disjunction);
                    return criteria.list();
                }
            };
            ArrayList<MediaData> a = new ArrayList<MediaData>();
            List hbmList = (List)this.getHibernateTemplate().execute(hcb);
            for (int i = 0; i < hbmList.size(); ++i) {
                MediaData mediaData = (MediaData)hbmList.get(i);
                mediaData.setContentResource(this.getMediaContentResource(mediaData));
                a.add(mediaData);
            }
            return a;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return new ArrayList();
        }
    }

    @Override
    public List<Long> getMediaConversionBatch() {
        HibernateCallback<List<Long>> hcb = new HibernateCallback<List<Long>>(){

            public List<Long> doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("SELECT id FROM MediaData WHERE dbMedia IS NOT NULL AND location IS NULL");
                q.setMaxResults(10);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute((HibernateCallback)hcb);
    }

    @Override
    public boolean markMediaForConversion(final List<Long> mediaIds) {
        HibernateCallback hcb = new HibernateCallback(){

            public Integer doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("UPDATE MediaData SET location = 'CONVERTING' WHERE id in (:ids)");
                q.setParameterList("ids", (Collection)mediaIds);
                return q.executeUpdate();
            }
        };
        return this.getHibernateTemplate().execute(hcb).equals(mediaIds.size());
    }

    @Override
    public List<Long> getMediaWithDataAndLocation() {
        HibernateCallback<List<Long>> hcb = new HibernateCallback<List<Long>>(){

            public List<Long> doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("SELECT id FROM MediaData WHERE dbMedia IS NOT NULL AND location IS NOT NULL");
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute((HibernateCallback)hcb);
    }

    @Override
    public List<Long> getMediaInConversion() {
        HibernateCallback<List<Long>> hcb = new HibernateCallback<List<Long>>(){

            public List<Long> doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("SELECT id FROM MediaData WHERE location = 'CONVERTING'");
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute((HibernateCallback)hcb);
    }

    @Override
    public ItemGradingData getLastItemGradingDataByAgent(final Long publishedItemId, final String agentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingData i where i.publishedItemId=? and i.agentId=?");
                q.setLong(0, publishedItemId.longValue());
                q.setString(1, agentId);
                return q.list();
            }
        };
        List itemGradings = this.getHibernateTemplate().executeFind(hcb);
        if (itemGradings.isEmpty()) {
            return null;
        }
        return (ItemGradingData)itemGradings.get(0);
    }

    @Override
    public ItemGradingData getItemGradingData(final Long itemGradingId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingData i where i.itemGradingId=?");
                q.setLong(0, itemGradingId.longValue());
                return q.list();
            }
        };
        List itemGradings = this.getHibernateTemplate().executeFind(hcb);
        if (itemGradings.isEmpty()) {
            return null;
        }
        return (ItemGradingData)itemGradings.get(0);
    }

    @Override
    public ItemGradingData getItemGradingData(final Long assessmentGradingId, final Long publishedItemId) {
        log.debug("****assessmentGradingId={}", (Object)assessmentGradingId);
        log.debug("****publishedItemId={}", (Object)publishedItemId);
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingData i where i.assessmentGradingId = ? and i.publishedItemId=?");
                q.setLong(0, assessmentGradingId.longValue());
                q.setLong(1, publishedItemId.longValue());
                return q.list();
            }
        };
        List itemGradings = this.getHibernateTemplate().executeFind(hcb);
        if (itemGradings.isEmpty()) {
            return null;
        }
        return (ItemGradingData)itemGradings.get(0);
    }

    @Override
    public AssessmentGradingData load(Long id) {
        return this.load(id, true);
    }

    @Override
    public AssessmentGradingData load(Long id, boolean loadGradingAttachment) {
        AssessmentGradingData gdata = (AssessmentGradingData)this.getHibernateTemplate().load(AssessmentGradingData.class, (Serializable)id);
        HashSet<ItemGradingData> itemGradingSet = new HashSet<ItemGradingData>();
        HashMap<Long, ItemGradingData> itemGradingMap = this.getItemGradingMap(gdata.getAssessmentGradingId());
        if (itemGradingMap.keySet().size() > 0) {
            Collection<ItemGradingData> itemGradingCollection = itemGradingMap.values();
            if (loadGradingAttachment) {
                HashMap<Long, ArrayList<ItemGradingAttachment>> attachmentMap = this.getItemGradingAttachmentMap(itemGradingMap.keySet());
                for (ItemGradingData itemGradingData : itemGradingCollection) {
                    if (attachmentMap.get(itemGradingData.getItemGradingId()) != null) {
                        itemGradingData.setItemGradingAttachmentList(attachmentMap.get(itemGradingData.getItemGradingId()));
                    } else {
                        itemGradingData.setItemGradingAttachmentList(new ArrayList());
                    }
                    itemGradingSet.add(itemGradingData);
                }
            } else {
                itemGradingSet.addAll(itemGradingCollection);
            }
        }
        gdata.setItemGradingSet(itemGradingSet);
        return gdata;
    }

    @Override
    public ItemGradingData getItemGrading(Long id) {
        return (ItemGradingData)this.getHibernateTemplate().load(ItemGradingData.class, (Serializable)id);
    }

    @Override
    public AssessmentGradingData getLastSavedAssessmentGradingByAgentId(final Long publishedAssessmentId, final String agentIdString) {
        AssessmentGradingData ag = null;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? and a.status<>? order by a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingData.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (!assessmentGradings.isEmpty()) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public AssessmentGradingData getLastSubmittedAssessmentGradingByAgentId(final Long publishedAssessmentId, final String agentIdString, Long assessmentGradingId) {
        Map<Long, List<AssessmentGradingAttachment>> map;
        List<AssessmentGradingAttachment> attachments;
        AssessmentGradingData ag;
        block4: {
            List assessmentGradings;
            block3: {
                ag = null;
                HibernateCallback hcb = new HibernateCallback(){

                    public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                        Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.submittedDate desc");
                        q.setLong(0, publishedAssessmentId.longValue());
                        q.setString(1, agentIdString);
                        q.setBoolean(2, true);
                        return q.list();
                    }
                };
                assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
                if (assessmentGradingId != null) break block3;
                if (assessmentGradings.size() <= 0) break block4;
                ag = (AssessmentGradingData)assessmentGradings.get(0);
                break block4;
            }
            for (int i = 0; i < assessmentGradings.size(); ++i) {
                AssessmentGradingData agd = (AssessmentGradingData)assessmentGradings.get(i);
                if (agd.getAssessmentGradingId().compareTo(assessmentGradingId) != 0) continue;
                ag = agd;
                ag.setItemGradingSet(this.getItemGradingSet(agd.getAssessmentGradingId()));
                break;
            }
        }
        if ((attachments = (map = this.getAssessmentGradingAttachmentMap(publishedAssessmentId)).get(ag.getAssessmentGradingId())) != null) {
            ag.setAssessmentGradingAttachmentList(attachments);
        } else {
            ag.setAssessmentGradingAttachmentList(new ArrayList());
        }
        return ag;
    }

    @Override
    public AssessmentGradingData getLastAssessmentGradingByAgentId(final Long publishedAssessmentId, final String agentIdString) {
        AssessmentGradingData ag = null;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? order by a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (!assessmentGradings.isEmpty()) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public void saveItemGrading(ItemGradingData item) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)item);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving itemGrading: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAssessmentGrading(AssessmentGradingData assessment) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)assessment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem inserting/updating assessmentGrading: {}", (Object)e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getMediaStream(Long mediaId) {
        byte[] b = new byte[4000];
        Session session = null;
        Connection conn = null;
        InputStream in = null;
        ResultSet rs = null;
        Statement statement = null;
        try {
            Object o;
            session = this.getSessionFactory().openSession();
            conn = session.connection();
            log.debug("****Connection={}", (Object)conn);
            String query = "select MEDIA from SAM_MEDIA_T where MEDIAID=?";
            statement = conn.prepareStatement(query);
            statement.setLong(1, mediaId);
            rs = statement.executeQuery();
            if (rs.next() && (o = rs.getObject("MEDIA")) != null) {
                int ch;
                in = rs.getBinaryStream("MEDIA");
                in.mark(0);
                int len = 0;
                while ((ch = in.read()) != -1) {
                    ++len;
                }
                b = new byte[len];
                in.reset();
                in.read(b, 0, len);
            }
        }
        catch (IOException | SQLException | HibernateException e) {
            log.warn(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        return b;
    }

    @Override
    public List getAssessmentGradingIds(final Long publishedItemId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select g.assessmentGradingId from  ItemGradingData g where g.publishedItemId=?");
                q.setLong(0, publishedItemId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public AssessmentGradingData getHighestAssessmentGrading(final Long publishedAssessmentId, final String agentId) {
        AssessmentGradingData ag = null;
        String query = "from AssessmentGradingData a  where a.publishedAssessmentId=? and  a.agentId=? order by a.finalScore desc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a  where a.publishedAssessmentId=? and  a.agentId=? order by a.finalScore desc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentId);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (!assessmentGradings.isEmpty()) {
            ag = (AssessmentGradingData)assessmentGradings.get(0);
            ag.setItemGradingSet(this.getItemGradingSet(ag.getAssessmentGradingId()));
        }
        return ag;
    }

    @Override
    public AssessmentGradingData getHighestSubmittedAssessmentGrading(final Long publishedAssessmentId, final String agentId, Long assessmentGradingId) {
        Map<Long, List<AssessmentGradingAttachment>> map;
        List<AssessmentGradingAttachment> attachments;
        AssessmentGradingData ag;
        block4: {
            List assessmentGradings;
            block3: {
                ag = null;
                String query = "from AssessmentGradingData a  where a.publishedAssessmentId=? and a.agentId=? and  a.forGrade=?  order by a.finalScore desc, a.submittedDate desc";
                HibernateCallback hcb = new HibernateCallback(){

                    public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                        Query q = session.createQuery("from AssessmentGradingData a  where a.publishedAssessmentId=? and a.agentId=? and  a.forGrade=?  order by a.finalScore desc, a.submittedDate desc");
                        q.setLong(0, publishedAssessmentId.longValue());
                        q.setString(1, agentId);
                        q.setBoolean(2, true);
                        return q.list();
                    }
                };
                assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
                if (assessmentGradingId != null) break block3;
                if (assessmentGradings.size() <= 0) break block4;
                ag = (AssessmentGradingData)assessmentGradings.get(0);
                break block4;
            }
            for (int i = 0; i < assessmentGradings.size(); ++i) {
                AssessmentGradingData agd = (AssessmentGradingData)assessmentGradings.get(i);
                if (agd.getAssessmentGradingId().compareTo(assessmentGradingId) != 0) continue;
                ag = agd;
                ag.setItemGradingSet(this.getItemGradingSet(agd.getAssessmentGradingId()));
                break;
            }
        }
        if ((attachments = (map = this.getAssessmentGradingAttachmentMap(publishedAssessmentId)).get(ag.getAssessmentGradingId())) != null) {
            ag.setAssessmentGradingAttachmentList(attachments);
        } else {
            ag.setAssessmentGradingAttachmentList(new ArrayList());
        }
        return ag;
    }

    @Override
    public List getLastAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public List getLastSubmittedAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "select a from AssessmentGradingData a left join fetch a.assessmentGradingAttachmentSet where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a from AssessmentGradingData a left join fetch a.assessmentGradingAttachmentSet where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public List getLastSubmittedOrGradedAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingData.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public List getHighestAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.finalScore desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.finalScore desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public List getHighestSubmittedOrGradedAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId asc, a.finalScore desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=?)) order by a.agentId asc, a.finalScore desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingData.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public HashMap getLastAssessmentGradingByPublishedItem(final Long publishedAssessmentId) {
        HashMap h = new HashMap();
        String query = "select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        String currentAgent = "";
        Date submittedDate = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            log.debug("**** itemId=" + itemId + ", gradingId=" + gradingId + ", agentId=" + g.getAgentId() + ", score=" + g.getFinalScore());
            if (i == 0) {
                currentAgent = g.getAgentId();
                submittedDate = g.getSubmittedDate();
            }
            if (currentAgent.equals(g.getAgentId()) && (submittedDate == null && g.getSubmittedDate() == null || submittedDate != null && submittedDate.equals(g.getSubmittedDate()))) {
                Object o = h.get(itemId);
                if (o != null) {
                    ((ArrayList)o).add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            submittedDate = g.getSubmittedDate();
        }
        return h;
    }

    @Override
    public HashMap getHighestAssessmentGradingByPublishedItem(final Long publishedAssessmentId) {
        HashMap h = new HashMap();
        String query = "select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a,  PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.finalScore desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a,  PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.finalScore desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        String currentAgent = "";
        Double finalScore = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            log.debug("**** itemId=" + itemId + ", gradingId=" + gradingId + ", agentId=" + g.getAgentId() + ", score=" + g.getFinalScore());
            if (i == 0) {
                currentAgent = g.getAgentId();
                finalScore = g.getFinalScore();
            }
            if (currentAgent.equals(g.getAgentId()) && (finalScore == null && g.getFinalScore() == null || finalScore != null && finalScore.equals(g.getFinalScore()))) {
                Object o = h.get(itemId);
                if (o != null) {
                    ((ArrayList)o).add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            finalScore = g.getFinalScore();
        }
        return h;
    }

    @Override
    public Set getItemGradingSet(final Long assessmentGradingId) {
        String query = "from ItemGradingData i where i.assessmentGradingId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingData i where i.assessmentGradingId=?");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        List itemGradings = this.getHibernateTemplate().executeFind(hcb);
        HashSet s = new HashSet();
        for (int i = 0; i < itemGradings.size(); ++i) {
            s.add(itemGradings.get(i));
        }
        return s;
    }

    public HashMap<Long, ItemGradingData> getItemGradingMap(final Long assessmentGradingId) {
        String query = "from ItemGradingData i where i.assessmentGradingId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingData i where i.assessmentGradingId=?");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        List itemGradingList = this.getHibernateTemplate().executeFind(hcb);
        HashMap<Long, ItemGradingData> m = new HashMap<Long, ItemGradingData>();
        for (int i = 0; i < itemGradingList.size(); ++i) {
            m.put(((ItemGradingData)itemGradingList.get(i)).getItemGradingId(), (ItemGradingData)itemGradingList.get(i));
        }
        return m;
    }

    @Override
    public HashMap getAssessmentGradingByItemGradingId(final Long publishedAssessmentId) {
        List aList = this.getAllSubmissions(publishedAssessmentId.toString());
        HashMap<Long, AssessmentGradingData> aHash = new HashMap<Long, AssessmentGradingData>();
        for (int j = 0; j < aList.size(); ++j) {
            AssessmentGradingData a = (AssessmentGradingData)aList.get(j);
            aHash.put(a.getAssessmentGradingId(), a);
        }
        String query = "select new ItemGradingData(i.itemGradingId, a.assessmentGradingId)  from ItemGradingData i, AssessmentGradingData a  where i.assessmentGradingId=a.assessmentGradingId  and a.publishedAssessmentId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new ItemGradingData(i.itemGradingId, a.assessmentGradingId)  from ItemGradingData i, AssessmentGradingData a  where i.assessmentGradingId=a.assessmentGradingId  and a.publishedAssessmentId=?");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List l = this.getHibernateTemplate().executeFind(hcb);
        HashMap<Long, AssessmentGradingData> h = new HashMap<Long, AssessmentGradingData>();
        for (int i = 0; i < l.size(); ++i) {
            ItemGradingData o = (ItemGradingData)l.get(i);
            h.put(o.getItemGradingId(), (AssessmentGradingData)aHash.get(o.getAssessmentGradingId()));
        }
        return h;
    }

    @Override
    public void deleteAll(Collection c) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().deleteAll(c);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem inserting assessmentGrading: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAll(Collection<ItemGradingData> c) {
        int retryCount = this.persistenceHelper.getRetryCount();
        c.removeAll(Collections.singleton(null));
        while (retryCount > 0) {
            try {
                for (ItemGradingData itemGradingData : c) {
                    this.getHibernateTemplate().saveOrUpdate((Object)itemGradingData);
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem inserting assessmentGrading: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public PublishedAssessmentIfc getPublishedAssessmentByAssessmentGradingId(final Long assessmentGradingId) {
        PublishedAssessmentIfc pub = null;
        String query = "select p from PublishedAssessmentData p, AssessmentGradingData a  where a.publishedAssessmentId=p.publishedAssessmentId and a.assessmentGradingId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p from PublishedAssessmentData p, AssessmentGradingData a  where a.publishedAssessmentId=p.publishedAssessmentId and a.assessmentGradingId=?");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        List pubList = this.getHibernateTemplate().executeFind(hcb);
        if (pubList != null && pubList.size() > 0) {
            pub = (PublishedAssessmentIfc)pubList.get(0);
        }
        return pub;
    }

    @Override
    public PublishedAssessmentIfc getPublishedAssessmentByPublishedItemId(final Long publishedItemId) {
        PublishedAssessmentIfc pub = null;
        String query = "select p from PublishedAssessmentData p, PublishedItemData i  where p.publishedAssessmentId=i.section.assessment.publishedAssessmentId and i.itemId=?";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p from PublishedAssessmentData p, PublishedItemData i  where p.publishedAssessmentId=i.section.assessment.publishedAssessmentId and i.itemId=?");
                q.setLong(0, publishedItemId.longValue());
                return q.list();
            }
        };
        List pubList = this.getHibernateTemplate().executeFind(hcb);
        if (pubList != null && pubList.size() > 0) {
            pub = (PublishedAssessmentIfc)pubList.get(0);
        }
        return pub;
    }

    @Override
    public ArrayList getLastItemGradingDataPosition(final Long assessmentGradingId, final String agentId) {
        ArrayList<Integer> position = new ArrayList<Integer>();
        try {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery("select s.sequence  from ItemGradingData i, PublishedItemData pi, PublishedSectionData s  where i.agentId = ? and i.assessmentGradingId = ?  and pi.itemId = i.publishedItemId  and pi.section.id = s.id  group by i.publishedItemId, s.sequence, pi.sequence  order by s.sequence desc , pi.sequence desc");
                    q.setString(0, agentId);
                    q.setLong(1, assessmentGradingId.longValue());
                    return q.list();
                }
            };
            List list = this.getHibernateTemplate().executeFind(hcb);
            if (list.isEmpty()) {
                position.add(0);
                position.add(0);
            } else {
                Integer sequence = (Integer)list.get(0);
                int count = 1;
                for (int i = 1; i < list.size(); ++i) {
                    log.debug("i = {}", (Object)i);
                    Integer nextSequence = (Integer)list.get(i);
                    if (!sequence.equals(nextSequence)) break;
                    log.debug("equal");
                    ++count;
                }
                log.debug("sequence = " + sequence);
                log.debug("count = " + count);
                position.add(sequence);
                position.add(count);
            }
            return position;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            position.add(0);
            position.add(0);
            return position;
        }
    }

    @Override
    public List getPublishedItemIds(final Long assessmentGradingId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i.publishedItemId from  ItemGradingData i where i.assessmentGradingId=?");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List getItemGradingIds(final Long assessmentGradingId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select i.itemGradingId from  ItemGradingData i where i.assessmentGradingId=?");
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public HashSet getItemSet(final Long publishedAssessmentId, final Long sectionId) {
        HashSet<PublishedItemData> itemSet = new HashSet<PublishedItemData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select distinct p.itemId from PublishedItemData p, AssessmentGradingData a, ItemGradingData i where a.publishedAssessmentId=? and a.forGrade=? and p.section.id=? and i.assessmentGradingId = a.assessmentGradingId and p.itemId = i.publishedItemId ");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                q.setLong(2, sectionId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        final ArrayList<Long> itemIds = new ArrayList<Long>();
        Iterator iter = assessmentGradings.iterator();
        while (iter.hasNext()) {
            itemIds.add((Long)iter.next());
        }
        if (itemIds.isEmpty()) {
            return itemSet;
        }
        HibernateCallback hcb2 = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(PublishedItemData.class);
                if (itemIds.size() > 1000) {
                    HashSet<Long> ids = new HashSet<Long>();
                    Disjunction disjunction = Restrictions.disjunction();
                    for (Long id : itemIds) {
                        if (ids.size() < 1000) {
                            ids.add(id);
                            continue;
                        }
                        criteria.add((Criterion)disjunction.add(Restrictions.in((String)"itemId", ids)));
                        ids.clear();
                    }
                } else {
                    criteria.add(Restrictions.in((String)"itemId", (Collection)itemIds));
                }
                return criteria.list();
            }
        };
        List publishedItems = this.getHibernateTemplate().executeFind(hcb2);
        for (PublishedItemData publishedItemData2 : publishedItems) {
            log.debug("itemId = " + publishedItemData2.getItemId());
            itemSet.add(publishedItemData2);
        }
        return itemSet;
    }

    @Override
    public Long getTypeId(final Long itemGradingId) {
        Long typeId2 = -1L;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select p.typeId from PublishedItemData p, ItemGradingData i where i.itemGradingId=? and p.itemId = i.publishedItemId ");
                q.setLong(0, itemGradingId.longValue());
                return q.list();
            }
        };
        List typeIdList = this.getHibernateTemplate().executeFind(hcb);
        for (Long typeId2 : typeIdList) {
            log.debug("typeId = {}", (Object)typeId2);
        }
        return typeId2;
    }

    @Override
    public List getAllAssessmentGradingByAgentId(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, true);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        return assessmentGradings;
    }

    @Override
    public List<ItemGradingData> getAllItemGradingDataForItemInGrading(Long assesmentGradingId, Long publishedItemId) {
        if (assesmentGradingId == null) {
            throw new IllegalArgumentException("assesmentGradingId cant' be null");
        }
        if (publishedItemId == null) {
            throw new IllegalArgumentException("publishedItemId cant' be null");
        }
        List assessmentGradings = this.getSession().createCriteria(ItemGradingData.class).add((Criterion)Restrictions.eq((String)"assessmentGradingId", (Object)assesmentGradingId)).add((Criterion)Restrictions.eq((String)"publishedItemId", (Object)publishedItemId)).list();
        return assessmentGradings;
    }

    @Override
    public HashMap getSiteSubmissionCountHash(final String siteId) {
        HashMap siteSubmissionCountHash = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.publishedAssessmentId, a.agentId, count(*) from AssessmentGradingData a, AuthorizationData au  where a.forGrade=? and au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId group by a.publishedAssessmentId, a.agentId order by a.publishedAssessmentId, a.agentId ");
                q.setBoolean(0, true);
                q.setString(1, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(2, siteId);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        Long lastPublishedAssessmentId = -1L;
        HashMap<Object, Object> numberSubmissionPerStudentHash = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberSubmissionPerStudentHash.put(o[1], o[2]);
                continue;
            }
            numberSubmissionPerStudentHash = new HashMap();
            numberSubmissionPerStudentHash.put(o[1], o[2]);
            siteSubmissionCountHash.put(publishedAssessmentid, numberSubmissionPerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteSubmissionCountHash;
    }

    @Override
    public HashMap getSiteInProgressCountHash(final String siteId) {
        HashMap siteInProgressCountHash = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.publishedAssessmentId, a.agentId, count(*) from AssessmentGradingData a, AuthorizationData au  where a.forGrade=? and au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and (a.status=? or a.status=?) group by a.publishedAssessmentId, a.agentId order by a.publishedAssessmentId, a.agentId ");
                q.setBoolean(0, false);
                q.setString(1, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(2, siteId);
                q.setInteger(3, 0);
                q.setInteger(4, 6);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        Long lastPublishedAssessmentId = -1L;
        HashMap<Object, Object> numberInProgressPerStudentHash = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberInProgressPerStudentHash.put(o[1], o[2]);
                continue;
            }
            numberInProgressPerStudentHash = new HashMap();
            numberInProgressPerStudentHash.put(o[1], o[2]);
            siteInProgressCountHash.put(publishedAssessmentid, numberInProgressPerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteInProgressCountHash;
    }

    @Override
    public int getActualNumberRetake(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select count(*) from AssessmentGradingData a, StudentGradingSummaryData s  where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=?  and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, true);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        if (iter.hasNext()) {
            int i = (Integer)iter.next();
            return i;
        }
        return 0;
    }

    @Override
    public HashMap getSiteActualNumberRetakeHash(final String siteId) {
        HashMap actualNumberRetakeHash = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.publishedAssessmentId, a.agentId, count(*)  from AssessmentGradingData a, StudentGradingSummaryData s, AuthorizationData au, PublishedAssessmentData p  where a.forGrade=? and au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate and a.publishedAssessmentId = p.publishedAssessmentId and p.status != 2 group by a.publishedAssessmentId, a.agentId order by a.publishedAssessmentId");
                q.setBoolean(0, true);
                q.setString(1, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(2, siteId);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        Long lastPublishedAssessmentId = -1L;
        HashMap<Object, Object> actualNumberRetakePerStudentHash = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            Long publishedAssessmentid = (Long)o[0];
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                actualNumberRetakePerStudentHash.put(o[1], o[2]);
                continue;
            }
            actualNumberRetakePerStudentHash = new HashMap();
            actualNumberRetakePerStudentHash.put(o[1], o[2]);
            actualNumberRetakeHash.put(publishedAssessmentid, actualNumberRetakePerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return actualNumberRetakeHash;
    }

    @Override
    public HashMap getActualNumberRetakeHash(final String agentIdString) {
        HashMap<Object, Object> actualNumberRetakeHash = new HashMap<Object, Object>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a.publishedAssessmentId, count(*) from AssessmentGradingData a, StudentGradingSummaryData s  where a.agentId=? and a.forGrade=?  and a.publishedAssessmentId = s.publishedAssessmentId and a.agentId = s.agentId  and a.submittedDate > s.createdDate group by a.publishedAssessmentId");
                q.setString(0, agentIdString);
                q.setBoolean(1, true);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        for (Object[] o : countList) {
            actualNumberRetakeHash.put(o[0], o[1]);
        }
        return actualNumberRetakeHash;
    }

    @Override
    public List getStudentGradingSummaryData(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from StudentGradingSummaryData s where s.publishedAssessmentId=? and s.agentId=?");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                return q.list();
            }
        };
        List studentGradingSummaryDataList = this.getHibernateTemplate().executeFind(hcb);
        return studentGradingSummaryDataList;
    }

    @Override
    public int getNumberRetake(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s.numberRetake from StudentGradingSummaryData s where s.publishedAssessmentId=? and s.agentId=?");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                return q.list();
            }
        };
        List numberRetakeList = this.getHibernateTemplate().executeFind(hcb);
        if (numberRetakeList.isEmpty()) {
            return 0;
        }
        Integer numberRetake = (Integer)numberRetakeList.get(0);
        return numberRetake;
    }

    @Override
    public HashMap getNumberRetakeHash(final String agentIdString) {
        HashMap<Long, StudentGradingSummaryData> h = new HashMap<Long, StudentGradingSummaryData>();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from StudentGradingSummaryData s where s.agentId=? ");
                q.setString(0, agentIdString);
                return q.list();
            }
        };
        List numberRetakeList = this.getHibernateTemplate().executeFind(hcb);
        for (int i = 0; i < numberRetakeList.size(); ++i) {
            StudentGradingSummaryData s = (StudentGradingSummaryData)numberRetakeList.get(i);
            h.put(s.getPublishedAssessmentId(), s);
        }
        return h;
    }

    @Override
    public HashMap getSiteNumberRetakeHash(final String siteId) {
        HashMap siteNumberRetakeHash = new HashMap();
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select s from StudentGradingSummaryData s, AuthorizationData au where au.functionId = ? and au.agentIdString = ? and s.publishedAssessmentId = au.qualifierId order by s.publishedAssessmentId, s.agentId");
                q.setString(0, "OWN_PUBLISHED_ASSESSMENT");
                q.setString(1, siteId);
                return q.list();
            }
        };
        List countList = this.getHibernateTemplate().executeFind(hcb);
        Iterator iter = countList.iterator();
        Long lastPublishedAssessmentId = -1L;
        HashMap<String, Integer> numberRetakePerStudentHash = null;
        while (iter.hasNext()) {
            StudentGradingSummaryData s = (StudentGradingSummaryData)iter.next();
            Long publishedAssessmentid = s.getPublishedAssessmentId();
            if (lastPublishedAssessmentId.equals(publishedAssessmentid)) {
                numberRetakePerStudentHash.put(s.getAgentId(), s.getNumberRetake());
                continue;
            }
            numberRetakePerStudentHash = new HashMap<String, Integer>();
            numberRetakePerStudentHash.put(s.getAgentId(), s.getNumberRetake());
            siteNumberRetakeHash.put(publishedAssessmentid, numberRetakePerStudentHash);
            lastPublishedAssessmentId = publishedAssessmentid;
        }
        return siteNumberRetakeHash;
    }

    @Override
    public void saveStudentGradingSummaryData(StudentGradingSummaryIfc studentGradingSummaryData) {
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)((StudentGradingSummaryData)studentGradingSummaryData));
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem saving studentGradingSummaryData: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public int getLateSubmissionsNumberByAgentId(final Long publishedAssessmentId, final String agentIdString, final Date dueDate) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? and a.submittedDate>?");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, true);
                q.setDate(3, dueDate);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        return assessmentGradings.size();
    }

    public List getAllOrderedSubmissions(final String publishedId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and (a.forGrade=? or (a.forGrade=? and a.status=? and a.finalScore <> 0)) order by a.agentId ASC, a.submittedDate");
                q.setLong(0, Long.parseLong(publishedId));
                q.setBoolean(1, true);
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingData.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List getExportResponsesData(String publishedAssessmentId, boolean anonymous, String audioMessage, String fileUploadMessage, String noSubmissionMessage, boolean showPartAndTotalScoreSpreadsheetColumns, String poolString, String partString, String questionString, String textString, String rationaleString, String itemGradingCommentsString, Map useridMap, String responseCommentString) {
        ArrayList<Object> responseList;
        ArrayList dataList = new ArrayList();
        ArrayList<String> headerList = new ArrayList<String>();
        ArrayList<ArrayList<Object>> finalList = new ArrayList<ArrayList<Object>>(2);
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        HashSet publishedAssessmentSections = pubService.getSectionSetForAssessment(Long.valueOf(publishedAssessmentId));
        Double zeroDouble = 0.0;
        HashMap<Long, AnswerIfc> publishedAnswerHash = pubService.preparePublishedAnswerHash(pubService.getPublishedAssessment(publishedAssessmentId));
        HashMap<Long, ItemTextIfc> publishedItemTextHash = pubService.preparePublishedItemTextHash(pubService.getPublishedAssessment(publishedAssessmentId));
        HashMap<Long, ItemDataIfc> publishedItemHash = pubService.preparePublishedItemHash(pubService.getPublishedAssessment(publishedAssessmentId));
        TreeSet<ItemDataIfc> publishItemSet = new TreeSet<ItemDataIfc>(new ItemComparator());
        publishItemSet.addAll(publishedItemHash.values());
        int numSubmission = 1;
        String lastAgentId = "";
        String agentEid = "";
        String firstName = "";
        String lastName = "";
        HashSet useridSet = new HashSet(useridMap.keySet());
        boolean fistItemGradingData = true;
        List list = this.getAllOrderedSubmissions(publishedAssessmentId);
        Iterator assessmentGradingIter = list.iterator();
        while (assessmentGradingIter.hasNext()) {
            Iterator sectionsIter = publishedAssessmentSections.iterator();
            HashMap sectionItems = new HashMap();
            TreeMap<Integer, Double> sectionScores = new TreeMap<Integer, Double>();
            while (sectionsIter.hasNext()) {
                PublishedSectionData publishedSection = (PublishedSectionData)sectionsIter.next();
                ArrayList itemsArray = publishedSection.getItemArraySortedForGrading();
                Iterator itemsIter = itemsArray.iterator();
                HashMap<Long, Long> itemsForSection = new HashMap<Long, Long>();
                while (itemsIter.hasNext()) {
                    ItemDataIfc item = (ItemDataIfc)itemsIter.next();
                    itemsForSection.put(item.getItemId(), item.getItemId());
                }
                sectionItems.put(publishedSection.getSequence(), itemsForSection);
                sectionScores.put(publishedSection.getSequence(), zeroDouble);
            }
            AssessmentGradingData assessmentGradingData = (AssessmentGradingData)assessmentGradingIter.next();
            String agentId = assessmentGradingData.getAgentId();
            responseList = new ArrayList<Object>();
            boolean canBeExported = false;
            if (anonymous) {
                canBeExported = true;
                responseList.add(assessmentGradingData.getAssessmentGradingId());
            } else if (useridMap.containsKey(assessmentGradingData.getAgentId())) {
                useridSet.remove(assessmentGradingData.getAgentId());
                canBeExported = true;
                try {
                    agentEid = this.userDirectoryService.getUser(assessmentGradingData.getAgentId()).getEid();
                    firstName = this.userDirectoryService.getUser(assessmentGradingData.getAgentId()).getFirstName();
                    lastName = this.userDirectoryService.getUser(assessmentGradingData.getAgentId()).getLastName();
                }
                catch (Exception e) {
                    log.error("Cannot get user");
                }
                responseList.add(lastName);
                responseList.add(firstName);
                responseList.add(agentEid);
                if (assessmentGradingData.getForGrade().booleanValue()) {
                    if (lastAgentId.equals(agentId)) {
                        ++numSubmission;
                    } else {
                        numSubmission = 1;
                        lastAgentId = agentId;
                    }
                } else {
                    numSubmission = 0;
                    lastAgentId = agentId;
                }
                String numSubmissionText = numSubmission == 0 ? noSubmissionMessage : String.valueOf(numSubmission);
                responseList.add(numSubmissionText);
            }
            if (!canBeExported) continue;
            int sectionScoreColumnStart = responseList.size();
            if (showPartAndTotalScoreSpreadsheetColumns) {
                Double finalScore = assessmentGradingData.getFinalScore();
                if (finalScore != null) {
                    responseList.add(finalScore);
                } else {
                    log.debug("finalScore is NULL");
                    responseList.add(0.0);
                }
            }
            String assessmentGradingComments = "";
            if (assessmentGradingData.getComments() != null) {
                assessmentGradingComments = assessmentGradingData.getComments().replaceAll("<br\\s*/>", "");
            }
            responseList.add(assessmentGradingComments);
            Long assessmentGradingId = assessmentGradingData.getAssessmentGradingId();
            HashMap studentGradingMap = this.getStudentGradingData(assessmentGradingData.getAssessmentGradingId().toString(), false);
            ArrayList<Object> grades = new ArrayList<Object>();
            grades.addAll(studentGradingMap.values());
            Collections.sort(grades, new QuestionComparator(publishedItemHash));
            if (grades.size() < publishItemSet.size()) {
                int index = -1;
                for (Object e : publishItemSet) {
                    PublishedItemData pid = (PublishedItemData)e;
                    if (++index != grades.size() && ((ItemGradingData)((List)grades.get(index)).get(0)).getPublishedItemId().longValue() == pid.getItemId().longValue()) continue;
                    ArrayList<EmptyItemGrading> newList = new ArrayList<EmptyItemGrading>();
                    newList.add(new EmptyItemGrading(pid.getSection().getSequence(), pid.getItemId(), pid.getSequence()));
                    grades.add(index, newList);
                }
            }
            int questionNumber = 0;
            for (Object e : grades) {
                Integer sectionSequenceNumber;
                List l = (List)e;
                if (l.size() > 1) {
                    Collections.sort(l, new AnswerComparator(publishedAnswerHash));
                }
                String maintext = "";
                String rationale = "";
                String responseComment = "";
                boolean addRationale = false;
                boolean addResponseComment = false;
                boolean matrixChoices = false;
                TreeMap<Long, Object> responsesMap = new TreeMap<Long, Object>();
                int count = 0;
                ItemGradingData grade = null;
                boolean isFinFib = false;
                double itemScore = 0.0;
                TreeMap<Long, String> emiAnswerText = new TreeMap<Long, String>();
                for (Object e2 : l) {
                    PublishedItemData pid;
                    String thistext;
                    Long sequence;
                    ItemTextIfc itemTextIfc;
                    String thistext2;
                    AnswerIfc answer;
                    String temptext;
                    Long answerid;
                    grade = (ItemGradingData)e2;
                    if (grade == null || EmptyItemGrading.class.isInstance(grade)) continue;
                    if (grade.getAutoScore() != null) {
                        itemScore += grade.getAutoScore().doubleValue();
                    }
                    log.debug("<br> " + grade.getPublishedItemId() + " " + grade.getRationale() + " " + grade.getAnswerText() + " " + grade.getComments() + " " + grade.getReview());
                    Long publishedItemId = grade.getPublishedItemId();
                    ItemDataIfc publishedItemData = publishedItemHash.get(publishedItemId);
                    Long typeId = publishedItemData.getTypeId();
                    questionNumber = publishedItemData.getSequence();
                    if (typeId.equals(TypeIfc.FILL_IN_BLANK) || typeId.equals(TypeIfc.FILL_IN_NUMERIC) || typeId.equals(TypeIfc.CALCULATED_QUESTION)) {
                        String temptext2;
                        AnswerIfc answer2;
                        log.debug("FILL_IN_BLANK, FILL_IN_NUMERIC");
                        isFinFib = true;
                        answerid = grade.getPublishedAnswerId();
                        Long sequence3 = null;
                        if (answerid != null && (answer2 = publishedAnswerHash.get(answerid)) != null) {
                            sequence3 = answer2.getSequence();
                        }
                        if ((temptext2 = grade.getAnswerText()) == null) {
                            temptext2 = "No Answer";
                        }
                        String thistext22 = sequence3 + ": " + temptext2;
                        maintext = count == 0 ? thistext22 : maintext + "|" + thistext22;
                        ++count;
                    } else if (typeId.equals(TypeIfc.MATCHING)) {
                        log.debug("MATCHING");
                        answerid = grade.getPublishedAnswerId();
                        temptext = "No Answer";
                        Long sequence2 = null;
                        if (answerid != null) {
                            answer = publishedAnswerHash.get(answerid);
                            if (answer != null) {
                                temptext = answer.getText();
                                if (temptext == null) {
                                    temptext = "No Answer";
                                }
                                sequence2 = answer.getItemText().getSequence();
                            } else if (answerid == -1L) {
                                temptext = "None of the Above";
                                ItemTextIfc itemTextIfc3 = publishedItemTextHash.get(grade.getPublishedItemTextId());
                                sequence2 = itemTextIfc3.getSequence();
                            }
                        } else {
                            ItemTextIfc itemTextIfc2 = publishedItemTextHash.get(grade.getPublishedItemTextId());
                            sequence2 = itemTextIfc2.getSequence();
                        }
                        thistext2 = sequence2 + ": " + temptext;
                        maintext = count == 0 ? thistext2 : maintext + "|" + thistext2;
                        ++count;
                    } else if (typeId.equals(TypeIfc.IMAGEMAP_QUESTION)) {
                        log.debug("MATCHING");
                        itemTextIfc = publishedItemTextHash.get(grade.getPublishedItemTextId());
                        sequence = itemTextIfc.getSequence();
                        temptext = grade.getIsCorrect() != false ? "OK" : "No OK";
                        thistext = sequence + ": " + temptext;
                        maintext = count == 0 ? thistext : maintext + "|" + thistext;
                        ++count;
                    } else if (typeId.equals(TypeIfc.IMAGEMAP_QUESTION)) {
                        log.debug("MATCHING");
                        itemTextIfc = publishedItemTextHash.get(grade.getPublishedItemTextId());
                        sequence = itemTextIfc.getSequence();
                        temptext = grade.getIsCorrect() != false ? "OK" : "No OK";
                        thistext = sequence + ": " + temptext;
                        maintext = count == 0 ? thistext : maintext + "|" + thistext;
                        ++count;
                    } else if (typeId.equals(TypeIfc.IMAGEMAP_QUESTION)) {
                        log.debug("MATCHING");
                        itemTextIfc = publishedItemTextHash.get(grade.getPublishedItemTextId());
                        sequence = itemTextIfc.getSequence();
                        temptext = grade.getIsCorrect() != false ? "OK" : "No OK";
                        thistext = sequence + ": " + temptext;
                        maintext = count == 0 ? thistext : maintext + "|" + thistext;
                        ++count;
                    } else if (typeId.equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) {
                        ItemTextIfc itemTextIfc2;
                        log.debug("EXTENDED_MATCHING_ITEMS");
                        answerid = grade.getPublishedAnswerId();
                        temptext = "No Answer";
                        Long sequence2 = null;
                        if (answerid != null && (answer = publishedAnswerHash.get(answerid)) != null) {
                            temptext = answer.getLabel();
                            if (temptext == null) {
                                temptext = "No Answer";
                            }
                            sequence2 = answer.getItemText().getSequence();
                        }
                        if (sequence2 == null && (itemTextIfc2 = publishedItemTextHash.get(grade.getPublishedItemTextId())) != null) {
                            sequence2 = itemTextIfc2.getSequence();
                        }
                        if (sequence2 != null) {
                            thistext2 = (String)emiAnswerText.get(sequence2);
                            thistext2 = thistext2 == null ? temptext : thistext2 + temptext;
                            emiAnswerText.put(sequence2, thistext2);
                        } else {
                            sequence2 = new Long(99L);
                            emiAnswerText.put(sequence2, "Item Removed");
                        }
                    } else if (typeId.equals(TypeIfc.MATRIX_CHOICES_SURVEY)) {
                        String temptext2;
                        Long sequence3;
                        log.debug("MATRIX_CHOICES_SURVEY");
                        matrixChoices = true;
                        Long answerid2 = grade.getPublishedAnswerId();
                        if (answerid2 != null) {
                            AnswerIfc answer2 = publishedAnswerHash.get(answerid2);
                            String temptext3 = answer2.getText();
                            if (temptext3 == null) {
                                temptext3 = "No Answer";
                            }
                            sequence3 = answer2.getItemText().getSequence();
                        } else {
                            ItemTextIfc itemTextIfc4 = publishedItemTextHash.get(grade.getPublishedItemTextId());
                            sequence3 = itemTextIfc4.getSequence();
                            log.debug("Answerid null for " + grade.getPublishedItemId() + ". Adding " + sequence3);
                            temptext2 = "No Answer";
                        }
                        responsesMap.put(sequence3, temptext2);
                    } else if (typeId.equals(TypeIfc.AUDIO_RECORDING)) {
                        log.debug("AUDIO_RECORDING");
                        maintext = audioMessage;
                    } else if (typeId.equals(TypeIfc.FILE_UPLOAD)) {
                        log.debug("FILE_UPLOAD");
                        maintext = fileUploadMessage;
                    } else if (typeId.equals(TypeIfc.ESSAY_QUESTION)) {
                        log.debug("ESSAY_QUESTION");
                        if (grade.getAnswerText() != null) {
                            maintext = grade.getAnswerText();
                        }
                    } else {
                        log.debug("other type");
                        thistext2 = "";
                        answerid = grade.getPublishedAnswerId();
                        if (answerid != null) {
                            AnswerIfc answer3 = publishedAnswerHash.get(answerid);
                            if (answer3 != null) {
                                String temptext3 = answer3.getText();
                                if (temptext3 != null) {
                                    thistext2 = temptext3;
                                }
                            } else {
                                log.warn("Published answer for " + answerid + " is null");
                            }
                        }
                        maintext = count == 0 ? thistext2 : maintext + "|" + thistext2;
                        ++count;
                    }
                    if (!addRationale && (typeId.equals(TypeIfc.MULTIPLE_CHOICE) || typeId.equals(TypeIfc.MULTIPLE_CORRECT) || typeId.equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) || typeId.equals(TypeIfc.TRUE_FALSE))) {
                        log.debug("MULTIPLE_CHOICE or MULTIPLE_CORRECT or MULTIPLE_CORRECT_SINGLE_SELECTION or TRUE_FALSE");
                        if (publishedItemData.getHasRationale() != null && publishedItemData.getHasRationale().booleanValue()) {
                            addRationale = true;
                            rationale = grade.getRationale();
                            if (rationale == null) {
                                rationale = "";
                            }
                        }
                    }
                    if (!typeId.equals(TypeIfc.MATRIX_CHOICES_SURVEY) || !(pid = (PublishedItemData)publishedItemData).getAddCommentFlag()) continue;
                    addResponseComment = true;
                    if (!responseComment.equals("") || grade.getAnswerText() == null) continue;
                    responseComment = grade.getAnswerText();
                }
                if (!emiAnswerText.isEmpty()) {
                    if (maintext == null) {
                        maintext = "";
                    }
                    for (Map.Entry entry : emiAnswerText.entrySet()) {
                        maintext = maintext + "|" + ((Long)entry.getKey()).toString() + ":" + (String)entry.getValue();
                    }
                    if (maintext.startsWith("|")) {
                        maintext = maintext.substring(1);
                    }
                }
                if (grade == null || EmptyItemGrading.class.isInstance(grade)) {
                    sectionSequenceNumber = ((EmptyItemGrading)((Object)EmptyItemGrading.class.cast(grade))).getSectionSequence();
                    questionNumber = ((EmptyItemGrading)((Object)EmptyItemGrading.class.cast(grade))).getItemSequence();
                    maintext = "-";
                } else {
                    sectionSequenceNumber = this.updateSectionScore(sectionItems, sectionScores, grade.getPublishedItemId(), itemScore);
                }
                if (isFinFib && maintext.contains("No Answer") && count == 1) {
                    maintext = "No Answer";
                } else if ("".equals(maintext)) {
                    maintext = "No Answer";
                }
                String string = "";
                if (!matrixChoices) {
                    void var65_77;
                    responseList.add(maintext);
                    if (grade.getComments() != null) {
                        String string2 = grade.getComments().replaceAll("<br\\s*/>", "");
                    }
                    responseList.add(var65_77);
                } else {
                    ItemDataIfc correspondingPublishedItemData = publishedItemHash.get(grade.getPublishedItemId());
                    List correspondingItemTextArray = correspondingPublishedItemData.getItemTextArray();
                    log.debug("publishedItem is " + correspondingPublishedItemData.getText() + " and number of rows " + correspondingItemTextArray.size());
                    if (responsesMap.size() < correspondingItemTextArray.size()) {
                        for (ItemTextIfc itemTextIfc : correspondingItemTextArray) {
                            if (responsesMap.containsKey(itemTextIfc.getSequence())) continue;
                            log.debug("responsesMap does not contain answer to " + itemTextIfc.getText());
                            responsesMap.put(itemTextIfc.getSequence(), "No Answer");
                        }
                    }
                    for (Map.Entry e3 : responsesMap.entrySet()) {
                        void var65_80;
                        log.debug("Adding to response list " + e3.getKey() + " and " + e3.getValue());
                        responseList.add(e3.getValue());
                        if (grade.getComments() != null) {
                            String string3 = grade.getComments().replaceAll("<br\\s*/>", "");
                        }
                        responseList.add(var65_80);
                        String string4 = "";
                    }
                }
                if (addRationale) {
                    responseList.add(rationale);
                }
                if (addResponseComment) {
                    responseList.add(responseComment);
                }
                if (!fistItemGradingData) continue;
                String poolName = null;
                for (PublishedSectionData psd : publishedAssessmentSections) {
                    if (psd.getSequence().intValue() != sectionSequenceNumber.intValue()) continue;
                    poolName = psd.getSectionMetaDataByLabel("POOLNAME_FOR_RANDOM_DRAW");
                }
                if (!matrixChoices) {
                    headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, textString, questionNumber, poolString, poolName));
                    if (addRationale) {
                        headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, rationaleString, questionNumber, poolString, poolName));
                    }
                    if (addResponseComment) {
                        headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, responseCommentString, questionNumber, poolString, poolName));
                    }
                    headerList.add(this.makeHeader(partString, sectionSequenceNumber, questionString, itemGradingCommentsString, questionNumber, poolString, poolName));
                    continue;
                }
                int numberRows = responsesMap.size();
                for (int i = 0; i < numberRows; ++i) {
                    headerList.add(this.makeHeaderMatrix(partString, sectionSequenceNumber, questionString, textString, questionNumber, i + 1, poolString, poolName));
                    if (addRationale) {
                        headerList.add(this.makeHeaderMatrix(partString, sectionSequenceNumber, questionString, rationaleString, questionNumber, i + 1, poolString, poolName));
                    }
                    if (addResponseComment) {
                        headerList.add(this.makeHeaderMatrix(partString, sectionSequenceNumber, questionString, responseCommentString, questionNumber, i + 1, poolString, poolName));
                    }
                    headerList.add(this.makeHeaderMatrix(partString, sectionSequenceNumber, questionString, itemGradingCommentsString, questionNumber, i + 1, poolString, poolName));
                }
            }
            if (showPartAndTotalScoreSpreadsheetColumns && sectionScores.size() > 1) {
                Iterator keys = sectionScores.keySet().iterator();
                while (keys.hasNext()) {
                    Double d = (Double)sectionScores.get(keys.next());
                    responseList.add(sectionScoreColumnStart++, d);
                }
            }
            dataList.add(responseList);
            if (!fistItemGradingData) continue;
            fistItemGradingData = false;
        }
        if (!anonymous && !useridSet.isEmpty()) {
            for (String id : useridSet) {
                try {
                    agentEid = this.userDirectoryService.getUser(id).getEid();
                    firstName = this.userDirectoryService.getUser(id).getFirstName();
                    lastName = this.userDirectoryService.getUser(id).getLastName();
                }
                catch (Exception e) {
                    log.error("Cannot get user");
                }
                responseList = new ArrayList();
                responseList.add(lastName);
                responseList.add(firstName);
                responseList.add(agentEid);
                responseList.add(noSubmissionMessage);
                dataList.add(responseList);
            }
        }
        Collections.sort(dataList, new ResponsesComparator(anonymous));
        finalList.add(dataList);
        finalList.add(headerList);
        return finalList;
    }

    private int updateSectionScore(HashMap sectionItems, TreeMap sectionScores, Long publishedItemId, double itemScore) {
        for (Map.Entry entry : sectionItems.entrySet()) {
            Object sectionSequence = entry.getKey();
            HashMap itemsForSection = (HashMap)entry.getValue();
            if (itemsForSection.get(publishedItemId) == null) continue;
            Double score = (Double)sectionScores.get(sectionSequence) + itemScore;
            sectionScores.put(sectionSequence, score);
            return (Integer)sectionSequence;
        }
        return 0;
    }

    @Override
    public void removeUnsubmittedAssessmentGradingData(final AssessmentGradingData data) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? and a.status=? order by a.submittedDate desc");
                q.setLong(0, data.getPublishedAssessmentId().longValue());
                q.setString(1, data.getAgentId());
                q.setBoolean(2, false);
                q.setInteger(3, AssessmentGradingData.NO_SUBMISSION.intValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (!assessmentGradings.isEmpty()) {
            this.deleteAll(assessmentGradings);
        }
    }

    @Override
    public boolean getHasGradingData(final Long publishedAssessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? ");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        return !assessmentGradings.isEmpty();
    }

    @Override
    public ArrayList getHasGradingDataAndHasSubmission(final Long publishedAssessmentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<Boolean> al = new ArrayList<Boolean>();
        if (assessmentGradings.size() == 0) {
            al.add(Boolean.FALSE);
            al.add(Boolean.FALSE);
        } else {
            al.add(Boolean.TRUE);
            String currentAgent = "";
            Iterator iter = assessmentGradings.iterator();
            boolean hasSubmission = false;
            while (iter.hasNext()) {
                AssessmentGradingData adata = (AssessmentGradingData)iter.next();
                if (currentAgent.equals(adata.getAgentId())) continue;
                if (adata.getForGrade().booleanValue()) {
                    al.add(Boolean.TRUE);
                    hasSubmission = true;
                    break;
                }
                currentAgent = adata.getAgentId();
            }
            if (!hasSubmission) {
                al.add(Boolean.FALSE);
            }
        }
        return al;
    }

    @Override
    public String getFilename(Long itemGradingId, String agentId, String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex < 0) {
            return this.getFilenameWOExtesion(itemGradingId, agentId, filename);
        }
        return this.getFilenameWExtesion(itemGradingId, agentId, filename, dotIndex);
    }

    private String getFilenameWOExtesion(Long itemGradingId, String agentId, String filename) {
        StringBuilder bindVar = new StringBuilder(filename);
        bindVar.append("%");
        Object[] values = new Object[]{itemGradingId, agentId, bindVar.toString()};
        List list = this.getHibernateTemplate().find("select filename from MediaData m where m.itemGradingData.itemGradingId=? and m.createdBy=? and m.filename like ?", values);
        if (list.isEmpty()) {
            return filename;
        }
        HashSet<String> hs = new HashSet<String>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String name = ((String)iter.next()).trim();
            if (name.contains(".") || !name.equals(filename) && !name.startsWith(filename + "(")) continue;
            hs.add(name);
        }
        if (hs.isEmpty()) {
            return filename;
        }
        StringBuilder testName = new StringBuilder(filename);
        int i = 1;
        while (hs.contains(testName.toString())) {
            testName = new StringBuilder(filename);
            testName.append("(");
            testName.append(++i);
            testName.append(")");
        }
        return testName.toString();
    }

    private String getFilenameWExtesion(Long itemGradingId, String agentId, String filename, int dotIndex) {
        String filenameWithoutExtension = filename.substring(0, dotIndex);
        StringBuilder bindVar = new StringBuilder(filenameWithoutExtension);
        bindVar.append("%");
        bindVar.append(filename.substring(dotIndex));
        Object[] values = new Object[]{itemGradingId, agentId, bindVar.toString()};
        List list = this.getHibernateTemplate().find("select filename from MediaData m where m.itemGradingData.itemGradingId=? and m.createdBy=? and m.filename like ?", values);
        if (list.isEmpty()) {
            return filename;
        }
        HashSet<String> hs = new HashSet<String>();
        Iterator iter = list.iterator();
        String extension = filename.substring(dotIndex);
        int extensionLength = extension.length();
        while (iter.hasNext()) {
            String name = ((String)iter.next()).trim();
            if (!name.equals(filename) && !name.startsWith(filenameWithoutExtension + "(")) continue;
            int nameLenght = name.length();
            hs.add(name.substring(0, nameLenght - extensionLength));
        }
        if (hs.isEmpty()) {
            return filename;
        }
        StringBuffer testName = new StringBuffer(filenameWithoutExtension);
        int i = 1;
        while (true) {
            if (!hs.contains(testName.toString())) {
                testName.append(extension);
                return testName.toString();
            }
            testName = new StringBuffer(filenameWithoutExtension);
            testName.append("(");
            testName.append(++i);
            testName.append(")");
        }
    }

    @Override
    public List getUpdatedAssessmentList(String agentId, String siteId) {
        ArrayList finalList = new ArrayList();
        ArrayList<Object> updatedAssessmentList = new ArrayList<Object>();
        ArrayList<Object> updatedAssessmentNeedResubmitListList = new ArrayList<Object>();
        Object[] values = new Object[]{agentId, siteId, "OWN_PUBLISHED_ASSESSMENT", false, AssessmentGradingData.ASSESSMENT_UPDATED, AssessmentGradingData.ASSESSMENT_UPDATED_NEED_RESUBMIT};
        List list = this.getHibernateTemplate().find("select a.publishedAssessmentId, a.status from AssessmentGradingData a, AuthorizationData az  where a.agentId=? and az.agentIdString=? and az.functionId=?  and az.qualifierId=a.publishedAssessmentId and a.forGrade=? and (a.status=? or a.status=?)  order by a.status", values);
        if (list.isEmpty()) {
            return updatedAssessmentList;
        }
        for (Object[] o : list) {
            if (AssessmentGradingData.ASSESSMENT_UPDATED_NEED_RESUBMIT.compareTo((Integer)o[1]) == 0) {
                updatedAssessmentNeedResubmitListList.add(o[0]);
                continue;
            }
            updatedAssessmentList.add(o[0]);
        }
        finalList.add(updatedAssessmentNeedResubmitListList);
        finalList.add(updatedAssessmentList);
        return finalList;
    }

    @Override
    public List getSiteNeedResubmitList(String siteId) {
        Object[] values = new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, false, 4};
        List list = this.getHibernateTemplate().find("select distinct a.publishedAssessmentId from AssessmentGradingData a, AuthorizationData au where au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and a.forGrade=? and a.status=? ", values);
        return list;
    }

    @Override
    public void autoSubmitAssessments() {
        String hql = "select new AssessmentGradingData(a.assessmentGradingId, a.publishedAssessmentId, a.agentId, a.submittedDate, a.isLate, a.forGrade, a.totalAutoScore, a.totalOverrideScore, a.finalScore, a.comments, a.status, a.gradedBy, a.gradedDate, a.attemptDate, a.timeElapsed) from AssessmentGradingData a, PublishedAccessControl c where a.publishedAssessmentId = c.assessment.publishedAssessmentId and c.retractDate <= :now and a.status != 5 and (a.hasAutoSubmissionRun = 0 or a.hasAutoSubmissionRun is null) and c.autoSubmit = 1 and a.attemptDate is not null and (a.attemptDate <= c.retractDate or (c.dueDate <= :now and c.lateHandling = 2)) order by a.publishedAssessmentId, a.agentId, a.forGrade desc, a.assessmentGradingId";
        Session session = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
        List list = session.createQuery(hql).setTimestamp("now", new Date()).list();
        log.info("AutoSubmit found {} submissions to process", (Object)list.size());
        Iterator iter = list.iterator();
        String lastAgentId = "";
        Long lastPublishedAssessmentId = 0L;
        AssessmentGradingData adata = null;
        HashMap sectionSetMap = new HashMap();
        PublishedAssessmentFacade assessment = null;
        EventLogService eventService = new EventLogService();
        EventLogFacade eventLogFacade = new EventLogFacade();
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        GradebookExternalAssessmentService g = null;
        boolean updateGrades = false;
        HashMap toGradebookPublishedAssessmentSiteIdMap = null;
        GradebookServiceHelper gbsHelper = null;
        if (IntegrationContextFactory.getInstance() != null) {
            boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
            if (integrated) {
                g = (GradebookExternalAssessmentService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookExternalAssessmentService");
            }
            toGradebookPublishedAssessmentSiteIdMap = publishedAssessmentService.getToGradebookPublishedAssessmentSiteIdMap();
            gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper();
            updateGrades = true;
        }
        while (iter.hasNext()) {
            boolean updateCurrentGrade = false;
            HashMap<String, Object> notiValues = new HashMap<String, Object>();
            try {
                String currentSiteId;
                adata = (AssessmentGradingData)iter.next();
                adata.setHasAutoSubmissionRun(Boolean.TRUE);
                Date endDate = new Date();
                if (Boolean.FALSE.equals(adata.getForGrade())) {
                    adata.setForGrade(Boolean.TRUE);
                    if (adata.getTotalAutoScore() == null) {
                        adata.setTotalAutoScore(Double.valueOf(0.0));
                    }
                    if (adata.getFinalScore() == null) {
                        adata.setFinalScore(Double.valueOf(0.0));
                    }
                    if (adata.getAttemptDate() != null && assessment != null && assessment.getDueDate() != null && adata.getAttemptDate().after(assessment.getDueDate())) {
                        adata.setIsLate(Boolean.valueOf(true));
                    } else if (adata.getSubmittedDate() != null && assessment != null && assessment.getDueDate() != null && adata.getSubmittedDate().after(assessment.getDueDate())) {
                        adata.setIsLate(Boolean.valueOf(true));
                    }
                    if (adata.getSubmittedDate() == null && adata.getAttemptDate() != null) {
                        adata.setSubmittedDate(endDate);
                    }
                    updateCurrentGrade = true;
                    adata.setIsAutoSubmitted(Boolean.TRUE);
                    if (lastPublishedAssessmentId.equals(adata.getPublishedAssessmentId()) && lastAgentId.equals(adata.getAgentId())) {
                        AssessmentGradingData assessmentGrading;
                        adata.setStatus(AssessmentGradingData.AUTOSUBMIT_UPDATED);
                        assessment = (PublishedAssessmentFacade)publishedAssessmentService.getAssessment(adata.getPublishedAssessmentId());
                        if (assessment.getEvaluationModel().getScoringType().equals(EvaluationModel.HIGHEST_SCORE) && (assessmentGrading = this.getHighestSubmittedAssessmentGrading(adata.getPublishedAssessmentId(), adata.getAgentId(), null)).getTotalAutoScore() > adata.getTotalAutoScore()) {
                            updateCurrentGrade = false;
                        }
                    } else {
                        adata.setStatus(AssessmentGradingData.SUBMITTED);
                    }
                    this.completeItemGradingData(adata, sectionSetMap);
                    List<EventLogData> eventLogDataList = eventService.getEventLogData(adata.getAssessmentGradingId());
                    if (!eventLogDataList.isEmpty()) {
                        EventLogData eventLogData = eventLogDataList.get(0);
                        eventLogData.setErrorMsg("No Errors (Auto submit)");
                        eventLogData.setEndDate(endDate);
                        if (eventLogData.getStartDate() != null) {
                            double minute = 60000.0;
                            int eclipseTime = (int)Math.ceil((double)(endDate.getTime() - eventLogData.getStartDate().getTime()) / minute);
                            eventLogData.setEclipseTime(Integer.valueOf(eclipseTime));
                        } else {
                            eventLogData.setEclipseTime(null);
                            eventLogData.setErrorMsg("Error during auto submit");
                        }
                        eventLogFacade.setData(eventLogData);
                        eventService.saveOrUpdateEventLog(eventLogFacade);
                    }
                    EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.auto-submit.job", (String)AutoSubmitAssessmentsJob.safeEventLength("publishedAssessmentId=" + adata.getPublishedAssessmentId() + ", assessmentGradingId=" + adata.getAssessmentGradingId()), (boolean)true));
                    notiValues.put("publishedAssessmentID", adata.getPublishedAssessmentId());
                    notiValues.put("assessmentGradingID", adata.getAssessmentGradingId());
                    notiValues.put("userID", adata.getAgentId());
                    notiValues.put("submissionDate", adata.getSubmittedDate());
                    PublishedAssessmentFacade publishedAssessment = publishedAssessmentService.getPublishedAssessment(adata.getPublishedAssessmentId().toString());
                    String confirmationNumber = adata.getAssessmentGradingId() + "-" + publishedAssessment.getPublishedAssessmentId() + "-" + adata.getAgentId() + "-" + adata.getSubmittedDate().toString();
                    notiValues.put("confirmationNumber", confirmationNumber);
                    EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.assessmentAutoSubmitted", (String)((Object)notiValues).toString(), (String)AgentFacade.getCurrentSiteId(), (boolean)false, (int)2));
                }
                lastPublishedAssessmentId = adata.getPublishedAssessmentId();
                lastAgentId = adata.getAgentId();
                this.getHibernateTemplate().saveOrUpdate((Object)adata);
                if (updateGrades && updateCurrentGrade && toGradebookPublishedAssessmentSiteIdMap.containsKey(adata.getPublishedAssessmentId()) && gbsHelper.gradebookExists(GradebookFacade.getGradebookUId(currentSiteId = (String)toGradebookPublishedAssessmentSiteIdMap.get(adata.getPublishedAssessmentId())), g)) {
                    int retryCount = this.persistenceHelper.getRetryCount();
                    while (retryCount > 0) {
                        try {
                            HashMap<String, Double> studentScore = new HashMap<String, Double>();
                            studentScore.put(adata.getAgentId(), adata.getFinalScore());
                            gbsHelper.updateExternalAssessmentScores(adata.getPublishedAssessmentId(), studentScore, g);
                            retryCount = 0;
                        }
                        catch (Exception e) {
                            if (adata != null) {
                                log.error("Error while updating external assessment score during auto submitting assessment grade data id: " + adata.getAssessmentGradingId(), (Throwable)e);
                            } else {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                            retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
                        }
                    }
                }
                adata = null;
            }
            catch (Exception e) {
                if (adata != null) {
                    log.error("Error while auto submitting assessment grade data id: " + adata.getAssessmentGradingId(), (Throwable)e);
                    continue;
                }
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String makeHeader(String section, int sectionNumber, String question, String headerType, int questionNumber, String pool, String poolName) {
        StringBuilder sb = new StringBuilder(section);
        sb.append(" ");
        sb.append(sectionNumber);
        sb.append(", ");
        sb.append(question);
        sb.append(" ");
        sb.append(questionNumber);
        sb.append(", ");
        if (poolName != null) {
            sb.append(pool);
            sb.append(" ");
            sb.append(poolName);
            sb.append(", ");
        }
        sb.append(headerType);
        return sb.toString();
    }

    private String makeHeaderMatrix(String section, int sectionNumber, String question, String headerType, int questionNumber, int questionRow, String pool, String poolName) {
        StringBuilder sb = new StringBuilder(section);
        sb.append(" ");
        sb.append(sectionNumber);
        sb.append(", ");
        sb.append(question);
        sb.append(" ");
        sb.append(questionNumber);
        sb.append(": ");
        sb.append(questionRow);
        sb.append(", ");
        if (poolName != null) {
            sb.append(pool);
            sb.append(" ");
            sb.append(poolName);
            sb.append(", ");
        }
        sb.append(headerType);
        return sb.toString();
    }

    @Override
    public ItemGradingAttachment createItemGradingtAttachment(ItemGradingData itemGrading, String resourceId, String filename, String protocol) {
        GradingAttachmentData attach = this.createGradingtAttachment(resourceId, filename, protocol);
        ItemGradingAttachment itemAttach = new ItemGradingAttachment(attach, itemGrading);
        itemAttach.setItemGrading(itemGrading);
        return itemAttach;
    }

    @Override
    public AssessmentGradingAttachment createAssessmentGradingtAttachment(AssessmentGradingData assessmentGrading, String resourceId, String filename, String protocol) {
        GradingAttachmentData attach = this.createGradingtAttachment(resourceId, filename, protocol);
        AssessmentGradingAttachment assessAttach = new AssessmentGradingAttachment(attach, assessmentGrading);
        assessAttach.setAssessmentGrading(assessmentGrading);
        return assessAttach;
    }

    private GradingAttachmentData createGradingtAttachment(String resourceId, String filename, String protocol) {
        GradingAttachmentData attach = null;
        Boolean isLink = Boolean.FALSE;
        try {
            ContentResource cr = this.contentHostingService.getResource(resourceId);
            if (cr != null) {
                AssessmentFacadeQueries assessmentFacadeQueries = new AssessmentFacadeQueries();
                ResourceProperties p = cr.getProperties();
                attach = new GradingAttachmentData();
                attach.setResourceId(resourceId);
                attach.setFilename(filename);
                attach.setMimeType(cr.getContentType());
                attach.setFileSize(Long.valueOf(assessmentFacadeQueries.fileSizeInKB(cr.getContentLength())));
                if (cr.getContentType().lastIndexOf("url") > -1) {
                    isLink = Boolean.TRUE;
                    if (!filename.toLowerCase().startsWith("http")) {
                        String adjustedFilename = "http://" + filename;
                        attach.setFilename(adjustedFilename);
                    } else {
                        attach.setFilename(filename);
                    }
                } else {
                    attach.setFilename(filename);
                }
                attach.setIsLink(isLink);
                attach.setStatus(AssessmentAttachmentIfc.ACTIVE_STATUS);
                attach.setCreatedBy(p.getProperty(p.getNamePropCreator()));
                attach.setCreatedDate(new Date());
                attach.setLastModifiedBy(p.getProperty(p.getNamePropModifiedBy()));
                attach.setLastModifiedDate(new Date());
                attach.setLocation(assessmentFacadeQueries.getRelativePath(cr.getUrl(), protocol));
            }
        }
        catch (IdUnusedException | PermissionException | TypeException pe) {
            log.warn(pe.getMessage(), pe);
        }
        return attach;
    }

    @Override
    public void removeItemGradingAttachment(Long attachmentId) {
        ItemGradingAttachment itemGradingAttachment = (ItemGradingAttachment)this.getHibernateTemplate().load(ItemGradingAttachment.class, (Serializable)attachmentId);
        ItemGradingData itemGrading = itemGradingAttachment.getItemGrading();
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                if (itemGrading == null) continue;
                Set set = itemGrading.getItemGradingAttachmentSet();
                set.remove(itemGradingAttachment);
                this.getHibernateTemplate().delete((Object)itemGradingAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete assessmentAttachment: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void removeAssessmentGradingAttachment(Long attachmentId) {
        AssessmentGradingAttachment assessmentGradingAttachment = (AssessmentGradingAttachment)this.getHibernateTemplate().load(AssessmentGradingAttachment.class, (Serializable)attachmentId);
        AssessmentGradingData assessmentGrading = assessmentGradingAttachment.getAssessmentGrading();
        int retryCount = this.persistenceHelper.getRetryCount();
        while (retryCount > 0) {
            try {
                if (assessmentGrading == null) continue;
                Set set = assessmentGrading.getAssessmentGradingAttachmentSet();
                set.remove(assessmentGradingAttachment);
                this.getHibernateTemplate().delete((Object)assessmentGradingAttachment);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete assessmentAttachment: " + e.getMessage());
                retryCount = this.persistenceHelper.retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void saveOrUpdateAttachments(List<AttachmentIfc> list) {
        for (AttachmentIfc attachment : list) {
            this.getHibernateTemplate().saveOrUpdate((Object)attachment);
        }
    }

    @Override
    public HashMap getInProgressCounts(String siteId) {
        Object[] values = new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, false, 0, 6};
        List list = this.getHibernateTemplate().find("select a.publishedAssessmentId, count(*) from AssessmentGradingData a, AuthorizationData au where au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and a.forGrade=? and (a.status=? or a.status=?) group by a.publishedAssessmentId", values);
        Iterator iter = list.iterator();
        HashMap<Object, Object> inProgressCountsMap = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            inProgressCountsMap.put(o[0], o[1]);
        }
        return inProgressCountsMap;
    }

    @Override
    public HashMap getSubmittedCounts(String siteId) {
        Object[] values = new Object[]{"OWN_PUBLISHED_ASSESSMENT", siteId, true};
        List list = this.getHibernateTemplate().find("select a.publishedAssessmentId, count(distinct a.agentId) from AssessmentGradingData a, AuthorizationData au, PublishedAssessmentData p where au.functionId = ? and au.agentIdString = ? and a.publishedAssessmentId = au.qualifierId and a.forGrade=? and a.publishedAssessmentId = p.publishedAssessmentId and (p.lastNeedResubmitDate is null or a.submittedDate >= p.lastNeedResubmitDate) group by a.publishedAssessmentId", values);
        Iterator iter = list.iterator();
        HashMap<Object, Object> startedCountsMap = new HashMap<Object, Object>();
        while (iter.hasNext()) {
            Object[] o = (Object[])iter.next();
            startedCountsMap.put(o[0], o[1]);
        }
        return startedCountsMap;
    }

    @Override
    public void completeItemGradingData(AssessmentGradingData assessmentGradingData) {
        this.completeItemGradingData(assessmentGradingData, null);
    }

    public void completeItemGradingData(AssessmentGradingData assessmentGradingData, HashMap sectionSetMap) {
        HashSet sectionSet;
        ArrayList<Long> answeredPublishedItemIdList = new ArrayList<Long>();
        List publishedItemIds = this.getPublishedItemIds(assessmentGradingData.getAssessmentGradingId());
        for (Long answeredPublishedItemId : publishedItemIds) {
            log.debug("answeredPublishedItemId = " + answeredPublishedItemId);
            answeredPublishedItemIdList.add(answeredPublishedItemId);
        }
        PublishedAssessmentService publishedAssessmentService = new PublishedAssessmentService();
        Long publishedAssessmentId = assessmentGradingData.getPublishedAssessmentId();
        if (sectionSetMap == null || !sectionSetMap.containsKey(publishedAssessmentId)) {
            sectionSet = publishedAssessmentService.getSectionSetForAssessment(publishedAssessmentId);
            if (sectionSetMap != null) {
                sectionSetMap.put(publishedAssessmentId, sectionSet);
            }
        } else {
            sectionSet = (HashSet)sectionSetMap.get(publishedAssessmentId);
        }
        if (sectionSet == null) {
            return;
        }
        for (PublishedSectionData publishedSectionData : sectionSet) {
            Long publishedItemId;
            ArrayList itemArrayList;
            log.debug("sectionId = " + publishedSectionData.getSectionId());
            String authorType = publishedSectionData.getSectionMetaDataByLabel("AUTHOR_TYPE");
            if (authorType != null && authorType.equals(SectionDataIfc.RANDOM_DRAW_FROM_QUESTIONPOOL.toString())) {
                log.debug("Random draw from questonpool");
                itemArrayList = publishedSectionData.getItemArray();
                long seed = AgentFacade.getAgentString().hashCode();
                if (publishedSectionData.getSectionMetaDataByLabel("RANDOMIZATION_TYPE") != null && publishedSectionData.getSectionMetaDataByLabel("RANDOMIZATION_TYPE").equals("1")) {
                    seed = (assessmentGradingData.getAssessmentGradingId().toString() + "_" + publishedSectionData.getSectionId().toString()).hashCode();
                }
                Collections.shuffle(itemArrayList, new Random(seed));
                Integer numberToBeDrawn = 0;
                if (publishedSectionData.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN") != null) {
                    numberToBeDrawn = Integer.valueOf(publishedSectionData.getSectionMetaDataByLabel("NUM_QUESTIONS_DRAWN"));
                }
                int samplesize = numberToBeDrawn;
                for (int i = 0; i < samplesize; ++i) {
                    PublishedItemData publishedItemData = (PublishedItemData)itemArrayList.get(i);
                    publishedItemId = publishedItemData.getItemId();
                    log.debug("publishedItemId = " + publishedItemId);
                    if (answeredPublishedItemIdList.contains(publishedItemId)) continue;
                    this.saveItemGradingData(assessmentGradingData, publishedItemId);
                }
                continue;
            }
            log.debug("Not random draw from questonpool");
            itemArrayList = publishedSectionData.getItemArray();
            for (PublishedItemData publishedItemData : itemArrayList) {
                publishedItemId = publishedItemData.getItemId();
                log.debug("publishedItemId = " + publishedItemId);
                if (answeredPublishedItemIdList.contains(publishedItemId)) continue;
                this.saveItemGradingData(assessmentGradingData, publishedItemId);
            }
        }
    }

    private void saveItemGradingData(AssessmentGradingData assessmentGradingData, Long publishedItemId) {
        log.debug("Adding one ItemGradingData...");
        ItemGradingData itemGradingData = new ItemGradingData();
        itemGradingData.setAssessmentGradingId(assessmentGradingData.getAssessmentGradingId());
        itemGradingData.setAgentId(assessmentGradingData.getAgentId());
        itemGradingData.setPublishedItemId(publishedItemId);
        ItemService itemService = new ItemService();
        Long itemTextId = itemService.getItemTextId(publishedItemId);
        log.debug("itemTextId = {}", (Object)itemTextId);
        if (itemTextId != -1L) {
            itemGradingData.setPublishedItemTextId(itemTextId);
            this.saveItemGrading(itemGradingData);
        }
    }

    @Override
    public Double getAverageSubmittedAssessmentGrading(final Long publishedAssessmentId, final String agentId) {
        Double averageScore = 0.0;
        Object ag = null;
        String query = "from AssessmentGradingData a  where a.publishedAssessmentId=? and a.agentId=? and  a.forGrade=?  order by  a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a  where a.publishedAssessmentId=? and a.agentId=? and  a.forGrade=?  order by  a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentId);
                q.setBoolean(2, true);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        if (!assessmentGradings.isEmpty()) {
            Double cumulativeScore = new Double(0.0);
            for (AssessmentGradingData agd : assessmentGradings) {
                cumulativeScore = cumulativeScore + agd.getFinalScore();
            }
            averageScore = cumulativeScore / (double)assessmentGradings.size();
            DecimalFormat df = new DecimalFormat("0.##");
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(dfs);
            averageScore = new Double(df.format(averageScore));
        }
        return averageScore;
    }

    @Override
    public List getHighestSubmittedAssessmentGradingList(final Long publishedAssessmentId) {
        String query = "from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId asc, a.finalScore desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.forGrade=? order by a.agentId asc, a.finalScore desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setBoolean(1, true);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        String currentAgent = "";
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            if (currentAgent.equals(g.getAgentId())) continue;
            l.add(g);
            currentAgent = g.getAgentId();
        }
        return l;
    }

    @Override
    public HashMap getAverageAssessmentGradingByPublishedItem(final Long publishedAssessmentId) {
        HashMap h = new HashMap();
        String query = "select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.submittedDate desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select new AssessmentGradingData( a.assessmentGradingId, p.itemId,  a.agentId, a.finalScore, a.submittedDate)  from ItemGradingData i, AssessmentGradingData a, PublishedItemData p where  i.assessmentGradingId = a.assessmentGradingId and i.publishedItemId = p.itemId and  a.publishedAssessmentId=?  order by a.agentId asc, a.submittedDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        String currentAgent = "";
        Date submittedDate = null;
        for (int i = 0; i < assessmentGradings.size(); ++i) {
            AssessmentGradingData g = (AssessmentGradingData)assessmentGradings.get(i);
            Long itemId = g.getPublishedItemId();
            Long gradingId = g.getAssessmentGradingId();
            if (i == 0) {
                currentAgent = g.getAgentId();
                submittedDate = g.getSubmittedDate();
            }
            if (currentAgent.equals(g.getAgentId()) && (submittedDate == null && g.getSubmittedDate() == null || submittedDate != null && submittedDate.equals(g.getSubmittedDate()))) {
                Object o = h.get(itemId);
                if (o != null) {
                    ((ArrayList)o).add(gradingId);
                } else {
                    ArrayList<Long> gradingIds = new ArrayList<Long>();
                    gradingIds.add(gradingId);
                    h.put(itemId, gradingIds);
                }
            }
            if (currentAgent.equals(g.getAgentId())) continue;
            currentAgent = g.getAgentId();
            submittedDate = g.getSubmittedDate();
        }
        return h;
    }

    public HashMap<Long, ArrayList<ItemGradingAttachment>> getItemGradingAttachmentMap(final Set itemGradingIds) {
        String query = "from ItemGradingAttachment a where a.itemGrading.itemGradingId in (:itemGradingIds)";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from ItemGradingAttachment a where a.itemGrading.itemGradingId in (:itemGradingIds)");
                q.setParameterList("itemGradingIds", (Collection)itemGradingIds);
                return q.list();
            }
        };
        List itemGradingAttachmentList = this.getHibernateTemplate().executeFind(hcb);
        return this.processItemGradingAttachment(itemGradingAttachmentList);
    }

    public HashMap<Long, ArrayList<ItemGradingAttachment>> getItemGradingAttachmentMap(final Long publishedItemId) {
        String query = "select a from ItemGradingAttachment a where a.itemGrading.publishedItemId = :publishedItemId ";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a from ItemGradingAttachment a where a.itemGrading.publishedItemId = :publishedItemId ");
                q.setLong("publishedItemId", publishedItemId.longValue());
                return q.list();
            }
        };
        List itemGradingAttachmentList = this.getHibernateTemplate().executeFind(hcb);
        return this.processItemGradingAttachment(itemGradingAttachmentList);
    }

    public Map<Long, List<AssessmentGradingAttachment>> getAssessmentGradingAttachmentMap(final Long pubAssessmentId) {
        String query = "select a from AssessmentGradingAttachment a where a.assessmentGrading.publishedAssessmentId = :pubAssessmentId ";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a from AssessmentGradingAttachment a where a.assessmentGrading.publishedAssessmentId = :pubAssessmentId ");
                q.setLong("pubAssessmentId", pubAssessmentId.longValue());
                return q.list();
            }
        };
        List assessmentGradingAttachmentList = this.getHibernateTemplate().executeFind(hcb);
        return this.processAssessmentGradingAttachment(assessmentGradingAttachmentList);
    }

    public HashMap<Long, ArrayList<ItemGradingAttachment>> getItemGradingAttachmentMapByAssessmentGradingId(final Long assessmentGradingId) {
        String query = "select a from ItemGradingAttachment a, ItemGradingData i where a.itemGrading.itemGradingId = i.itemGradingId and i.assessmentGradingId = :assessmentGradingId";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("select a from ItemGradingAttachment a, ItemGradingData i where a.itemGrading.itemGradingId = i.itemGradingId and i.assessmentGradingId = :assessmentGradingId");
                q.setLong("assessmentGradingId", assessmentGradingId.longValue());
                return q.list();
            }
        };
        List itemGradingAttachmentList = this.getHibernateTemplate().executeFind(hcb);
        return this.processItemGradingAttachment(itemGradingAttachmentList);
    }

    private HashMap<Long, ArrayList<ItemGradingAttachment>> processItemGradingAttachment(List itemGradingAttachmentList) {
        HashMap<Long, ArrayList<ItemGradingAttachment>> itemGradingAttachmentMap = new HashMap<Long, ArrayList<ItemGradingAttachment>>();
        for (int i = 0; i < itemGradingAttachmentList.size(); ++i) {
            ItemGradingAttachment attachment = (ItemGradingAttachment)itemGradingAttachmentList.get(i);
            Long itemGrdingId = attachment.getItemGrading().getItemGradingId();
            ArrayList<Object> attachmentList = itemGradingAttachmentMap.containsKey(itemGrdingId) ? itemGradingAttachmentMap.get(itemGrdingId) : new ArrayList();
            attachmentList.add(attachment);
            itemGradingAttachmentMap.put(itemGrdingId, attachmentList);
        }
        return itemGradingAttachmentMap;
    }

    private Map<Long, List<AssessmentGradingAttachment>> processAssessmentGradingAttachment(List<AssessmentGradingAttachment> assessmentGradingAttachmentList) {
        HashMap<Long, List<AssessmentGradingAttachment>> assessmentGradingAttachmentMap = new HashMap<Long, List<AssessmentGradingAttachment>>();
        for (int i = 0; i < assessmentGradingAttachmentList.size(); ++i) {
            AssessmentGradingAttachment attachment = assessmentGradingAttachmentList.get(i);
            Long assessGradingId = attachment.getAssessmentGrading().getAssessmentGradingId();
            List<Object> attachmentList = new ArrayList<AssessmentGradingAttachment>();
            if (assessmentGradingAttachmentMap.containsKey(assessGradingId)) {
                attachmentList = (List)assessmentGradingAttachmentMap.get(assessGradingId);
            }
            attachmentList.add(attachment);
            assessmentGradingAttachmentMap.put(assessGradingId, attachmentList);
        }
        return assessmentGradingAttachmentMap;
    }

    @Override
    public List getUnSubmittedAssessmentGradingDataList(final Long publishedAssessmentId, final String agentIdString) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(org.hibernate.Session session) throws HibernateException, SQLException {
                Query q = session.createQuery("from AssessmentGradingData a where a.publishedAssessmentId=? and a.agentId=? and a.forGrade=? order by a.attemptDate desc");
                q.setLong(0, publishedAssessmentId.longValue());
                q.setString(1, agentIdString);
                q.setBoolean(2, false);
                return q.list();
            }
        };
        List assessmentGradings = this.getHibernateTemplate().executeFind(hcb);
        return assessmentGradings;
    }

    private static class EmptyItemGrading
    extends ItemGradingData {
        private static final long serialVersionUID = 1444166131103415747L;
        private Integer sectionSequence;
        private Long publishedItemId;
        private Integer itemSequence;

        EmptyItemGrading(Integer sectionSequence, Long publishedItemId, Integer itemSequence) {
            this.sectionSequence = sectionSequence;
            this.publishedItemId = publishedItemId;
            this.itemSequence = itemSequence;
        }

        public Integer getItemSequence() {
            return this.itemSequence;
        }

        public Integer getSectionSequence() {
            return this.sectionSequence;
        }
    }

    private static class ItemComparator
    implements Comparator {
        private ItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            PublishedItemData a = (PublishedItemData)o1;
            PublishedItemData b = (PublishedItemData)o2;
            if (a.getSection().getSequence() < b.getSection().getSequence()) {
                return -1;
            }
            if (a.getSection().getSequence() > b.getSection().getSequence()) {
                return 1;
            }
            return a.getSequence() - b.getSequence();
        }
    }

    private static class ResponsesComparator
    implements Comparator {
        boolean anonymous;
        private static final Logger log = LoggerFactory.getLogger(ResponsesComparator.class);

        public ResponsesComparator(boolean anony) {
            this.anonymous = anony;
        }

        public int compare(Object a, Object b) {
            RuleBasedCollator collator_ini = (RuleBasedCollator)Collator.getInstance();
            try {
                String bThirdElement;
                String bSecondElement;
                String bFirstElement;
                RuleBasedCollator collator = new RuleBasedCollator(collator_ini.getRules().replaceAll("<'_'", "<' '<'_'"));
                if (this.anonymous) {
                    Long bFirstElement2;
                    Long aFirstElement = (Long)((ArrayList)a).get(0);
                    if (collator.compare(aFirstElement, bFirstElement2 = (Long)((ArrayList)b).get(0)) < 0) {
                        return -1;
                    }
                    if (collator.compare(aFirstElement, bFirstElement2) > 0) {
                        return 1;
                    }
                    return 0;
                }
                String aFirstElement = (String)((ArrayList)a).get(0);
                if (collator.compare(aFirstElement, bFirstElement = (String)((ArrayList)b).get(0)) < 0) {
                    return -1;
                }
                if (collator.compare(aFirstElement, bFirstElement) > 0) {
                    return 1;
                }
                String aSecondElement = (String)((ArrayList)a).get(1);
                if (collator.compare(aSecondElement, bSecondElement = (String)((ArrayList)b).get(1)) < 0) {
                    return -1;
                }
                if (collator.compare(aSecondElement, bSecondElement) > 0) {
                    return 1;
                }
                String aThirdElement = (String)((ArrayList)a).get(2);
                if (collator.compare(aThirdElement, bThirdElement = (String)((ArrayList)b).get(2)) < 0) {
                    return -1;
                }
                if (collator.compare(aThirdElement, bThirdElement) > 0) {
                    return 1;
                }
                return 0;
            }
            catch (ParseException e) {
                log.error("ERROR compare: ", (Throwable)e);
                return Collator.getInstance().compare(a, b);
            }
        }
    }

    private static class QuestionComparator
    implements Comparator {
        HashMap publishedItemHash;

        public QuestionComparator(HashMap m) {
            this.publishedItemHash = m;
        }

        public int compare(Object a, Object b) {
            ItemGradingData agrade = (ItemGradingData)((List)a).get(0);
            ItemGradingData bgrade = (ItemGradingData)((List)b).get(0);
            ItemDataIfc aitem = (ItemDataIfc)this.publishedItemHash.get(agrade.getPublishedItemId());
            ItemDataIfc bitem = (ItemDataIfc)this.publishedItemHash.get(bgrade.getPublishedItemId());
            Integer asectionseq = aitem.getSection().getSequence();
            Integer bsectionseq = bitem.getSection().getSequence();
            if (asectionseq < bsectionseq) {
                return -1;
            }
            if (asectionseq > bsectionseq) {
                return 1;
            }
            Integer aitemseq = aitem.getSequence();
            Integer bitemseq = bitem.getSequence();
            if (aitemseq < bitemseq) {
                return -1;
            }
            if (aitemseq > bitemseq) {
                return 1;
            }
            return 0;
        }
    }

    private static class AnswerComparator
    implements Comparator {
        HashMap publishedAnswerHash;

        public AnswerComparator(HashMap m) {
            this.publishedAnswerHash = m;
        }

        public int compare(Object a, Object b) {
            ItemGradingData agrade = (ItemGradingData)a;
            ItemGradingData bgrade = (ItemGradingData)b;
            Long aindex = agrade.getItemGradingId();
            Long bindex = bgrade.getItemGradingId();
            Long aanswerid = agrade.getPublishedAnswerId();
            Long banswerid = bgrade.getPublishedAnswerId();
            if (aanswerid != null && banswerid != null) {
                AnswerIfc aanswer = (AnswerIfc)this.publishedAnswerHash.get(aanswerid);
                AnswerIfc banswer = (AnswerIfc)this.publishedAnswerHash.get(banswerid);
                if (aanswer == null || banswer == null) {
                    return aanswer == null ? -1 : 1;
                }
                if (aanswer.getItem() != null && TypeIfc.EXTENDED_MATCHING_ITEMS.equals(aanswer.getItem().getTypeId()) && banswer.getItem() != null && TypeIfc.EXTENDED_MATCHING_ITEMS.equals(banswer.getItem().getTypeId())) {
                    Long bTextSeq;
                    Long aTextSeq = aanswer.getItemText().getSequence();
                    if (!aTextSeq.equals(bTextSeq = banswer.getItemText().getSequence())) {
                        return aTextSeq.compareTo(bTextSeq);
                    }
                    return aanswer.getLabel().compareToIgnoreCase(banswer.getLabel());
                }
                aindex = aanswer.getSequence();
                bindex = banswer.getSequence();
            }
            if (aindex < bindex) {
                return -1;
            }
            if (aindex > bindex) {
                return 1;
            }
            return 0;
        }
    }
}

