/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.tool.assessment.data.dao.assessment.EventLogData;
import org.sakaiproject.tool.assessment.facade.EventLogFacade;
import org.sakaiproject.tool.assessment.facade.EventLogFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class EventLogFacadeQueries
extends HibernateDaoSupport
implements EventLogFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(EventLogFacadeQueries.class);

    @Override
    public void saveOrUpdateEventLog(EventLogFacade eventLog) {
        EventLogData data = eventLog.getData();
        int retryCount = PersistenceService.getInstance().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().saveOrUpdate((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem save or update eventLog: " + e.getMessage());
                retryCount = PersistenceService.getInstance().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public List<EventLogData> getEventLogData(final Long assessmentGradingId) {
        String query;
        final String hql = query = "select eld from EventLogData as eld where eld.processId = ? order by eld.id desc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setLong(0, assessmentGradingId.longValue());
                return q.list();
            }
        };
        List list = this.getHibernateTemplate().executeFind(hcb);
        ArrayList<EventLogData> eventLogList = new ArrayList<EventLogData>();
        HashMap<String, User> userMap = new HashMap<String, User>();
        for (int i = 0; i < list.size(); ++i) {
            EventLogData e = (EventLogData)list.get(i);
            e.setUserDisplay(this.getUserDisplay(e.getUserEid(), userMap));
            eventLogList.add(e);
        }
        return eventLogList;
    }

    @Override
    public List<EventLogData> getDataBySiteId(final String siteId) {
        String query;
        final String hql = query = "select eld from EventLogData as eld where eld.siteId = ? order by eld.assessmentId asc, eld.userEid asc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString(0, siteId);
                return q.list();
            }
        };
        ArrayList list = (ArrayList)this.getHibernateTemplate().executeFind(hcb);
        ArrayList<EventLogData> eventLogDataList = new ArrayList<EventLogData>();
        HashMap<String, User> userMap = new HashMap<String, User>();
        for (int i = 0; i < list.size(); ++i) {
            EventLogData e = (EventLogData)list.get(i);
            e.setUserDisplay(this.getUserDisplay(e.getUserEid(), userMap));
            eventLogDataList.add(e);
        }
        return eventLogDataList;
    }

    @Override
    public List<EventLogData> getEventLogData(final String siteId, final Long assessmentId, String userFilter) {
        String query = "select eld from EventLogData as eld where eld.siteId = ?";
        if (assessmentId > -1L) {
            query = query + " and eld.assessmentId = ?";
        }
        final String hql = query = query + " order by eld.assessmentId asc, eld.userEid asc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString(0, siteId);
                if (assessmentId > -1L) {
                    q.setLong(1, assessmentId.longValue());
                }
                return q.list();
            }
        };
        ArrayList list = (ArrayList)this.getHibernateTemplate().executeFind(hcb);
        ArrayList<EventLogData> eventLogDataList = new ArrayList<EventLogData>();
        HashMap<String, User> userMap = new HashMap<String, User>();
        for (int i = 0; i < list.size(); ++i) {
            EventLogData e = (EventLogData)list.get(i);
            e.setUserDisplay(this.getUserDisplay(e.getUserEid(), userMap));
            if (userFilter != null && !"".equals(userFilter) && (userFilter == null || "".equals(userFilter) || !e.getUserDisplay().toLowerCase().contains(userFilter.toLowerCase()))) continue;
            eventLogDataList.add(e);
        }
        return eventLogDataList;
    }

    private String getUserDisplay(String userEid, Map<String, User> userMap) {
        String display = userEid;
        User user = userMap.get(userEid);
        if (user == null) {
            try {
                user = UserDirectoryService.getUserByEid((String)userEid);
                userMap.put(userEid, user);
            }
            catch (UserNotDefinedException e) {
                log.warn("Unable to get user with eid: " + userEid);
            }
        }
        if (user != null) {
            display = user.getSortName() + " (" + userEid + ")";
        }
        return display;
    }

    @Override
    public List<Object[]> getTitlesFromEventLogBySite(final String siteId) {
        String query;
        final String hql = query = "select distinct eld.assessmentId, eld.title from EventLogData as eld where eld.siteId = ? order by lower(eld.title) asc";
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hql);
                q.setString(0, siteId);
                return q.list();
            }
        };
        ArrayList list = (ArrayList)this.getHibernateTemplate().executeFind(hcb);
        return list;
    }
}

