/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedItemData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class PublishedItemFacadeQueries
extends HibernateDaoSupport
implements PublishedItemFacadeQueriesAPI {
    private Logger log = LoggerFactory.getLogger(PublishedItemFacadeQueries.class);

    @Override
    public IdImpl getItemId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(long id) {
        return new IdImpl(id);
    }

    @Override
    public PublishedItemFacade getItem(Long itemId, String agent) {
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)itemId);
        return new PublishedItemFacade((ItemDataIfc)item);
    }

    @Override
    public PublishedItemFacade getItem(String itemId) {
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)Long.valueOf(itemId));
        return new PublishedItemFacade((ItemDataIfc)item);
    }

    @Override
    public void deleteItemContent(Long itemId, String agent) {
        Set set;
        PublishedItemData item = (PublishedItemData)this.getHibernateTemplate().load(PublishedItemData.class, (Serializable)itemId);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemTextSet();
                    item.setItemTextSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem deleteItemTextSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemMetaDataSet();
                    item.setItemMetaDataSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem deleteItemMetaDataSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemFeedbackSet();
                    item.setItemFeedbackSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                this.log.warn("problem deleting ItemFeedbackSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public PublishedItemFacade saveItem(PublishedItemFacade item) {
        try {
            ItemDataIfc publishedItemdata = item.getData();
            publishedItemdata.setLastModifiedDate(new Date());
            publishedItemdata.setLastModifiedBy(AgentFacade.getAgentString());
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().saveOrUpdate((Object)publishedItemdata);
                    item.setItemId(publishedItemdata.getItemId());
                    retryCount = 0;
                }
                catch (Exception e) {
                    this.log.warn("problem save or update itemdata: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
            if (item.getData() != null && item.getData().getSection() != null) {
                AssessmentIfc assessment = item.getData().getSection().getAssessment();
                assessment.setLastModifiedBy(AgentFacade.getAgentString());
                assessment.setLastModifiedDate(new Date());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)assessment);
                        retryCount = 0;
                    }
                    catch (Exception e) {
                        this.log.warn("problem updating asssessment: " + e.getMessage());
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                    }
                }
            }
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

