/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.osid.assessment.AssessmentException;
import org.osid.assessment.Section;
import org.osid.shared.Id;
import org.osid.shared.Type;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.assessment.impl.SectionImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionFacade
implements Serializable,
SectionDataIfc,
Comparable {
    private Logger log = LoggerFactory.getLogger(SectionFacade.class);
    private static final long serialVersionUID = 7526471155622776147L;
    protected Section section;
    protected Id id;
    protected String description;
    protected SectionDataIfc data;
    protected Type sectionType;
    protected Long sectionId;
    protected Long assessmentId;
    protected AssessmentBaseIfc assessment;
    protected Integer duration;
    protected Integer sequence;
    protected String title;
    protected Long typeId;
    protected Integer status;
    protected String createdBy;
    protected Date createdDate;
    protected String lastModifiedBy;
    protected Date lastModifiedDate;
    protected Set itemSet;
    protected Set metaDataSet = new HashSet();
    protected HashMap metaDataMap = new HashMap();
    protected Set itemFacadeSet;
    protected Set sectionAttachmentSet;

    public SectionFacade() {
        this.data = new SectionData();
        SectionImpl sectionImpl = new SectionImpl();
        this.section = sectionImpl;
        try {
            this.section.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public SectionFacade(SectionDataIfc data) {
        this.data = data;
        SectionImpl sectionImpl = new SectionImpl();
        this.section = sectionImpl;
        try {
            this.section.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.id = this.getId();
        this.description = this.getDescription();
        this.assessmentId = this.getAssessmentId();
        this.sectionType = this.getSectionType();
        this.sequence = this.getSequence();
        this.duration = this.getDuration();
        this.typeId = this.getTypeId();
        this.status = this.getStatus();
        this.createdBy = this.getCreatedBy();
        this.createdDate = this.getCreatedDate();
        this.lastModifiedBy = this.getLastModifiedBy();
        this.lastModifiedDate = this.getLastModifiedDate();
        this.itemSet = this.getItemSet();
        this.metaDataSet = this.getSectionMetaDataSet();
        this.metaDataMap = this.getSectionMetaDataMap(this.metaDataSet);
        this.sectionAttachmentSet = this.getSectionAttachmentSet();
    }

    Id getId() {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        SectionFacadeQueriesAPI sectionFacadeQueries = PersistenceService.getInstance().getSectionFacadeQueries();
        return sectionFacadeQueries.getId(this.data.getSectionId());
    }

    Type getSectionType() {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeById(this.data.getTypeId());
    }

    public SectionDataIfc getData() {
        return this.data;
    }

    public void updateData(SectionDataIfc data) {
        this.setData(data);
    }

    public void setData(SectionDataIfc data) {
        this.data = data;
    }

    public Long getSectionId() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getSectionId();
    }

    public void setSectionId(Long sectionId) {
        this.sectionId = sectionId;
        this.data.setSectionId(sectionId);
    }

    public Long getAssessmentId() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAssessmentId();
    }

    public void setAssessmentId(Long assessmentId) {
        this.assessmentId = assessmentId;
        this.data.setAssessmentId(assessmentId);
    }

    public AssessmentIfc getAssessment() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return new AssessmentFacade(this.data.getAssessment());
    }

    public void setAssessment(AssessmentIfc assessment) {
        this.assessment = (AssessmentFacade)assessment;
        AssessmentData d = (AssessmentData)((AssessmentFacade)this.assessment).getData();
        this.data.setAssessment((AssessmentIfc)d);
    }

    public Integer getDuration() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDuration();
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
        this.data.setDuration(duration);
    }

    public Integer getSequence() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getSequence();
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
        this.data.setSequence(sequence);
    }

    public String getTitle() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTitle();
    }

    public void setTitle(String title) {
        this.title = title;
        this.data.setTitle(title);
    }

    public String getDescription() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.description = description;
        this.data.setDescription(description);
    }

    public Long getTypeId() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTypeId();
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
        this.data.setTypeId(typeId);
    }

    public Integer getStatus() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getStatus();
    }

    public void setStatus(Integer status) {
        this.status = status;
        this.data.setStatus(status);
    }

    public String getCreatedBy() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getCreatedBy();
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        this.data.setCreatedBy(createdBy);
    }

    public Date getCreatedDate() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getCreatedDate();
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
        this.data.setCreatedDate(createdDate);
    }

    public String getLastModifiedBy() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedBy();
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        this.data.setLastModifiedBy(lastModifiedBy);
    }

    public Date getLastModifiedDate() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedDate();
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        this.data.setLastModifiedDate(lastModifiedDate);
    }

    public Set getItemFacadeSet() throws DataFacadeException {
        this.itemFacadeSet = new HashSet();
        try {
            this.data = (SectionDataIfc)this.section.getData();
            Set set = this.data.getItemSet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                ItemFacade itemFacade = new ItemFacade((ItemDataIfc)iter.next());
                this.itemFacadeSet.add(itemFacade);
            }
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.itemFacadeSet;
    }

    public Set getItemSet() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemSet();
    }

    public void setItemSet(Set itemSet) {
        this.itemSet = itemSet;
        this.data.setItemSet(itemSet);
    }

    public Set getSectionMetaDataSet() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getSectionMetaDataSet();
    }

    public void setSectionMetaDataSet(Set metaDataSet) {
        this.metaDataSet = metaDataSet;
        this.data.setSectionMetaDataSet(metaDataSet);
    }

    public HashMap getSectionMetaDataMap(Set metaDataSet) {
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        if (metaDataSet != null) {
            for (SectionMetaDataIfc sectionMetaData : metaDataSet) {
                metaDataMap.put(sectionMetaData.getLabel(), sectionMetaData.getEntry());
            }
        }
        return metaDataMap;
    }

    public void addItem(ItemFacade itemFacade) {
        this.addItem(itemFacade.getData());
    }

    public void addItem(ItemDataIfc itemDataIfc) {
        if (this.itemSet == null) {
            this.setItemSet(new HashSet());
        }
        this.data.getItemSet().add(itemDataIfc);
        this.itemSet = this.data.getItemSet();
    }

    public String getSectionMetaDataByLabel(String label) {
        return (String)this.metaDataMap.get(label);
    }

    public void addSectionMetaData(String label, String entry) {
        if (this.metaDataSet == null) {
            this.setSectionMetaDataSet(new HashSet());
            this.metaDataMap = new HashMap();
        }
        if (this.metaDataMap.get(label) != null) {
            for (SectionMetaDataIfc metadata : this.metaDataSet) {
                if (!metadata.getLabel().equals(label)) continue;
                metadata.setEntry(entry);
            }
        } else {
            this.metaDataMap.put(label, entry);
            this.data.getSectionMetaDataSet().add(new SectionMetaData(this.data, label, entry));
            this.metaDataSet = this.data.getSectionMetaDataSet();
        }
    }

    public TypeIfc getType() {
        return this.getSectionTypeFacade();
    }

    public TypeFacade getSectionTypeFacade() {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeFacadeById(this.data.getTypeId());
    }

    public ArrayList getItemArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.itemSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public ArrayList getItemArraySortedForGrading() {
        ArrayList list = this.getItemArray();
        Collections.sort(list);
        return list;
    }

    public ArrayList getItemArraySorted() {
        ArrayList list = this.getItemArray();
        Collections.sort(list);
        return list;
    }

    public ArrayList getItemArraySortedWithRandom(long seed) {
        ArrayList list = this.getItemArray();
        Collections.sort(list);
        return list;
    }

    public int compareTo(Object o) {
        SectionFacade a = (SectionFacade)o;
        return this.sequence.compareTo(a.sequence);
    }

    public Set getSectionAttachmentSet() throws DataFacadeException {
        try {
            this.data = (SectionDataIfc)this.section.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getSectionAttachmentSet();
    }

    public void setSectionAttachmentSet(Set sectionAttachmentSet) {
        this.sectionAttachmentSet = sectionAttachmentSet;
        this.data.setSectionAttachmentSet(sectionAttachmentSet);
    }

    public List getSectionAttachmentList() {
        ArrayList<SectionAttachmentIfc> list = new ArrayList<SectionAttachmentIfc>();
        if (this.sectionAttachmentSet != null) {
            for (SectionAttachmentIfc a : this.sectionAttachmentSet) {
                list.add(a);
            }
        }
        return list;
    }
}

