/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.integration.helper.ifc.AgentHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.AgentImpl;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentHelperImpl
implements AgentHelper {
    private Logger log = LoggerFactory.getLogger(AgentHelperImpl.class);
    AgentImpl agent;
    private AuthzGroupService authzGroupService = (AuthzGroupService)ComponentManager.get(AuthzGroupService.class);

    @Override
    public AgentImpl getAgent() {
        AgentImpl agent = new AgentImpl("Administrator", null, new IdImpl("admin"));
        return agent;
    }

    @Override
    public String getAgentString(String agentString) {
        String agentS = "";
        try {
            User user = UserDirectoryService.getCurrentUser();
            agentS = user == null || user.getId() == null || "".equals(user.getId()) ? this.getAnonymousId(agentString) : user.getId();
        }
        catch (Exception ex) {
            this.log.warn("getAgentString(): " + ex.getMessage());
        }
        return agentS;
    }

    @Override
    public String getEid(String agentString) {
        String eid = "";
        try {
            User user = UserDirectoryService.getCurrentUser();
            eid = user == null || user.getId() == null || "".equals(user.getId()) ? this.getAnonymousId(agentString) : user.getEid();
        }
        catch (Exception ex) {
            this.log.warn("getEid: " + ex.getMessage());
        }
        return eid;
    }

    @Override
    public String getEidById(String agentString) {
        this.log.debug("getEidById agentString = " + agentString);
        String s = "";
        try {
            if (!agentString.startsWith("anonymous_")) {
                s = UserDirectoryService.getUser((String)agentString).getEid();
            }
            this.log.debug("getEidById agentString s = " + s);
        }
        catch (Exception e) {
            this.log.warn("getEidById: " + e.getMessage());
        }
        return s;
    }

    @Override
    public String getDisplayName(String agentString) {
        String s = "";
        try {
            if (!agentString.startsWith("anonymous_")) {
                s = UserDirectoryService.getUser((String)agentString).getDisplayName();
            }
        }
        catch (Exception e) {
            this.log.warn("getDisplayName: " + e.getMessage());
        }
        return s;
    }

    @Override
    public String getFirstName(String agentString) {
        String s = "";
        try {
            if (!agentString.startsWith("anonymous_")) {
                s = UserDirectoryService.getUser((String)agentString).getFirstName();
            }
        }
        catch (Exception e) {
            this.log.warn("getFirstName:" + e.getMessage());
        }
        return s;
    }

    @Override
    public String getLastName(String agentString) {
        String s = "";
        try {
            if (!agentString.startsWith("anonymous_")) {
                s = UserDirectoryService.getUser((String)agentString).getLastName();
            }
        }
        catch (Exception e) {
            this.log.warn("getLastName: " + e.getMessage());
        }
        return s;
    }

    @Override
    public String getEmail(String agentString) {
        String s = "";
        try {
            if (!agentString.startsWith("anonymous_")) {
                s = UserDirectoryService.getUser((String)agentString).getEmail();
            }
        }
        catch (Exception e) {
            this.log.warn(e.getMessage());
        }
        return s;
    }

    @Override
    public String getRole(String agentString) {
        String role = "anonymous_access";
        String thisSiteId = null;
        try {
            thisSiteId = ToolManager.getCurrentPlacement().getContext();
        }
        catch (Exception ex) {
            this.log.warn("Failure to get site id from ToolManager.  \nNeed to fix if not running in unit test.");
            this.log.warn("getRole : " + ex.getMessage());
        }
        if (thisSiteId == null || thisSiteId.equals("")) {
            return role;
        }
        String realmName = "/site/" + thisSiteId;
        Role userRole = null;
        try {
            AuthzGroup siteAuthzGroup = this.authzGroupService.getAuthzGroup(realmName);
            if (siteAuthzGroup != null) {
                userRole = siteAuthzGroup.getUserRole(agentString);
            }
            if (userRole != null) {
                role = userRole.getId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return role;
    }

    @Override
    public String getRoleForCurrentAgent(String agentString) {
        return this.getRole(agentString);
    }

    @Override
    public String getCurrentSiteId(boolean accessViaUrl) {
        Placement thisPlacement;
        String currentSiteId = null;
        if (!accessViaUrl && (thisPlacement = ToolManager.getCurrentPlacement()) != null) {
            currentSiteId = thisPlacement.getContext();
        }
        return currentSiteId;
    }

    @Override
    public String createAnonymous(AgentFacade agent) {
        String anonymousId = "anonymous_";
        try {
            anonymousId = anonymousId + new Date().getTime();
            agent.setAgentInstanceString(anonymousId);
        }
        catch (Exception ex) {
            this.log.warn("createAnonymous : " + ex.getMessage());
        }
        return anonymousId;
    }

    @Override
    public String getCurrentSiteName(boolean accessViaUrl) {
        String currentSiteName = null;
        if (!accessViaUrl) {
            try {
                currentSiteName = SiteService.getSite((String)this.getCurrentSiteId(accessViaUrl)).getTitle();
            }
            catch (Exception e) {
                this.log.warn("getCurrentSiteName : " + e.getMessage());
            }
        }
        return currentSiteName;
    }

    @Override
    public String getSiteName(String siteId) {
        String siteName = null;
        try {
            siteName = SiteService.getSite((String)siteId).getTitle();
        }
        catch (Exception ex) {
            this.log.warn("getSiteName : " + ex.getMessage());
            this.log.warn("SiteService not available.  This needs to be fixed if you are not running a unit test.");
        }
        return siteName;
    }

    @Override
    public String getDisplayNameByAgentId(String agentId) {
        String name = null;
        try {
            name = UserDirectoryService.getUser((String)agentId).getDisplayName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    @Override
    public boolean isIntegratedEnvironment() {
        return true;
    }

    @Override
    public String getAnonymousId(String agentString) {
        String agentS = "";
        if (!"UNASSIGNED".equals(agentString)) {
            agentS = agentString;
        }
        return agentS;
    }

    @Override
    public Map getUserRolesFromContextRealm(Collection inUsers) {
        String thisSiteId = null;
        try {
            thisSiteId = ToolManager.getCurrentPlacement().getContext();
        }
        catch (Exception ex) {
            this.log.warn("Failure to get site id from ToolManager.  \nNeed to fix if not running in unit test.");
            this.log.warn("getUserRolesFromContextRealm : " + ex.getMessage());
        }
        if (thisSiteId == null) {
            return new HashMap();
        }
        String realmName = "/site/" + thisSiteId;
        return this.authzGroupService.getUsersRole(inUsers, realmName);
    }

    @Override
    public String getRoleForAgentAndSite(String agentString, String siteId) {
        String role = "anonymous_access";
        if (siteId == null) {
            return role;
        }
        String realmName = "/site/" + siteId;
        Role userRole = null;
        try {
            AuthzGroup siteAuthzGroup = this.authzGroupService.getAuthzGroup(realmName);
            if (siteAuthzGroup != null) {
                userRole = siteAuthzGroup.getUserRole(agentString);
            }
            if (userRole != null) {
                role = userRole.getId();
            }
            this.log.debug(realmName + ":" + role);
        }
        catch (GroupNotDefinedException e) {
            this.log.error("error in:" + this + "-getRoleForAgnetAndSite");
        }
        return role;
    }

    @Override
    public boolean isFileUploadAvailable() {
        String commentOutFileUpload = ServerConfigurationService.getString((String)"sam_file_upload_comment_out");
        if (commentOutFileUpload == null) {
            return true;
        }
        return !commentOutFileUpload.equalsIgnoreCase("true");
    }

    @Override
    public String getDisplayId(String agentString) {
        if ("UNASSIGNED".equals(agentString)) {
            return "";
        }
        try {
            if (!agentString.startsWith("anonymous_")) {
                return UserDirectoryService.getUser((String)agentString).getDisplayId();
            }
        }
        catch (Exception e) {
            this.log.warn("getDisplayId: " + e.getMessage());
        }
        return "";
    }
}

