/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.math3.util.Precision;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.cover.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradebookServiceHelperImpl
implements GradebookServiceHelper {
    private Logger log = LoggerFactory.getLogger(GradebookServiceHelperImpl.class);

    @Override
    public boolean gradebookExists(String gradebookUId, GradebookExternalAssessmentService g) {
        this.log.debug("GradebookService = " + g);
        if (gradebookUId == null) {
            return false;
        }
        return g.isGradebookDefined(gradebookUId);
    }

    @Override
    public boolean isGradebookExist(String siteId) {
        Site currentSite = this.getCurrentSite(siteId);
        if (currentSite == null) {
            return false;
        }
        SitePage page = null;
        String toolId = null;
        try {
            List pageList = currentSite.getPages();
            for (int i = 0; i < pageList.size(); ++i) {
                page = (SitePage)pageList.get(i);
                List pageToolList = page.getTools();
                try {
                    toolId = ((ToolConfiguration)pageToolList.get(0)).getTool().getId();
                }
                catch (Exception ee) {
                    this.log.warn(siteId + " contains a page (" + page.getTitle() + ") without a valid tool registration");
                }
                if (toolId != null && toolId.equalsIgnoreCase("sakai.gradebook.tool")) {
                    return true;
                }
                if (toolId != null && toolId.equalsIgnoreCase("sakai.gradebook.gwt.rpc")) {
                    return true;
                }
                if (toolId == null || !toolId.equalsIgnoreCase("sakai.gradebookng")) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.log.warn(e.getMessage());
        }
        return false;
    }

    private Site getCurrentSite(String id) {
        Site site = null;
        try {
            site = SiteService.getSite((String)id);
        }
        catch (IdUnusedException e) {
            this.log.error(e.getMessage());
            e.printStackTrace();
        }
        return site;
    }

    @Override
    public void removeExternalAssessment(String gradebookUId, String publishedAssessmentId, GradebookExternalAssessmentService g) throws Exception {
        if (g.isGradebookDefined(gradebookUId)) {
            g.removeExternalAssessment(gradebookUId, publishedAssessmentId);
        }
    }

    @Override
    public boolean isAssignmentDefined(String assessmentTitle, GradebookExternalAssessmentService g) throws Exception {
        String gradebookUId = GradebookFacade.getGradebookUId();
        return g.isAssignmentDefined(gradebookUId, assessmentTitle);
    }

    @Override
    public boolean addToGradebook(PublishedAssessmentData publishedAssessment, Long categoryId, GradebookExternalAssessmentService g) throws Exception {
        boolean added = false;
        String gradebookUId = GradebookFacade.getGradebookUId();
        if (gradebookUId == null) {
            return false;
        }
        if (g.isGradebookDefined(gradebookUId)) {
            Tool tool = ToolManager.getTool((String)"sakai.samigo");
            String appName = null;
            if (tool == null) {
                this.log.warn("could not get tool named sakai.samigo, so we're going to assume we're called 'Tests & Quizzes'");
                appName = "Tests & Quizzes";
            } else {
                appName = tool.getTitle();
            }
            String title = StringEscapeUtils.unescapeHtml((String)publishedAssessment.getTitle());
            if (!g.isAssignmentDefined(gradebookUId, title)) {
                g.addExternalAssessment(gradebookUId, publishedAssessment.getPublishedAssessmentId().toString(), null, title, Double.valueOf(publishedAssessment.getTotalScore()), publishedAssessment.getAssessmentAccessControl().getDueDate(), appName, Boolean.valueOf(false), categoryId);
                added = true;
            }
        }
        return added;
    }

    @Override
    public boolean updateGradebook(PublishedAssessmentIfc publishedAssessment, GradebookExternalAssessmentService g) throws Exception {
        this.log.debug("updateGradebook start");
        String gradebookUId = GradebookFacade.getGradebookUId();
        if (gradebookUId == null) {
            return false;
        }
        this.log.debug("before g.isAssignmentDefined()");
        g.updateExternalAssessment(gradebookUId, publishedAssessment.getPublishedAssessmentId().toString(), null, publishedAssessment.getTitle(), publishedAssessment.getTotalScore().doubleValue(), publishedAssessment.getAssessmentAccessControl().getDueDate());
        return true;
    }

    @Override
    public void updateExternalAssessmentScore(AssessmentGradingData ag, GradebookExternalAssessmentService g) throws Exception {
        boolean testErrorHandling = false;
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        GradingService gradingService = new GradingService();
        String gradebookUId = pubService.getPublishedAssessmentOwner(ag.getPublishedAssessmentId());
        if (gradebookUId == null) {
            return;
        }
        String points = null;
        if (ag.getFinalScore() != null) {
            double fScore = Precision.round((double)ag.getFinalScore(), (int)2);
            Double score = fScore;
            points = score.toString();
            this.log.info("rounded:  " + ag.getFinalScore() + " to: " + score.toString());
        }
        g.updateExternalAssessmentScore(gradebookUId, ag.getPublishedAssessmentId().toString(), ag.getAgentId(), points);
        if (testErrorHandling) {
            throw new Exception("Encountered an error in update ExternalAssessmentScore.");
        }
    }

    @Override
    public void updateExternalAssessmentScores(Long publishedAssessmentId, Map<String, Double> studentUidsToScores, GradebookExternalAssessmentService g) throws Exception {
        boolean testErrorHandling = false;
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        String gradebookUId = pubService.getPublishedAssessmentOwner(publishedAssessmentId);
        if (gradebookUId == null) {
            return;
        }
        g.updateExternalAssessmentScores(gradebookUId, publishedAssessmentId.toString(), studentUidsToScores);
        if (testErrorHandling) {
            throw new Exception("Encountered an error in update ExternalAssessmentScore.");
        }
    }

    @Override
    public void updateExternalAssessmentComment(Long publishedAssessmentId, String studentUid, String comment, GradebookExternalAssessmentService g) throws Exception {
        boolean testErrorHandling = false;
        PublishedAssessmentService pubService = new PublishedAssessmentService();
        String gradebookUId = pubService.getPublishedAssessmentOwner(publishedAssessmentId);
        if (gradebookUId == null) {
            return;
        }
        g.updateExternalAssessmentComment(gradebookUId, publishedAssessmentId.toString(), studentUid, comment);
        if (testErrorHandling) {
            throw new Exception("Encountered an error in update ExternalAssessmentComment.");
        }
    }

    @Override
    public Long getExternalAssessmentCategoryId(String gradebookUId, String publishedAssessmentId, GradebookExternalAssessmentService g) {
        Long categoryId = null;
        if (g.isGradebookDefined(gradebookUId)) {
            categoryId = g.getExternalAssessmentCategoryId(gradebookUId, publishedAssessmentId);
        }
        return categoryId;
    }
}

