/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexFormat;
import org.apache.commons.math3.exception.MathParseException;
import org.apache.commons.math3.util.Precision;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.service.gradebook.shared.AssessmentNotFoundException;
import org.sakaiproject.service.gradebook.shared.GradebookExternalAssessmentService;
import org.sakaiproject.spring.SpringBeanLocator;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingAttachment;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingAttachment;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.EvaluationModelIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.grading.StudentGradingSummaryIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.GradebookFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.integration.context.IntegrationContextFactory;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.services.EMIScore;
import org.sakaiproject.tool.assessment.services.FinFormatException;
import org.sakaiproject.tool.assessment.services.GradebookServiceException;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.util.SamigoExpressionError;
import org.sakaiproject.tool.assessment.util.SamigoExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradingService {
    public static final String ANSWER_TYPE_COMPLEX = "COMPLEX";
    public static final String ANSWER_TYPE_REAL = "REAL";
    final String OPEN_BRACKET = "\\{";
    final String CLOSE_BRACKET = "\\}";
    final String CALCULATION_OPEN = "[[";
    final String CALCULATION_CLOSE = "]]";
    final String FORMAT_MASK = "0E0";
    final Double MAX_THRESHOLD = 10000.0;
    final Double MIN_THRESHOLD = 1.0E-4;
    final String CALCQ_VAR_FORM_NAME = "[a-zA-Z][^\\{\\}]*?";
    final String CALCQ_VAR_FORM_NAME_EXPRESSION = "([a-zA-Z][^\\{\\}]*?)";
    final Pattern CALCQ_ANSWER_PATTERN = Pattern.compile("(?<!\\{)\\{([a-zA-Z][^\\{\\}]*?)\\}(?!\\})");
    final Pattern CALCQ_FORMULA_PATTERN = Pattern.compile("\\{\\{([a-zA-Z][^\\{\\}]*?)\\}\\}");
    final Pattern CALCQ_FORMULA_SPLIT_PATTERN = Pattern.compile("(\\{\\{[a-zA-Z][^\\{\\}]*?\\}\\})");
    final Pattern CALCQ_CALCULATION_PATTERN = Pattern.compile("\\[\\[([^\\[\\]]+?)\\]\\]?");
    private Logger log = LoggerFactory.getLogger(GradingService.class);

    public ArrayList getTotalScores(String publishedId, String which) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getTotalScores(publishedId, which));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public ArrayList getTotalScores(String publishedId, String which, boolean getSubmittedOnly) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getTotalScores(publishedId, which, getSubmittedOnly));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List getAllSubmissions(String publishedId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAllSubmissions(publishedId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List getAllAssessmentGradingData(Long publishedId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAllAssessmentGradingData(publishedId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public ArrayList getHighestAssessmentGradingList(Long publishedId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestAssessmentGradingList(publishedId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List getHighestSubmittedOrGradedAssessmentGradingList(Long publishedId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestSubmittedOrGradedAssessmentGradingList(publishedId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public ArrayList getLastAssessmentGradingList(Long publishedId) {
        ArrayList results = null;
        try {
            results = new ArrayList(PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastAssessmentGradingList(publishedId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List getLastSubmittedAssessmentGradingList(Long publishedId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSubmittedAssessmentGradingList(publishedId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List getLastSubmittedOrGradedAssessmentGradingList(Long publishedId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSubmittedOrGradedAssessmentGradingList(publishedId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public void saveTotalScores(ArrayList gdataList, PublishedAssessmentIfc pub) {
        try {
            AssessmentGradingData gdata = null;
            if (gdataList.size() <= 0) {
                return;
            }
            gdata = (AssessmentGradingData)gdataList.get(0);
            Integer scoringType = this.getScoringType(pub);
            ArrayList oldList = this.getAssessmentGradingsByScoringType(scoringType, gdata.getPublishedAssessmentId());
            for (int i = 0; i < gdataList.size(); ++i) {
                AssessmentGradingData ag = (AssessmentGradingData)gdataList.get(i);
                this.saveOrUpdateAssessmentGrading(ag);
                EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.total.score.update", (String)("siteId=" + AgentFacade.getCurrentSiteId() + ", gradedBy=" + AgentFacade.getAgentString() + ", assessmentGradingId=" + ag.getAssessmentGradingId() + ", totalAutoScore=" + ag.getTotalAutoScore() + ", totalOverrideScore=" + ag.getTotalOverrideScore() + ", FinalScore=" + ag.getFinalScore() + ", comments=" + ag.getComments()), (boolean)true));
            }
            ArrayList newList = this.getAssessmentGradingsByScoringType(scoringType, gdata.getPublishedAssessmentId());
            ArrayList l = this.getListForGradebookNotification(newList, oldList);
            this.notifyGradebook(l, pub);
        }
        catch (GradebookServiceException ge) {
            this.log.error("GradebookServiceException" + ge);
            throw ge;
        }
    }

    public void notifyDeleteToGradebook(ArrayList gdataList, PublishedAssessmentIfc pub, String studentId) {
        try {
            AssessmentGradingData gdata = null;
            if (gdataList.size() <= 0) {
                return;
            }
            gdata = (AssessmentGradingData)gdataList.get(0);
            Integer scoringType = this.getScoringType(pub);
            ArrayList fullList = this.getAssessmentGradingsByScoringType(scoringType, gdata.getPublishedAssessmentId());
            ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
            for (int i = 0; i < fullList.size(); ++i) {
                AssessmentGradingData ag = (AssessmentGradingData)fullList.get(i);
                if (!ag.getAgentId().equals(studentId)) continue;
                l.add(ag);
            }
            if (l.size() == 0) {
                l.add(gdata);
            }
            this.notifyGradebook(l, pub);
        }
        catch (GradebookServiceException ge) {
            this.log.error(ge.getMessage(), (Throwable)ge);
            throw ge;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private ArrayList getListForGradebookNotification(ArrayList newList, ArrayList oldList) {
        int i;
        ArrayList<AssessmentGradingData> l = new ArrayList<AssessmentGradingData>();
        HashMap<Long, AssessmentGradingData> h = new HashMap<Long, AssessmentGradingData>();
        for (i = 0; i < oldList.size(); ++i) {
            AssessmentGradingData ag = (AssessmentGradingData)oldList.get(i);
            h.put(ag.getAssessmentGradingId(), ag);
        }
        for (i = 0; i < newList.size(); ++i) {
            AssessmentGradingData a = (AssessmentGradingData)newList.get(i);
            Object o = h.get(a.getAssessmentGradingId());
            if (o == null) {
                l.add(a);
                continue;
            }
            AssessmentGradingData b = (AssessmentGradingData)o;
            if (a.getFinalScore() != null && b.getFinalScore() != null && !a.getFinalScore().equals(b.getFinalScore())) {
                l.add(a);
                continue;
            }
            if (a.getComments() == null) continue;
            if (b.getComments() != null) {
                if (a.getComments().equals(b.getComments())) continue;
                l.add(a);
                continue;
            }
            l.add(a);
        }
        return l;
    }

    public ArrayList getAssessmentGradingsByScoringType(Integer scoringType, Long publishedAssessmentId) {
        List l = null;
        l = scoringType.equals(EvaluationModelIfc.HIGHEST_SCORE) ? this.getHighestSubmittedOrGradedAssessmentGradingList(publishedAssessmentId) : (scoringType.equals(EvaluationModelIfc.LAST_SCORE) ? this.getLastSubmittedOrGradedAssessmentGradingList(publishedAssessmentId) : this.getTotalScores(publishedAssessmentId.toString(), "3", false));
        return new ArrayList(l);
    }

    public Integer getScoringType(PublishedAssessmentIfc pub) {
        Integer scoringType = null;
        EvaluationModelIfc e = pub.getEvaluationModel();
        if (e != null) {
            scoringType = e.getScoringType();
        }
        return scoringType;
    }

    private boolean updateGradebook(AssessmentGradingData data, PublishedAssessmentIfc pub) {
        boolean forGrade = Boolean.TRUE.equals(data.getForGrade());
        boolean toGradebook = false;
        EvaluationModelIfc e = pub.getEvaluationModel();
        if (e != null) {
            String toGradebookString = e.getToGradeBook();
            toGradebook = toGradebookString.equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString());
        }
        return forGrade && toGradebook;
    }

    private void notifyGradebook(ArrayList l, PublishedAssessmentIfc pub) {
        for (int i = 0; i < l.size(); ++i) {
            this.notifyGradebook((AssessmentGradingData)l.get(i), pub);
        }
    }

    public HashMap getItemScores(Long publishedId, Long itemId, String which) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemScores(publishedId, itemId, which);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    public HashMap getItemScores(Long publishedId, Long itemId, String which, boolean loadItemGradingAttachment) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemScores(publishedId, itemId, which, loadItemGradingAttachment);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    public HashMap getItemScores(Long itemId, List scores, boolean loadItemGradingAttachment) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemScores(itemId, scores, loadItemGradingAttachment);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    public HashMap getLastItemGradingData(String publishedId, String agentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastItemGradingData(Long.valueOf(publishedId), agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    public HashMap getStudentGradingData(String assessmentGradingId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getStudentGradingData(assessmentGradingId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    public HashMap getSubmitData(String publishedId, String agentId, Integer scoringoption, String assessmentGradingId) {
        try {
            Long gradingId = null;
            if (assessmentGradingId != null) {
                gradingId = Long.valueOf(assessmentGradingId);
            }
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSubmitData(Long.valueOf(publishedId), agentId, scoringoption, gradingId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new HashMap();
        }
    }

    public String getTextForId(Long typeId) {
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        TypeFacade type = typeFacadeQueries.getTypeFacadeById(typeId);
        return type.getKeyword();
    }

    public int getSubmissionSizeOfPublishedAssessment(String publishedAssessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSubmissionSizeOfPublishedAssessment(Long.valueOf(publishedAssessmentId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public Long saveMedia(byte[] media, String mimeType) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveMedia(media, mimeType);
    }

    public Long saveMedia(MediaData mediaData) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveMedia(mediaData);
    }

    public MediaData getMedia(String mediaId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMedia(Long.valueOf(mediaId));
    }

    public ArrayList getMediaArray(String itemGradingId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaArray(Long.valueOf(itemGradingId));
    }

    public ArrayList getMediaArray2(String itemGradingId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaArray2(Long.valueOf(itemGradingId));
    }

    public ArrayList getMediaArray(ItemGradingData i) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaArray(i);
    }

    public HashMap getMediaItemGradingHash(Long assessmentGradingId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaItemGradingHash(assessmentGradingId);
    }

    public List<MediaData> getMediaArray(String publishedId, String publishItemId, String which) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getMediaArray(Long.valueOf(publishedId), Long.valueOf(publishItemId), which);
    }

    public ItemGradingData getLastItemGradingDataByAgent(String publishedItemId, String agentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastItemGradingDataByAgent(Long.valueOf(publishedItemId), agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ItemGradingData getItemGradingData(String assessmentGradingId, String publishedItemId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemGradingData(Long.valueOf(assessmentGradingId), Long.valueOf(publishedItemId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AssessmentGradingData load(String assessmentGradingId) {
        return this.load(assessmentGradingId, true);
    }

    public AssessmentGradingData load(String assessmentGradingId, boolean loadGradingAttachment) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().load(Long.valueOf(assessmentGradingId), loadGradingAttachment);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ItemGradingData getItemGrading(String itemGradingId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemGrading(Long.valueOf(itemGradingId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new Error(e);
        }
    }

    public AssessmentGradingData getLastAssessmentGradingByAgentId(String publishedAssessmentId, String agentIdString) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastAssessmentGradingByAgentId(Long.valueOf(publishedAssessmentId), agentIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentGradingData getLastSavedAssessmentGradingByAgentId(String publishedAssessmentId, String agentIdString) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSavedAssessmentGradingByAgentId(Long.valueOf(publishedAssessmentId), agentIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentGradingData getLastSubmittedAssessmentGradingByAgentId(String publishedAssessmentId, String agentIdString, String assessmentGradingId) {
        AssessmentGradingData assessmentGranding = null;
        try {
            assessmentGranding = assessmentGradingId != null ? PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSubmittedAssessmentGradingByAgentId(Long.valueOf(publishedAssessmentId), agentIdString, Long.valueOf(assessmentGradingId)) : PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastSubmittedAssessmentGradingByAgentId(Long.valueOf(publishedAssessmentId), agentIdString, null);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return assessmentGranding;
    }

    public void saveItemGrading(ItemGradingData item) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveItemGrading(item);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveOrUpdateAssessmentGrading(AssessmentGradingData assessment) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveOrUpdateAssessmentGrading(assessment);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateAssessmentGradingOnly(AssessmentGradingData assessment) {
        Set origItemGradingSet = assessment.getItemGradingSet();
        HashSet h = new HashSet(origItemGradingSet);
        origItemGradingSet.clear();
        int size = assessment.getItemGradingSet().size();
        this.log.debug("before persist to db: size = " + size);
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveOrUpdateAssessmentGrading(assessment);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            assessment.setItemGradingSet(h);
            size = assessment.getItemGradingSet().size();
            this.log.debug("after persist to db: size = {}", (Object)size);
        }
    }

    public List getAssessmentGradingIds(String publishedItemId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAssessmentGradingIds(Long.valueOf(publishedItemId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentGradingData getHighestAssessmentGrading(String publishedAssessmentId, String agentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestAssessmentGrading(Long.valueOf(publishedAssessmentId), agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AssessmentGradingData getHighestSubmittedAssessmentGrading(String publishedAssessmentId, String agentId, String assessmentGradingId) {
        AssessmentGradingData assessmentGrading = null;
        try {
            assessmentGrading = assessmentGradingId != null ? PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestSubmittedAssessmentGrading(Long.valueOf(publishedAssessmentId), agentId, Long.valueOf(assessmentGradingId)) : PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHighestSubmittedAssessmentGrading(Long.valueOf(publishedAssessmentId), agentId, null);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return assessmentGrading;
    }

    public AssessmentGradingData getHighestSubmittedAssessmentGrading(String publishedAssessmentId, String agentId) {
        return this.getHighestSubmittedAssessmentGrading(publishedAssessmentId, agentId, null);
    }

    public Set getItemGradingSet(String assessmentGradingId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemGradingSet(Long.valueOf(assessmentGradingId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public HashMap getAssessmentGradingByItemGradingId(String publishedAssessmentId) {
        try {
            return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAssessmentGradingByItemGradingId(Long.valueOf(publishedAssessmentId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void updateItemScore(ItemGradingData gdata, double scoreDifference, PublishedAssessmentIfc pub) {
        try {
            AssessmentGradingData adata = this.load(gdata.getAssessmentGradingId().toString());
            adata.setItemGradingSet(this.getItemGradingSet(adata.getAssessmentGradingId().toString()));
            Set itemGradingSet = adata.getItemGradingSet();
            Iterator iter = itemGradingSet.iterator();
            double totalAutoScore = 0.0;
            double totalOverrideScore = adata.getTotalOverrideScore();
            while (iter.hasNext()) {
                ItemGradingData i = (ItemGradingData)iter.next();
                if (i.getItemGradingId().equals(gdata.getItemGradingId())) {
                    i.setAutoScore(gdata.getAutoScore());
                    i.setComments(gdata.getComments());
                    i.setGradedBy(AgentFacade.getAgentString());
                    i.setGradedDate(new Date());
                }
                if (i.getAutoScore() == null) continue;
                totalAutoScore += i.getAutoScore().doubleValue();
            }
            adata.setTotalAutoScore(Double.valueOf(totalAutoScore));
            if (Double.compare(totalAutoScore + totalOverrideScore, Double.valueOf("0")) < 0) {
                adata.setFinalScore(Double.valueOf("0"));
            } else {
                adata.setFinalScore(Double.valueOf(totalAutoScore + totalOverrideScore));
            }
            this.saveOrUpdateAssessmentGrading(adata);
            if (scoreDifference != 0.0) {
                this.notifyGradebookByScoringType(adata, pub);
            }
        }
        catch (GradebookServiceException ge) {
            this.log.error(ge.getMessage(), (Throwable)ge);
            throw ge;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void storeGrades(AssessmentGradingData data, PublishedAssessmentIfc pub, HashMap publishedItemHash, HashMap publishedItemTextHash, HashMap publishedAnswerHash, HashMap invalidFINMap, ArrayList invalidSALengthList) throws GradebookServiceException, FinFormatException {
        this.log.debug("storeGrades: data.getSubmittedDate()" + data.getSubmittedDate());
        this.storeGrades(data, false, pub, publishedItemHash, publishedItemTextHash, publishedAnswerHash, true, invalidFINMap, invalidSALengthList);
    }

    public void storeGrades(AssessmentGradingData data, PublishedAssessmentIfc pub, HashMap publishedItemHash, HashMap publishedItemTextHash, HashMap publishedAnswerHash, boolean persistToDB, HashMap invalidFINMap, ArrayList invalidSALengthList) throws GradebookServiceException, FinFormatException {
        this.log.debug("storeGrades (not persistToDB) : data.getSubmittedDate()" + data.getSubmittedDate());
        this.storeGrades(data, false, pub, publishedItemHash, publishedItemTextHash, publishedAnswerHash, persistToDB, invalidFINMap, invalidSALengthList);
    }

    public void storeGrades(AssessmentGradingData data, boolean regrade, PublishedAssessmentIfc pub, HashMap publishedItemHash, HashMap publishedItemTextHash, HashMap publishedAnswerHash, boolean persistToDB) throws GradebookServiceException, FinFormatException {
        this.log.debug("storeGrades (not persistToDB) : data.getSubmittedDate()" + data.getSubmittedDate());
        this.storeGrades(data, regrade, pub, publishedItemHash, publishedItemTextHash, publishedAnswerHash, persistToDB, null, null);
    }

    public void storeGrades(AssessmentGradingData data, boolean regrade, PublishedAssessmentIfc pub, HashMap publishedItemHash, HashMap publishedItemTextHash, HashMap publishedAnswerHash, boolean persistToDB, HashMap invalidFINMap, ArrayList invalidSALengthList) throws GradebookServiceException, FinFormatException {
        this.log.debug("****x1. regrade =" + regrade + " " + new Date().getTime());
        try {
            boolean imageMapAllOk = true;
            boolean NeededAllOk = false;
            String agent = data.getAgentId();
            HashSet<ItemGradingData> itemGradingSet = data.getItemGradingSet();
            if (itemGradingSet == null) {
                itemGradingSet = new HashSet<ItemGradingData>();
            }
            this.log.debug("****itemGrading size=" + itemGradingSet.size());
            ArrayList tempItemGradinglist = new ArrayList(itemGradingSet);
            if (this.isCalcQuestion(tempItemGradinglist, publishedItemHash)) {
                Collections.sort(tempItemGradinglist, new Comparator<ItemGradingData>(){

                    @Override
                    public int compare(ItemGradingData o1, ItemGradingData o2) {
                        ItemGradingData gradeData1 = o1;
                        ItemGradingData gradeData2 = o2;
                        if (gradeData1 == null) {
                            return -1;
                        }
                        if (gradeData2 == null) {
                            return 1;
                        }
                        if (gradeData1.getPublishedAnswerId() == null) {
                            return -1;
                        }
                        if (gradeData2.getPublishedAnswerId() == null) {
                            return 1;
                        }
                        return gradeData1.getPublishedAnswerId().compareTo(gradeData2.getPublishedAnswerId());
                    }
                });
            }
            Iterator iter = tempItemGradinglist.iterator();
            HashMap fibEmiAnswersMap = new HashMap();
            HashMap<Long, Map<Long, Set<EMIScore>>> emiScoresMap = new HashMap<Long, Map<Long, Set<EMIScore>>>();
            HashMap<Long, Double> totalItems = new HashMap<Long, Double>();
            this.log.debug("****x2. {}", (Object)new Date().getTime());
            double autoScore = 0.0;
            Long itemId = 0L;
            int calcQuestionAnswerSequence = 1;
            while (iter.hasNext()) {
                Long itemType;
                ItemDataIfc item;
                ItemGradingData itemGrading;
                block44: {
                    String processedAnswerText;
                    itemGrading = (ItemGradingData)iter.next();
                    calcQuestionAnswerSequence = itemGrading.getPublishedItemId().equals(itemId) ? ++calcQuestionAnswerSequence : 1;
                    itemId = itemGrading.getPublishedItemId();
                    item = (ItemDataIfc)publishedItemHash.get(itemId);
                    if (item == null) {
                        this.log.error("unable to retrive itemDataIfc for: {}", publishedItemHash.get(itemId));
                        continue;
                    }
                    for (ItemMetaDataIfc meta : item.getItemMetaDataSet()) {
                        if (!meta.getLabel().equals("REQUIRE_ALL_OK")) continue;
                        if (meta.getEntry().equals("true")) {
                            NeededAllOk = true;
                            break;
                        }
                        if (!meta.getEntry().equals("false")) continue;
                        NeededAllOk = false;
                        break;
                    }
                    itemType = item.getTypeId();
                    autoScore = 0.0;
                    itemGrading.setAssessmentGradingId(data.getAssessmentGradingId());
                    itemGrading.setAgentId(agent);
                    itemGrading.setOverrideScore(Double.valueOf(0.0));
                    if (itemType == 5L && itemGrading.getAnswerText() != null && (processedAnswerText = itemGrading.getAnswerText().replaceAll("\r", "").replaceAll("\n", "")).length() > 32000 && invalidSALengthList != null) {
                        invalidSALengthList.add(item.getItemId());
                    }
                    try {
                        autoScore = this.getScoreByQuestionType(itemGrading, item, itemType, publishedItemTextHash, totalItems, fibEmiAnswersMap, emiScoresMap, publishedAnswerHash, regrade, calcQuestionAnswerSequence);
                    }
                    catch (FinFormatException e) {
                        ArrayList list;
                        autoScore = 0.0;
                        if (invalidFINMap == null) break block44;
                        if (invalidFINMap.containsKey(itemId)) {
                            list = (ArrayList)invalidFINMap.get(itemId);
                            list.add(itemGrading.getItemGradingId());
                        }
                        list = new ArrayList();
                        list.add(itemGrading.getItemGradingId());
                        invalidFINMap.put(itemId, list);
                    }
                }
                if (TypeIfc.IMAGEMAP_QUESTION.equals(itemType) && NeededAllOk && (autoScore == -1.23456789E8 || !imageMapAllOk)) {
                    autoScore = 0.0;
                    imageMapAllOk = false;
                }
                this.log.debug("**!regrade, autoScore=" + autoScore);
                if (!TypeIfc.MULTIPLE_CORRECT.equals(itemType) && !TypeIfc.EXTENDED_MATCHING_ITEMS.equals(itemType)) {
                    totalItems.put(itemId, autoScore);
                }
                if (regrade && TypeIfc.AUDIO_RECORDING.equals(itemType)) {
                    itemGrading.setAttemptsRemaining(item.getTriesAllowed());
                }
                itemGrading.setAutoScore(Double.valueOf(autoScore));
            }
            if (invalidFINMap != null && invalidFINMap.size() > 0 || invalidSALengthList != null && invalidSALengthList.size() > 0) {
                return;
            }
            if (!regrade && persistToDB) {
                data.setSubmittedDate(new Date());
                this.setIsLate(data, pub);
            }
            this.log.debug("****x3. {}", (Object)new Date().getTime());
            ArrayList<ItemGradingData> emiItemGradings = new ArrayList<ItemGradingData>();
            iter = itemGradingSet.iterator();
            HashMap<Long, Double[]> mcmcAllOrNothingCheck = new HashMap<Long, Double[]>();
            HashMap<Long, Double[]> minScoreCheck = new HashMap<Long, Double[]>();
            double totalAutoScoreCheck = 0.0;
            HashMap<Long, Integer> countMcmcAllItemGradings = new HashMap<Long, Integer>();
            Long itemType2 = -1L;
            String mcmsPartialCredit = "";
            double itemScore = -1.0;
            while (iter.hasNext()) {
                Double accumulatedScore;
                ItemGradingData itemGrading = (ItemGradingData)iter.next();
                itemId = itemGrading.getPublishedItemId();
                ItemDataIfc item = (ItemDataIfc)publishedItemHash.get(itemId);
                if (item == null) {
                    this.log.error("unable to retrive itemDataIfc for: " + publishedItemHash.get(itemId));
                    continue;
                }
                itemType2 = item.getTypeId();
                mcmsPartialCredit = item.getItemMetaDataByLabel("MCMS_PARTIAL_CREDIT");
                itemScore = item.getScore();
                if (TypeIfc.EXTENDED_MATCHING_ITEMS.equals(itemType2)) {
                    emiItemGradings.add(itemGrading);
                    continue;
                }
                double eachItemScore = (Double)totalItems.get(itemId);
                if (eachItemScore < 0.0 && !TypeIfc.MULTIPLE_CHOICE.equals(itemType2) && !TypeIfc.TRUE_FALSE.equals(itemType2) && !TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION.equals(itemType2)) {
                    itemGrading.setAutoScore(Double.valueOf(0.0));
                }
                if (TypeIfc.MULTIPLE_CORRECT.equals(itemType2) && "false".equals(mcmsPartialCredit)) {
                    accumulatedScore = itemGrading.getAutoScore();
                    if (mcmcAllOrNothingCheck.containsKey(itemId)) {
                        Double[] accumulatedScoreArr = (Double[])mcmcAllOrNothingCheck.get(itemId);
                        accumulatedScore = accumulatedScore + accumulatedScoreArr[0];
                    }
                    mcmcAllOrNothingCheck.put(itemId, new Double[]{accumulatedScore, item.getScore()});
                    int count = 0;
                    if (countMcmcAllItemGradings.containsKey(itemId)) {
                        count = (Integer)countMcmcAllItemGradings.get(itemId);
                    }
                    countMcmcAllItemGradings.put(itemId, new Integer(++count));
                }
                if (item.getMinScore() == null) continue;
                accumulatedScore = new Double(itemGrading.getAutoScore());
                Double itemParts = 1.0;
                if (minScoreCheck.containsKey(itemId)) {
                    Double[] accumulatedScoreArr = (Double[])minScoreCheck.get(itemId);
                    accumulatedScore = accumulatedScore + accumulatedScoreArr[0];
                    itemParts = itemParts + accumulatedScoreArr[2];
                }
                minScoreCheck.put(itemId, new Double[]{accumulatedScore, item.getMinScore(), itemParts});
            }
            this.log.debug("****x3.1 {}", (Object)new Date().getTime());
            if (emiItemGradings != null && !emiItemGradings.isEmpty()) {
                Iterator emiOrderedScoresMap = this.reorderEMIScoreMap(emiScoresMap);
                for (ItemGradingData itemGrading : emiItemGradings) {
                    if (itemGrading == null) {
                        this.log.warn("Map contains null itemgrading!");
                        continue;
                    }
                    Map innerMap = (Map)emiOrderedScoresMap.get(itemGrading.getPublishedItemId());
                    if (innerMap == null) {
                        this.log.warn("Inner map is empty!");
                        continue;
                    }
                    Map scoreMap = (Map)innerMap.get(itemGrading.getPublishedItemTextId());
                    if (scoreMap == null) {
                        this.log.warn("Score map is empty!");
                        continue;
                    }
                    EMIScore score = (EMIScore)scoreMap.get(itemGrading.getPublishedAnswerId());
                    if (score == null) {
                        this.log.warn("we can't find a score for answer: {}", (Object)itemGrading.getPublishedAnswerId());
                        continue;
                    }
                    itemGrading.setAutoScore(Double.valueOf(((EMIScore)((Map)((Map)emiOrderedScoresMap.get((Object)itemGrading.getPublishedItemId())).get((Object)itemGrading.getPublishedItemTextId())).get((Object)itemGrading.getPublishedAnswerId())).effectiveScore));
                }
                totalAutoScoreCheck = 0.0;
            }
            for (Map.Entry entry : mcmcAllOrNothingCheck.entrySet()) {
                if (Double.compare(((Double[])entry.getValue())[0], ((Double[])entry.getValue())[1]) == 0) continue;
                for (ItemGradingData itemGrading : itemGradingSet) {
                    Long itemId2 = (Long)entry.getKey();
                    if (!itemGrading.getPublishedItemId().equals(itemId2)) continue;
                    AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(itemGrading.getPublishedAnswerId());
                    if (answer == null) {
                        itemGrading.setAutoScore(Double.valueOf(0.0));
                        this.log.error("unable to retrieve answerIfc for: " + itemId2);
                        continue;
                    }
                    if (!countMcmcAllItemGradings.containsKey(itemId2)) {
                        itemGrading.setAutoScore(Double.valueOf(0.0));
                        this.log.error("unable to retrieve itemGrading's counter for: " + itemId2);
                        continue;
                    }
                    double discount = Math.abs(answer.getDiscount()) * -1.0;
                    int count = (Integer)countMcmcAllItemGradings.get(itemId2);
                    double itemGrDisc = discount / (double)count;
                    itemGrading.setAutoScore(Double.valueOf(itemGrDisc));
                }
            }
            for (Map.Entry entry : minScoreCheck.entrySet()) {
                if (!(((Double[])entry.getValue())[0] < ((Double[])entry.getValue())[1])) continue;
                for (ItemGradingData itemGrading : itemGradingSet) {
                    if (!itemGrading.getPublishedItemId().equals(entry.getKey())) continue;
                    itemGrading.setAutoScore(new Double(((Double[])entry.getValue())[1] / ((Double[])entry.getValue())[2]));
                }
            }
            this.log.debug("****x4. " + new Date().getTime());
            if (persistToDB) {
                this.saveOrUpdateAll(itemGradingSet);
            }
            this.log.debug("****x5. " + new Date().getTime());
            Set fullItemGradingSet = this.getItemGradingSet(data.getAssessmentGradingId().toString());
            double totalAutoScore = this.getTotalAutoScore(fullItemGradingSet);
            data.setTotalAutoScore(Double.valueOf(totalAutoScore));
            if (Double.compare(totalAutoScore + data.getTotalOverrideScore(), new Double("0")) < 0) {
                data.setFinalScore(Double.valueOf("0"));
            } else {
                data.setFinalScore(Double.valueOf(totalAutoScore + data.getTotalOverrideScore()));
            }
            this.log.debug("****x6. " + new Date().getTime());
        }
        catch (GradebookServiceException ge) {
            this.log.error(ge.getMessage(), (Throwable)ge);
            throw ge;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (persistToDB) {
            data.setItemGradingSet(new HashSet());
            this.saveOrUpdateAssessmentGrading(data);
            this.log.debug("****x7. {}", (Object)new Date().getTime());
            if (!regrade) {
                this.notifyGradebookByScoringType(data, pub);
            }
        }
        this.log.debug("****x8. {}", (Object)new Date().getTime());
        if (!regrade && Boolean.TRUE.equals(data.getForGrade())) {
            this.removeUnsubmittedAssessmentGradingData(data);
        }
    }

    private double getTotalAutoScore(Set itemGradingSet) {
        double totalAutoScore = 0.0;
        for (ItemGradingData i : itemGradingSet) {
            if (i.getAutoScore() == null) continue;
            totalAutoScore += i.getAutoScore().doubleValue();
        }
        return totalAutoScore;
    }

    private void notifyGradebookByScoringType(AssessmentGradingData data, PublishedAssessmentIfc pub) {
        Integer scoringType = pub.getEvaluationModel().getScoringType();
        if (this.updateGradebook(data, pub)) {
            AssessmentGradingData d = data;
            if (scoringType.equals(EvaluationModelIfc.HIGHEST_SCORE)) {
                d = this.getHighestSubmittedAssessmentGrading(pub.getPublishedAssessmentId().toString(), data.getAgentId());
            }
            this.notifyGradebook(d, pub);
        }
    }

    private double getScoreByQuestionType(ItemGradingData itemGrading, ItemDataIfc item, Long itemType, Map publishedItemTextHash, Map totalItems, Map fibAnswersMap, Map<Long, Map<Long, Set<EMIScore>>> emiScoresMap, HashMap publishedAnswerHash, boolean regrade, int calcQuestionAnswerSequence) throws FinFormatException {
        double initScore = 0.0;
        double autoScore = 0.0;
        double accumelateScore = 0.0;
        Long itemId = item.getItemId();
        int type = itemType.intValue();
        switch (type) {
            case 1: {
                autoScore = item.getPartialCreditFlag() != false ? this.getAnswerScoreMCQ(itemGrading, publishedAnswerHash) : this.getAnswerScore(itemGrading, publishedAnswerHash);
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().doubleValue();
                }
                totalItems.put(itemId, new Double(autoScore));
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                autoScore = this.getAnswerScore(itemGrading, publishedAnswerHash);
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().doubleValue();
                }
                totalItems.put(itemId, autoScore);
                break;
            }
            case 2: {
                ItemTextIfc itemText = (ItemTextIfc)publishedItemTextHash.get(itemGrading.getPublishedItemTextId());
                List answerArray = itemText.getAnswerArray();
                int correctAnswers = 0;
                if (answerArray != null) {
                    for (int i = 0; i < answerArray.size(); ++i) {
                        AnswerIfc a = (AnswerIfc)answerArray.get(i);
                        if (!a.getIsCorrect().booleanValue()) continue;
                        ++correctAnswers;
                    }
                }
                autoScore = (initScore = this.getAnswerScore(itemGrading, publishedAnswerHash)) > 0.0 ? initScore / (double)correctAnswers : this.getTotalCorrectScore(itemGrading, publishedAnswerHash) / (double)correctAnswers * -1.0;
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().doubleValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, autoScore);
                    break;
                }
                accumelateScore = (Double)totalItems.get(itemId);
                totalItems.put(itemId, accumelateScore += autoScore);
                break;
            }
            case 9: {
                initScore = this.getAnswerScore(itemGrading, publishedAnswerHash);
                if (initScore > 0.0) {
                    int nonDistractors = 0;
                    for (ItemTextIfc curItem : item.getItemTextArraySorted()) {
                        if (this.isDistractor(curItem)) continue;
                        ++nonDistractors;
                    }
                    autoScore = initScore / (double)nonDistractors;
                }
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().doubleValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, autoScore);
                    break;
                }
                accumelateScore = (Double)totalItems.get(itemId);
                totalItems.put(itemId, accumelateScore += autoScore);
                break;
            }
            case 8: {
                autoScore = this.getFIBScore(itemGrading, fibAnswersMap, item, publishedAnswerHash) / (double)((ItemTextIfc)item.getItemTextSet().toArray()[0]).getAnswerSet().size();
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().doubleValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, autoScore);
                    break;
                }
                accumelateScore = (Double)totalItems.get(itemId);
                totalItems.put(itemId, accumelateScore += autoScore);
                break;
            }
            case 11: 
            case 15: {
                if (type == 15) {
                    Map<Integer, String> calculatedAnswersMap = this.getCalculatedAnswersMap(itemGrading, item);
                    int numAnswers = calculatedAnswersMap.size();
                    autoScore = this.getCalcQScore(itemGrading, item, calculatedAnswersMap, calcQuestionAnswerSequence) / (double)numAnswers;
                } else {
                    autoScore = this.getFINScore(itemGrading, item, publishedAnswerHash) / (double)((ItemTextIfc)item.getItemTextSet().toArray()[0]).getAnswerSet().size();
                }
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().doubleValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, autoScore);
                    break;
                }
                accumelateScore = (Double)totalItems.get(itemId);
                totalItems.put(itemId, accumelateScore += autoScore);
                break;
            }
            case 14: {
                autoScore = this.getEMIScore(itemGrading, itemId, totalItems, emiScoresMap, publishedItemTextHash, publishedAnswerHash);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (regrade && itemGrading.getAutoScore() != null) {
                    autoScore = itemGrading.getAutoScore();
                }
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().doubleValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, autoScore);
                    break;
                }
                accumelateScore = (Double)totalItems.get(itemId);
                totalItems.put(itemId, accumelateScore += autoScore);
                break;
            }
            case 16: {
                initScore = this.getImageMapScore(itemGrading, item, (HashMap)publishedItemTextHash, publishedAnswerHash);
                boolean NeededAllOk = false;
                for (ItemMetaDataIfc meta : item.getItemMetaDataSet()) {
                    if (!meta.getLabel().equals("REQUIRE_ALL_OK") || !meta.getEntry().equals("true")) continue;
                    NeededAllOk = true;
                    break;
                }
                if (NeededAllOk && initScore <= 0.0) {
                    autoScore = -1.23456789E8;
                    break;
                }
                autoScore += initScore;
                if (itemGrading.getOverrideScore() != null) {
                    autoScore += itemGrading.getOverrideScore().doubleValue();
                }
                if (!totalItems.containsKey(itemId)) {
                    totalItems.put(itemId, autoScore);
                    break;
                }
                accumelateScore = (Double)totalItems.get(itemId);
                totalItems.put(itemId, accumelateScore += autoScore);
            }
        }
        return autoScore;
    }

    public double getAnswerScore(ItemGradingData data, Map publishedAnswerHash) {
        AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answer == null || answer.getScore() == null) {
            return 0.0;
        }
        ItemDataIfc item = answer.getItem();
        Long itemType = item.getTypeId();
        if (answer.getIsCorrect() == null || !answer.getIsCorrect().booleanValue()) {
            if (TypeIfc.EXTENDED_MATCHING_ITEMS.equals(itemType) || TypeIfc.MULTIPLE_CHOICE.equals(itemType) || TypeIfc.TRUE_FALSE.equals(itemType) || TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION.equals(itemType)) {
                return Math.abs(answer.getDiscount()) * -1.0;
            }
            return 0.0;
        }
        return answer.getScore();
    }

    public void notifyGradebook(AssessmentGradingData data, PublishedAssessmentIfc pub) throws GradebookServiceException {
        PublishedAssessmentService publishedAssessmentService;
        String currentSiteId;
        GradebookServiceHelper gbsHelper;
        String toGradebook = pub.getEvaluationModel().getToGradeBook();
        GradebookExternalAssessmentService g = null;
        boolean integrated = IntegrationContextFactory.getInstance().isIntegrated();
        if (integrated) {
            g = (GradebookExternalAssessmentService)SpringBeanLocator.getInstance().getBean("org.sakaiproject.service.gradebook.GradebookExternalAssessmentService");
        }
        if ((gbsHelper = IntegrationContextFactory.getInstance().getGradebookServiceHelper()).gradebookExists(GradebookFacade.getGradebookUId(currentSiteId = (publishedAssessmentService = new PublishedAssessmentService()).getPublishedAssessmentSiteId(pub.getPublishedAssessmentId().toString())), g) && toGradebook.equals(EvaluationModelIfc.TO_DEFAULT_GRADEBOOK.toString())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attempting to update a score in the gradebook");
            }
            Double originalFinalScore = data.getFinalScore();
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    Integer scoringType = pub.getEvaluationModel().getScoringType();
                    if (scoringType.equals(EvaluationModelIfc.AVERAGE_SCORE)) {
                        if (data.getStatus() == 5) {
                            data.setFinalScore(data.getFinalScore());
                        } else {
                            Double averageScore = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAverageSubmittedAssessmentGrading((long)pub.getPublishedAssessmentId(), data.getAgentId());
                            data.setFinalScore(averageScore);
                        }
                    }
                    gbsHelper.updateExternalAssessmentScore(data, g);
                    retryCount = 0;
                }
                catch (AssessmentNotFoundException ante) {
                    this.log.warn("problem sending grades to gradebook: {}", (Object)ante.getMessage());
                    if (AssessmentIfc.RETRACT_FOR_EDIT_STATUS.equals(pub.getStatus())) {
                        retryCount = this.retry(retryCount, (Exception)((Object)ante), pub, true);
                        continue;
                    }
                    retryCount = this.retry(retryCount, (Exception)((Object)ante), pub, false);
                }
                catch (Exception e) {
                    retryCount = this.retry(retryCount, e, pub, false);
                }
            }
            if (originalFinalScore != null && data.getFinalScore() != null && !Precision.equalsIncludingNaN((double)data.getFinalScore(), (double)originalFinalScore, (double)1.0E-4)) {
                data.setFinalScore(originalFinalScore);
            }
            try {
                Long publishedAssessmentId = data.getPublishedAssessmentId();
                String agent = data.getAgentId();
                String comment = data.getComments();
                gbsHelper.updateExternalAssessmentComment(publishedAssessmentId, agent, comment, g);
            }
            catch (Exception ex) {
                this.log.warn("Error sending comments to gradebook: {}", (Object)ex.getMessage());
            }
        } else {
            this.log.debug("Not updating the gradebook.  toGradebook = {}", (Object)toGradebook);
        }
    }

    private int retry(int retryCount, Exception e, PublishedAssessmentIfc pub, boolean retractForEditStatus) {
        this.log.warn("retrying...sending grades to gradebook. ");
        this.log.warn("retry....");
        --retryCount;
        try {
            int deadlockInterval = PersistenceService.getInstance().getPersistenceHelper().getDeadlockInterval();
            Thread.sleep(deadlockInterval);
        }
        catch (InterruptedException ex) {
            this.log.warn(ex.getMessage());
        }
        if (retryCount == 0) {
            if (retractForEditStatus) {
                this.log.info("We quietly sallow the AssessmentNotFoundException excption here. Published Assessment Name: " + pub.getTitle());
            } else {
                this.log.warn("After all retries, still failed ...  Now throw error to UI");
                throw new GradebookServiceException(e);
            }
        }
        return retryCount;
    }

    public double getFIBScore(ItemGradingData data, Map fibmap, ItemDataIfc itemdata, Map publishedAnswerHash) {
        String studentanswer = "";
        boolean matchresult = false;
        double totalScore = 0.0;
        data.setIsCorrect(Boolean.FALSE);
        if (data.getPublishedAnswerId() == null) {
            return totalScore;
        }
        AnswerIfc answerIfc = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answerIfc == null) {
            return totalScore;
        }
        String answertext = answerIfc.getText();
        Long itemId = itemdata.getItemId();
        String casesensitive = itemdata.getItemMetaDataByLabel("CASE_SENSITIVE");
        String mutuallyexclusive = itemdata.getItemMetaDataByLabel("MUTUALLY_EXCLUSIVE");
        String ignorespaces = itemdata.getItemMetaDataByLabel("IGNORE_SPACES");
        if (answertext != null) {
            StringTokenizer st = new StringTokenizer(answertext, "|");
            while (st.hasMoreTokens()) {
                String answer = st.nextToken().trim();
                boolean ignoreSpaces = "true".equalsIgnoreCase(ignorespaces);
                if ("true".equalsIgnoreCase(casesensitive)) {
                    if (data.getAnswerText() != null) {
                        studentanswer = data.getAnswerText().trim();
                        matchresult = this.fibmatch(answer, studentanswer, true, ignoreSpaces);
                    }
                } else if (data.getAnswerText() != null) {
                    studentanswer = data.getAnswerText().trim();
                    matchresult = this.fibmatch(answer, studentanswer, false, ignoreSpaces);
                }
                if (!matchresult) continue;
                boolean alreadyused = false;
                if ("true".equalsIgnoreCase(mutuallyexclusive)) {
                    HashSet<String> answer_used_sofar = (HashSet<String>)fibmap.get(itemId);
                    if (answer_used_sofar != null && answer_used_sofar.contains(studentanswer.toLowerCase())) {
                        alreadyused = true;
                    } else {
                        if (answer_used_sofar == null) {
                            answer_used_sofar = new HashSet<String>();
                        }
                        answer_used_sofar.add(studentanswer.toLowerCase());
                        fibmap.put(itemId, answer_used_sofar);
                    }
                }
                if (alreadyused) break;
                totalScore += ((AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId())).getScore().doubleValue();
                data.setIsCorrect(Boolean.TRUE);
                break;
            }
        }
        return totalScore;
    }

    public boolean getFIBResult(ItemGradingData data, HashMap fibmap, ItemDataIfc itemdata, HashMap publishedAnswerHash) {
        String studentanswer = "";
        boolean matchresult = false;
        if (data.getPublishedAnswerId() == null) {
            return matchresult;
        }
        AnswerIfc answerIfc = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answerIfc == null) {
            return matchresult;
        }
        String answertext = answerIfc.getText();
        Long itemId = itemdata.getItemId();
        String casesensitive = itemdata.getItemMetaDataByLabel("CASE_SENSITIVE");
        String mutuallyexclusive = itemdata.getItemMetaDataByLabel("MUTUALLY_EXCLUSIVE");
        String ignorespaces = itemdata.getItemMetaDataByLabel("IGNORE_SPACES");
        if (answertext != null) {
            StringTokenizer st = new StringTokenizer(answertext, "|");
            while (st.hasMoreTokens()) {
                String answer = st.nextToken().trim();
                boolean ignoreSpaces = "true".equalsIgnoreCase(ignorespaces);
                if ("true".equalsIgnoreCase(casesensitive)) {
                    if (data.getAnswerText() != null) {
                        studentanswer = data.getAnswerText().trim();
                        matchresult = this.fibmatch(answer, studentanswer, true, ignoreSpaces);
                    }
                } else if (data.getAnswerText() != null) {
                    studentanswer = data.getAnswerText().trim();
                    matchresult = this.fibmatch(answer, studentanswer, false, ignoreSpaces);
                }
                if (!matchresult) continue;
                boolean alreadyused = false;
                if ("true".equalsIgnoreCase(mutuallyexclusive)) {
                    HashSet<String> answer_used_sofar = (HashSet<String>)fibmap.get(itemId);
                    if (answer_used_sofar != null && answer_used_sofar.contains(studentanswer.toLowerCase())) {
                        alreadyused = true;
                    } else {
                        if (answer_used_sofar == null) {
                            answer_used_sofar = new HashSet<String>();
                        }
                        answer_used_sofar.add(studentanswer.toLowerCase());
                        fibmap.put(itemId, answer_used_sofar);
                    }
                }
                if (!alreadyused) break;
                matchresult = false;
                break;
            }
        }
        return matchresult;
    }

    public double getFINScore(ItemGradingData data, ItemDataIfc itemdata, Map publishedAnswerHash) throws FinFormatException {
        data.setIsCorrect(Boolean.FALSE);
        double totalScore = 0.0;
        boolean matchresult = this.getFINResult(data, itemdata, publishedAnswerHash);
        if (matchresult) {
            totalScore += ((AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId())).getScore().doubleValue();
            data.setIsCorrect(Boolean.TRUE);
        }
        return totalScore;
    }

    public boolean getFINResult(ItemGradingData data, ItemDataIfc itemdata, Map publishedAnswerHash) throws FinFormatException {
        String studentanswer = "";
        boolean matchresult = false;
        ComplexFormat complexFormat = new ComplexFormat();
        Complex answerComplex = null;
        Complex studentAnswerComplex = null;
        BigDecimal answerNum = null;
        BigDecimal answer1Num = null;
        BigDecimal answer2Num = null;
        BigDecimal studentAnswerNum = null;
        if (data.getPublishedAnswerId() == null) {
            return false;
        }
        AnswerIfc answerIfc = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answerIfc == null) {
            return matchresult;
        }
        String answertext = answerIfc.getText();
        if (answertext != null) {
            StringTokenizer st = new StringTokenizer(answertext, "|");
            boolean range = false;
            if (st.countTokens() > 1) {
                range = true;
            }
            String studentAnswerText = null;
            if (data.getAnswerText() != null) {
                studentAnswerText = data.getAnswerText().replaceAll("\\s+", "").replace(',', '.');
            }
            if (range) {
                String answer1 = st.nextToken().trim();
                String answer2 = st.nextToken().trim();
                if (answer1 != null) {
                    answer1 = answer1.trim().replace(',', '.');
                }
                if (answer2 != null) {
                    answer2 = answer2.trim().replace(',', '.');
                }
                try {
                    answer1Num = new BigDecimal(answer1);
                    answer2Num = new BigDecimal(answer2);
                }
                catch (Exception e) {
                    this.log.debug("Number is not BigDecimal: " + answer1 + " or " + answer2);
                }
                Map map = this.validate(studentAnswerText);
                studentAnswerNum = (BigDecimal)map.get(ANSWER_TYPE_REAL);
                matchresult = answer1Num != null && answer2Num != null && studentAnswerNum != null && answer1Num.compareTo(studentAnswerNum) <= 0 && answer2Num.compareTo(studentAnswerNum) >= 0;
            } else {
                String answer = st.nextToken().trim();
                if (answer != null) {
                    answer = answer.replaceAll("\\s+", "").replace(',', '.');
                }
                try {
                    answerNum = new BigDecimal(answer);
                }
                catch (NumberFormatException ex) {
                    this.log.debug("Number is not BigDecimal: " + answer);
                }
                try {
                    answerComplex = complexFormat.parse(answer);
                }
                catch (MathParseException ex) {
                    this.log.debug("Number is not Complex: " + answer);
                }
                if (data.getAnswerText() != null) {
                    Map map = this.validate(studentAnswerText);
                    if (answerNum != null) {
                        studentAnswerNum = (BigDecimal)map.get(ANSWER_TYPE_REAL);
                        matchresult = studentAnswerNum != null && answerNum.compareTo(studentAnswerNum) == 0;
                    } else if (answerComplex != null) {
                        studentAnswerComplex = (Complex)map.get(ANSWER_TYPE_COMPLEX);
                        matchresult = studentAnswerComplex != null && answerComplex.equals((Object)studentAnswerComplex);
                    }
                }
            }
        }
        return matchresult;
    }

    public double getImageMapScore(ItemGradingData data, ItemDataIfc itemdata, HashMap publishedItemTextHash, HashMap publishedAnswerHash) {
        double totalScore;
        data.setIsCorrect(Boolean.FALSE);
        Iterator iter = publishedAnswerHash.keySet().iterator();
        int answerNumber = 0;
        while (iter.hasNext()) {
            Long answerId = Long.valueOf(iter.next().toString());
            AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(answerId);
            if (!answer.getItem().getItemId().equals(data.getPublishedItemId())) continue;
            ++answerNumber;
        }
        double answerScore = itemdata.getScore();
        if (answerNumber != 0) {
            answerScore /= (double)answerNumber;
        }
        ItemTextIfc itemTextIfc = (ItemTextIfc)publishedItemTextHash.get(data.getPublishedItemTextId());
        ArrayList answerArray = (ArrayList)itemTextIfc.getAnswerArray();
        AnswerIfc answerIfc = (AnswerIfc)answerArray.get(0);
        try {
            String area = answerIfc.getText();
            Integer areax1 = Integer.valueOf(area.substring(area.indexOf("\"x1\":") + 5, area.indexOf(",", area.indexOf("\"x1\":"))));
            Integer areay1 = Integer.valueOf(area.substring(area.indexOf("\"y1\":") + 5, area.indexOf(",", area.indexOf("\"y1\":"))));
            Integer areax2 = Integer.valueOf(area.substring(area.indexOf("\"x2\":") + 5, area.indexOf(",", area.indexOf("\"x2\":"))));
            Integer areay2 = Integer.valueOf(area.substring(area.indexOf("\"y2\":") + 5, area.indexOf("}", area.indexOf("\"y2\":"))));
            String point = data.getAnswerText();
            Integer pointx = Integer.valueOf(point.substring(point.indexOf("\"x\":") + 4, point.indexOf(",", point.indexOf("\"x\":"))));
            Integer pointy = Integer.valueOf(point.substring(point.indexOf("\"y\":") + 4, point.indexOf("}", point.indexOf("\"y\":"))));
            if (pointx >= areax1 && pointx <= areax2 && pointy >= areay1 && pointy <= areay2) {
                totalScore = answerScore;
                data.setIsCorrect(Boolean.TRUE);
            } else {
                totalScore = 0.0;
            }
        }
        catch (Exception ex) {
            totalScore = 0.0;
        }
        return totalScore;
    }

    public Map validate(String value) {
        Boolean isValid;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (value == null || value.trim().equals("")) {
            return map;
        }
        String trimmedValue = value.trim();
        boolean isComplex = true;
        boolean isRealNumber = true;
        BigDecimal studentAnswerReal = null;
        try {
            studentAnswerReal = new BigDecimal(trimmedValue);
        }
        catch (Exception e) {
            isRealNumber = false;
        }
        Complex studentAnswerComplex = null;
        if (!isRealNumber) {
            try {
                DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
                df.setGroupingUsed(false);
                ComplexFormat complexFormat = new ComplexFormat((NumberFormat)df);
                studentAnswerComplex = complexFormat.parse(trimmedValue);
                if (studentAnswerComplex.getImaginary() == 0.0 && trimmedValue.contains("i")) {
                    isComplex = false;
                }
            }
            catch (Exception e) {
                isComplex = false;
            }
        }
        if (!(isValid = Boolean.valueOf(isComplex || isRealNumber)).booleanValue()) {
            throw new FinFormatException("Not a valid FIN Input. studentanswer=" + trimmedValue);
        }
        if (isRealNumber) {
            map.put(ANSWER_TYPE_REAL, studentAnswerReal);
        } else if (isComplex) {
            map.put(ANSWER_TYPE_COMPLEX, (BigDecimal)studentAnswerComplex);
        }
        return map;
    }

    private double getEMIScore(ItemGradingData itemGrading, Long itemId, Map totalItems, Map<Long, Map<Long, Set<EMIScore>>> emiScoresMap, Map publishedItemTextHash, Map publishedAnswerHash) {
        this.log.debug("getEMIScore( " + itemGrading + ", " + itemId);
        double autoScore = 0.0;
        if (!totalItems.containsKey(itemId)) {
            totalItems.put(itemId, new HashMap());
            emiScoresMap.put(itemId, new HashMap());
        }
        autoScore = this.getAnswerScore(itemGrading, publishedAnswerHash);
        AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(itemGrading.getPublishedAnswerId());
        if (answer == null) {
            this.log.warn("could not find answer: " + itemGrading.getPublishedAnswerId() + ", for item " + itemGrading.getItemGradingId());
            return 0.0;
        }
        Long itemTextId = itemGrading.getPublishedItemTextId();
        Map<Long, Set<EMIScore>> emiItemScoresMap = emiScoresMap.get(itemId);
        Set<Object> scores = null;
        if (emiItemScoresMap.containsKey(itemTextId)) {
            scores = emiItemScoresMap.get(itemTextId);
        } else {
            scores = new TreeSet();
            emiItemScoresMap.put(itemTextId, scores);
        }
        scores.add(new EMIScore(itemId, itemTextId, itemGrading.getPublishedAnswerId(), answer.getIsCorrect(), autoScore));
        ItemTextIfc itemText = (ItemTextIfc)publishedItemTextHash.get(itemTextId);
        int numberCorrectAnswers = itemText.getEmiCorrectOptionLabels().length();
        Integer requiredCount = itemText.getRequiredOptionsCount();
        autoScore = 0.0;
        int c = 0;
        for (EMIScore eMIScore : scores) {
            eMIScore.effectiveScore = 0.0;
            if (++c <= numberCorrectAnswers && c <= requiredCount) {
                eMIScore.effectiveScore = eMIScore.correct ? eMIScore.score : 0.0;
            } else if (c > numberCorrectAnswers) {
                double d = eMIScore.effectiveScore = !eMIScore.correct ? eMIScore.score : 0.0;
            }
            if (autoScore + eMIScore.effectiveScore < 0.0) {
                eMIScore.effectiveScore = 0.0;
            }
            autoScore += eMIScore.effectiveScore;
        }
        if (itemGrading.getOverrideScore() != null) {
            autoScore += itemGrading.getOverrideScore().doubleValue();
        }
        HashMap totalItemTextScores = (HashMap)totalItems.get(itemId);
        totalItemTextScores.put(itemTextId, autoScore);
        return autoScore;
    }

    public double getCalcQScore(ItemGradingData data, ItemDataIfc itemdata, Map<Integer, String> calculatedAnswersMap, int calcQuestionAnswerSequence) {
        boolean closeEnough;
        BigDecimal userAnswer;
        double totalScore = 0.0;
        if (data.getAnswerText() == null) {
            return totalScore;
        }
        if (!calculatedAnswersMap.containsKey(calcQuestionAnswerSequence)) {
            return totalScore;
        }
        String allAnswerText = calculatedAnswersMap.get(calcQuestionAnswerSequence).toString();
        BigDecimal correctAnswer = new BigDecimal(this.getAnswerExpression(allAnswerText));
        String varianceString = allAnswerText.substring(allAnswerText.indexOf("|") + 1, allAnswerText.indexOf(","));
        BigDecimal acceptableVariance = BigDecimal.ZERO;
        if (varianceString.contains("%")) {
            double percentage = Double.valueOf(varianceString.substring(0, varianceString.indexOf("%")));
            acceptableVariance = correctAnswer.multiply(new BigDecimal(percentage / 100.0));
        } else {
            acceptableVariance = new BigDecimal(varianceString);
        }
        String userAnswerString = data.getAnswerText().replaceAll(",", "").trim();
        try {
            userAnswer = new BigDecimal(userAnswerString);
        }
        catch (NumberFormatException nfe) {
            return totalScore;
        }
        BigDecimal answerDiff = correctAnswer.subtract(userAnswer);
        boolean bl = closeEnough = answerDiff.abs().compareTo(acceptableVariance.abs()) <= 0;
        if (closeEnough) {
            totalScore += itemdata.getScore().doubleValue();
        }
        return totalScore;
    }

    public boolean getCalcQResult(ItemGradingData data, ItemDataIfc itemdata, Map<Integer, String> calculatedAnswersMap, int calcQuestionAnswerSequence) {
        boolean closeEnough;
        BigDecimal userAnswer;
        boolean result = false;
        if (data.getAnswerText() == null) {
            return result;
        }
        if (!calculatedAnswersMap.containsKey(calcQuestionAnswerSequence)) {
            return result;
        }
        String allAnswerText = calculatedAnswersMap.get(calcQuestionAnswerSequence).toString();
        BigDecimal correctAnswer = new BigDecimal(this.getAnswerExpression(allAnswerText));
        String varianceString = allAnswerText.substring(allAnswerText.indexOf("|") + 1, allAnswerText.indexOf(","));
        BigDecimal acceptableVariance = BigDecimal.ZERO;
        if (varianceString.contains("%")) {
            double percentage = Double.valueOf(varianceString.substring(0, varianceString.indexOf("%")));
            acceptableVariance = correctAnswer.multiply(new BigDecimal(percentage / 100.0));
        } else {
            acceptableVariance = new BigDecimal(varianceString);
        }
        String userAnswerString = data.getAnswerText().replaceAll(",", "").trim();
        try {
            userAnswer = new BigDecimal(userAnswerString);
        }
        catch (NumberFormatException nfe) {
            return result;
        }
        BigDecimal answerDiff = correctAnswer.subtract(userAnswer);
        boolean bl = closeEnough = answerDiff.abs().compareTo(acceptableVariance.abs()) <= 0;
        if (closeEnough) {
            result = true;
        }
        return result;
    }

    public double getTotalCorrectScore(ItemGradingData data, Map publishedAnswerHash) {
        AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answer == null || answer.getScore() == null) {
            return 0.0;
        }
        return answer.getScore();
    }

    private void setIsLate(AssessmentGradingData data, PublishedAssessmentIfc pub) {
        if (data.getSubmitFromTimeoutPopup().booleanValue()) {
            data.setIsLate(Boolean.valueOf(false));
        } else if (pub.getAssessmentAccessControl() != null && pub.getAssessmentAccessControl().getDueDate() != null && pub.getAssessmentAccessControl().getDueDate().before(new Date())) {
            data.setIsLate(Boolean.TRUE);
        } else {
            data.setIsLate(Boolean.valueOf(false));
        }
        if (data.getForGrade().booleanValue()) {
            data.setStatus(Integer.valueOf(1));
        }
        data.setTotalOverrideScore(Double.valueOf(0.0));
    }

    public void deleteAll(Collection c) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().deleteAll(c);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updateAssessmentGradingScore(AssessmentGradingData adata, PublishedAssessmentIfc pub) {
        try {
            Set itemGradingSet = adata.getItemGradingSet();
            Iterator iter = itemGradingSet.iterator();
            double totalAutoScore = 0.0;
            double totalOverrideScore = adata.getTotalOverrideScore();
            while (iter.hasNext()) {
                ItemGradingData i = (ItemGradingData)iter.next();
                if (i.getAutoScore() == null) continue;
                totalAutoScore += i.getAutoScore().doubleValue();
            }
            double oldAutoScore = adata.getTotalAutoScore();
            double scoreDifference = totalAutoScore - oldAutoScore;
            adata.setTotalAutoScore(Double.valueOf(totalAutoScore));
            if (Double.compare(totalAutoScore + totalOverrideScore, Double.valueOf("0")) < 0) {
                adata.setFinalScore(Double.valueOf("0"));
            } else {
                adata.setFinalScore(Double.valueOf(totalAutoScore + totalOverrideScore));
            }
            this.saveOrUpdateAssessmentGrading(adata);
            if (scoreDifference != 0.0) {
                this.notifyGradebookByScoringType(adata, pub);
            }
        }
        catch (GradebookServiceException ge) {
            this.log.error(ge.getMessage(), (Throwable)ge);
            throw ge;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void saveOrUpdateAll(Collection<ItemGradingData> c) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveOrUpdateAll(c);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public PublishedAssessmentIfc getPublishedAssessmentByAssessmentGradingId(String id) {
        PublishedAssessmentIfc pub = null;
        try {
            pub = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getPublishedAssessmentByAssessmentGradingId(Long.valueOf(id));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return pub;
    }

    public PublishedAssessmentIfc getPublishedAssessmentByPublishedItemId(String publishedItemId) {
        PublishedAssessmentIfc pub = null;
        try {
            pub = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getPublishedAssessmentByPublishedItemId(Long.valueOf(publishedItemId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return pub;
    }

    public ArrayList getLastItemGradingDataPosition(Long assessmentGradingId, String agentId) {
        ArrayList results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLastItemGradingDataPosition(assessmentGradingId, agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List getItemGradingIds(Long assessmentGradingId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemGradingIds(assessmentGradingId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List getPublishedItemIds(Long assessmentGradingId) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getPublishedItemIds(assessmentGradingId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public HashSet getItemSet(Long publishedAssessmentId, Long sectionId) {
        HashSet results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getItemSet(publishedAssessmentId, sectionId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public Long getTypeId(Long itemGradingId) {
        Long typeId = null;
        try {
            typeId = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getTypeId(itemGradingId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return typeId;
    }

    public boolean fibmatch(String answer, String input, boolean casesensitive, boolean ignorespaces) {
        try {
            if (ignorespaces) {
                answer = answer.replaceAll(" ", "");
                input = input.replaceAll(" ", "");
            }
            StringBuilder regex_quotebuf = new StringBuilder();
            String REGEX = answer.replaceAll("\\*", "|*|");
            String[] oneblank = REGEX.split("\\|");
            for (int j = 0; j < oneblank.length; ++j) {
                if ("*".equals(oneblank[j])) {
                    regex_quotebuf.append(".+");
                    continue;
                }
                regex_quotebuf.append(Pattern.quote(oneblank[j]));
            }
            String regex_quote = regex_quotebuf.toString();
            Pattern p = casesensitive ? Pattern.compile(regex_quote) : Pattern.compile(regex_quote, 66);
            Matcher m = p.matcher(input);
            boolean result = m.matches();
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List getAllAssessmentGradingByAgentId(Long publishedAssessmentId, String agentIdString) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAllAssessmentGradingByAgentId(publishedAssessmentId, agentIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List<ItemGradingData> getAllItemGradingDataForItemInGrading(Long assesmentGradingId, Long publihsedItemId) {
        ArrayList<ItemGradingData> results = new ArrayList();
        results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getAllItemGradingDataForItemInGrading(assesmentGradingId, publihsedItemId);
        return results;
    }

    public HashMap getSiteSubmissionCountHash(String siteId) {
        HashMap results = new HashMap();
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteSubmissionCountHash(siteId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public HashMap getSiteInProgressCountHash(String siteId) {
        HashMap results = new HashMap();
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteInProgressCountHash(siteId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public int getActualNumberRetake(Long publishedAssessmentId, String agentIdString) {
        int actualNumberReatke = 0;
        try {
            actualNumberReatke = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getActualNumberRetake(publishedAssessmentId, agentIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return actualNumberReatke;
    }

    public HashMap getActualNumberRetakeHash(String agentIdString) {
        HashMap actualNumberReatkeHash = new HashMap();
        try {
            actualNumberReatkeHash = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getActualNumberRetakeHash(agentIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return actualNumberReatkeHash;
    }

    public HashMap getSiteActualNumberRetakeHash(String siteIdString) {
        HashMap numberRetakeHash = new HashMap();
        try {
            numberRetakeHash = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteActualNumberRetakeHash(siteIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return numberRetakeHash;
    }

    public List getStudentGradingSummaryData(Long publishedAssessmentId, String agentIdString) {
        List results = null;
        try {
            results = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getStudentGradingSummaryData(publishedAssessmentId, agentIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public int getNumberRetake(Long publishedAssessmentId, String agentIdString) {
        int numberRetake = 0;
        try {
            numberRetake = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getNumberRetake(publishedAssessmentId, agentIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return numberRetake;
    }

    public HashMap getNumberRetakeHash(String agentIdString) {
        HashMap numberRetakeHash = new HashMap();
        try {
            numberRetakeHash = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getNumberRetakeHash(agentIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return numberRetakeHash;
    }

    public HashMap getSiteNumberRetakeHash(String siteIdString) {
        HashMap siteActualNumberRetakeList = new HashMap();
        try {
            siteActualNumberRetakeList = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteNumberRetakeHash(siteIdString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return siteActualNumberRetakeList;
    }

    public void saveStudentGradingSummaryData(StudentGradingSummaryIfc studentGradingSummaryData) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveStudentGradingSummaryData(studentGradingSummaryData);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public int getLateSubmissionsNumberByAgentId(Long publishedAssessmentId, String agentIdString, Date dueDate) {
        int numberRetake = 0;
        try {
            numberRetake = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getLateSubmissionsNumberByAgentId(publishedAssessmentId, agentIdString, dueDate);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return numberRetake;
    }

    public List getExportResponsesData(String publishedAssessmentId, boolean anonymous, String audioMessage, String fileUploadMessage, String noSubmissionMessage, boolean showPartAndTotalScoreSpreadsheetColumns, String poolString, String partString, String questionString, String textString, String rationaleString, String itemGradingCommentsString, Map useridMap, String responseCommentString) {
        List list = null;
        try {
            list = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getExportResponsesData(publishedAssessmentId, anonymous, audioMessage, fileUploadMessage, noSubmissionMessage, showPartAndTotalScoreSpreadsheetColumns, poolString, partString, questionString, textString, rationaleString, itemGradingCommentsString, useridMap, responseCommentString);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    private void removeUnsubmittedAssessmentGradingData(AssessmentGradingData data) {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().removeUnsubmittedAssessmentGradingData(data);
        }
        catch (Exception e) {
            this.log.error("Exception thrown from removeUnsubmittedAssessmentGradingData" + e.getMessage());
        }
    }

    public boolean getHasGradingData(Long publishedAssessmentId) {
        boolean hasGradingData = false;
        try {
            hasGradingData = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHasGradingData(publishedAssessmentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return hasGradingData;
    }

    private Map<Integer, String> getCalculatedAnswersMap(ItemGradingData itemGrading, ItemDataIfc item) {
        HashMap<Integer, String> calculatedAnswersMap = new HashMap<Integer, String>();
        this.extractCalcQAnswersArray(calculatedAnswersMap, item, itemGrading.getAssessmentGradingId(), itemGrading.getAgentId());
        return calculatedAnswersMap;
    }

    public List<String> extractCalculations(String text) {
        List<String> calculations = this.extractCalculatedQuestionKeyFromItemText(text, this.CALCQ_CALCULATION_PATTERN);
        Iterator<String> iterator = calculations.iterator();
        while (iterator.hasNext()) {
            String calc = iterator.next();
            if (StringUtils.containsAny((String)calc, (String)"{}()+-*/")) continue;
            iterator.remove();
        }
        return calculations;
    }

    public List<String> extractFormulas(String text) {
        return this.extractCalculatedQuestionKeyFromItemText(text, this.CALCQ_FORMULA_PATTERN);
    }

    public List<String> extractVariables(String text) {
        return this.extractCalculatedQuestionKeyFromItemText(text, this.CALCQ_ANSWER_PATTERN);
    }

    private List<String> extractCalculatedQuestionKeyFromItemText(String itemText, Pattern identifierPattern) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (itemText != null && itemText.trim().length() > 0) {
            Matcher keyMatcher = identifierPattern.matcher(itemText);
            while (keyMatcher.find()) {
                String match = keyMatcher.group(1);
                keys.add(match);
            }
        }
        return new ArrayList<String>(keys);
    }

    private String replaceFormulaNameWithFormula(ItemDataIfc item, String formulaName) {
        String result = "";
        List items = item.getItemTextArray();
        block0: for (ItemTextIfc itemText : items) {
            if (!itemText.getText().equals(formulaName)) continue;
            List answers = itemText.getAnswerArray();
            for (AnswerIfc answer : answers) {
                if (!itemText.getSequence().equals(answer.getSequence())) continue;
                result = answer.getText();
                continue block0;
            }
        }
        return result;
    }

    protected List<String> extractInstructionSegments(String instructions) {
        ArrayList<String> segments = new ArrayList<String>();
        if (instructions != null && instructions.length() > 0) {
            String[] results;
            for (String part : results = this.CALCQ_FORMULA_SPLIT_PATTERN.split(instructions)) {
                segments.add(part);
            }
            if (segments.size() == 1) {
                segments.add("");
            }
        }
        return segments;
    }

    public String toScientificNotation(String numberStr, int decimalPlaces) {
        BigDecimal x = new BigDecimal(numberStr);
        x.setScale(decimalPlaces, RoundingMode.HALF_UP);
        DecimalFormat formatter = (Math.abs(x.doubleValue()) >= this.MAX_THRESHOLD || Math.abs(x.doubleValue()) <= this.MIN_THRESHOLD || numberStr.contains("e") || numberStr.contains("E")) && x.doubleValue() != 0.0 ? new DecimalFormat("0E0") : new DecimalFormat("0");
        ((NumberFormat)formatter).setRoundingMode(RoundingMode.HALF_UP);
        ((NumberFormat)formatter).setMaximumFractionDigits(decimalPlaces);
        String formattedNumber = formatter.format(x);
        return formattedNumber.replace(",", ".");
    }

    public String applyPrecisionToNumberString(String numberStr, int decimalPlaces) {
        BigDecimal bd = new BigDecimal(numberStr);
        bd = bd.setScale(decimalPlaces, 6);
        String decimal = ".";
        String displayAnswer = bd.toString();
        if (displayAnswer.length() > 2 && displayAnswer.contains(decimal)) {
            if (decimalPlaces == 0) {
                displayAnswer = displayAnswer.replace(decimal + "0", "");
            } else {
                if (displayAnswer.endsWith("0")) {
                    displayAnswer = StringUtils.stripEnd((String)displayAnswer, (String)"0");
                }
                if (displayAnswer.endsWith(decimal)) {
                    displayAnswer = displayAnswer.substring(0, displayAnswer.length() - 1);
                }
            }
        }
        return displayAnswer;
    }

    private Map<Integer, String> calculateFormulaValues(Map<String, String> variables, ItemDataIfc item) throws Exception {
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        String instructions = item.getInstruction();
        List<String> formulaNames = this.extractFormulas(instructions);
        for (int i = 0; i < formulaNames.size(); ++i) {
            String formulaName = formulaNames.get(i);
            String longFormula = this.replaceFormulaNameWithFormula(item, formulaName);
            longFormula = this.defaultVarianceAndDecimal(longFormula);
            String formula = this.getAnswerExpression(longFormula);
            String answerData = this.getAnswerData(longFormula);
            int decimalPlaces = this.getAnswerDecimalPlaces(answerData);
            String substitutedFormula = this.replaceMappedVariablesWithNumbers(formula, variables);
            String formulaValue = this.processFormulaIntoValue(substitutedFormula, decimalPlaces);
            values.put(i + 1, formulaValue + answerData);
        }
        return values;
    }

    public List<String> extractCalcQAnswersArray(Map<Integer, String> answerList, ItemDataIfc item, Long gradingId, String agentId) {
        int MAX_ERROR_TRIES = 100;
        boolean hasErrors = true;
        Map<String, String> variableRangeMap = this.buildVariableRangeMap(item);
        List<String> instructionSegments = new ArrayList<String>(0);
        int attemptCount = 1;
        while (hasErrors && attemptCount <= 100) {
            instructionSegments.clear();
            Map<String, String> variablesWithValues = this.determineRandomValuesForRanges(variableRangeMap, item.getItemId(), gradingId, agentId, attemptCount);
            try {
                Map<Integer, String> evaluatedFormulas = this.calculateFormulaValues(variablesWithValues, item);
                answerList.putAll(evaluatedFormulas);
                String instructions = item.getInstruction();
                instructions = this.replaceMappedVariablesWithNumbers(instructions, variablesWithValues);
                try {
                    instructions = this.replaceCalculationsWithValues(instructions, 5);
                }
                catch (SamigoExpressionError e1) {
                    this.log.warn("Samigo calculated item (" + item.getItemId() + ") calculation invalid: " + e1.get());
                }
                instructionSegments = this.extractInstructionSegments(instructions);
                hasErrors = false;
            }
            catch (Exception e) {
                ++attemptCount;
            }
        }
        return instructionSegments;
    }

    private int getAnswerDecimalPlaces(String allAnswerText) {
        String answerData = this.getAnswerData(allAnswerText);
        int decimalPlaces = Integer.valueOf(answerData.substring(answerData.indexOf(",") + 1, answerData.length()));
        return decimalPlaces;
    }

    private String getAnswerData(String allAnswerText) {
        String answerData = allAnswerText.substring(allAnswerText.indexOf("|"), allAnswerText.length());
        return answerData;
    }

    private String getAnswerExpression(String allAnswerText) {
        String answerExpression = allAnswerText.substring(0, allAnswerText.indexOf("|"));
        return answerExpression;
    }

    private String defaultVarianceAndDecimal(String allAnswerText) {
        String defaultVariance = "0.001";
        String defaultDecimal = "3";
        if (!allAnswerText.contains("|")) {
            allAnswerText = !allAnswerText.contains(",") ? allAnswerText.concat("|" + defaultVariance + "," + defaultDecimal) : allAnswerText.replace(",", "|" + defaultVariance + ",");
        }
        if (!allAnswerText.contains(",")) {
            allAnswerText = allAnswerText.concat("," + defaultDecimal);
        }
        return allAnswerText;
    }

    public boolean isAnswerValid(String answer) {
        String INFINITY = "Infinity";
        String NaN = "NaN";
        if (answer.length() == 0) {
            return false;
        }
        if (answer.equals(INFINITY)) {
            return false;
        }
        return !answer.equals(NaN);
    }

    public String replaceMappedVariablesWithNumbers(String expression, Map<String, String> variables) {
        if (expression == null) {
            expression = "";
        }
        if (variables == null) {
            variables = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String name = "{" + entry.getKey() + "}";
            String value = entry.getValue();
            int index = expression.indexOf(name);
            while (index > -1) {
                String prefix = expression.substring(0, index);
                String suffix = expression.substring(index + name.length());
                String replacementValue = value;
                if (prefix.length() > 0 && (Character.isDigit(prefix.charAt(prefix.length() - 1)) || prefix.charAt(prefix.length() - 1) == ')')) {
                    replacementValue = "*" + replacementValue;
                }
                if (suffix.length() > 0 && (Character.isDigit(suffix.charAt(0)) || suffix.charAt(0) == '(')) {
                    replacementValue = replacementValue + "*";
                }
                expression = prefix + replacementValue + suffix;
                index = expression.indexOf(name);
            }
        }
        return expression;
    }

    public String replaceCalculationsWithValues(String expression, int decimalPlaces) throws SamigoExpressionError {
        if (StringUtils.isEmpty((String)expression)) {
            expression = "";
        } else {
            Matcher keyMatcher = this.CALCQ_CALCULATION_PATTERN.matcher(expression);
            ArrayList<String> toReplace = new ArrayList<String>();
            while (keyMatcher.find()) {
                String match = keyMatcher.group(1);
                toReplace.add(match);
            }
            if (toReplace.size() > 0) {
                for (String formula : toReplace) {
                    String replace = "[[" + formula + "]]";
                    String formulaValue = this.processFormulaIntoValue(formula, decimalPlaces);
                    expression = StringUtils.replace((String)expression, (String)replace, (String)formulaValue);
                }
            }
        }
        return expression;
    }

    public String processFormulaIntoValue(String formula, int decimalPlaces) throws SamigoExpressionError {
        String value = "";
        if (StringUtils.isEmpty((String)formula)) {
            value = "";
        } else {
            SamigoExpressionParser parser;
            String numericString;
            if (decimalPlaces < 0) {
                decimalPlaces = 0;
            }
            if (this.isAnswerValid(numericString = (parser = new SamigoExpressionParser()).parse(formula = GradingService.cleanFormula(formula), decimalPlaces + 1))) {
                value = numericString = this.toScientificNotation(numericString, decimalPlaces);
            } else {
                throw new IllegalStateException("Invalid calculation formula (" + formula + ") result (" + numericString + "), result could not be calculated");
            }
        }
        return value;
    }

    public static String cleanFormula(String formula) {
        formula = StringUtils.isEmpty((String)formula) ? "" : StringUtils.trimToEmpty((String)formula).replaceAll("\\s+", " ");
        return formula;
    }

    public boolean isNegativeSqrt(String expression) throws SamigoExpressionError {
        Pattern sqrt = Pattern.compile("sqrt\\s*\\(");
        boolean isNegative = false;
        if (expression == null) {
            expression = "";
        }
        expression = expression.toLowerCase();
        Matcher matcher = sqrt.matcher(expression);
        while (matcher.find()) {
            String sqrtExpression;
            SamigoExpressionParser parser;
            String numericAnswerString;
            int x;
            int p = 1;
            int len = expression.length();
            for (x = matcher.end(); p > 0 && x < len; ++x) {
                if (expression.charAt(x) == ')') {
                    --p;
                    continue;
                }
                if (expression.charAt(x) != '(') continue;
                ++p;
            }
            if (p != 0 || this.isAnswerValid(numericAnswerString = (parser = new SamigoExpressionParser()).parse(sqrtExpression = expression.substring(matcher.start(), x)))) continue;
            isNegative = true;
            break;
        }
        return isNegative;
    }

    public Map<String, String> determineRandomValuesForRanges(Map<String, String> variableRangeMap, long itemId, long gradingId, String agentId, int validAnswersAttemptCount) {
        HashMap<String, String> variableValueMap = new HashMap<String, String>();
        long seed = this.getCalcuatedQuestionSeed(itemId, gradingId, agentId, validAnswersAttemptCount);
        Random generator = new Random(seed);
        for (Map.Entry<String, String> entry : variableRangeMap.entrySet()) {
            String delimRange = entry.getValue().toString();
            double minVal = Double.valueOf(delimRange.substring(0, delimRange.indexOf(124)));
            double maxVal = Double.valueOf(delimRange.substring(delimRange.indexOf(124) + 1, delimRange.indexOf(44)));
            int decimalPlaces = Integer.valueOf(delimRange.substring(delimRange.indexOf(44) + 1, delimRange.length()));
            Double randomValue = minVal + (maxVal - minVal) * generator.nextDouble();
            String displayNumber = this.toScientificNotation(randomValue.toString(), decimalPlaces);
            if (decimalPlaces == 0) {
                displayNumber = displayNumber.replace(".0", "");
            }
            variableValueMap.put(entry.getKey(), displayNumber);
        }
        return variableValueMap;
    }

    private Map<String, String> buildVariableRangeMap(ItemDataIfc item) {
        HashMap<String, String> variableRangeMap = new HashMap<String, String>();
        String instructions = item.getInstruction();
        List<String> variables = this.extractVariables(instructions);
        List itemTextList = item.getItemTextArraySorted();
        for (ItemTextIfc varName : itemTextList) {
            if (!variables.contains(varName.getText())) continue;
            List answerList = varName.getAnswerArray();
            for (AnswerIfc range : answerList) {
                if (range.getLabel() == null || !range.getSequence().equals(varName.getSequence()) || !range.getText().contains("|")) continue;
                variableRangeMap.put(varName.getText(), range.getText());
            }
        }
        return variableRangeMap;
    }

    private long getCalcuatedQuestionSeed(long itemId, long gradingId, String agentId, int validAnswersAttemptCount) {
        long userSeed = agentId.hashCode();
        return userSeed * itemId * gradingId * (long)validAnswersAttemptCount;
    }

    private boolean isCalcQuestion(List tempItemGradinglist, HashMap publishedItemHash) {
        if (tempItemGradinglist == null) {
            return false;
        }
        if (tempItemGradinglist.size() == 0) {
            return false;
        }
        for (ItemGradingData itemCheck : tempItemGradinglist) {
            Long itemId = itemCheck.getPublishedItemId();
            ItemDataIfc item = (ItemDataIfc)publishedItemHash.get(itemId);
            if (item == null || !TypeIfc.CALCULATED_QUESTION.equals(item.getTypeId())) continue;
            return true;
        }
        return false;
    }

    public ArrayList getHasGradingDataAndHasSubmission(Long publishedAssessmentId) {
        ArrayList al = new ArrayList();
        try {
            al = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getHasGradingDataAndHasSubmission(publishedAssessmentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return al;
    }

    public String getFileName(Long itemGradingId, String agentId, String filename) {
        String name = "";
        try {
            name = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getFilename(itemGradingId, agentId, filename);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return name;
    }

    public List getUpdatedAssessmentList(String agentId, String siteId) {
        List list = null;
        try {
            list = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getUpdatedAssessmentList(agentId, siteId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getSiteNeedResubmitList(String siteId) {
        List list = null;
        try {
            list = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSiteNeedResubmitList(siteId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public void autoSubmitAssessments() {
        try {
            PersistenceService.getInstance().getAssessmentGradingFacadeQueries().autoSubmitAssessments();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ItemGradingAttachment createItemGradingAttachment(ItemGradingData itemGrading, String resourceId, String filename, String protocol) {
        ItemGradingAttachment attachment = null;
        try {
            attachment = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().createItemGradingtAttachment(itemGrading, resourceId, filename, protocol);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return attachment;
    }

    public AssessmentGradingAttachment createAssessmentGradingAttachment(AssessmentGradingData assessmentGrading, String resourceId, String filename, String protocol) {
        AssessmentGradingAttachment attachment = null;
        try {
            attachment = PersistenceService.getInstance().getAssessmentGradingFacadeQueries().createAssessmentGradingtAttachment(assessmentGrading, resourceId, filename, protocol);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return attachment;
    }

    public void removeItemGradingAttachment(String attachmentId) {
        PersistenceService.getInstance().getAssessmentGradingFacadeQueries().removeItemGradingAttachment(Long.valueOf(attachmentId));
    }

    public void removeAssessmentGradingAttachment(String attachmentId) {
        PersistenceService.getInstance().getAssessmentGradingFacadeQueries().removeAssessmentGradingAttachment(Long.valueOf(attachmentId));
    }

    public void saveOrUpdateAttachments(List list) {
        PersistenceService.getInstance().getAssessmentGradingFacadeQueries().saveOrUpdateAttachments(list);
    }

    public HashMap getInProgressCounts(String siteId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getInProgressCounts(siteId);
    }

    public HashMap getSubmittedCounts(String siteId) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getSubmittedCounts(siteId);
    }

    public void completeItemGradingData(AssessmentGradingData assessmentGradingData) {
        PersistenceService.getInstance().getAssessmentGradingFacadeQueries().completeItemGradingData(assessmentGradingData);
    }

    public double getAnswerScoreMCQ(ItemGradingData data, Map publishedAnswerHash) {
        AnswerIfc answer = (AnswerIfc)publishedAnswerHash.get(data.getPublishedAnswerId());
        if (answer == null || answer.getScore() == null) {
            return 0.0;
        }
        if (answer.getIsCorrect().booleanValue()) {
            return answer.getItem().getScore();
        }
        return answer.getItem().getScore() * answer.getPartialCredit() / 100.0;
    }

    private Map<Long, Map<Long, Map<Long, EMIScore>>> reorderEMIScoreMap(Map<Long, Map<Long, Set<EMIScore>>> emiScoresMap) {
        HashMap<Long, Map<Long, Map<Long, EMIScore>>> scoresMap = new HashMap<Long, Map<Long, Map<Long, EMIScore>>>();
        for (Map<Long, Set<EMIScore>> emiItemScoresMap : emiScoresMap.values()) {
            for (Set<EMIScore> scoreSet : emiItemScoresMap.values()) {
                for (EMIScore s : scoreSet) {
                    HashMap<Long, EMIScore> scoresItemText;
                    HashMap<Long, HashMap<Long, EMIScore>> scoresItem = (HashMap<Long, HashMap<Long, EMIScore>>)scoresMap.get(s.itemId);
                    if (scoresItem == null) {
                        scoresItem = new HashMap<Long, HashMap<Long, EMIScore>>();
                        scoresMap.put(s.itemId, scoresItem);
                    }
                    if ((scoresItemText = (HashMap<Long, EMIScore>)scoresItem.get(s.itemTextId)) == null) {
                        scoresItemText = new HashMap<Long, EMIScore>();
                        scoresItem.put(s.itemTextId, scoresItemText);
                    }
                    scoresItemText.put(s.answerId, s);
                }
            }
        }
        return scoresMap;
    }

    public boolean hasDistractors(ItemDataIfc item) {
        boolean hasDistractor = false;
        for (ItemTextIfc curItem : item.getItemTextArraySorted()) {
            if (!this.isDistractor(curItem)) continue;
            hasDistractor = true;
            break;
        }
        return hasDistractor;
    }

    public boolean isDistractor(ItemTextIfc itemText) {
        boolean hasCorrectAnswer = false;
        List answers = itemText.getAnswerArray();
        for (AnswerIfc answer : answers) {
            if (answer.getIsCorrect() == null || !answer.getIsCorrect().booleanValue()) continue;
            hasCorrectAnswer = true;
            break;
        }
        return !hasCorrectAnswer;
    }

    public List getUnSubmittedAssessmentGradingDataList(Long publishedAssessmentId, String agentIdString) {
        return PersistenceService.getInstance().getAssessmentGradingFacadeQueries().getUnSubmittedAssessmentGradingDataList(publishedAssessmentId, agentIdString);
    }
}

