/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.tool.assessment.data.dao.assessment.Answer;
import org.sakaiproject.tool.assessment.data.dao.assessment.AnswerFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.FavoriteColChoices;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemAttachment;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTextAttachment;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemService {
    private Logger log = LoggerFactory.getLogger(ItemService.class);

    public ItemFacade getItem(Long itemId, String agentId) {
        ItemFacade item = null;
        try {
            item = PersistenceService.getInstance().getItemFacadeQueries().getItem(itemId, agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return item;
    }

    public void deleteItem(Long itemId, String agentId) {
        try {
            PersistenceService.getInstance().getItemFacadeQueries().deleteItem(itemId, agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void deleteItemContent(Long itemId, String agentId) {
        try {
            PersistenceService.getInstance().getItemFacadeQueries().deleteItemContent(itemId, agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void deleteItemMetaData(Long itemId, String label, String agentId) {
        try {
            PersistenceService.getInstance().getItemFacadeQueries().deleteItemMetaData(itemId, label);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void addItemMetaData(Long itemId, String label, String value, String agentId) {
        try {
            PersistenceService.getInstance().getItemFacadeQueries().addItemMetaData(itemId, label, value);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ItemFacade saveItem(ItemFacade item) {
        try {
            return PersistenceService.getInstance().getItemFacadeQueries().saveItem(item);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return item;
        }
    }

    public ItemFacade getItem(String itemId) {
        try {
            return PersistenceService.getInstance().getItemFacadeQueries().getItem(new Long(itemId));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public HashMap getItemsByKeyword(String keyword) {
        keyword = "%" + keyword + "%";
        HashMap map = null;
        map = PersistenceService.getInstance().getItemFacadeQueries().getItemsByKeyword(keyword);
        return map;
    }

    public Long getItemTextId(Long publishedItemId) {
        try {
            return PersistenceService.getInstance().getItemFacadeQueries().getItemTextId(publishedItemId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    public ItemData cloneItem(ItemDataIfc item) {
        ItemData cloned = new ItemData(item.getSection(), item.getSequence(), item.getDuration(), item.getInstruction(), item.getDescription(), item.getTypeId(), item.getGrade(), item.getScore(), item.getScoreDisplayFlag(), item.getDiscount(), item.getMinScore(), item.getHint(), item.getHasRationale(), item.getStatus(), item.getCreatedBy(), item.getCreatedDate(), item.getLastModifiedBy(), item.getLastModifiedDate(), null, null, null, item.getTriesAllowed(), item.getPartialCreditFlag());
        Set newItemTextSet = this.copyItemTextSet(cloned, item.getItemTextSet());
        Set newItemMetaDataSet = this.copyItemMetaDataSet(cloned, item.getItemMetaDataSet());
        Set newItemFeedbackSet = this.copyItemFeedbackSet(cloned, item.getItemFeedbackSet());
        Set newItemAttachmentSet = this.copyItemAttachmentSet(cloned, item.getItemAttachmentSet());
        String newItemInstruction = AssessmentService.copyStringAttachment(item.getInstruction());
        cloned.setItemTextSet(newItemTextSet);
        cloned.setItemMetaDataSet(newItemMetaDataSet);
        cloned.setItemFeedbackSet(newItemFeedbackSet);
        cloned.setItemAttachmentSet(newItemAttachmentSet);
        cloned.setAnswerOptionsSimpleOrRich(item.getAnswerOptionsSimpleOrRich());
        cloned.setAnswerOptionsRichCount(item.getAnswerOptionsRichCount());
        cloned.setInstruction(newItemInstruction);
        return cloned;
    }

    private Set copyItemTextSet(ItemData cloned, Set itemTextSet) {
        HashSet<ItemText> h = new HashSet<ItemText>();
        for (ItemText itemText : itemTextSet) {
            String newText = AssessmentService.copyStringAttachment(itemText.getText());
            ItemText newItemText = new ItemText(cloned, itemText.getSequence(), newText, null);
            newItemText.setRequiredOptionsCount(itemText.getRequiredOptionsCount());
            newItemText.setItemTextAttachmentSet(this.copyItemAttachmentSetItemText(newItemText, itemText.getItemTextAttachmentSet()));
            Set newAnswerSet = this.copyAnswerSet(newItemText, itemText.getAnswerSet());
            newItemText.setAnswerSet(newAnswerSet);
            h.add(newItemText);
        }
        return h;
    }

    private Set copyAnswerSet(ItemText newItemText, Set answerSet) {
        HashSet<Answer> h = new HashSet<Answer>();
        for (Answer answer : answerSet) {
            Answer newAnswer = new Answer((ItemTextIfc)newItemText, answer.getText(), answer.getSequence(), answer.getLabel(), answer.getIsCorrect(), answer.getGrade(), answer.getScore(), answer.getPartialCredit(), answer.getDiscount(), null);
            Set newAnswerFeedbackSet = this.copyAnswerFeedbackSet(newAnswer, answer.getAnswerFeedbackSet());
            newAnswer.setAnswerFeedbackSet(newAnswerFeedbackSet);
            h.add(newAnswer);
        }
        return h;
    }

    private Set copyAnswerFeedbackSet(Answer newAnswer, Set answerFeedbackSet) {
        HashSet<AnswerFeedback> h = new HashSet<AnswerFeedback>();
        for (AnswerFeedback answerFeedback : answerFeedbackSet) {
            AnswerFeedback newAnswerFeedback = new AnswerFeedback((AnswerIfc)newAnswer, answerFeedback.getTypeId(), answerFeedback.getText());
            h.add(newAnswerFeedback);
        }
        return h;
    }

    private Set copyItemMetaDataSet(ItemData cloned, Set itemMetaDataSet) {
        HashSet<ItemMetaData> h = new HashSet<ItemMetaData>();
        for (ItemMetaData itemMetaData : itemMetaDataSet) {
            ItemMetaData newItemMetaData = new ItemMetaData((ItemDataIfc)cloned, itemMetaData.getLabel(), itemMetaData.getEntry());
            h.add(newItemMetaData);
        }
        return h;
    }

    private Set copyItemFeedbackSet(ItemData cloned, Set itemFeedbackSet) {
        HashSet<ItemFeedback> h = new HashSet<ItemFeedback>();
        for (ItemFeedback itemFeedback : itemFeedbackSet) {
            ItemFeedback newItemFeedback = new ItemFeedback(cloned, itemFeedback.getTypeId(), AssessmentService.copyStringAttachment(itemFeedback.getText()));
            h.add(newItemFeedback);
        }
        return h;
    }

    private Set copyItemAttachmentSet(ItemData cloned, Set itemAttachmentSet) {
        AssessmentService service = new AssessmentService();
        HashSet<ItemAttachment> h = new HashSet<ItemAttachment>();
        for (ItemAttachmentIfc itemAttachment : itemAttachmentSet) {
            ContentResource cr_copy = service.createCopyOfContentResource(itemAttachment.getResourceId(), itemAttachment.getFilename());
            ItemAttachment newItemAttachment = new ItemAttachment(null, cr_copy.getId(), itemAttachment.getFilename(), itemAttachment.getMimeType(), itemAttachment.getFileSize(), itemAttachment.getDescription(), cr_copy.getUrl(true), itemAttachment.getIsLink(), itemAttachment.getStatus(), itemAttachment.getCreatedBy(), itemAttachment.getCreatedDate(), itemAttachment.getLastModifiedBy(), itemAttachment.getLastModifiedDate());
            newItemAttachment.setItem((ItemDataIfc)cloned);
            h.add(newItemAttachment);
        }
        return h;
    }

    private Set copyItemAttachmentSetItemText(ItemText itemText, Set itemAttachmentSet) {
        AssessmentService service = new AssessmentService();
        HashSet<ItemTextAttachment> h = new HashSet<ItemTextAttachment>();
        for (ItemTextAttachmentIfc ItemTextAttachment2 : itemAttachmentSet) {
            ContentResource cr_copy = service.createCopyOfContentResource(ItemTextAttachment2.getResourceId(), ItemTextAttachment2.getFilename());
            ItemTextAttachment newItemTextAttachment = new ItemTextAttachment(null, cr_copy.getId(), ItemTextAttachment2.getFilename(), ItemTextAttachment2.getMimeType(), ItemTextAttachment2.getFileSize(), ItemTextAttachment2.getDescription(), cr_copy.getUrl(true), ItemTextAttachment2.getIsLink(), ItemTextAttachment2.getStatus(), ItemTextAttachment2.getCreatedBy(), ItemTextAttachment2.getCreatedDate(), ItemTextAttachment2.getLastModifiedBy(), ItemTextAttachment2.getLastModifiedDate());
            newItemTextAttachment.setItemText((ItemTextIfc)itemText);
            h.add(newItemTextAttachment);
        }
        return h;
    }

    public void deleteSet(Set s) {
        try {
            PersistenceService.getInstance().getItemFacadeQueries().deleteSet(s);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void saveFavoriteColumnChoices(FavoriteColChoices choices) {
        try {
            PersistenceService.getInstance().getFavoriteColChoicesFacadeQueries().saveOrUpdate(choices);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

