/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedItemService
extends ItemService {
    private Logger log = LoggerFactory.getLogger(PublishedItemService.class);

    @Override
    public ItemFacade getItem(Long itemId, String agentId) {
        PublishedItemFacade item = null;
        try {
            item = PersistenceService.getInstance().getPublishedItemFacadeQueries().getItem(itemId, agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return item;
    }

    @Override
    public ItemFacade getItem(String itemId) {
        PublishedItemFacade item = null;
        try {
            item = PersistenceService.getInstance().getPublishedItemFacadeQueries().getItem(itemId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return item;
    }

    @Override
    public void deleteItemContent(Long itemId, String agentId) {
        try {
            PersistenceService.getInstance().getPublishedItemFacadeQueries().deleteItemContent(itemId, agentId);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ItemFacade saveItem(PublishedItemFacade item) {
        try {
            return PersistenceService.getInstance().getPublishedItemFacadeQueries().saveItem(item);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return item;
        }
    }
}

