/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.assessment;

import java.util.List;
import java.util.Map;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentServiceException;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.assessment.PublishedAssessmentServiceAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedAssessmentServiceImpl
implements PublishedAssessmentServiceAPI {
    private Logger log = LoggerFactory.getLogger(PublishedAssessmentServiceImpl.class);

    public List getBasicInfoOfAllPublishedAssessments(String agentId, String orderBy, boolean ascending, String siteId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getBasicInfoOfAllPublishedAssessments(agentId, orderBy, ascending, siteId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllActivePublishedAssessments(String orderBy) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getAllActivePublishedAssessments(orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllActivePublishedAssessments(int pageSize, int pageNumber, String orderBy) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getAllActivePublishedAssessments(pageSize, pageNumber, orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllInActivePublishedAssessments(String orderBy) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getAllInActivePublishedAssessments(orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllInActivePublishedAssessments(int pageSize, int pageNumber, String orderBy) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getAllInActivePublishedAssessments(pageSize, pageNumber, orderBy);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllPublishedAssessments(String orderBy, Integer status) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getAllPublishedAssessments(orderBy, status);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getAllPublishedAssessments(int pageSize, int pageNumber, String orderBy, Integer status) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getAllPublishedAssessments(pageSize, pageNumber, orderBy, status);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public PublishedAssessmentIfc getPublishedAssessment(String assessmentId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getPublishedAssessment(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public Long getPublishedAssessmentId(String assessmentId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getPublishedAssessmentId(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public PublishedAssessmentIfc publishAssessment(AssessmentIfc assessment) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            AssessmentService assessmentService = new AssessmentService();
            AssessmentFacade facade = assessmentService.getAssessment(assessment.getAssessmentId().toString());
            return service.publishAssessment(facade);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public PublishedAssessmentIfc publishPreviewAssessment(AssessmentIfc assessment, String protocol) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            AssessmentService assessmentService = new AssessmentService();
            AssessmentFacade facade = assessmentService.getAssessment(assessment.getAssessmentId().toString());
            return service.publishPreviewAssessment(facade);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void saveAssessment(PublishedAssessmentIfc assessment) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            PublishedAssessmentFacade facade = service.getPublishedAssessment(assessment.getAssessmentId().toString());
            service.saveAssessment(facade);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void removeAssessment(String assessmentId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            service.removeAssessment(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getBasicInfoOfAllActivePublishedAssessments(String orderBy, boolean ascending) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getBasicInfoOfAllActivePublishedAssessments(orderBy, ascending);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getBasicInfoOfAllInActivePublishedAssessments(String orderBy, boolean ascending) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getBasicInfoOfAllInActivePublishedAssessments(orderBy, ascending);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public PublishedAssessmentIfc getSettingsOfPublishedAssessment(String assessmentId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getSettingsOfPublishedAssessment(assessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public ItemDataIfc loadPublishedItem(String itemId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.loadPublishedItem(itemId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public ItemTextIfc loadPublishedItemText(String itemTextId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.loadPublishedItemText(itemTextId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public List getBasicInfoOfLastSubmittedAssessments(String agentId, String orderBy, boolean ascending) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getBasicInfoOfLastSubmittedAssessments(agentId, orderBy, ascending);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public Map getTotalSubmissionPerAssessment(String agentId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getTotalSubmissionPerAssessment(agentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public Integer getTotalSubmission(String agentId, String publishedAssessmentId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getTotalSubmission(agentId, publishedAssessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public PublishedAssessmentIfc getPublishedAssessmentIdByAlias(String alias) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getPublishedAssessmentIdByAlias(alias);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public void saveOrUpdateMetaData(ItemMetaDataIfc meta) {
        try {
            ItemService itemService = new ItemService();
            ItemDataIfc itemIfc = meta.getItem();
            itemIfc.getItemMetaDataSet().add(meta);
            ItemFacade facade = itemService.getItem(itemIfc.getItemIdString());
            itemService.saveItem(facade);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public Map getFeedbackHash() {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getFeedbackHash();
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public Map getAllAssessmentsReleasedToAuthenticatedUsers() {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getAllAssessmentsReleasedToAuthenticatedUsers();
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }

    public String getPublishedAssessmentOwner(Long publishedAssessmentId) {
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            return service.getPublishedAssessmentOwner(publishedAssessmentId);
        }
        catch (Exception ex) {
            throw new AssessmentServiceException(ex);
        }
    }
}

