/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.assessment;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.RegisteredSecureDeliveryModuleIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SecureDeliveryModuleIfc;
import org.sakaiproject.tool.assessment.shared.api.assessment.SecureDeliveryServiceAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

public class SecureDeliveryServiceImpl
implements SecureDeliveryServiceAPI {
    private Logger log = LoggerFactory.getLogger(SecureDeliveryServiceImpl.class);
    private Map<String, SecureDeliveryModuleIfc> secureDeliveryModules = new HashMap<String, SecureDeliveryModuleIfc>();

    public void init() {
        String secureDeliveryPluginSetting = ServerConfigurationService.getString((String)"samigo.secureDeliveryPlugins", null);
        this.log.info("Secure delivery plugins are: " + secureDeliveryPluginSetting);
        if (secureDeliveryPluginSetting != null) {
            String[] plugins;
            for (String plugin : plugins = secureDeliveryPluginSetting.split(":")) {
                this.handlePlugin(plugin);
            }
        }
    }

    public boolean isSecureDeliveryAvaliable() {
        return this.secureDeliveryModules.size() > 0;
    }

    public boolean isSecureDeliveryModuleAvailable(String moduleId) {
        if ("SECURE_DELIVERY_NONE_ID".equals(moduleId)) {
            return true;
        }
        return this.secureDeliveryModules.get(moduleId) != null;
    }

    public SortedSet<RegisteredSecureDeliveryModuleIfc> getSecureDeliveryModules(Locale locale) {
        TreeSet<RegisteredSecureDeliveryModuleIfc> moduleSet = new TreeSet<RegisteredSecureDeliveryModuleIfc>();
        SecureDeliveryModuleImpl module = new SecureDeliveryModuleImpl();
        module.id = "SECURE_DELIVERY_NONE_ID";
        module.name = "None";
        moduleSet.add(module);
        for (Map.Entry<String, SecureDeliveryModuleIfc> entry : this.secureDeliveryModules.entrySet()) {
            module = new SecureDeliveryModuleImpl();
            module.id = entry.getKey();
            module.name = entry.getValue().getModuleName(locale);
            module.enabled = entry.getValue().isEnabled();
            moduleSet.add(module);
        }
        return moduleSet;
    }

    public String getTitleDecoration(String moduleId, Locale locale) {
        SecureDeliveryModuleIfc module = this.secureDeliveryModules.get(moduleId);
        if (moduleId == null || "SECURE_DELIVERY_NONE_ID".equals(moduleId) || module == null || !module.isEnabled()) {
            return "";
        }
        try {
            return module.getTitleDecoration(locale);
        }
        catch (Exception e) {
            this.log.error("getTitleDecoration failed for module " + moduleId, (Throwable)e);
            return "";
        }
    }

    public SecureDeliveryServiceAPI.PhaseStatus validatePhase(String moduleId, SecureDeliveryServiceAPI.Phase phase, PublishedAssessmentIfc assessment, HttpServletRequest request) {
        SecureDeliveryModuleIfc module = this.secureDeliveryModules.get(moduleId);
        if (moduleId == null || "SECURE_DELIVERY_NONE_ID".equals(moduleId) || module == null || !module.isEnabled()) {
            return SecureDeliveryServiceAPI.PhaseStatus.SUCCESS;
        }
        try {
            return module.validatePhase(phase, assessment, request);
        }
        catch (Exception e) {
            this.log.error("canStartDelivery failed for module " + moduleId, (Throwable)e);
            return SecureDeliveryServiceAPI.PhaseStatus.SUCCESS;
        }
    }

    public String getInitialHTMLFragments(HttpServletRequest request, Locale locale) {
        StringBuilder sb = new StringBuilder();
        for (SecureDeliveryModuleIfc module : this.secureDeliveryModules.values()) {
            String fragment;
            if (!module.isEnabled() || (fragment = module.getInitialHTMLFragment(request, locale)) == null || fragment.isEmpty()) continue;
            sb.append(fragment);
        }
        return sb.toString();
    }

    public String getHTMLFragment(String moduleId, PublishedAssessmentIfc assessment, HttpServletRequest request, SecureDeliveryServiceAPI.Phase phase, SecureDeliveryServiceAPI.PhaseStatus status, Locale locale) {
        SecureDeliveryModuleIfc module = this.secureDeliveryModules.get(moduleId);
        if (moduleId == null || "SECURE_DELIVERY_NONE_ID".equals(moduleId) || module == null || !module.isEnabled()) {
            return "";
        }
        try {
            return module.getHTMLFragment(assessment, request, phase, status, locale);
        }
        catch (Exception e) {
            this.log.error("getHTMLFragment failed for module " + moduleId, (Throwable)e);
            return "";
        }
    }

    public SecureDeliveryModuleIfc getModuleReference(String moduleId, Object context) {
        SecureDeliveryModuleIfc module = this.secureDeliveryModules.get(moduleId);
        if (moduleId == null || "SECURE_DELIVERY_NONE_ID".equals(moduleId) || module == null) {
            return null;
        }
        try {
            if (module.validateContext(context)) {
                return module;
            }
            return null;
        }
        catch (Exception e) {
            this.log.error("validateContext failed for module " + moduleId, (Throwable)e);
            return null;
        }
    }

    public String encryptPassword(String moduleId, String password) {
        SecureDeliveryModuleIfc module = this.secureDeliveryModules.get(moduleId);
        if (moduleId == null || "SECURE_DELIVERY_NONE_ID".equals(moduleId) || module == null) {
            return password;
        }
        try {
            return module.encryptPassword(password);
        }
        catch (Exception e) {
            this.log.error("encryptPassword failed for module " + moduleId, (Throwable)e);
            return password;
        }
    }

    public String decryptPassword(String moduleId, String password) {
        SecureDeliveryModuleIfc module = this.secureDeliveryModules.get(moduleId);
        if (moduleId == null || password == null || "SECURE_DELIVERY_NONE_ID".equals(moduleId) || module == null) {
            return password;
        }
        try {
            return module.decryptPassword(password);
        }
        catch (Exception e) {
            this.log.error("decryptPassword failed for module " + moduleId, (Throwable)e);
            return password;
        }
    }

    private void handlePlugin(String secureDeliveryPlugin) {
        try {
            File file = new File(secureDeliveryPlugin);
            if (!file.exists()) {
                this.log.warn("Secure delivery plugin " + secureDeliveryPlugin + " not found");
                return;
            }
            URL pluginUrl = new URL("file:" + secureDeliveryPlugin);
            URLClassLoader classLoader = new URLClassLoader(new URL[]{pluginUrl}, this.getClass().getClassLoader());
            GenericApplicationContext ctx = new GenericApplicationContext();
            ctx.setClassLoader((ClassLoader)classLoader);
            Resource resource = ctx.getResource("jar:file:" + secureDeliveryPlugin + "!/spring-context.xml");
            XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
            xmlReader.loadBeanDefinitions(resource);
            ctx.refresh();
            String[] secureDeliveryModuleBeanNames = ctx.getBeanNamesForType(SecureDeliveryModuleIfc.class);
            if (secureDeliveryModuleBeanNames.length == 0) {
                this.log.warn("Secure delivery plugin doesn't define any beans of type SecureDeliveryModuleIfc");
            }
            for (String name : secureDeliveryModuleBeanNames) {
                SecureDeliveryModuleIfc secureDeliveryModuleBean = (SecureDeliveryModuleIfc)ctx.getBean(name);
                this.log.info("Loaded secure delivery module: " + secureDeliveryModuleBean + " (" + secureDeliveryModuleBean.getModuleName(Locale.getDefault()) + ")");
                if (!secureDeliveryModuleBean.initialize()) continue;
                this.secureDeliveryModules.put(secureDeliveryModuleBean.getClass().getName(), secureDeliveryModuleBean);
            }
        }
        catch (Exception e) {
            this.log.error("Unable to load secure delivery plugin " + secureDeliveryPlugin, (Throwable)e);
        }
    }

    private class SecureDeliveryModuleImpl
    implements RegisteredSecureDeliveryModuleIfc,
    Comparable<RegisteredSecureDeliveryModuleIfc> {
        private String id;
        private String name;
        private boolean enabled;

        private SecureDeliveryModuleImpl() {
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public int compareTo(RegisteredSecureDeliveryModuleIfc other) {
            if ("SECURE_DELIVERY_NONE_ID".equals(this.id)) {
                return -1;
            }
            if ("SECURE_DELIVERY_NONE_ID".equals(other.getId())) {
                return 1;
            }
            if (!this.name.equals(other.getName())) {
                return this.name.compareTo(other.getName());
            }
            return this.id.compareTo(other.getId());
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegisteredSecureDeliveryModuleIfc) {
                return this.compareTo((RegisteredSecureDeliveryModuleIfc)obj) == 0;
            }
            return false;
        }
    }
}

