/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.grading;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.ItemGradingData;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.services.GradingServiceException;
import org.sakaiproject.tool.assessment.shared.api.grading.GradingServiceAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradingServiceImpl
implements GradingServiceAPI {
    private Logger log = LoggerFactory.getLogger(GradingServiceImpl.class);

    public List getTotalScores(String publishedId, String which) {
        try {
            GradingService service = new GradingService();
            return service.getTotalScores(publishedId, which);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public List getAllSubmissions(String publishedId) {
        try {
            GradingService service = new GradingService();
            return service.getAllSubmissions(publishedId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public void saveTotalScores(List data, PublishedAssessmentIfc pub) {
        try {
            GradingService service = new GradingService();
            ArrayList list = new ArrayList(data);
            service.saveTotalScores(list, pub);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public Map getItemScores(Long publishedId, Long itemId, String which) {
        try {
            GradingService service = new GradingService();
            return service.getItemScores(publishedId, itemId, which);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public Map getLastItemGrading(String publishedId, String agentId) {
        try {
            GradingService service = new GradingService();
            return service.getLastItemGradingData(publishedId, agentId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public Map getStudentGradingData(String assessmentGradingId) {
        try {
            GradingService service = new GradingService();
            return service.getStudentGradingData(assessmentGradingId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public Map getSubmitData(String publishedId, String agentId, Integer scoringoption) {
        try {
            GradingService service = new GradingService();
            return service.getSubmitData(publishedId, agentId, scoringoption, null);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public String getTextForId(Long typeId) {
        try {
            GradingService service = new GradingService();
            return service.getTextForId(typeId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public int getSubmissionSizeOfPublishedAssessment(String publishedAssessmentId) {
        try {
            GradingService service = new GradingService();
            return service.getSubmissionSizeOfPublishedAssessment(publishedAssessmentId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public Long saveMedia(byte[] media, String mimeType) {
        try {
            GradingService service = new GradingService();
            return service.saveMedia(media, mimeType);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public Long saveMedia(MediaData mediaData) {
        try {
            GradingService service = new GradingService();
            return service.saveMedia(service.getMedia(mediaData.getMediaId().toString()));
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public MediaData getMedia(String mediaId) {
        try {
            GradingService service = new GradingService();
            return service.getMedia(mediaId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public List getMediaArray(String itemGradingId) {
        try {
            GradingService service = new GradingService();
            return service.getMediaArray(itemGradingId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public List getMediaArray(ItemGradingData itemGrading) {
        try {
            GradingService service = new GradingService();
            String publishedItemId = itemGrading.getPublishedItemId().toString();
            String assessmentGradingId = itemGrading.getAssessmentGradingId().toString();
            ItemGradingData gradingData = service.getItemGradingData(assessmentGradingId, publishedItemId);
            return service.getMediaArray(gradingData);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public ItemGradingData getLastItemGradingByAgent(String publishedItemId, String agentId) {
        try {
            GradingService service = new GradingService();
            return service.getLastItemGradingDataByAgent(publishedItemId, agentId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public ItemGradingData getItemGrading(String assessmentGradingId, String publishedItemId) {
        try {
            GradingService service = new GradingService();
            return service.getItemGradingData(assessmentGradingId, publishedItemId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public AssessmentGradingData load(String assessmentGradingId) {
        try {
            GradingService service = new GradingService();
            return service.load(assessmentGradingId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public AssessmentGradingData getLastAssessmentGradingByAgentId(String publishedAssessmentId, String agentIdString) {
        try {
            GradingService service = new GradingService();
            return service.getLastAssessmentGradingByAgentId(publishedAssessmentId, agentIdString);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public void saveOrUpdateAssessmentGrading(AssessmentGradingData assessment) {
        try {
            GradingService service = new GradingService();
            service.saveOrUpdateAssessmentGrading(assessment);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public void saveItemGrading(ItemGradingData item) {
        try {
            GradingService service = new GradingService();
            service.saveItemGrading(item);
        }
        catch (Exception e) {
            throw new GradingServiceException(e);
        }
    }
}

