/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.util.List;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.tool.assessment.data.dao.grading.MediaData;
import org.sakaiproject.tool.assessment.facade.AssessmentGradingFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaContentConverter {
    private static final String CONVERT_MEDIA_PROP = "samigo.convertMedia";
    private PersistenceService persistenceService;
    private AssessmentGradingFacadeQueriesAPI gq;
    private int recordsConverted = 0;
    private int recordsNotMarked = 0;
    private int recordsInError = 0;
    Logger log = LoggerFactory.getLogger(MediaContentConverter.class);

    public void init() {
        boolean convertMedia = ServerConfigurationService.getBoolean((String)CONVERT_MEDIA_PROP, (boolean)false);
        if (convertMedia) {
            this.gq = this.persistenceService.getAssessmentGradingFacadeQueries();
            this.convert();
        }
    }

    public void convert() {
        this.log.info("Starting Samigo Media Conversion...");
        List<Long> ids = this.gq.getMediaConversionBatch();
        if (ids.isEmpty()) {
            String summary = this.outstandingSummary();
            if ("".equals(summary)) {
                this.log.info("No remaining Media to convert.");
            } else {
                this.log.info("No Media can be converted, but there are outstanding errors:\n" + this.outstandingSummary());
            }
        } else {
            while (!ids.isEmpty()) {
                this.gq.markMediaForConversion(ids);
                for (Long mediaId : ids) {
                    this.convertMedia(mediaId);
                }
                this.log.info("Samigo Media Conversion in progress... " + this.summary());
                ids = this.gq.getMediaConversionBatch();
            }
            this.log.info("Samigo Media Conversion finished... " + this.summary());
            this.log.info(this.outstandingSummary());
        }
    }

    private void convertMedia(Long mediaId) {
        try {
            MediaData mediaData = this.gq.getMedia(mediaId);
            if ("CONVERTING".equals(mediaData.getLocation())) {
                mediaData.setLocation(null);
                this.gq.saveMedia(mediaData);
                this.log.debug("MediaData converted with ID: " + mediaId);
                ++this.recordsConverted;
            } else {
                this.log.debug("MediaData could not be marked as in progress, ID: " + mediaId);
                ++this.recordsNotMarked;
            }
        }
        catch (Exception e) {
            ++this.recordsInError;
            this.log.warn("Error converting MediaData with ID: " + mediaId, (Throwable)e);
        }
    }

    private String summary() {
        return String.format("%d records converted, %d records unsuccessfully processed", this.recordsConverted, this.recordsInError + this.recordsNotMarked);
    }

    private String outstandingSummary() {
        List<Long> withBoth = this.gq.getMediaWithDataAndLocation();
        List<Long> inProgress = this.gq.getMediaInConversion();
        if (withBoth.size() + inProgress.size() > 0) {
            String message = "%d records remaining with data and location, %d records remaining marked as in progress\n\tIDs with both fields: %s\n\tIDs marked in progress: %s";
            return String.format(message, withBoth.size(), inProgress.size(), withBoth, inProgress);
        }
        return "";
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

