/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.util.HashMap;
import java.util.Map;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.util.SamigoExpressionError;
import org.sakaiproject.tool.assessment.util.SamigoExpressionFunctions;

public class SamigoExpressionParser {
    public static String INFINITY = "Infinity";
    public static String NaN = "NaN";
    private String expr = "";
    private int expr_pos = -1;
    private char expr_c = '\u0000';
    private String token = "";
    private TOKENTYPE token_type;
    private double ans;
    private String ans_str;
    private Map<String, Double> user_var = new HashMap<String, Double>();

    public SamigoExpressionParser() {
        this.token_type = TOKENTYPE.NOTHING;
    }

    public String parse(String new_expr) throws SamigoExpressionError {
        return this.parse(new_expr, 5);
    }

    public String parse(String new_expr, int decimals) throws SamigoExpressionError {
        try {
            this.expr = new_expr;
            this.ans = 0.0;
            this.getFirstChar();
            this.getToken();
            if (this.token_type == TOKENTYPE.DELIMETER && this.expr_c == '\u0000') {
                throw new SamigoExpressionError(this.row(), this.col(), 4);
            }
            this.ans = this.parse_level1();
            if (this.token_type != TOKENTYPE.DELIMETER || this.token.length() > 0) {
                if (this.token_type == TOKENTYPE.DELIMETER) {
                    throw new SamigoExpressionError(this.row(), this.col(), 101, this.token);
                }
                throw new SamigoExpressionError(this.row(), this.col(), 5, this.token);
            }
            if (Double.isInfinite(this.ans)) {
                throw new SamigoExpressionError(402, this.expr);
            }
            if (Double.isNaN(this.ans)) {
                throw new SamigoExpressionError(401, this.expr);
            }
            GradingService service = new GradingService();
            this.ans_str = service.toScientificNotation(Double.toString(this.ans), decimals);
            this.user_var.put("ANS", Double.valueOf(this.ans_str));
        }
        catch (SamigoExpressionError err) {
            this.ans_str = err.get();
            throw err;
        }
        return this.ans_str;
    }

    boolean isMinus(char c) {
        return c == '-';
    }

    boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t';
    }

    boolean isDelimeter(char c) {
        return "&|<>=+/*%^!".indexOf(c) != -1;
    }

    boolean isNotDelimeter(char c) {
        return "&|<>=+-/*%^!()".indexOf(c) != -1;
    }

    boolean isAlpha(char c) {
        char cUpper = Character.toUpperCase(c);
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ_".indexOf(cUpper) != -1;
    }

    boolean isDigitDot(char c) {
        return "0123456789.".indexOf(c) != -1;
    }

    boolean isDigit(char c) {
        return "0123456789".indexOf(c) != -1;
    }

    boolean isLegalVariableName(String name) {
        String nameUpper = name.toUpperCase();
        if (nameUpper.equals("E")) {
            return false;
        }
        return !nameUpper.equals("PI");
    }

    void getChar() {
        ++this.expr_pos;
        this.expr_c = this.expr_pos < this.expr.length() ? this.expr.charAt(this.expr_pos) : (char)'\u0000';
    }

    void getFirstChar() {
        this.expr_pos = 0;
        this.expr_c = this.expr_pos < this.expr.length() ? this.expr.charAt(this.expr_pos) : (char)'\u0000';
    }

    void getToken() throws SamigoExpressionError {
        this.token_type = TOKENTYPE.NOTHING;
        this.token = "";
        while (this.isWhiteSpace(this.expr_c)) {
            this.getChar();
        }
        if (this.expr_c == '\u0000') {
            this.token_type = TOKENTYPE.DELIMETER;
            return;
        }
        if (this.expr_c == '-') {
            this.token_type = TOKENTYPE.DELIMETER;
            this.token = this.token + this.expr_c;
            this.getChar();
            return;
        }
        if (this.expr_c == '(' || this.expr_c == ')') {
            this.token_type = TOKENTYPE.DELIMETER;
            this.token = this.token + this.expr_c;
            this.getChar();
            return;
        }
        if (this.isDelimeter(this.expr_c)) {
            this.token_type = TOKENTYPE.DELIMETER;
            while (this.isDelimeter(this.expr_c)) {
                this.token = this.token + this.expr_c;
                this.getChar();
            }
            return;
        }
        if (this.isDigitDot(this.expr_c)) {
            this.token_type = TOKENTYPE.NUMBER;
            while (this.isDigitDot(this.expr_c)) {
                this.token = this.token + this.expr_c;
                this.getChar();
            }
            if (this.expr_c == 'e' || this.expr_c == 'E') {
                this.token = this.token + this.expr_c;
                this.getChar();
                if (this.expr_c == '+' || this.expr_c == '-') {
                    this.token = this.token + this.expr_c;
                    this.getChar();
                }
                while (this.isDigit(this.expr_c)) {
                    this.token = this.token + this.expr_c;
                    this.getChar();
                }
            }
            return;
        }
        if (this.isAlpha(this.expr_c)) {
            while (this.isAlpha(this.expr_c) || this.isDigit(this.expr_c)) {
                this.token = this.token + this.expr_c;
                this.getChar();
            }
            while (this.isWhiteSpace(this.expr_c)) {
                this.getChar();
            }
            this.token_type = this.expr_c == '(' ? TOKENTYPE.FUNCTION : TOKENTYPE.VARIABLE;
            return;
        }
        this.token_type = TOKENTYPE.UNKNOWN;
        while (this.expr_c != '\u0000') {
            this.token = this.token + this.expr_c;
            this.getChar();
        }
        throw new SamigoExpressionError(this.row(), this.col(), 1, this.token);
    }

    double parse_level1() throws SamigoExpressionError {
        if (this.token_type == TOKENTYPE.VARIABLE) {
            while (this.isWhiteSpace(this.expr_c)) {
                this.getChar();
            }
            if (this.expr_c == '=') {
                String var_name = this.token;
                this.getToken();
                this.getToken();
                double ans = this.parse_level2();
                if (!this.isLegalVariableName(var_name)) {
                    throw new SamigoExpressionError(this.row(), this.col(), 300);
                }
                this.user_var.put(var_name.toUpperCase(), new Double(ans));
                return ans;
            }
        }
        return this.parse_level2();
    }

    double parse_level2() throws SamigoExpressionError {
        double ans = this.parse_level3();
        OPERATOR op_id = this.get_operator_id(this.token);
        while (op_id == OPERATOR.AND || op_id == OPERATOR.OR || op_id == OPERATOR.BITSHIFTLEFT || op_id == OPERATOR.BITSHIFTRIGHT) {
            this.getToken();
            ans = this.eval_operator(op_id, ans, this.parse_level3());
            op_id = this.get_operator_id(this.token);
        }
        return ans;
    }

    double parse_level3() throws SamigoExpressionError {
        double ans = this.parse_level4();
        OPERATOR op_id = this.get_operator_id(this.token);
        while (op_id == OPERATOR.EQUAL || op_id == OPERATOR.UNEQUAL || op_id == OPERATOR.SMALLER || op_id == OPERATOR.LARGER || op_id == OPERATOR.SMALLEREQ || op_id == OPERATOR.LARGEREQ) {
            this.getToken();
            ans = this.eval_operator(op_id, ans, this.parse_level4());
            op_id = this.get_operator_id(this.token);
        }
        return ans;
    }

    double parse_level4() throws SamigoExpressionError {
        double ans = this.parse_level5();
        OPERATOR op_id = this.get_operator_id(this.token);
        while (op_id == OPERATOR.PLUS || op_id == OPERATOR.MINUS) {
            this.getToken();
            ans = this.eval_operator(op_id, ans, this.parse_level5());
            op_id = this.get_operator_id(this.token);
        }
        return ans;
    }

    double parse_level5() throws SamigoExpressionError {
        double ans = this.parse_level6();
        OPERATOR op_id = this.get_operator_id(this.token);
        while (op_id == OPERATOR.MULTIPLY || op_id == OPERATOR.DIVIDE || op_id == OPERATOR.MODULUS || op_id == OPERATOR.XOR) {
            this.getToken();
            ans = this.eval_operator(op_id, ans, this.parse_level6());
            op_id = this.get_operator_id(this.token);
        }
        return ans;
    }

    double parse_level6() throws SamigoExpressionError {
        double ans = this.parse_level7();
        OPERATOR op_id = this.get_operator_id(this.token);
        while (op_id == OPERATOR.POW) {
            this.getToken();
            ans = this.eval_operator(op_id, ans, this.parse_level7());
            op_id = this.get_operator_id(this.token);
        }
        return ans;
    }

    double parse_level7() throws SamigoExpressionError {
        double ans = this.parse_level8();
        OPERATOR op_id = this.get_operator_id(this.token);
        while (op_id == OPERATOR.FACTORIAL) {
            this.getToken();
            ans = this.eval_operator(op_id, ans, 0.0);
            op_id = this.get_operator_id(this.token);
        }
        return ans;
    }

    double parse_level8() throws SamigoExpressionError {
        double ans;
        OPERATOR op_id = this.get_operator_id(this.token);
        if (op_id == OPERATOR.MINUS) {
            this.getToken();
            ans = this.parse_level9();
            ans = -ans;
        } else {
            ans = this.parse_level9();
        }
        return ans;
    }

    double parse_level9() throws SamigoExpressionError {
        double ans;
        if (this.token_type == TOKENTYPE.FUNCTION) {
            String fn_name = this.token;
            this.getToken();
            ans = this.eval_function(fn_name, this.parse_level10());
        } else {
            ans = this.parse_level10();
        }
        return ans;
    }

    double parse_level10() throws SamigoExpressionError {
        if (this.token_type == TOKENTYPE.DELIMETER && this.token.equals("(")) {
            this.getToken();
            double ans = this.parse_level2();
            if (this.token_type != TOKENTYPE.DELIMETER || !this.token.equals(")")) {
                throw new SamigoExpressionError(this.row(), this.col(), 3);
            }
            this.getToken();
            return ans;
        }
        return this.parse_number();
    }

    double parse_number() throws SamigoExpressionError {
        double ans = 0.0;
        switch (this.token_type) {
            case NUMBER: {
                ans = Double.parseDouble(this.token);
                this.getToken();
                break;
            }
            case VARIABLE: {
                ans = this.eval_variable(this.token);
                this.getToken();
                break;
            }
            default: {
                if (this.token.length() == 0) {
                    throw new SamigoExpressionError(this.row(), this.col(), 6);
                }
                throw new SamigoExpressionError(this.row(), this.col(), 7);
            }
        }
        return ans;
    }

    OPERATOR get_operator_id(String op_name) {
        if (op_name.equals("&")) {
            return OPERATOR.AND;
        }
        if (op_name.equals("|")) {
            return OPERATOR.OR;
        }
        if (op_name.equals("<<")) {
            return OPERATOR.BITSHIFTLEFT;
        }
        if (op_name.equals(">>")) {
            return OPERATOR.BITSHIFTRIGHT;
        }
        if (op_name.equals("=")) {
            return OPERATOR.EQUAL;
        }
        if (op_name.equals("<>")) {
            return OPERATOR.UNEQUAL;
        }
        if (op_name.equals("<")) {
            return OPERATOR.SMALLER;
        }
        if (op_name.equals(">")) {
            return OPERATOR.LARGER;
        }
        if (op_name.equals("<=")) {
            return OPERATOR.SMALLEREQ;
        }
        if (op_name.equals(">=")) {
            return OPERATOR.LARGEREQ;
        }
        if (op_name.equals("+")) {
            return OPERATOR.PLUS;
        }
        if (op_name.equals("-")) {
            return OPERATOR.MINUS;
        }
        if (op_name.equals("*")) {
            return OPERATOR.MULTIPLY;
        }
        if (op_name.equals("/")) {
            return OPERATOR.DIVIDE;
        }
        if (op_name.equals("%")) {
            return OPERATOR.MODULUS;
        }
        if (op_name.equals("||")) {
            return OPERATOR.XOR;
        }
        if (op_name.equals("^")) {
            return OPERATOR.POW;
        }
        if (op_name.equals("!")) {
            return OPERATOR.FACTORIAL;
        }
        return OPERATOR.UNKNOWN;
    }

    double eval_operator(OPERATOR op_id, double lhs, double rhs) throws SamigoExpressionError {
        switch (op_id) {
            case AND: {
                return (int)lhs & (int)rhs;
            }
            case OR: {
                return (int)lhs | (int)rhs;
            }
            case BITSHIFTLEFT: {
                return (int)lhs << (int)rhs;
            }
            case BITSHIFTRIGHT: {
                return (int)lhs >> (int)rhs;
            }
            case EQUAL: {
                return lhs == rhs ? 1.0 : 0.0;
            }
            case UNEQUAL: {
                return lhs != rhs ? 1.0 : 0.0;
            }
            case SMALLER: {
                return lhs < rhs ? 1.0 : 0.0;
            }
            case LARGER: {
                return lhs > rhs ? 1.0 : 0.0;
            }
            case SMALLEREQ: {
                return lhs <= rhs ? 1.0 : 0.0;
            }
            case LARGEREQ: {
                return lhs >= rhs ? 1.0 : 0.0;
            }
            case PLUS: {
                return lhs + rhs;
            }
            case MINUS: {
                return lhs - rhs;
            }
            case MULTIPLY: {
                return lhs * rhs;
            }
            case DIVIDE: {
                return lhs / rhs;
            }
            case MODULUS: {
                return SamigoExpressionFunctions.modulus(lhs, rhs);
            }
            case XOR: {
                return (int)lhs ^ (int)rhs;
            }
            case POW: {
                return Math.pow(lhs, rhs);
            }
            case FACTORIAL: {
                return SamigoExpressionFunctions.factorial(lhs);
            }
        }
        throw new SamigoExpressionError(this.row(), this.col(), 104);
    }

    double eval_function(String fn_name, double value) throws SamigoExpressionError {
        String fnUpper = fn_name.toUpperCase();
        if (fnUpper.equals("ABS")) {
            return Math.abs(value);
        }
        if (fnUpper.equals("EXP")) {
            return Math.exp(value);
        }
        if (fnUpper.equals("SIGN")) {
            return SamigoExpressionFunctions.sign(value);
        }
        if (fnUpper.equals("SQRT")) {
            return Math.sqrt(value);
        }
        if (fnUpper.equals("LOG") || fnUpper.equals("LN")) {
            return Math.log(value);
        }
        if (fnUpper.equals("LOG10")) {
            return Math.log10(value);
        }
        if (fnUpper.equals("SIN")) {
            return Math.sin(value);
        }
        if (fnUpper.equals("COS")) {
            return Math.cos(value);
        }
        if (fnUpper.equals("TAN")) {
            return Math.tan(value);
        }
        if (fnUpper.equals("ASIN")) {
            return Math.asin(value);
        }
        if (fnUpper.equals("ACOS")) {
            return Math.acos(value);
        }
        if (fnUpper.equals("ATAN")) {
            return Math.atan(value);
        }
        if (fnUpper.equals("FACTORIAL")) {
            return SamigoExpressionFunctions.factorial(value);
        }
        throw new SamigoExpressionError(this.row(), this.col(), 102, fn_name);
    }

    double eval_variable(String var_name) throws SamigoExpressionError {
        String varUpper = var_name.toUpperCase();
        if (varUpper.equals("E")) {
            return Math.E;
        }
        if (varUpper.equals("PI")) {
            return Math.PI;
        }
        if (this.user_var.containsKey(varUpper)) {
            double ans = this.user_var.get(varUpper);
            return ans;
        }
        throw new SamigoExpressionError(this.row(), this.col(), 103, var_name);
    }

    int row() {
        return -1;
    }

    int col() {
        return this.expr_pos - this.token.length() + 1;
    }

    private static enum OPERATOR {
        UNKNOWN,
        AND,
        OR,
        BITSHIFTLEFT,
        BITSHIFTRIGHT,
        EQUAL,
        UNEQUAL,
        SMALLER,
        LARGER,
        SMALLEREQ,
        LARGEREQ,
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        MODULUS,
        XOR,
        POW,
        FACTORIAL;

    }

    private static enum TOKENTYPE {
        NOTHING,
        DELIMETER,
        NUMBER,
        VARIABLE,
        FUNCTION,
        UNKNOWN;

    }
}

