/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.BackfillItemHashResult;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.ItemHashUtil;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.integration.helper.ifc.TagServiceHelper;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public class ItemFacadeQueries
extends HibernateDaoSupport
implements ItemFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(ItemFacadeQueries.class);
    private ItemHashUtil itemHashUtil;
    private static final Map<String, String> BACKFILL_HASHES_HQL = new HashMap<String, String>(){
        {
            this.put("total.item.count.hql", "select count(*) from ItemData");
            this.put("total.hash.backfillable.item.count.hql", "select count(*) from ItemData as item where item.hash is null");
            this.put("all.backfillable.item.ids.hql", "select item.id from ItemData as item where item.hash is null");
            this.put("items.by.id.hql", "select item from ItemData as item where item.id in ({ID_PARAMS})");
        }
    };

    public void setItemHashUtil(ItemHashUtil itemHashUtil) {
        this.itemHashUtil = itemHashUtil;
    }

    @Override
    public IdImpl getItemId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getItemId(long id) {
        return new IdImpl(id);
    }

    @Override
    public List getQPItems(Long questionPoolId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select ab from ItemData ab, QuestionPoolItem qpi where qpi.itemId=ab.itemIdString and qpi.questionPoolId = :id");
            q.setLong("id", questionPoolId.longValue());
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List list() {
        return this.getHibernateTemplate().find("from ItemData", new Object[0]);
    }

    @Override
    public void show(Long itemId) {
        this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
    }

    @Override
    public ItemFacade getItem(Long itemId, String agent) {
        return this.getItem(itemId);
    }

    @Override
    public void showType(Long typeId) {
        this.getHibernateTemplate().load(TypeD.class, (Serializable)typeId);
    }

    @Override
    public void listType() {
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        TypeFacade f = typeFacadeQueries.getTypeFacadeById(1L);
        log.debug("***facade: " + f.getAuthority());
    }

    @Override
    public void remove(Long itemId) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        AssessmentService service = new AssessmentService();
        List itemAttachmentList = service.getItemResourceIdList((ItemDataIfc)item);
        service.deleteResources(itemAttachmentList);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().delete((Object)item);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleting item : " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        if (item != null) {
            this.printItem(item);
        }
    }

    @Override
    public void deleteItem(Long itemId, String agent) {
        ItemData item = null;
        try {
            item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        }
        catch (DataAccessException e) {
            log.warn("unable to retrieve item " + itemId + " due to:" + (Object)((Object)e));
            return;
        }
        AssessmentService service = new AssessmentService();
        List itemAttachmentList = service.getItemResourceIdList((ItemDataIfc)item);
        service.deleteResources(itemAttachmentList);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                SectionDataIfc section = item.getSection();
                if (section != null) {
                    Set set = section.getItemSet();
                    set.remove(item);
                }
                this.getHibernateTemplate().delete((Object)item);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleting item: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deleteItemContent(Long itemId, String agent) {
        Set set;
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemTextSet();
                    item.setItemTextSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleteItemTextSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemMetaDataSet();
                    item.setItemMetaDataSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleteItemMetaDataSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
        retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    set = item.getItemFeedbackSet();
                    item.setItemFeedbackSet(new HashSet());
                    this.getHibernateTemplate().deleteAll((Collection)set);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleting ItemFeedbackSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void deleteItemMetaData(Long itemId, String label) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from ItemMetaData imd where imd.item.itemId = :id and imd.label = :label");
            q.setLong("id", itemId.longValue());
            q.setString("label", label);
            return q.list();
        };
        List itemmetadatalist = (List)this.getHibernateTemplate().execute(hcb);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (item != null) {
                    for (ItemMetaDataIfc meta : itemmetadatalist) {
                        meta.setItem(null);
                    }
                    Set set = item.getItemMetaDataSet();
                    set.removeAll(itemmetadatalist);
                    item.setItemMetaDataSet(set);
                    this.getHibernateTemplate().deleteAll((Collection)itemmetadatalist);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete itemmetadatalist: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void addItemMetaData(Long itemId, String label, String value) {
        ItemData item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        if (item != null) {
            this.printItem(item);
            ItemMetaData itemmetadata = new ItemMetaData((ItemDataIfc)item, label, value);
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().save((Object)itemmetadata);
                    retryCount = 0;
                }
                catch (Exception e) {
                    log.warn("problem saving itemmetadata: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
        }
    }

    private void printItem(ItemData item) {
        log.debug("**Id = " + item.getItemId());
        log.debug("**score = " + item.getScore());
        log.debug("**grade = " + item.getGrade());
        log.debug("**CorrectFeedback is lazy = " + item.getCorrectItemFeedback());
        log.debug("**Objective not lazy = " + item.getItemMetaDataByLabel("ITEM_OBJECTIVE"));
    }

    @Override
    public void ifcShow(Long itemId) {
        ItemDataIfc itemData = (ItemDataIfc)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        if (itemData != null) {
            this.printIfcItem(itemData);
            this.printFacadeItem(itemData);
        }
    }

    @Override
    public ItemFacade saveItem(ItemFacade item) throws DataFacadeException {
        try {
            ItemDataIfc itemdata = item.getData();
            itemdata.setLastModifiedDate(new Date());
            itemdata.setLastModifiedBy(AgentFacade.getAgentString());
            itemdata.setHash(this.itemHashUtil.hashItem(itemdata));
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().saveOrUpdate((Object)itemdata);
                    item.setItemId(itemdata.getItemId());
                    retryCount = 0;
                }
                catch (Exception e) {
                    log.warn("problem save or update itemdata: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
            if (item.getData() != null && item.getData().getSection() != null) {
                AssessmentIfc assessment = item.getData().getSection().getAssessment();
                assessment.setLastModifiedBy(AgentFacade.getAgentString());
                assessment.setLastModifiedDate(new Date());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
                while (retryCount > 0) {
                    try {
                        this.getHibernateTemplate().update((Object)assessment);
                        retryCount = 0;
                    }
                    catch (Exception e) {
                        log.warn("problem updating asssessment: " + e.getMessage());
                        retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                    }
                }
            }
            return item;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public BackfillItemHashResult backfillItemHashes(int batchSize) {
        return this.itemHashUtil.backfillItemHashes(batchSize, BACKFILL_HASHES_HQL, ItemData.class, i -> {
            String hash = this.itemHashUtil.hashItemUnchecked((ItemDataIfc)i);
            i.setHash(hash);
            return i;
        }, this.getHibernateTemplate());
    }

    private void printIfcItem(ItemDataIfc item) {
        log.debug("**Id = " + item.getItemId());
        log.debug("**score = " + item.getScore());
        log.debug("**grade = " + item.getGrade());
        log.debug("**CorrectFeedback is lazy = " + item.getCorrectItemFeedback());
        log.debug("**Objective not lazy = " + item.getItemMetaDataByLabel("ITEM_OBJECTIVE"));
        log.debug("**createdDate = " + item.getCreatedDate());
    }

    private void printFacadeItem(ItemDataIfc item) {
        ItemFacade f = new ItemFacade(item);
        log.debug("****Id = " + f.getItemId());
        log.debug("****score = " + f.getScore());
        log.debug("****grade = " + f.getGrade());
        log.debug("****CorrectFeedback is lazy = " + f.getCorrectItemFeedback());
        log.debug("****Objective not lazy = " + f.getItemMetaDataByLabel("ITEM_OBJECTIVE"));
        log.debug("****createdDate = " + f.getCreatedDate());
        log.debug("****ItemType = " + f.getItemType().getKeyword());
    }

    @Override
    public ItemFacade getItem(Long itemId) {
        ItemData item = null;
        try {
            item = (ItemData)this.getHibernateTemplate().load(ItemData.class, (Serializable)itemId);
        }
        catch (DataAccessException e) {
            log.warn("unable to retrieve item " + itemId + " due to:", (Throwable)e);
            return null;
        }
        return new ItemFacade((ItemDataIfc)item);
    }

    @Override
    public Boolean itemExists(Long itemId) {
        try {
            if (this.getHibernateTemplate().get(ItemData.class, (Serializable)itemId) == null) {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Map<String, ItemFacade> getItemsByHash(String hash) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from ItemData where hash = ? ");
            q.setString(0, hash);
            return q.list();
        };
        List list1 = (List)this.getHibernateTemplate().execute(hcb);
        HashMap<String, ItemFacade> itemFacadeMap = new HashMap<String, ItemFacade>();
        for (int i = 0; i < list1.size(); ++i) {
            ItemData a = (ItemData)list1.get(i);
            ItemFacade f = new ItemFacade((ItemDataIfc)a);
            itemFacadeMap.put(f.getItemIdString(), f);
        }
        return itemFacadeMap;
    }

    @Override
    public Map<String, ItemFacade> getItemsByKeyword(String keyword) {
        ItemFacade f;
        ItemData a;
        int i;
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select ab from ItemData ab, ItemText itext where itext.item=ab and itext.text like :text");
            q.setString("text", keyword);
            return q.list();
        };
        List list1 = (List)this.getHibernateTemplate().execute(hcb);
        HibernateCallback hcb2 = session -> {
            Query q = session.createQuery("select distinct ab from ItemData ab, Answer answer where answer.item=ab and answer.text like :text");
            q.setString("text", keyword);
            return q.list();
        };
        List list2 = (List)this.getHibernateTemplate().execute(hcb2);
        HibernateCallback hcb3 = session -> {
            Query q = session.createQuery("select ab from ItemData ab, ItemMetaData md where md.item=ab and md.entry like :keyword and md.label = :label");
            q.setString("keyword", keyword);
            q.setString("label", "KEYWORD");
            return q.list();
        };
        List list3 = (List)this.getHibernateTemplate().execute(hcb3);
        HibernateCallback hcb4 = session -> {
            Query q = session.createQuery("select ab from ItemData ab where ab.instruction like :keyword");
            q.setString("keyword", keyword);
            return q.list();
        };
        List list4 = (List)this.getHibernateTemplate().execute(hcb4);
        HashMap<String, ItemFacade> itemfacadeMap = new HashMap<String, ItemFacade>();
        for (i = 0; i < list1.size(); ++i) {
            a = (ItemData)list1.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list2.size(); ++i) {
            a = (ItemData)list2.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list3.size(); ++i) {
            a = (ItemData)list3.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        for (i = 0; i < list4.size(); ++i) {
            a = (ItemData)list4.get(i);
            f = new ItemFacade((ItemDataIfc)a);
            itemfacadeMap.put(f.getItemIdString(), f);
        }
        log.debug("Search for keyword, found: " + itemfacadeMap.size());
        return itemfacadeMap;
    }

    @Override
    public Long getItemTextId(Long publishedItemId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select i.id from PublishedItemText i where i.item.itemId = :id");
            q.setLong("id", publishedItemId.longValue());
            return q.list();
        };
        List list = (List)this.getHibernateTemplate().execute(hcb);
        log.debug("list.size() = " + list.size());
        Long itemTextId = -1L;
        if (!list.isEmpty()) {
            itemTextId = (Long)list.get(0);
        }
        log.debug("itemTextId" + itemTextId);
        return itemTextId;
    }

    @Override
    public void deleteSet(Set s) {
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                if (s != null) {
                    this.getHibernateTemplate().deleteAll((Collection)s);
                    retryCount = 0;
                    continue;
                }
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem deleteSet: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void updateItemTagBindingsHavingTag(TagServiceHelper.TagView tagView) {
        this.getHibernateTemplate().bulkUpdate("update ItemTag it set it.tagLabel = ?, it.tagCollectionId = ?, it.tagCollectionName = ? where it.tagId = ?", new Object[]{tagView.tagLabel, tagView.tagCollectionId, tagView.tagCollectionName, tagView.tagId});
    }

    @Override
    public void deleteItemTagBindingsHavingTagId(String tagId) {
        this.getHibernateTemplate().bulkUpdate("delete ItemTag it where it.tagId = ?", new Object[]{tagId});
    }

    @Override
    public void updateItemTagBindingsHavingTagCollection(TagServiceHelper.TagCollectionView tagCollectionView) {
        this.getHibernateTemplate().bulkUpdate("update ItemTag it set it.tagCollectionName = ? where it.tagCollectionId = ?", new Object[]{tagCollectionView.tagCollectionName, tagCollectionView.tagCollectionId});
    }

    @Override
    public void deleteItemTagBindingsHavingTagCollectionId(String tagCollectionId) {
        this.getHibernateTemplate().bulkUpdate("delete ItemTag it where it.tagCollectionId = ?", new Object[]{tagCollectionId});
    }

    @Override
    public List<Long> getItemsIdsByHash(String hash) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select ab.itemId from ItemData ab where ab.hash = ? ");
            q.setString(0, hash);
            return q.list();
        };
        List list1 = (List)this.getHibernateTemplate().execute(hcb);
        return list1;
    }

    @Override
    public Long getAssessmentId(Long itemId) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("select s.assessment.assessmentBaseId from SectionData s, ItemData i where s.id = i.section AND i.itemId = ?");
            q.setLong(0, itemId.longValue());
            return q.list();
        };
        List list1 = (List)this.getHibernateTemplate().execute(hcb);
        if (list1.isEmpty()) {
            return -1L;
        }
        return (Long)list1.get(0);
    }
}

