/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.osid.shared.Id;
import org.osid.shared.SharedException;
import org.sakaiproject.tool.assessment.business.questionpool.QuestionPool;
import org.sakaiproject.tool.assessment.business.questionpool.QuestionPoolException;
import org.sakaiproject.tool.assessment.data.dao.questionpool.QuestionPoolData;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.questionpool.QuestionPoolItemIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.AgentDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.AgentFacade;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.questionpool.impl.QuestionPoolImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionPoolFacade
implements Serializable,
QuestionPoolDataIfc,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(QuestionPoolFacade.class);
    private static final long serialVersionUID = 7526471155622776147L;
    public static final Long ACCESS_DENIED = 30L;
    public static final Long READ_ONLY = 31L;
    public static final Long READ_COPY = 32L;
    public static final Long READ_WRITE = 33L;
    public static final Long ADMIN = 34L;
    public static final Long DEFAULT_TYPEID = 0L;
    public static final Long DEFAULT_INTELLECTUAL_PROPERTYID = 0L;
    public static final Long ROOT_POOL = 0L;
    private QuestionPool questionPool;
    private String displayName;
    private String description;
    private QuestionPoolDataIfc data;
    private Id id;
    private TypeIfc questionPoolType;
    private Id parentId;
    private Long questionPoolId;
    private Long parentPoolId;
    private String ownerId;
    private AgentDataIfc owner;
    private String title;
    private Date dateCreated;
    private Date lastModified;
    private String lastModifiedById;
    private AgentDataIfc lastModifiedBy;
    private Long accessTypeId;
    private TypeIfc accessType;
    private String objectives;
    private String keywords;
    private String rubric;
    private Long typeId;
    private TypeIfc type;
    private Long intellectualPropertyId;
    private String organizationName;
    private Set questionPoolItems;
    private Collection items = new ArrayList();
    private Long subPoolSize;

    public QuestionPoolFacade() {
        this.data = new QuestionPoolData();
        QuestionPoolImpl questionPoolImpl = new QuestionPoolImpl();
        this.questionPool = questionPoolImpl;
        try {
            this.questionPool.updateData((Serializable)this.data);
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public QuestionPoolFacade(Id id, Id parentId) {
        this.id = id;
        this.parentId = parentId;
        this.data = new QuestionPoolData();
        QuestionPoolImpl questionPoolImpl = new QuestionPoolImpl();
        this.questionPool = questionPoolImpl;
        try {
            this.questionPool.updateData((Serializable)this.data);
            this.setQuestionPoolId(new Long(id.getIdString()));
            this.setParentPoolId(new Long(parentId.getIdString()));
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        catch (SharedException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        catch (NumberFormatException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public QuestionPoolFacade(Long id, Long parentId) {
        QuestionPoolFacadeQueriesAPI questionPoolFacadeQueries = PersistenceService.getInstance().getQuestionPoolFacadeQueries();
        this.id = questionPoolFacadeQueries.getQuestionPoolId(id);
        this.parentId = questionPoolFacadeQueries.getQuestionPoolId(parentId);
        this.data = new QuestionPoolData();
        QuestionPoolImpl questionPoolImpl = new QuestionPoolImpl();
        this.questionPool = questionPoolImpl;
        try {
            this.questionPool.updateData((Serializable)this.data);
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.setQuestionPoolId(id);
        this.setParentPoolId(parentId);
    }

    public QuestionPoolFacade(QuestionPoolDataIfc data) {
        this.data = data;
        QuestionPoolImpl questionPoolImpl = new QuestionPoolImpl();
        this.questionPool = questionPoolImpl;
        try {
            this.questionPool.updateData((Serializable)this.data);
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.id = this.getId();
        this.displayName = this.getTitle();
        this.description = this.getDescription();
        this.questionPoolType = this.getType();
        this.ownerId = this.getOwnerId();
        this.owner = this.getOwner();
        this.dateCreated = this.getDateCreated();
        this.lastModified = this.getLastModified();
        this.lastModifiedBy = this.getLastModifiedBy();
        this.lastModifiedById = this.getLastModifiedById();
        this.accessTypeId = this.getAccessTypeId();
        this.accessType = this.getAccessType();
        this.objectives = this.getObjectives();
        this.keywords = this.getKeywords();
        this.rubric = this.getRubric();
        this.typeId = this.getTypeId();
        this.type = this.getType();
        this.intellectualPropertyId = this.getIntellectualPropertyId();
        this.organizationName = this.getOrganizationName();
        this.questionPoolItems = this.getQuestionPoolItems();
        this.items = this.getQuestions();
        try {
            this.parentId = this.getParentId();
        }
        catch (Exception ex1) {
            throw new DataFacadeException(ex1.getMessage());
        }
    }

    public QuestionPoolFacade(Long id, String title) {
        this.questionPoolId = id;
        this.title = title;
        this.data = new QuestionPoolData();
        QuestionPoolImpl questionPoolImpl = new QuestionPoolImpl();
        this.questionPool = questionPoolImpl;
        try {
            this.questionPool.updateData((Serializable)this.data);
            this.setQuestionPoolId(id);
            this.setTitle(title);
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public QuestionPoolFacade(Long id, String title, Long parentId) {
        this.questionPoolId = id;
        this.title = title;
        this.parentPoolId = parentId;
        this.data = new QuestionPoolData();
        QuestionPoolImpl questionPoolImpl = new QuestionPoolImpl();
        this.questionPool = questionPoolImpl;
        try {
            this.questionPool.updateData((Serializable)this.data);
            this.setParentPoolId(parentId);
            this.setQuestionPoolId(id);
            this.setTitle(title);
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    Id getId() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        QuestionPoolFacadeQueriesAPI questionPoolFacadeQueries = PersistenceService.getInstance().getQuestionPoolFacadeQueries();
        return questionPoolFacadeQueries.getQuestionPoolId(this.data.getQuestionPoolId());
    }

    public String getDisplayName() throws DataFacadeException {
        return this.getTitle();
    }

    public void updateDisplayName(String displayName) throws DataFacadeException {
        this.setDisplayName(displayName);
    }

    private void setDisplayName(String displayName) throws DataFacadeException {
        this.displayName = displayName;
        this.data.setTitle(displayName);
    }

    public String getDescription() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDescription();
    }

    public void updateDescription(String description) throws DataFacadeException {
        this.setDescription(description);
    }

    public void setDescription(String description) {
        this.description = description;
        this.data.setDescription(description);
    }

    public QuestionPoolDataIfc getData() {
        return this.data;
    }

    public void updateData(QuestionPoolDataIfc data) {
        this.setData(data);
    }

    public void setData(QuestionPoolDataIfc data) {
        this.data = data;
    }

    public TypeIfc getQuestionPoolType() throws DataFacadeException {
        return this.getType();
    }

    public void updateQuestionPoolType(TypeIfc questionPoolType) throws DataFacadeException {
        this.setQuestionPoolType(questionPoolType);
    }

    private void setQuestionPoolType(TypeIfc questionPoolType) throws DataFacadeException {
        this.questionPoolType = questionPoolType;
        this.setType(questionPoolType);
    }

    public Id getParentId() throws DataFacadeException {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
            if (this.data != null) {
                QuestionPoolFacadeQueriesAPI questionPoolFacadeQueries = PersistenceService.getInstance().getQuestionPoolFacadeQueries();
                return questionPoolFacadeQueries.getQuestionPoolId(this.data.getParentPoolId());
            }
            return null;
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public void setParentId(Id parentId) throws DataFacadeException {
        this.parentId = parentId;
        try {
            this.setParentPoolId(new Long(parentId.getIdString()));
        }
        catch (SharedException ex) {
            log.warn(ex.getMessage());
        }
        catch (NumberFormatException ex) {
            log.warn(ex.getMessage());
        }
    }

    public Long getQuestionPoolId() throws DataFacadeException {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getQuestionPoolId();
    }

    public void setQuestionPoolId(Long questionPoolId) {
        this.questionPoolId = questionPoolId;
        this.data.setQuestionPoolId(questionPoolId);
    }

    public String getTitle() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTitle();
    }

    public void setTitle(String title) {
        this.title = title;
        this.data.setTitle(title);
    }

    public Long getParentPoolId() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        if (this.data != null) {
            return this.data.getParentPoolId();
        }
        return null;
    }

    public void setParentPoolId(Long parentPoolId) {
        this.parentPoolId = parentPoolId;
        this.data.setParentPoolId(parentPoolId);
    }

    public String getOwnerId() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getOwnerId();
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
        this.data.setOwnerId(ownerId);
    }

    public AgentDataIfc getOwner() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getOwner();
    }

    public void setOwner(AgentDataIfc owner) {
        this.owner = owner;
        this.data.setOwner(owner);
    }

    public Date getDateCreated() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDateCreated();
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this.data.setDateCreated(dateCreated);
    }

    public Date getLastModified() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModified();
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        this.data.setLastModified(lastModified);
    }

    public String getLastModifiedById() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedById();
    }

    public void setLastModifiedById(String lastModifiedById) {
        this.lastModifiedById = lastModifiedById;
        this.data.setLastModifiedById(lastModifiedById);
    }

    public AgentDataIfc getLastModifiedBy() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedBy();
    }

    public void setLastModifiedBy(AgentDataIfc lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        this.data.setLastModifiedBy(lastModifiedBy);
    }

    public Long getAccessTypeId() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAccessTypeId();
    }

    public void setAccessTypeId(Long accessTypeId) {
        this.accessTypeId = accessTypeId;
        this.data.setAccessTypeId(accessTypeId);
    }

    public TypeIfc getAccessType() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAccessType();
    }

    public void setAccessType(TypeIfc accessType) {
        this.accessType = accessType;
        this.data.setAccessType(accessType);
    }

    public String getObjectives() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getObjectives();
    }

    public void setObjectives(String objectives) {
        this.objectives = objectives;
        this.data.setObjectives(objectives);
    }

    public String getKeywords() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getKeywords();
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
        this.data.setKeywords(keywords);
    }

    public String getRubric() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getRubric();
    }

    public void setRubric(String rubric) {
        this.rubric = rubric;
        this.data.setRubric(rubric);
    }

    public Long getTypeId() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTypeId();
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
        this.data.setTypeId(typeId);
    }

    public TypeIfc getType() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getType();
    }

    public void setType(TypeIfc type) {
        this.type = type;
        this.data.setType(type);
    }

    public Long getIntellectualPropertyId() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getIntellectualPropertyId();
    }

    public void setIntellectualPropertyId(Long intellectualPropertyId) {
        this.intellectualPropertyId = intellectualPropertyId;
        this.data.setIntellectualPropertyId(intellectualPropertyId);
    }

    public String getOrganizationName() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getOrganizationName();
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
        this.data.setOrganizationName(organizationName);
    }

    public Set getQuestionPoolItems() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getQuestionPoolItems();
    }

    public void setQuestionPoolItems(Set questionPoolItems) {
        this.questionPoolItems = questionPoolItems;
        this.data.setQuestionPoolItems(questionPoolItems);
    }

    public void addQuestionPoolItem(QuestionPoolItemIfc queestionPoolItem) {
        Set questionPoolItemSet = this.getQuestionPoolItems();
        questionPoolItemSet.add(queestionPoolItem);
        this.setQuestionPoolItems(questionPoolItemSet);
    }

    public Collection getQuestions() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getQuestions();
    }

    public void setQuestions(Collection items) {
        this.items = items;
        this.data.setQuestions(items);
    }

    public Integer getQuestionSize() {
        return this.items.size();
    }

    public void setSubPoolSize(Long subPoolSize) {
        this.subPoolSize = subPoolSize;
        this.data.setSubPoolSize(subPoolSize);
    }

    public Long getSubPoolSize() {
        try {
            this.data = (QuestionPoolDataIfc)this.questionPool.getData();
        }
        catch (QuestionPoolException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getSubPoolSize();
    }

    public Object clone() {
        QuestionPoolFacade newPool = new QuestionPoolFacade((QuestionPoolDataIfc)((QuestionPoolData)this.data.clone()));
        return newPool;
    }

    public String getOwnerDisplayName() {
        String ownerIdString = this.getOwnerId();
        String ownerDisplayName = AgentFacade.getDisplayName(ownerIdString);
        return ownerDisplayName;
    }
}

