/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.authz;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sakaiproject.tool.assessment.data.dao.authz.AuthorizationData;
import org.sakaiproject.tool.assessment.data.dao.authz.QualifierData;
import org.sakaiproject.tool.assessment.data.ifc.authz.AuthorizationIfc;
import org.sakaiproject.tool.assessment.data.ifc.authz.QualifierIfc;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.authz.AuthorizationFacade;
import org.sakaiproject.tool.assessment.facade.authz.AuthorizationFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.authz.QualifierFacade;
import org.sakaiproject.tool.assessment.facade.authz.QualifierIteratorFacade;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public class AuthorizationFacadeQueries
extends HibernateDaoSupport
implements AuthorizationFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationFacadeQueries.class);

    @Override
    public QualifierIteratorFacade getQualifierParents(String qualifierId) {
        HibernateCallback hcb = session -> session.createQuery("select p from QualifierData as p, QualifierData as c, QualifierHierarchyData as q where p.qualifierId = q.parentId and c.qualifierId = q.childId and q.childId = :id").setString("id", qualifierId).list();
        List parents = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<QualifierFacade> a = new ArrayList<QualifierFacade>();
        for (QualifierData data : parents) {
            QualifierFacade qf = new QualifierFacade((QualifierIfc)data);
            a.add(qf);
        }
        return new QualifierIteratorFacade(a);
    }

    @Override
    public QualifierIteratorFacade getQualifierChildren(String qualifierId) {
        HibernateCallback hcb = session -> session.createQuery("select p from QualifierData as p, QualifierData as c, QualifierHierarchyData as q where p.qualifierId = q.parentId and c.qualifierId = q.childId and q.parentId = :id").setString("id", qualifierId).list();
        List children = (List)this.getHibernateTemplate().execute(hcb);
        ArrayList<QualifierFacade> a = new ArrayList<QualifierFacade>();
        for (QualifierData data : children) {
            QualifierFacade qf = new QualifierFacade((QualifierIfc)data);
            a.add(qf);
        }
        return new QualifierIteratorFacade(a);
    }

    @Override
    public void showQualifiers(QualifierIteratorFacade iter) {
        while (iter.hasNextQualifier()) {
        }
    }

    @Override
    public void addAuthz(AuthorizationIfc a) {
        AuthorizationData data = a instanceof AuthorizationFacade ? (AuthorizationData)((AuthorizationFacade)a).getData() : (AuthorizationData)a;
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem adding authorization: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    @Override
    public void addQualifier(QualifierIfc q) {
        QualifierData data = q instanceof QualifierFacade ? (QualifierData)((QualifierFacade)q).getData() : (QualifierData)q;
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().save((Object)data);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem adding Qualifier: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }

    public static void main(String[] args) throws DataFacadeException {
        AuthorizationFacadeQueries instance = new AuthorizationFacadeQueries();
        if (args[0].equals("listChild")) {
            QualifierIteratorFacade childrenIter = instance.getQualifierChildren(args[1]);
            instance.showQualifiers(childrenIter);
        }
        if (args[0].equals("addAuthz")) {
            AuthorizationFacade a = new AuthorizationFacade(args[1], args[2], args[3], new Date(), null, "2", new Date(), Boolean.TRUE);
            instance.addAuthz(a);
        }
        System.exit(0);
    }
}

