/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.context;

import org.sakaiproject.tool.assessment.integration.context.spring.FactoryUtil;
import org.sakaiproject.tool.assessment.integration.helper.ifc.AgentHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.CalendarServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.PublishingTargetHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.SectionAwareServiceHelper;
import org.sakaiproject.tool.assessment.integration.helper.ifc.ServerConfigurationServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IntegrationContextFactory {
    private static final Logger log = LoggerFactory.getLogger(IntegrationContextFactory.class);
    private static IntegrationContextFactory instance = null;

    public static IntegrationContextFactory getInstance() {
        log.debug("IntegrationContextFactory.getInstance()");
        if (instance == null) {
            try {
                FactoryUtil.setUseLocator(true);
                instance = FactoryUtil.lookup();
            }
            catch (Exception ex) {
                log.error("Unable to read integration context", (Throwable)ex);
            }
        }
        log.debug("instance=" + instance);
        return instance;
    }

    public static IntegrationContextFactory getTestInstance() {
        log.debug("IntegrationContextFactory.getTestInstance()");
        if (instance == null) {
            try {
                FactoryUtil.setUseLocator(false);
                instance = FactoryUtil.lookup();
            }
            catch (Exception ex) {
                log.error("Unable to read integration context: " + ex);
            }
        }
        log.debug("instance=" + instance);
        return instance;
    }

    public abstract boolean isIntegrated();

    public abstract AgentHelper getAgentHelper();

    public abstract GradebookHelper getGradebookHelper();

    public abstract GradebookServiceHelper getGradebookServiceHelper();

    public abstract PublishingTargetHelper getPublishingTargetHelper();

    public abstract SectionAwareServiceHelper getSectionAwareServiceHelper();

    public abstract ServerConfigurationServiceHelper getServerConfigurationServiceHelper();

    public abstract CalendarServiceHelper getCalendarServiceHelper();
}

