/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.Optional;
import org.sakaiproject.event.api.NotificationService;
import org.sakaiproject.tags.api.Tag;
import org.sakaiproject.tags.api.TagCollection;
import org.sakaiproject.tags.api.TagService;
import org.sakaiproject.tool.assessment.integration.helper.ifc.TagEventHandler;
import org.sakaiproject.tool.assessment.integration.helper.ifc.TagServiceHelper;

public class TagServiceHelperImpl
implements TagServiceHelper {
    private NotificationService notificationService;
    private TagService tagService;

    @Override
    public void registerTagEventHandler(TagEventHandler tagEventHandler) {
        tagEventHandler.registerEventCallbacks(this.notificationService);
    }

    @Override
    public Optional<TagServiceHelper.TagView> findTagById(String id) {
        Optional results = this.tagService.getTags().getForId(id);
        if (results.isPresent()) {
            Tag tag = (Tag)results.get();
            TagServiceHelper.TagView tagView = new TagServiceHelper.TagView(tag.getTagId(), tag.getTagLabel(), tag.getTagCollectionId(), tag.getCollectionName());
            return Optional.of(tagView);
        }
        return Optional.empty();
    }

    @Override
    public Optional<TagServiceHelper.TagCollectionView> findTagCollectionById(String id) {
        Optional results = this.tagService.getTagCollections().getForId(id);
        if (results.isPresent()) {
            TagCollection tagCollection = (TagCollection)results.get();
            TagServiceHelper.TagCollectionView tagView = new TagServiceHelper.TagCollectionView(tagCollection.getTagCollectionId(), tagCollection.getName());
            return Optional.of(tagView);
        }
        return Optional.empty();
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setTagService(TagService tagService) {
        this.tagService = tagService;
    }
}

