/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobExecutionException;
import org.sakaiproject.api.app.scheduler.ConfigurableJobPropertyValidationException;
import org.sakaiproject.api.app.scheduler.ConfigurableJobPropertyValidator;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.app.scheduler.jobs.AbstractConfigurableJob;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.assessment.facade.BackfillItemHashResult;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PublishedItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackfillItemHashesJob
extends AbstractConfigurableJob {
    private static final Logger log = LoggerFactory.getLogger(BackfillItemHashesJob.class);
    private static final String BATCH_SIZE = "batch.size";
    private static final String BATCH_SIZE_NON_NUMERIC = "batch.size.non.numeric";
    private static final String BACKFILL_ITEMS = "backfill.items";
    private static final String BACKFILL_PUBLISHED_ITEMS = "backfill.published.items";
    private static final String BACKFILL_PUBLISHED_ITEMS_BASELINE_HASH = "backfill.published.items.baseline.hash";
    private static final String NOTIFICATION_EMAIL_ADDR = "notification.email.address";
    private static final String INVALID_NOTIFICATION_EMAIL_ADDR = "invalid.notification.email.address";
    private static final String UNRECOGNIZED_JOB_CONFIG_PROPERTY = "unrecognized.job.config.property";
    private static final int DEFAULT_BATCH_SIZE = 100;
    private SessionManager sessionManager;
    private ServerConfigurationService serverConfigurationService;
    private EmailService emailService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runJob() throws JobExecutionException {
        long start = System.currentTimeMillis();
        log.info("Backfill question hashing - Job start");
        BackfillItemHashResult itemBackfillResult = null;
        BackfillItemHashResult publishedItemBackfillResult = null;
        RuntimeException error = null;
        try {
            boolean backfillPublishedItemHashes;
            this.logIn();
            int batchSize = this.getBatchSize();
            boolean backfillItemHashes = this.getBackfillItemHashes();
            if (backfillItemHashes) {
                ItemService itemService = new ItemService();
                itemBackfillResult = itemService.backfillItemHashes(batchSize, true);
            }
            if (backfillPublishedItemHashes = this.getBackfillPublishedItemHashes()) {
                boolean backfillPublishedItemBaselineHashes = this.getBackfillPublishedItemBaselineHashes();
                PublishedItemService publishedItemService = new PublishedItemService();
                publishedItemBackfillResult = publishedItemService.backfillItemHashes(batchSize, backfillPublishedItemBaselineHashes);
            }
            try {
                if (error == null) {
                    log.info("Backfill question hashing - Job exiting " + this.elapsedTimeMessage(start) + " " + this.jobResultMessage(itemBackfillResult, publishedItemBackfillResult, " "));
                } else {
                    log.info("Backfill question hashing - Job exiting with error. " + this.elapsedTimeMessage(start) + " " + this.jobResultMessage(itemBackfillResult, publishedItemBackfillResult, " "), (Throwable)error);
                }
                this.sentNotification(itemBackfillResult, publishedItemBackfillResult, error);
            }
            catch (RuntimeException e) {
                log.warn("Failed to send job completion email notification", (Throwable)e);
            }
            finally {
                try {
                    this.logOut();
                }
                catch (Exception e) {
                    log.warn("Backfill question hashing - Failed to cleanup Sakai session.", (Throwable)e);
                }
            }
            if (error == null) return;
        }
        catch (RuntimeException e) {
            error = e;
        }
        finally {
            try {
                if (error == null) {
                    log.info("Backfill question hashing - Job exiting " + this.elapsedTimeMessage(start) + " " + this.jobResultMessage(itemBackfillResult, publishedItemBackfillResult, " "));
                } else {
                    log.info("Backfill question hashing - Job exiting with error. " + this.elapsedTimeMessage(start) + " " + this.jobResultMessage(itemBackfillResult, publishedItemBackfillResult, " "), (Throwable)error);
                }
                this.sentNotification(itemBackfillResult, publishedItemBackfillResult, error);
            }
            catch (RuntimeException e) {
                log.warn("Failed to send job completion email notification", (Throwable)e);
            }
            finally {
                try {
                    this.logOut();
                }
                catch (Exception e) {
                    log.warn("Backfill question hashing - Failed to cleanup Sakai session.", (Throwable)e);
                }
            }
            if (error == null) return;
            throw new JobExecutionException((Throwable)error);
        }
        throw new JobExecutionException((Throwable)error);
    }

    private void sentNotification(BackfillItemHashResult itemBackfillResult, BackfillItemHashResult publishedItemBackfillResult, RuntimeException error) {
        String to = this.getNotificationEmailAddress();
        if (to == null) {
            return;
        }
        String from = "<" + this.serverConfigurationService.getString("setup.request", "no-reply@" + this.serverConfigurationService.getServerName()) + ">";
        StringBuilder body = new StringBuilder();
        if (error != null) {
            body.append("Job failed with following error message. See logs for full details.").append("\n\n").append(error.getMessage()).append("\n\n");
        }
        body.append(this.jobResultMessage(itemBackfillResult, publishedItemBackfillResult, "\n\n"));
        this.emailService.send(from, to, "Backfill Item Hash Job: " + (error == null ? "Success" : "Failure"), body.toString(), to, null, null);
    }

    private int getBatchSize() {
        String val = StringUtils.trimToNull((String)this.getConfiguredProperty(BATCH_SIZE));
        if (val == null) {
            return 100;
        }
        int valInt = Integer.parseInt(val);
        return valInt <= 0 ? 100 : valInt;
    }

    private boolean getBackfillItemHashes() {
        return this.getBooleanConfig(BACKFILL_ITEMS, true);
    }

    private boolean getBackfillPublishedItemHashes() {
        return this.getBooleanConfig(BACKFILL_PUBLISHED_ITEMS, true);
    }

    private boolean getBackfillPublishedItemBaselineHashes() {
        return this.getBooleanConfig(BACKFILL_PUBLISHED_ITEMS_BASELINE_HASH, false);
    }

    private boolean getBooleanConfig(String name, boolean defaultTo) {
        String val = StringUtils.trimToNull((String)this.getConfiguredProperty(name));
        if (val == null) {
            return defaultTo;
        }
        return Boolean.parseBoolean(val);
    }

    private String getNotificationEmailAddress() {
        return StringUtils.trimToNull((String)this.getConfiguredProperty(NOTIFICATION_EMAIL_ADDR));
    }

    private String jobResultMessage(BackfillItemHashResult itemBackfillResult, BackfillItemHashResult publishedItemBackfillResult, String separator) {
        StringBuilder sb = new StringBuilder();
        if (itemBackfillResult != null) {
            sb.append("Item backfill results: [").append(itemBackfillResult).append("]");
            if (publishedItemBackfillResult != null) {
                sb.append(separator);
            }
        }
        if (publishedItemBackfillResult != null) {
            sb.append("Published item backfill results: [").append(publishedItemBackfillResult).append("]");
        }
        return sb.toString();
    }

    private String elapsedTimeMessage(long start) {
        return "Elapsed time: [" + (System.currentTimeMillis() - start) + "ms]";
    }

    private void logIn() {
        Session sakaiSession = this.sessionManager.getCurrentSession();
        sakaiSession.setUserId("admin");
        sakaiSession.setUserEid("admin");
    }

    private void logOut() {
        Session currentSession = this.sessionManager.getCurrentSession();
        currentSession.invalidate();
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public static class BackfillItemHashesConfigurationValidator
    implements ConfigurableJobPropertyValidator {
        public void assertValid(String propertyLabel, String value) throws ConfigurableJobPropertyValidationException {
            value = StringUtils.trimToNull((String)value);
            if (BackfillItemHashesJob.BATCH_SIZE.equals(propertyLabel)) {
                if (value == null) {
                    return;
                }
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ConfigurableJobPropertyValidationException(BackfillItemHashesJob.BATCH_SIZE_NON_NUMERIC);
                }
            } else if (!(BackfillItemHashesJob.BACKFILL_ITEMS.equals(propertyLabel) || BackfillItemHashesJob.BACKFILL_PUBLISHED_ITEMS.equals(propertyLabel) || BackfillItemHashesJob.BACKFILL_PUBLISHED_ITEMS_BASELINE_HASH.equals(propertyLabel))) {
                if (BackfillItemHashesJob.NOTIFICATION_EMAIL_ADDR.equals(propertyLabel)) {
                    if (value == null) {
                        return;
                    }
                    try {
                        new InternetAddress(value, true);
                    }
                    catch (AddressException e) {
                        throw new ConfigurableJobPropertyValidationException(BackfillItemHashesJob.INVALID_NOTIFICATION_EMAIL_ADDR);
                    }
                } else {
                    throw new ConfigurableJobPropertyValidationException(BackfillItemHashesJob.UNRECOGNIZED_JOB_CONFIG_PROPERTY);
                }
            }
        }
    }
}

