/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceHelper {
    private static final Logger log = LoggerFactory.getLogger(PersistenceHelper.class);
    private Integer deadlockInterval;
    private Integer retryCount;

    public void setDeadlockInterval(Integer deadlockInterval) {
        this.deadlockInterval = deadlockInterval;
    }

    public Integer getDeadlockInterval() {
        return this.deadlockInterval;
    }

    public int retryDeadlock(Exception e, int retryCount) {
        log.warn("Error saving to db...retry again....");
        String errorMessage = e.getMessage();
        log.warn(errorMessage);
        int index = errorMessage.indexOf("ORA-00060");
        int index2 = errorMessage.indexOf("SQL state [61000]");
        int index3 = errorMessage.indexOf("SQL state [41000]");
        if (index > -1 || index2 > -1 || index3 > -1) {
            log.info("deadlock detected (" + e.getMessage() + ") retry count is now" + --retryCount);
            try {
                int ideadlockInterval = this.deadlockInterval;
                Thread.currentThread();
                Thread.sleep(ideadlockInterval);
            }
            catch (InterruptedException ex) {
                log.warn(ex.getMessage());
            }
        } else {
            retryCount = 0;
        }
        return retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }
}

