/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.assessment.util.SamigoExpressionError;

public class SamigoExpressionParser {
    public static String INFINITY = "Infinity";
    public static String NaN = "NaN";
    public static Pattern oldLogPattern;
    private String expr = "";
    private int expr_pos = -1;
    private char expr_c = '\u0000';
    private String token = "";
    private TOKENTYPE token_type;
    private BigDecimal ans;
    private String ans_str;
    private Map<String, BigDecimal> user_var = new HashMap<String, BigDecimal>();

    public SamigoExpressionParser() {
        this.token_type = TOKENTYPE.NOTHING;
        oldLogPattern = Pattern.compile("log\\([^,]*\\)");
    }

    public String parse(String new_expr) throws SamigoExpressionError {
        return this.parse(new_expr, 5);
    }

    public String parse(String new_expr, int decimals) throws SamigoExpressionError {
        try {
            this.expr = new_expr.toLowerCase();
            Matcher matcher = oldLogPattern.matcher(this.expr);
            if (matcher.matches()) {
                this.expr = this.expr.replaceAll("log", "ln");
            }
            this.expr = this.expr.replaceAll("sign", "sgn");
            this.ans = BigDecimal.valueOf(0.0);
            this.getFirstChar();
            this.getToken();
            if (this.token_type == TOKENTYPE.DELIMETER && this.expr_c == '\u0000') {
                throw new SamigoExpressionError(this.row(), this.col(), 4);
            }
            Expression e = null;
            try {
                e = new Expression(this.expr, new PrimitiveElement[0]);
                double d = e.calculate();
                this.ans = new BigDecimal(d, MathContext.DECIMAL64);
            }
            catch (NumberFormatException nfe) {
                String errorMessage = e != null ? e.getErrorMessage() : this.expr;
                throw new SamigoExpressionError(401, errorMessage);
            }
            GradingService service = new GradingService();
            this.ans_str = service.toScientificNotation(this.ans.toPlainString(), decimals);
            this.user_var.put("ANS", new BigDecimal(this.ans_str));
        }
        catch (SamigoExpressionError err) {
            this.ans_str = err.get();
            throw err;
        }
        return this.ans_str;
    }

    boolean isMinus(char c) {
        return c == '-';
    }

    boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t';
    }

    boolean isDelimeter(char c) {
        return "&|<>=+/*%^!".indexOf(c) != -1;
    }

    boolean isNotDelimeter(char c) {
        return "&|<>=+-/*%^!()".indexOf(c) != -1;
    }

    boolean isAlpha(char c) {
        char cUpper = Character.toUpperCase(c);
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ_".indexOf(cUpper) != -1;
    }

    boolean isDigitDot(char c) {
        return "0123456789.".indexOf(c) != -1;
    }

    boolean isDigit(char c) {
        return "0123456789".indexOf(c) != -1;
    }

    boolean isLegalVariableName(String name) {
        String nameUpper = name.toUpperCase();
        if (nameUpper.equals("E")) {
            return false;
        }
        return !nameUpper.equals("PI");
    }

    void getChar() {
        ++this.expr_pos;
        this.expr_c = this.expr_pos < this.expr.length() ? this.expr.charAt(this.expr_pos) : (char)'\u0000';
    }

    void getFirstChar() {
        this.expr_pos = 0;
        this.expr_c = this.expr_pos < this.expr.length() ? this.expr.charAt(this.expr_pos) : (char)'\u0000';
    }

    void getToken() throws SamigoExpressionError {
        this.token_type = TOKENTYPE.NOTHING;
        this.token = "";
        while (this.isWhiteSpace(this.expr_c)) {
            this.getChar();
        }
        if (this.expr_c == '\u0000') {
            this.token_type = TOKENTYPE.DELIMETER;
            return;
        }
        if (this.expr_c == '-') {
            this.token_type = TOKENTYPE.DELIMETER;
            this.token = this.token + this.expr_c;
            this.getChar();
            return;
        }
        if (this.expr_c == '(' || this.expr_c == ')') {
            this.token_type = TOKENTYPE.DELIMETER;
            this.token = this.token + this.expr_c;
            this.getChar();
            return;
        }
        if (this.isDelimeter(this.expr_c)) {
            this.token_type = TOKENTYPE.DELIMETER;
            while (this.isDelimeter(this.expr_c)) {
                this.token = this.token + this.expr_c;
                this.getChar();
            }
            return;
        }
        if (this.isDigitDot(this.expr_c)) {
            this.token_type = TOKENTYPE.NUMBER;
            while (this.isDigitDot(this.expr_c)) {
                this.token = this.token + this.expr_c;
                this.getChar();
            }
            if (this.expr_c == 'e' || this.expr_c == 'E') {
                this.token = this.token + this.expr_c;
                this.getChar();
                if (this.expr_c == '+' || this.expr_c == '-') {
                    this.token = this.token + this.expr_c;
                    this.getChar();
                }
                while (this.isDigit(this.expr_c)) {
                    this.token = this.token + this.expr_c;
                    this.getChar();
                }
            }
            return;
        }
        if (this.isAlpha(this.expr_c)) {
            while (this.isAlpha(this.expr_c) || this.isDigit(this.expr_c)) {
                this.token = this.token + this.expr_c;
                this.getChar();
            }
            while (this.isWhiteSpace(this.expr_c)) {
                this.getChar();
            }
            this.token_type = this.expr_c == '(' ? TOKENTYPE.FUNCTION : TOKENTYPE.VARIABLE;
            return;
        }
        this.token_type = TOKENTYPE.UNKNOWN;
        while (this.expr_c != '\u0000') {
            this.token = this.token + this.expr_c;
            this.getChar();
        }
        throw new SamigoExpressionError(this.row(), this.col(), 1, this.token);
    }

    int row() {
        return -1;
    }

    int col() {
        return this.expr_pos - this.token.length() + 1;
    }

    private static enum TOKENTYPE {
        NOTHING,
        DELIMETER,
        NUMBER,
        VARIABLE,
        FUNCTION,
        UNKNOWN;

    }
}

