/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.entity.impl;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.BrowseSearchable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.PropertyProvideable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RedirectDefinable;
import org.sakaiproject.entitybroker.entityprovider.extension.EntityData;
import org.sakaiproject.entitybroker.entityprovider.extension.TemplateMap;
import org.sakaiproject.entitybroker.entityprovider.search.Restriction;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.tool.assessment.entity.api.PublishedAssessmentEntityProvider;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.shared.api.grading.GradingServiceAPI;

public class PublishedAssessmentEntityProviderImpl
implements PublishedAssessmentEntityProvider,
CoreEntityProvider,
AutoRegisterEntityProvider,
PropertyProvideable,
BrowseSearchable,
RESTful,
Outputable,
RedirectDefinable {
    private static final String CAN_TAKE = "assessment.takeAssessment";
    private static final String CAN_PUBLISH = "assessment.publishAssessment.any";
    private PublishedAssessmentFacadeQueriesAPI publishedAssessmentFacadeQueries;
    private SecurityService securityService;
    private GradingServiceAPI gradingService = null;
    private DeveloperHelperService developerHelperService;

    public String getEntityPrefix() {
        return "sam_pub";
    }

    public boolean entityExists(String id) {
        boolean rv = false;
        try {
            PublishedAssessmentService service = new PublishedAssessmentService();
            PublishedAssessmentFacade pub = service.getPublishedAssessment(id);
            if (pub != null) {
                rv = true;
            }
        }
        catch (Exception e) {
            rv = false;
        }
        return rv;
    }

    public TemplateMap[] defineURLMappings() {
        return new TemplateMap[]{new TemplateMap("/{prefix}/context/{siteId}", "{prefix}{dot-extension}")};
    }

    private List<String> browseEntities(String siteId, String userId) {
        ArrayList<String> refs = null;
        List<PublishedAssessmentFacade> assessments = null;
        boolean canPublish = false;
        Date currentDate = new Date();
        String orderBy = "title";
        if (this.securityService.unlock(CAN_PUBLISH, "/site/" + siteId)) {
            this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true);
            assessments = this.publishedAssessmentFacadeQueries.getBasicInfoOfAllInActivePublishedAssessments(orderBy, siteId, true);
            assessments.addAll(this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true));
            canPublish = true;
        } else if (this.securityService.unlock(CAN_TAKE, "/site/" + siteId)) {
            assessments = this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true);
        }
        if (assessments != null) {
            refs = new ArrayList<String>();
            for (int i = 0; i < assessments.size(); ++i) {
                PublishedAssessmentFacade pub = assessments.get(i);
                if (!canPublish && pub.getStartDate() != null && !currentDate.after(pub.getStartDate())) continue;
                refs.add("/sam_pub/" + pub.getPublishedAssessmentId());
            }
        }
        return refs;
    }

    public List getEntities(EntityReference ref, Search search) {
        Vector<PublishedAssessmentFacade> results = new Vector<PublishedAssessmentFacade>();
        String siteId = null;
        Restriction[] restrictions = search.getRestrictions();
        String userId = null;
        for (int r = 0; r < restrictions.length; ++r) {
            if (restrictions[r].property.equalsIgnoreCase("siteId")) {
                siteId = (String)restrictions[r].value;
            }
            if (restrictions[r].property.equalsIgnoreCase("userId")) {
                userId = (String)restrictions[r].value;
            }
            if (!restrictions[r].property.equalsIgnoreCase("context")) continue;
            siteId = (String)restrictions[r].value;
        }
        if (userId == null) {
            userId = this.developerHelperService.getCurrentUserId();
        }
        if (userId == null) {
            throw new SecurityException("No user is currently logged in so no data can be retrieved");
        }
        if (userId == null) {
            return results;
        }
        if (siteId == null) {
            return results;
        }
        String orderBy = "title";
        List<PublishedAssessmentFacade> assessments = null;
        boolean canPublish = false;
        Date currentDate = new Date();
        if (this.securityService.unlock(CAN_PUBLISH, "/site/" + siteId)) {
            this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true);
            assessments = this.publishedAssessmentFacadeQueries.getBasicInfoOfAllInActivePublishedAssessments(orderBy, siteId, true);
            assessments.addAll(this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true));
            canPublish = true;
        } else if (this.securityService.unlock(CAN_TAKE, "/site/" + siteId)) {
            assessments = this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true);
        }
        if (assessments != null) {
            for (PublishedAssessmentFacade pub : assessments) {
                results.add(pub);
            }
        }
        return results;
    }

    public Object getEntity(EntityReference ref) {
        return new EntityData(new EntityReference("dummy reference"), "dummy");
    }

    public List<EntityData> browseEntities(Search search, String userReference, String associatedReference, Map<String, Object> params) {
        Vector<EntityData> results = new Vector<EntityData>();
        String siteId = (String)params.get("context");
        Restriction[] restrictions = search.getRestrictions();
        String userId = null;
        for (int r = 0; r < restrictions.length; ++r) {
            if (restrictions[r].property.equalsIgnoreCase("userId")) {
                userId = (String)restrictions[r].value;
            }
            if (!restrictions[r].property.equalsIgnoreCase("context")) continue;
            siteId = (String)restrictions[r].value;
        }
        if (userId == null) {
            return results;
        }
        if (siteId == null) {
            return results;
        }
        String orderBy = "title";
        List<PublishedAssessmentFacade> assessments = null;
        boolean canPublish = false;
        Date currentDate = new Date();
        if (this.securityService.unlock(CAN_PUBLISH, "/site/" + siteId)) {
            this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true);
            assessments = this.publishedAssessmentFacadeQueries.getBasicInfoOfAllInActivePublishedAssessments(orderBy, siteId, true);
            assessments.addAll(this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true));
            canPublish = true;
        } else if (this.securityService.unlock(CAN_TAKE, "/site/" + siteId)) {
            assessments = this.publishedAssessmentFacadeQueries.getBasicInfoOfAllActivePublishedAssessments(orderBy, siteId, true);
        }
        for (PublishedAssessmentFacade pub : assessments) {
            if (!canPublish && pub.getStartDate() != null && !currentDate.after(pub.getStartDate())) continue;
            String thisEntityReference = "/sam_pub/" + pub.getPublishedAssessmentId();
            String thisEntityTitle = pub.getTitle();
            results.add(new EntityData(new EntityReference(thisEntityReference), thisEntityTitle));
        }
        return results;
    }

    public List<String> findEntityRefs(String[] prefixes, String[] name, String[] searchValue, boolean exactMatch) {
        String siteId = null;
        String userId = null;
        if ("sam_pub".equals(prefixes[0])) {
            for (int i = 0; i < name.length; ++i) {
                if ("context".equalsIgnoreCase(name[i]) || "site".equalsIgnoreCase(name[i])) {
                    siteId = searchValue[i];
                    continue;
                }
                if (!"user".equalsIgnoreCase(name[i]) && !"userId".equalsIgnoreCase(name[i])) continue;
                userId = searchValue[i];
            }
            if (siteId != null && userId != null) {
                return this.browseEntities(siteId, userId);
            }
        }
        return null;
    }

    public Map<String, String> getProperties(String reference) {
        HashMap<String, String> props = new HashMap<String, String>();
        PublishedAssessmentService service = new PublishedAssessmentService();
        PublishedAssessmentFacade pub = service.getPublishedAssessment(reference.substring("sam_pub".length() + 2));
        props.put("title", pub.getTitle());
        props.put("description", pub.getDescription());
        props.put("author", pub.getCreatedBy());
        if (pub.getCreatedDate() != null) {
            props.put("created_date", DateFormat.getInstance().format(pub.getCreatedDate()));
        }
        props.put("modified_by", pub.getLastModifiedBy());
        if (pub.getLastModifiedDate() != null) {
            props.put("modified_date", DateFormat.getInstance().format(pub.getLastModifiedDate()));
        }
        if (pub.getTotalScore() != null) {
            props.put("totalScore", pub.getTotalScore().toString());
        }
        if (pub.getStartDate() != null) {
            props.put("start_date", DateFormat.getInstance().format(pub.getStartDate()));
        } else if (pub.getAssessmentAccessControl().getStartDate() != null) {
            props.put("start_date", DateFormat.getInstance().format(pub.getAssessmentAccessControl().getStartDate()));
        }
        if (pub.getDueDate() != null) {
            props.put("due_date", DateFormat.getInstance().format(pub.getDueDate()));
        } else if (pub.getAssessmentAccessControl().getDueDate() != null) {
            props.put("due_date", DateFormat.getInstance().format(pub.getAssessmentAccessControl().getDueDate()));
        }
        if (pub.getRetractDate() != null) {
            props.put("retract_date", DateFormat.getInstance().format(pub.getRetractDate()));
        } else if (pub.getAssessmentAccessControl().getRetractDate() != null) {
            props.put("retract_date", DateFormat.getInstance().format(pub.getAssessmentAccessControl().getRetractDate()));
        }
        props.put("comments", pub.getComments());
        props.put("siteId", pub.getOwnerSiteId());
        return props;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"xml", "json", "html"};
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        return null;
    }

    public Object getSampleEntity() {
        return null;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
    }

    public String getPropertyValue(String reference, String name) {
        Map<String, String> props = this.getProperties(reference);
        return props.get(name);
    }

    public void setPropertyValue(String reference, String name, String value) {
    }

    public PublishedAssessmentFacadeQueriesAPI getPublishedAssessmentFacadeQueries() {
        return this.publishedAssessmentFacadeQueries;
    }

    public void setPublishedAssessmentFacadeQueries(PublishedAssessmentFacadeQueriesAPI publishedAssessmentFacadeQueries) {
        this.publishedAssessmentFacadeQueries = publishedAssessmentFacadeQueries;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService security) {
        this.securityService = security;
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }
}

