/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osid.assessment.AssessmentException;
import org.sakaiproject.tool.assessment.data.dao.assessment.AssessmentData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentBaseFacade;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssessmentFacade
extends AssessmentBaseFacade
implements Serializable,
AssessmentIfc {
    private static final Logger log = LoggerFactory.getLogger(AssessmentFacade.class);
    private static final long serialVersionUID = 7526471155622776147L;
    private AssessmentIfc data;
    private Long assessmentTemplateId;
    private Long assessmentId;
    private Set sectionSet;
    private Set assessmentAttachmentSet;
    private Integer questionSize;
    private String lastModifiedDateForDisplay;

    public AssessmentFacade() {
        this.data = new AssessmentData();
        try {
            this.assessment.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public AssessmentFacade(Long id, String title, Date lastModifiedDate) {
        super.setAssessmentBaseId(id);
        super.setTitle(title);
        super.setLastModifiedDate(lastModifiedDate);
    }

    public AssessmentFacade(Long id, String title, Date lastModifiedDate, String lastModifiedBy) {
        super.setAssessmentBaseId(id);
        super.setTitle(title);
        super.setLastModifiedDate(lastModifiedDate);
        super.setLastModifiedBy(lastModifiedBy);
    }

    public AssessmentFacade(Long id, String title, Date lastModifiedDate, String lastModifiedBy, int questionSize) {
        super.setAssessmentBaseId(id);
        super.setTitle(title);
        super.setLastModifiedDate(lastModifiedDate);
        super.setLastModifiedBy(lastModifiedBy);
        this.questionSize = questionSize;
    }

    public AssessmentFacade(AssessmentIfc data, Boolean loadSection) {
        try {
            super.setData((AssessmentBaseIfc)data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.assessmentTemplateId = data.getAssessmentTemplateId();
        this.assessmentAttachmentSet = data.getAssessmentAttachmentSet();
        this.sectionSet = new HashSet();
        if (loadSection.equals(Boolean.TRUE)) {
            Set dataSet = data.getSectionSet();
            for (SectionData s : dataSet) {
                this.sectionSet.add(new SectionFacade((SectionDataIfc)s));
            }
        }
    }

    public AssessmentFacade(AssessmentIfc data) {
        try {
            super.setData((AssessmentBaseIfc)data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.assessmentTemplateId = data.getAssessmentTemplateId();
        this.assessmentAttachmentSet = data.getAssessmentAttachmentSet();
        this.sectionSet = new HashSet();
        Set dataSet = data.getSectionSet();
        for (SectionData s : dataSet) {
            this.sectionSet.add(new SectionFacade((SectionDataIfc)s));
        }
    }

    public Long getAssessmentId() {
        try {
            this.data = (AssessmentIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAssessmentId();
    }

    public Long getAssessmentTemplateId() {
        try {
            this.data = (AssessmentIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAssessmentTemplateId();
    }

    public void setAssessmentTemplateId(Long assessmentTemplateId) {
        this.assessmentTemplateId = assessmentTemplateId;
        this.data.setAssessmentTemplateId(assessmentTemplateId);
    }

    public Set getSectionSet() {
        try {
            this.data = (AssessmentIfc)this.assessment.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.sectionSet = new HashSet();
        Set dataSet = this.data.getSectionSet();
        for (SectionData s : dataSet) {
            this.sectionSet.add(new SectionFacade((SectionDataIfc)s));
        }
        return this.sectionSet;
    }

    public void setSectionSet(Set sectionSet) {
        this.sectionSet = sectionSet;
        HashSet<SectionDataIfc> set = new HashSet<SectionDataIfc>();
        for (SectionFacade sf : sectionSet) {
            set.add(sf.getData());
        }
        this.data.setSectionSet(set);
    }

    public ArrayList getSectionArray() {
        ArrayList<SectionFacade> list = new ArrayList<SectionFacade>();
        if (this.sectionSet != null) {
            for (SectionFacade s : this.sectionSet) {
                list.add(s);
            }
        }
        return list;
    }

    public ArrayList getSectionArraySorted() {
        ArrayList list = this.getSectionArray();
        Collections.sort(list);
        return list;
    }

    public SectionDataIfc getSection(Long sequence) {
        ArrayList list = this.getSectionArraySorted();
        if (list == null) {
            return null;
        }
        return (SectionDataIfc)list.get(sequence.intValue() - 1);
    }

    public SectionDataIfc getDefaultSection() {
        ArrayList list = this.getSectionArraySorted();
        if (list == null) {
            return null;
        }
        return (SectionDataIfc)list.get(0);
    }

    public Set getAssessmentAttachmentSet() throws DataFacadeException {
        try {
            this.data = (AssessmentIfc)this.assessment.getData();
            this.assessmentAttachmentSet = this.data.getAssessmentAttachmentSet();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.assessmentAttachmentSet;
    }

    public void setAssessmentAttachmentSet(Set assessmentAttachmentSet) {
        this.assessmentAttachmentSet = assessmentAttachmentSet;
        this.data.setAssessmentAttachmentSet(assessmentAttachmentSet);
    }

    public List getAssessmentAttachmentList() {
        ArrayList<AssessmentAttachmentIfc> list = new ArrayList<AssessmentAttachmentIfc>();
        if (this.assessmentAttachmentSet != null) {
            for (AssessmentAttachmentIfc a : this.assessmentAttachmentSet) {
                list.add(a);
            }
        }
        return list;
    }

    public Integer getQuestionSize() {
        return this.questionSize;
    }

    public void setQuestionSize(Integer questionSize) {
        this.questionSize = questionSize;
    }

    public String getLastModifiedDateForDisplay() {
        return this.lastModifiedDateForDisplay;
    }

    public void setLastModifiedDateForDisplay(String lastModifiedDateForDisplay) {
        this.lastModifiedDateForDisplay = lastModifiedDateForDisplay;
    }
}

