/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.osid.shared.Type;
import org.sakaiproject.tool.assessment.data.dao.shared.TypeD;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.shared.extension.TypeExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public class TypeFacadeQueries
extends HibernateDaoSupport
implements TypeFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(TypeFacadeQueries.class);
    private Map<Long, TypeFacade> typeFacadeMap;
    private List<TypeFacade> itemTypes;

    @Override
    public void setTypeFacadeMap() {
        this.typeFacadeMap = this.getMapForAllTypes();
    }

    @Override
    public Map<Long, TypeFacade> getTypeFacadeMap() {
        return this.typeFacadeMap;
    }

    @Override
    public TypeFacade getTypeFacadeById(Long typeId) {
        TypeFacade typeFacade = null;
        Map<Long, TypeFacade> typeMap = this.getTypeFacadeMap();
        typeFacade = typeMap.get(typeId);
        return typeFacade;
    }

    @Override
    public Type getTypeById(Long typeId) {
        TypeFacade typeFacade = this.getTypeFacadeById(typeId);
        if (typeFacade == null) {
            log.warn("Unable to find Item Type: " + typeId.toString());
            return null;
        }
        TypeExtension type = new TypeExtension(typeFacade.getAuthority(), typeFacade.getDomain(), typeFacade.getKeyword(), typeFacade.getDescription());
        return type;
    }

    @Override
    public List getArrayListByAuthorityDomain(String authority, String domain) {
        List typeList = this.getListByAuthorityDomain(authority, domain);
        ArrayList<TypeFacade> typeFacadeList = new ArrayList<TypeFacade>();
        for (int i = 0; i < typeList.size(); ++i) {
            TypeD typeData = (TypeD)typeList.get(i);
            TypeFacade typeFacade = new TypeFacade((TypeIfc)typeData);
            typeFacadeList.add(typeFacade);
        }
        return typeFacadeList;
    }

    @Override
    public Map getHashMapByAuthorityDomain(String authority, String domain) {
        List typeList = this.getListByAuthorityDomain(authority, domain);
        return this.createTypeFacadeMapById(typeList);
    }

    private List<TypeD> getAllTypes() {
        return this.getHibernateTemplate().find("from TypeD", new Object[0]);
    }

    private Map<Long, TypeFacade> getMapForAllTypes() {
        List<TypeD> typeList = this.getAllTypes();
        return this.createTypeFacadeMapById(typeList);
    }

    private Map<Long, TypeFacade> createTypeFacadeMapById(List typeList) {
        HashMap<Long, TypeFacade> typeFacadeMap = new HashMap<Long, TypeFacade>();
        for (int i = 0; i < typeList.size(); ++i) {
            TypeD typeData = (TypeD)typeList.get(i);
            TypeFacade typeFacade = new TypeFacade((TypeIfc)typeData);
            typeFacadeMap.put(typeData.getTypeId(), typeFacade);
        }
        return typeFacadeMap;
    }

    @Override
    public List getListByAuthorityDomain(String authority, String domain) {
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from TypeD as t where t.authority = :auth and t.domain = :domain");
            q.setString("auth", authority);
            q.setString("domain", domain);
            q.setCacheable(true);
            return q.list();
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List getFacadeListByAuthorityDomain(String authority, String domain) {
        ArrayList<TypeFacade> typeList = new ArrayList<TypeFacade>();
        List list = this.getListByAuthorityDomain(authority, domain);
        for (int i = 0; i < list.size(); ++i) {
            TypeD type = (TypeD)list.get(i);
            TypeFacade f = new TypeFacade(type.getAuthority(), type.getDomain(), type.getKeyword(), type.getDescription());
            f.setTypeId(type.getTypeId());
            typeList.add(f);
        }
        return typeList;
    }

    @Override
    public List getFacadeItemTypes() {
        if (this.itemTypes == null) {
            this.itemTypes = this.getFacadeListByAuthorityDomain("stanford.edu", "assessment.item");
        }
        return this.itemTypes;
    }

    @Override
    public void setFacadeItemTypes() {
        this.itemTypes = this.getFacadeItemTypes();
    }
}

