/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade.util;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.sakaiproject.tool.assessment.facade.util.PagingUtilQueriesAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public class PagingUtilQueries
extends HibernateDaoSupport
implements PagingUtilQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(PagingUtilQueries.class);

    @Override
    public List getAll(final int pageSize, final int pageNumber, final String queryString, final Integer value) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                ScrollableResults assessmentList;
                ArrayList<Object> page = new ArrayList<Object>();
                Query q = session.createQuery(queryString);
                if (value != null) {
                    q.setInteger(0, value.intValue());
                }
                if ((assessmentList = q.scroll()).first()) {
                    int first = pageSize * (pageNumber - 1);
                    int i = 0;
                    assessmentList.setRowNumber(first);
                    assessmentList.beforeFirst();
                    while (pageSize > i++ && assessmentList.next()) {
                        log.debug("**** add " + i);
                        page.add(assessmentList.get(0));
                    }
                }
                return page;
            }
        };
        List pageList = (List)this.getHibernateTemplate().execute(callback);
        return pageList;
    }

    @Override
    public List getAll(int pageSize, int pageNumber, String queryString) {
        return this.getAll(pageSize, pageNumber, queryString, null);
    }
}

