/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.util.Optional;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.Notification;
import org.sakaiproject.event.api.NotificationAction;
import org.sakaiproject.event.api.NotificationEdit;
import org.sakaiproject.event.api.NotificationService;
import org.sakaiproject.tool.assessment.integration.helper.ifc.TagEventHandler;
import org.sakaiproject.tool.assessment.integration.helper.ifc.TagServiceHelper;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PublishedItemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TagSyncEventHandlerImpl
implements TagEventHandler {
    private static final Logger log = LoggerFactory.getLogger(TagSyncEventHandlerImpl.class);
    private static final String TAG_UPDATE_EVENT = "tags.update.tag";
    private static final String TAG_DELETE_EVENT = "tags.delete.tag";
    private static final String TAGCOLLECTION_UPDATE_EVENT = "tags.update.collection";
    private static final String TAGCOLLECTION_DELETE_EVENT = "tags.delete.collection";
    private static final String RESOURCE_REFEREENCE_DELIM_REGEX = "/";
    private TagServiceHelper tagServiceHelper;
    private NotificationEdit notification;
    private NotificationService notificationService;

    public void init() {
        if (this.tagServiceHelper == null) {
            log.warn("No TagServiceHelper assigned. Skipping initialization of this TagSyncEventHandlerImpl");
            return;
        }
        this.tagServiceHelper.registerTagEventHandler(this);
    }

    public void destroy() {
        if (this.notificationService != null && this.notification != null) {
            this.notificationService.removeNotification(this.notification);
        }
    }

    @Override
    public void registerEventCallbacks(NotificationService notificationService) {
        this.notificationService = notificationService;
        this.notification = notificationService.addTransientNotification();
        this.notification.addFunction(TAG_UPDATE_EVENT);
        this.notification.addFunction(TAG_DELETE_EVENT);
        this.notification.addFunction(TAGCOLLECTION_UPDATE_EVENT);
        this.notification.addFunction(TAGCOLLECTION_DELETE_EVENT);
        this.notification.setAction((NotificationAction)this);
    }

    public void set(Element el) {
    }

    public void set(NotificationAction other) {
    }

    public NotificationAction getClone() {
        TagSyncEventHandlerImpl clone = new TagSyncEventHandlerImpl();
        clone.tagServiceHelper = this.tagServiceHelper;
        clone.notification = this.notification;
        clone.notificationService = this.notificationService;
        return clone;
    }

    public void toXml(Element el) {
    }

    public void notify(Notification notification, Event event) {
        try {
            switch (event.getEvent()) {
                case "tags.update.tag": {
                    this.handleTagUpdate(notification, event);
                    return;
                }
                case "tags.delete.tag": {
                    this.handleTagDelete(notification, event);
                    return;
                }
                case "tags.update.collection": {
                    this.handleTagCollectionUpdate(notification, event);
                    return;
                }
                case "tags.delete.collection": {
                    this.handleTagCollectionDelete(notification, event);
                    return;
                }
            }
            this.noEventHandlerFor(notification, event);
            return;
        }
        catch (Exception e) {
            this.eventHandlingFailed(notification, event, e);
            return;
        }
    }

    private void noEventHandlerFor(Notification notification, Event event) {
        log.debug("Unexpected event type: " + event.getEvent());
    }

    private void eventHandlingFailed(Notification notification, Event event, Exception e) {
        log.error("Failure handling event: " + e);
    }

    private void handleTagUpdate(Notification notification, Event event) {
        ItemService itemService = this.getItemService();
        PublishedItemService publishedItemService = this.getPublishedItemService();
        Optional<TagServiceHelper.TagView> tagOptional = this.tagServiceHelper.findTagById(this.tagIdFor(event));
        if (!tagOptional.isPresent()) {
            log.debug("Tag for update event has gone missing. Skipping update processing. " + event);
            return;
        }
        itemService.updateItemTagBindingsHavingTag(tagOptional.get());
        publishedItemService.updateItemTagBindingsHavingTag(tagOptional.get());
    }

    private void handleTagDelete(Notification notification, Event event) {
        ItemService itemService = this.getItemService();
        PublishedItemService publishedItemService = this.getPublishedItemService();
        String tagId = this.tagIdFor(event);
        itemService.deleteItemTagBindingsHavingTagId(tagId);
        publishedItemService.deleteItemTagBindingsHavingTagId(tagId);
    }

    private void handleTagCollectionUpdate(Notification notification, Event event) {
        ItemService itemService = this.getItemService();
        PublishedItemService publishedItemService = this.getPublishedItemService();
        Optional<TagServiceHelper.TagCollectionView> tagCollectionOptional = this.tagServiceHelper.findTagCollectionById(this.tagIdFor(event));
        if (!tagCollectionOptional.isPresent()) {
            log.debug("Tag Collection for update event has gone missing. Skipping update processing. " + event);
            return;
        }
        itemService.updateItemTagBindingsHavingTagCollection(tagCollectionOptional.get());
        publishedItemService.updateItemTagBindingsHavingTagCollection(tagCollectionOptional.get());
    }

    private void handleTagCollectionDelete(Notification notification, Event event) {
        ItemService itemService = this.getItemService();
        PublishedItemService publishedItemService = this.getPublishedItemService();
        String tagCollectionId = this.tagCollectionIdFor(event);
        itemService.deleteItemTagBindingsHavingTagCollectionId(tagCollectionId);
        publishedItemService.deleteItemTagBindingsHavingTagCollectionId(tagCollectionId);
    }

    protected ItemService getItemService() {
        return new ItemService();
    }

    protected PublishedItemService getPublishedItemService() {
        return new PublishedItemService();
    }

    public void setTagServiceHelper(TagServiceHelper tagServiceHelper) {
        this.tagServiceHelper = tagServiceHelper;
    }

    private String tagIdFor(Event event) throws IllegalArgumentException {
        return this.entityIdFor(event);
    }

    private String tagCollectionIdFor(Event event) throws IllegalArgumentException {
        return this.entityIdFor(event);
    }

    private String entityIdFor(Event event) throws IllegalArgumentException {
        String resourceRef = event.getResource();
        if (resourceRef == null) {
            throw new IllegalArgumentException("Null resource reference for event: " + event);
        }
        String[] resourceRefParts = resourceRef.split(RESOURCE_REFEREENCE_DELIM_REGEX);
        try {
            return resourceRefParts[2];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unexpected resource reference structure for event: " + e);
        }
    }
}

