/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.util.Map;
import org.sakaiproject.tool.assessment.facade.BackfillItemHashResult;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.PublishedItemFacade;
import org.sakaiproject.tool.assessment.integration.helper.ifc.TagServiceHelper;
import org.sakaiproject.tool.assessment.services.ItemService;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedItemService
extends ItemService {
    private static final Logger log = LoggerFactory.getLogger(PublishedItemService.class);

    @Override
    public ItemFacade getItem(Long itemId, String agentId) {
        PublishedItemFacade item = null;
        try {
            item = PersistenceService.getInstance().getPublishedItemFacadeQueries().getItem(itemId, agentId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return item;
    }

    @Override
    public ItemFacade getItem(String itemId) {
        PublishedItemFacade item = null;
        try {
            item = PersistenceService.getInstance().getPublishedItemFacadeQueries().getItem(itemId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return item;
    }

    public Map<String, ItemFacade> getPublishedItemsByHash(String hash) {
        try {
            return PersistenceService.getInstance().getPublishedItemFacadeQueries().getPublishedItemsByHash(hash);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteItemContent(Long itemId, String agentId) {
        try {
            PersistenceService.getInstance().getPublishedItemFacadeQueries().deleteItemContent(itemId, agentId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateItemTagBindingsHavingTag(TagServiceHelper.TagView tagView) {
        PersistenceService.getInstance().getPublishedItemFacadeQueries().updateItemTagBindingsHavingTag(tagView);
    }

    @Override
    public void deleteItemTagBindingsHavingTagId(String tagId) {
        PersistenceService.getInstance().getPublishedItemFacadeQueries().deleteItemTagBindingsHavingTagId(tagId);
    }

    @Override
    public void updateItemTagBindingsHavingTagCollection(TagServiceHelper.TagCollectionView tagCollectionView) {
        PersistenceService.getInstance().getPublishedItemFacadeQueries().updateItemTagBindingsHavingTagCollection(tagCollectionView);
    }

    @Override
    public void deleteItemTagBindingsHavingTagCollectionId(String tagCollectionId) {
        PersistenceService.getInstance().getPublishedItemFacadeQueries().deleteItemTagBindingsHavingTagCollectionId(tagCollectionId);
    }

    @Override
    public BackfillItemHashResult backfillItemHashes(int batchSize, boolean backfillBaselineHashes) {
        return PersistenceService.getInstance().getPublishedItemFacadeQueries().backfillItemHashes(batchSize, backfillBaselineHashes);
    }
}

