/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.shared.impl.grading;

import org.sakaiproject.tool.assessment.data.dao.assessment.PublishedAssessmentData;
import org.sakaiproject.tool.assessment.data.dao.grading.AssessmentGradingData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.PublishedAssessmentFacade;
import org.sakaiproject.tool.assessment.services.GradingServiceException;
import org.sakaiproject.tool.assessment.services.assessment.PublishedAssessmentService;
import org.sakaiproject.tool.assessment.services.gradebook.GradebookServiceHelper;
import org.sakaiproject.tool.assessment.shared.api.grading.GradebookServiceAPI;

public class GradebookServiceImpl
implements GradebookServiceAPI {
    public boolean isAssignmentDefined(String assessmentTitle) {
        try {
            return GradebookServiceHelper.isAssignmentDefined(assessmentTitle);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public boolean addToGradebook(PublishedAssessmentIfc publishedAssessment) {
        try {
            Long id = publishedAssessment.getPublishedAssessmentId();
            PublishedAssessmentService pubService = new PublishedAssessmentService();
            PublishedAssessmentFacade pubFacade = pubService.getPublishedAssessment(id.toString());
            PublishedAssessmentIfc data = pubFacade.getData();
            return GradebookServiceHelper.addToGradebook((PublishedAssessmentData)data);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public void removeExternalAssessment(String siteId, String publishedAssessmentId) {
        try {
            GradebookServiceHelper.removeExternalAssessment(siteId, publishedAssessmentId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public void updateExternalAssessment(AssessmentGradingData ag, String agentIdString) {
    }

    public boolean gradebookExists(String siteId) {
        try {
            return GradebookServiceHelper.gradebookExists(siteId);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }

    public void updateExternalAssessmentScore(AssessmentGradingData ag) {
        try {
            GradebookServiceHelper.updateExternalAssessmentScore(ag);
        }
        catch (Exception ex) {
            throw new GradingServiceException(ex);
        }
    }
}

