/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.business.entity;

import java.util.Date;
import org.sakaiproject.tool.assessment.business.entity.SortableDate;
import org.sakaiproject.tool.assessment.util.StringParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNamer {
    private static final Logger log = LoggerFactory.getLogger(FileNamer.class);
    private static final int maxAgentName = 20;
    private static final int maxAgentId = 10;
    private static final int maxcourseAssignmentContext = 15;
    private static final int maxCourseId = 10;
    private static final int maxFileName = 64;

    public static String make(String agent_name, String agent_id, String course_assignment_context) {
        agent_name = "" + agent_name;
        agent_id = "" + agent_id;
        course_assignment_context = "" + course_assignment_context;
        Date date = new Date();
        StringBuilder sb = new StringBuilder();
        String rand = "" + Math.random() + "" + Math.random();
        sb.append(StringParseUtils.simplifyString("" + agent_name, 20, agent_name.length()));
        sb.append(StringParseUtils.simplifyString("" + agent_id, 10, agent_id.length()));
        sb.append(StringParseUtils.simplifyString("" + course_assignment_context, 15, course_assignment_context.length()));
        sb.append(new SortableDate(date));
        sb.append("__");
        sb.append(StringParseUtils.simplifyString(rand, 99, 99));
        if (sb.length() > 64) {
            return sb.substring(0, 63);
        }
        return sb.toString();
    }

    public static void unitTest() {
        String s = FileNamer.make("Ed Smiley", "esmiley", "Intro to Wombats 101");
        log.debug("esmiley file: " + s);
        s = FileNamer.make("Rachel Gollub", "rgollub", "Intro to Wolverines and Aardvarks 221B");
        log.debug("rgollub file: " + s);
        s = FileNamer.make("Ed Smiley", "esmiley", "Intro to Wombats 101");
        log.debug("esmiley file: " + s);
        s = FileNamer.make("Rachel Gollub", "rgollub", "Intro to Wolverines and Aardvarks 221B");
        log.debug("rgollub file: " + s);
        s = FileNamer.make(null, null, null);
        log.debug("NULL file: " + s);
        s = FileNamer.make(null, null, null);
        log.debug("NULL file: " + s);
    }

    public static void main(String[] args) {
        FileNamer.unitTest();
    }
}

