/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.tool.assessment.data.dao.assessment.ExtendedTime;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AssessmentBaseIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.PublishedAssessmentIfc;
import org.sakaiproject.tool.assessment.facade.AssessmentFacade;
import org.sakaiproject.tool.assessment.facade.ExtendedTimeQueriesAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedTimeFacade {
    private static final Logger log = LoggerFactory.getLogger(ExtendedTimeFacade.class);
    private ExtendedTimeQueriesAPI extendedTimeQueries;

    public void init() {
        log.info("init");
    }

    public List<ExtendedTime> getEntriesForAss(AssessmentBaseIfc ass) {
        if (ass instanceof PublishedAssessmentIfc) {
            throw new IllegalArgumentException("getEntriesForAss accepts only unpublished assessments.");
        }
        return this.getEntriesForX(ass, null);
    }

    public List<ExtendedTime> getEntriesForPub(PublishedAssessmentIfc pub) {
        return this.getEntriesForX(null, pub);
    }

    public ExtendedTime getEntryForPubAndUser(PublishedAssessmentIfc pub, String user) {
        return this.extendedTimeQueries.getEntryForPubAndUser(pub, user);
    }

    public ExtendedTime getEntryForPubAndGroup(PublishedAssessmentIfc pub, String group) {
        return this.extendedTimeQueries.getEntryForPubAndGroup(pub, group);
    }

    public void saveEntriesPub(PublishedAssessmentIfc p, List<ExtendedTime> entries) {
        this.saveExtendedTimeEntriesHelper(null, p, entries);
    }

    public void saveEntries(AssessmentFacade aFacade, List<ExtendedTime> entries) {
        this.saveExtendedTimeEntriesHelper(aFacade, null, entries);
    }

    public void copyEntriesToPub(PublishedAssessmentIfc pub, List<ExtendedTime> entries) {
        ArrayList<ExtendedTime> publishedTimes = new ArrayList<ExtendedTime>(entries.size());
        for (ExtendedTime entry : entries) {
            ExtendedTime pubEntry = new ExtendedTime(entry);
            pubEntry.setId(null);
            pubEntry.setAssessment(null);
            pubEntry.setPubAssessment(pub);
            publishedTimes.add(pubEntry);
        }
        this.saveEntriesPub(pub, publishedTimes);
    }

    private List<ExtendedTime> getEntriesForX(AssessmentBaseIfc ass, PublishedAssessmentIfc pub) {
        List<ExtendedTime> results = ass == null ? this.extendedTimeQueries.getEntriesForPub(pub) : this.extendedTimeQueries.getEntriesForAss(ass);
        if (results == null) {
            results = new ArrayList<ExtendedTime>(0);
        }
        return results;
    }

    private void syncExtendedTimeDates(List<ExtendedTime> et) {
        for (ExtendedTime e : et) {
            e.syncDates();
        }
    }

    private void saveExtendedTimeEntriesHelper(AssessmentFacade assFacade, PublishedAssessmentIfc p, List<ExtendedTime> newExtendedTime) {
        List<ExtendedTime> oldExtendedTime;
        if (assFacade == null) {
            oldExtendedTime = this.extendedTimeQueries.getEntriesForPub(p);
            this.syncExtendedTimeDates(newExtendedTime);
        } else {
            oldExtendedTime = this.extendedTimeQueries.getEntriesForAss(assFacade.getData());
            this.syncExtendedTimeDates(newExtendedTime);
        }
        ArrayList<ExtendedTime> extraneousInOld = new ArrayList<ExtendedTime>();
        for (ExtendedTime old : oldExtendedTime) {
            boolean matched = false;
            for (ExtendedTime newET : newExtendedTime) {
                if (!old.getId().equals(newET.getId())) continue;
                matched = true;
            }
            if (matched) continue;
            extraneousInOld.add(old);
        }
        for (ExtendedTime item : extraneousInOld) {
            this.extendedTimeQueries.deleteEntry(item);
        }
        this.extendedTimeQueries.updateEntries(newExtendedTime);
    }

    public void setExtendedTimeQueries(ExtendedTimeQueriesAPI extendedTimeQueries) {
        this.extendedTimeQueries = extendedTimeQueries;
    }
}

