/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osid.assessment.AssessmentException;
import org.osid.assessment.Item;
import org.osid.shared.Id;
import org.osid.shared.Type;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemFeedback;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemMetaData;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTag;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemText;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemAttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemFeedbackIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemMetaDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTagIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.DataFacadeException;
import org.sakaiproject.tool.assessment.facade.ItemFacadeQueries;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacade;
import org.sakaiproject.tool.assessment.facade.TypeFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.assessment.impl.ItemImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemFacade
implements Serializable,
ItemDataIfc,
Comparable<ItemDataIfc> {
    private static final Logger log = LoggerFactory.getLogger(ItemFacade.class);
    private static final long serialVersionUID = 7526471155622776147L;
    protected Item item;
    protected Id id;
    protected String description;
    protected ItemDataIfc data;
    protected Type itemType;
    protected Long itemId;
    protected String itemIdString;
    private SectionFacade section;
    protected Integer sequence;
    protected Integer duration;
    protected Integer triesAllowed;
    protected String instruction;
    protected Long typeId;
    protected String grade;
    protected Double score;
    protected Double discount;
    protected Boolean scoreDisplayFlag;
    protected Double minScore;
    protected String hint;
    protected String hash;
    protected Boolean partialCreditFlag;
    protected Boolean hasRationale;
    protected Integer status;
    protected String createdBy;
    protected Date createdDate;
    protected String lastModifiedBy;
    protected Date lastModifiedDate;
    protected Set itemTextSet;
    protected Set itemMetaDataSet;
    protected Set itemTagSet;
    protected Set itemFeedbackSet;
    protected TypeFacade itemTypeFacade;
    protected Set itemAttachmentSet;
    protected String itemAttachmentMetaData;
    protected String themeText;
    protected String leadInText;
    protected Integer answerOptionsRichCount;
    protected Integer answerOptionsSimpleOrRich;

    public ItemFacade() {
        this.data = new ItemData();
        ItemImpl itemImpl = new ItemImpl();
        this.item = itemImpl;
        try {
            this.item.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
    }

    public ItemFacade(ItemDataIfc data) {
        this.data = data;
        ItemImpl itemImpl = new ItemImpl();
        this.item = itemImpl;
        try {
            this.item.updateData((Serializable)this.data);
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.id = this.getId();
        this.description = this.getDescription();
        this.itemType = this.getItemType();
        this.itemTextSet = this.getItemTextSet();
        this.itemMetaDataSet = this.getItemMetaDataSet();
        this.itemTagSet = this.getItemTagSet();
        this.itemFeedbackSet = this.getItemFeedbackSet();
        this.hasRationale = data.getHasRationale();
        this.itemAttachmentSet = this.getItemAttachmentSet();
        this.answerOptionsRichCount = this.getAnswerOptionsRichCount();
        this.answerOptionsSimpleOrRich = this.getAnswerOptionsSimpleOrRich();
    }

    Id getId() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        ItemFacadeQueries itemFacadeQueries = new ItemFacadeQueries();
        return itemFacadeQueries.getItemId(this.data.getItemId());
    }

    Type getItemType() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeById(this.data.getTypeId());
    }

    public TypeIfc getType() {
        return this.getItemTypeFacade();
    }

    public TypeFacade getItemTypeFacade() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        TypeFacadeQueriesAPI typeFacadeQueries = PersistenceService.getInstance().getTypeFacadeQueries();
        return typeFacadeQueries.getTypeFacadeById(this.data.getTypeId());
    }

    public ItemDataIfc getData() {
        return this.data;
    }

    public void updateData(ItemDataIfc data) {
        this.setData(data);
    }

    public void setData(ItemDataIfc data) {
        this.data = data;
    }

    public Long getItemId() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemId();
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
        this.data.setItemId(itemId);
        this.setItemIdString(itemId.toString());
    }

    public String getItemIdString() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemIdString();
    }

    public void setItemIdString(String itemIdString) {
        this.itemIdString = itemIdString;
        this.data.setItemIdString(itemIdString);
    }

    public SectionDataIfc getSection() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        if (this.data.getSection() != null) {
            return new SectionFacade(this.data.getSection());
        }
        return null;
    }

    public void setSection(SectionDataIfc section) {
        this.section = (SectionFacade)section;
        if (this.section != null) {
            this.data.setSection(this.section.getData());
        } else {
            this.data.setSection(null);
        }
    }

    public Integer getSequence() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getSequence();
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
        this.data.setSequence(sequence);
    }

    public Integer getDuration() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDuration();
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
        this.data.setDuration(duration);
    }

    public String getInstruction() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getInstruction();
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
        this.data.setInstruction(instruction);
    }

    public String getDescription() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDescription();
    }

    public void setDescription(String description) {
        this.description = description;
        this.data.setDescription(description);
    }

    public Long getTypeId() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTypeId();
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
        this.data.setTypeId(typeId);
    }

    public String getGrade() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getGrade();
    }

    public void setGrade(String grade) {
        this.grade = grade;
        this.data.setGrade(grade);
    }

    public Double getScore() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getScore();
    }

    public void setScore(Double score) {
        this.score = score;
        this.data.setScore(score);
    }

    public Double getDiscount() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getDiscount();
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
        this.data.setDiscount(discount);
    }

    public String getHint() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getHint();
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.data.setHint(hint);
    }

    public String getHash() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getHash();
    }

    public void setHash(String hash) {
        this.hash = hash;
        this.data.setHash(hash);
    }

    public Boolean getHasRationale() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getHasRationale();
    }

    public void setHasRationale(Boolean hasRationale) {
        this.hasRationale = hasRationale;
        this.data.setHasRationale(hasRationale);
    }

    public Integer getStatus() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getStatus();
    }

    public void setStatus(Integer status) {
        this.status = status;
        this.data.setStatus(status);
    }

    public String getCreatedBy() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getCreatedBy();
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        this.data.setCreatedBy(createdBy);
    }

    public Date getCreatedDate() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getCreatedDate();
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
        this.data.setCreatedDate(createdDate);
    }

    public String getLastModifiedBy() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedBy();
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        this.data.setLastModifiedBy(lastModifiedBy);
    }

    public Date getLastModifiedDate() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getLastModifiedDate();
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
        this.data.setLastModifiedDate(lastModifiedDate);
    }

    public Set getItemTextSet() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemTextSet();
    }

    public void setItemTextSet(Set itemTextSet) {
        this.itemTextSet = itemTextSet;
        this.data.setItemTextSet(itemTextSet);
    }

    public Set getItemMetaDataSet() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemMetaDataSet();
    }

    public void setItemMetaDataSet(Set itemMetaDataSet) {
        this.itemMetaDataSet = itemMetaDataSet;
        this.data.setItemMetaDataSet(itemMetaDataSet);
    }

    public Set getItemTagSet() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemTagSet();
    }

    public void setItemTagSet(Set itemTagSet) {
        this.itemTagSet = itemTagSet;
        this.data.setItemTagSet(itemTagSet);
    }

    public void addItemTag(String tagId, String tagLabel, String tagCollectionId, String tagCollectionName) {
        if (this.getItemTagSet() == null) {
            this.setItemTagSet(new HashSet());
        }
        this.getItemTagSet().add(new ItemTag(this.data, tagId, tagLabel, tagCollectionId, tagCollectionName));
        this.itemTextSet = this.getItemTagSet();
    }

    public void removeItemTagByTagId(String tagId) {
        Set itemTagSet = this.getItemTagSet();
        if (itemTagSet == null || itemTagSet.isEmpty()) {
            return;
        }
        itemTagSet.removeIf(itemTag -> tagId.equals(((ItemTagIfc)itemTag).getTagId()));
        this.itemTagSet = this.getItemTagSet();
    }

    public Set getItemFeedbackSet() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemFeedbackSet();
    }

    public void setItemFeedbackSet(Set itemFeedbackSet) {
        this.itemFeedbackSet = itemFeedbackSet;
        this.data.setItemFeedbackSet(itemFeedbackSet);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void addItemText(String text, Set answerSet) {
        if (this.data.getItemTextSet() == null) {
            this.data.setItemTextSet(new HashSet());
        }
        Long sequence = this.data.getItemTextSet().size() + 1;
        ItemText itemText = new ItemText((ItemData)this.data, sequence, text, answerSet);
        this.data.getItemTextSet().add(itemText);
        this.itemTextSet = this.data.getItemTextSet();
    }

    public String getItemMetaDataByLabel(String label) {
        if (this.itemMetaDataSet != null) {
            for (ItemMetaDataIfc itemMetaData : this.itemMetaDataSet) {
                if (!itemMetaData.getLabel().equals(label)) continue;
                return itemMetaData.getEntry();
            }
        }
        return null;
    }

    public void addItemMetaData(String label, String entry) {
        if (this.itemMetaDataSet == null) {
            this.setItemMetaDataSet(new HashSet());
        }
        this.data.getItemMetaDataSet().add(new ItemMetaData((ItemDataIfc)((ItemData)this.data), label, entry));
        this.itemMetaDataSet = this.data.getItemMetaDataSet();
    }

    public String getGeneralItemFeedback() {
        return this.getItemFeedback("General Feedback");
    }

    public void setGeneralItemFeedback(String text) {
        this.removeFeedbackByType("General Feedback");
        this.addItemFeedback("General Feedback", text);
    }

    public String getCorrectItemFeedback() {
        return this.getItemFeedback("Correct Feedback");
    }

    public void setCorrectItemFeedback(String text) {
        this.removeFeedbackByType("Correct Feedback");
        this.addItemFeedback("Correct Feedback", text);
    }

    public String getInCorrectItemFeedback() {
        return this.getItemFeedback("InCorrect Feedback");
    }

    public void setInCorrectItemFeedback(String text) {
        this.removeFeedbackByType("InCorrect Feedback");
        this.addItemFeedback("InCorrect Feedback", text);
    }

    public String getItemFeedback(String feedbackTypeId) {
        for (ItemFeedbackIfc itemFeedback : this.itemFeedbackSet) {
            if (!itemFeedback.getTypeId().equals(feedbackTypeId)) continue;
            return itemFeedback.getText();
        }
        return null;
    }

    public void addItemFeedback(String feedbackTypeId, String text) {
        if (this.itemFeedbackSet == null) {
            this.setItemFeedbackSet(new HashSet());
        }
        this.data.getItemFeedbackSet().add(new ItemFeedback((ItemData)this.data, feedbackTypeId, text));
        this.itemFeedbackSet = this.data.getItemFeedbackSet();
    }

    public void removeFeedbackByType(String feedbackTypeId) {
        this.itemFeedbackSet = this.data.getItemFeedbackSet();
        if (this.itemFeedbackSet != null) {
            HashSet<ItemFeedbackIfc> toBeRemovedSet = new HashSet<ItemFeedbackIfc>();
            for (ItemFeedbackIfc itemFeedback : this.itemFeedbackSet) {
                if (!itemFeedback.getTypeId().equals(feedbackTypeId)) continue;
                toBeRemovedSet.add(itemFeedback);
            }
            this.itemFeedbackSet.removeAll(toBeRemovedSet);
        }
    }

    public Boolean getIsTrue() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getIsTrue();
    }

    public String getText() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getText();
    }

    public ArrayList getItemTextArray() {
        ArrayList list = new ArrayList();
        Iterator iter = this.itemTextSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public ArrayList getItemTextArraySorted() {
        ArrayList list = this.getItemTextArray();
        Collections.sort(list);
        return list;
    }

    public Integer getTriesAllowed() throws DataFacadeException {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getTriesAllowed();
    }

    public void setTriesAllowed(Integer triesAllowed) {
        this.triesAllowed = triesAllowed;
        this.data.setTriesAllowed(triesAllowed);
    }

    public void removeMetaDataByType(String label) {
        try {
            if (this.itemMetaDataSet != null) {
                Iterator i = this.itemMetaDataSet.iterator();
                while (i.hasNext()) {
                    ItemMetaDataIfc itemMetaData = (ItemMetaDataIfc)i.next();
                    if (!itemMetaData.getLabel().equals(label)) continue;
                    i.remove();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getAnswerKey() {
        return ((ItemData)this.data).getAnswerKey();
    }

    @Override
    public int compareTo(ItemDataIfc o) {
        return this.sequence.compareTo(o.getSequence());
    }

    public Set getItemAttachmentSet() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemAttachmentSet();
    }

    public void setItemAttachmentSet(Set itemAttachmentSet) {
        this.itemAttachmentSet = itemAttachmentSet;
        this.data.setItemAttachmentSet(itemAttachmentSet);
    }

    public void addItemAttachment(ItemAttachmentIfc attachment) {
        this.getItemAttachmentSet();
        this.data.addItemAttachment(attachment);
    }

    public void removeItemAttachment(ItemAttachmentIfc attachment) {
        this.getItemAttachmentSet();
        this.data.removeItemAttachment(attachment);
    }

    public void removeItemAttachmentById(Long attachmentId) {
        this.getItemAttachmentSet();
        this.data.removeItemAttachmentById(attachmentId);
    }

    public Map<Long, ItemAttachmentIfc> getItemAttachmentMap() {
        this.getItemAttachmentSet();
        return this.data.getItemAttachmentMap();
    }

    public List<ItemAttachmentIfc> getItemAttachmentList() {
        this.getItemAttachmentSet();
        return this.data.getItemAttachmentList();
    }

    public void addItemAttachmentMetaData(String entry) {
        this.itemAttachmentMetaData = entry;
    }

    public String getItemAttachmentMetaData() {
        return this.itemAttachmentMetaData;
    }

    public String getLeadInText() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.leadInText = this.data.getLeadInText();
        return this.leadInText;
    }

    public String getThemeText() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        this.themeText = this.data.getThemeText();
        return this.themeText;
    }

    public int getNumberOfCorrectEmiOptions() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getNumberOfCorrectEmiOptions();
    }

    public String getEmiAnswerOptionLabels() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getEmiAnswerOptionLabels();
    }

    public boolean isValidEmiAnswerOptionLabel(String label) {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.isValidEmiAnswerOptionLabel(label);
    }

    public void setPartialCreditFlag(Boolean partialCreditFlag) {
        this.partialCreditFlag = partialCreditFlag;
        this.data.setPartialCreditFlag(partialCreditFlag);
    }

    public Boolean getPartialCreditFlag() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getPartialCreditFlag();
    }

    public String getImageMapSrc() {
        return this.getItemMetaDataByLabel("IMAGE_MAP_SRC");
    }

    public String getImageMapAltText() {
        return this.getItemMetaDataByLabel("IMAGE_MAP_ALT_TEXT");
    }

    public List getEmiAnswerOptions() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getEmiAnswerOptions();
    }

    public List getEmiQuestionAnswerCombinations() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getEmiQuestionAnswerCombinations();
    }

    public ItemTextIfc getItemTextBySequence(Long itemTextSequence) {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getItemTextBySequence(itemTextSequence);
    }

    public Integer getAnswerOptionsRichCount() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAnswerOptionsRichCount();
    }

    public void setAnswerOptionsRichCount(Integer answerOptionsRichCount) {
        this.answerOptionsRichCount = answerOptionsRichCount;
        this.data.setAnswerOptionsRichCount(answerOptionsRichCount);
    }

    public Integer getAnswerOptionsSimpleOrRich() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getAnswerOptionsSimpleOrRich();
    }

    public void setAnswerOptionsSimpleOrRich(Integer answerOptionsSimpleOrRich) {
        this.answerOptionsSimpleOrRich = answerOptionsSimpleOrRich;
        this.data.setAnswerOptionsSimpleOrRich(answerOptionsSimpleOrRich);
    }

    public String getEmiAnswerOptionsRichText() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getEmiAnswerOptionsRichText();
    }

    public boolean getIsAnswerOptionsSimple() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getIsAnswerOptionsSimple();
    }

    public boolean getIsAnswerOptionsRich() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getIsAnswerOptionsRich();
    }

    public Double getMinScore() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getMinScore();
    }

    public void setMinScore(Double minScore) {
        this.minScore = minScore;
        this.data.setMinScore(minScore);
    }

    public Boolean getScoreDisplayFlag() {
        try {
            this.data = (ItemDataIfc)this.item.getData();
        }
        catch (AssessmentException ex) {
            throw new DataFacadeException(ex.getMessage());
        }
        return this.data.getScoreDisplayFlag();
    }

    public void setScoreDisplayFlag(Boolean scoreDisplayFlag) {
        this.scoreDisplayFlag = scoreDisplayFlag;
        this.data.setScoreDisplayFlag(scoreDisplayFlag);
    }

    public String getTagListToJsonString() {
        return this.data.getTagListToJsonString();
    }

    public void setTagListToJsonString(String tagListToJsonString) {
        this.data.setTagListToJsonString(tagListToJsonString);
    }
}

