/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AttachmentIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemDataIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.facade.BackfillItemHashResult;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

class ItemHashUtil {
    private static final Logger log = LoggerFactory.getLogger(ItemHashUtil.class);
    static final String TOTAL_ITEM_COUNT_HQL = "total.item.count.hql";
    static final String TOTAL_HASH_BACKFILLABLE_ITEM_COUNT_HQL = "total.hash.backfillable.item.count.hql";
    static final String ALL_HASH_BACKFILLABLE_ITEM_IDS_HQL = "all.backfillable.item.ids.hql";
    static final String ITEMS_BY_ID_HQL = "items.by.id.hql";
    static final String ID_PARAMS_PLACEHOLDER = "{ID_PARAMS}";
    private ContentHostingService contentHostingService;
    private PlatformTransactionManager transactionManager;

    ItemHashUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BackfillItemHashResult backfillItemHashes(int batchSize, Map<String, String> hqlQueries, Class<? extends ItemDataIfc> concreteType, Function<ItemDataIfc, ItemDataIfc> hashAndAssignCallback, HibernateTemplate hibernateTemplate) {
        long startTime = System.currentTimeMillis();
        log.debug("Hash backfill starting for items of type [" + concreteType.getSimpleName() + "]");
        if (batchSize <= 0) {
            batchSize = 100;
        }
        int flushSize = batchSize;
        AtomicInteger totalItems = new AtomicInteger(0);
        AtomicInteger totalItemsNeedingBackfill = new AtomicInteger(0);
        AtomicInteger batchNumber = new AtomicInteger(0);
        AtomicInteger recordsRead = new AtomicInteger(0);
        AtomicInteger recordsUpdated = new AtomicInteger(0);
        TreeMap<Long, Throwable> hashingErrors = new TreeMap<Long, Throwable>();
        TreeMap<Integer, Throwable> otherErrors = new TreeMap<Integer, Throwable>();
        ArrayList<Long> batchElapsedTimes = new ArrayList<Long>();
        AtomicReference<String> currentAvgBatchElapsedTime = new AtomicReference<String>("0.00");
        AtomicBoolean areMoreItems = new AtomicBoolean(true);
        hibernateTemplate.execute(session -> {
            session.setDefaultReadOnly(true);
            totalItems.set(this.countItems(hqlQueries, session));
            totalItemsNeedingBackfill.set(this.countItemsNeedingHashBackfill(hqlQueries, session));
            log.debug("Hash backfill required for [" + totalItemsNeedingBackfill + "] of [" + totalItems + "] items of type [" + concreteType.getSimpleName() + "]");
            return null;
        });
        while (areMoreItems.get()) {
            long batchStartTime = System.currentTimeMillis();
            batchNumber.getAndIncrement();
            AtomicInteger itemsHashedInBatch = new AtomicInteger(0);
            AtomicInteger itemsReadInBatch = new AtomicInteger(0);
            AtomicReference<Object> failure = new AtomicReference<Object>(null);
            try {
                new TransactionTemplate(this.transactionManager, this.requireNewTransaction()).execute(status -> {
                    hibernateTemplate.execute(session -> {
                        List<ItemDataIfc> itemsInBatch = null;
                        try {
                            session.setFlushMode(FlushMode.MANUAL);
                            try {
                                List<Long> itemIds = this.itemIdsNeedingHashBackfill(hqlQueries, flushSize, hashingErrors.size(), session);
                                itemsInBatch = this.itemsById(itemIds, hqlQueries, session);
                            }
                            catch (RuntimeException e) {
                                log.error("Failed to read batch of hashable items. Giving up at record [" + recordsRead + "] of [" + totalItemsNeedingBackfill + "] Type: [" + concreteType.getSimpleName() + "]", (Throwable)e);
                                areMoreItems.set(false);
                                throw e;
                            }
                            for (ItemDataIfc item : itemsInBatch) {
                                recordsRead.getAndIncrement();
                                itemsReadInBatch.getAndIncrement();
                                try {
                                    log.debug("Backfilling hash for item [" + recordsRead + "] of [" + totalItemsNeedingBackfill + "] Type: [" + concreteType.getSimpleName() + "] ID: [" + item.getItemId() + "]");
                                    hashAndAssignCallback.apply(item);
                                    itemsHashedInBatch.getAndIncrement();
                                }
                                catch (Throwable t) {
                                    log.error("Item hash calculation failed for item [" + recordsRead + "] of [" + totalItemsNeedingBackfill + "] Type: [" + concreteType.getSimpleName() + "] ID: [" + (item == null ? "?" : item.getItemId()) + "]", t);
                                    hashingErrors.put(item.getItemId(), t);
                                }
                            }
                            if (itemsHashedInBatch.get() > 0) {
                                session.flush();
                                recordsUpdated.getAndAdd(itemsHashedInBatch.get());
                            }
                            areMoreItems.set(itemsInBatch.size() >= flushSize);
                        }
                        finally {
                            this.quietlyClear(session);
                        }
                        return null;
                    });
                    return null;
                });
            }
            catch (Throwable t) {
                failure.set(t);
                otherErrors.put(batchNumber.get(), t);
            }
            finally {
                long batchElapsed = System.currentTimeMillis() - batchStartTime;
                batchElapsedTimes.add(batchElapsed);
                currentAvgBatchElapsedTime.set(new DecimalFormat("#.00").format(batchElapsedTimes.stream().collect(Collectors.averagingLong(l -> l))));
                if (failure.get() == null) {
                    log.debug("Item hash backfill batch flushed to database. Type: [" + concreteType.getSimpleName() + "] Batch number: [" + batchNumber + "] Items attempted in batch: [" + itemsReadInBatch + "] Items succeeded in batch: [" + itemsHashedInBatch + "] Total items attempted: [" + recordsRead + "] Total items succeeded: [" + recordsUpdated + "] Total attemptable items: [" + totalItemsNeedingBackfill + "] Elapsed batch time: [" + batchElapsed + "ms] Avg time/batch: [" + currentAvgBatchElapsedTime + "ms]");
                    continue;
                }
                log.error("Item hash backfill failed. Type: [" + concreteType.getSimpleName() + "] Batch number: [" + batchNumber + "] Items attempted in batch: [" + itemsReadInBatch + "] Items flushable (but failed) in batch: [" + itemsHashedInBatch + "] Total items attempted: [" + recordsRead + "] Total items succeeded: [" + recordsUpdated + "] Total attemptable items: [" + totalItemsNeedingBackfill + "] Elapsed batch time: [" + batchElapsed + "ms] Avg time/batch: [" + currentAvgBatchElapsedTime + "ms]", (Throwable)failure.get());
            }
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        log.debug("Hash backfill completed for items of type [" + concreteType.getSimpleName() + "]. Total items attempted: [" + recordsRead + "] Total items succeeded: [" + recordsUpdated + "] Target attemptable items: [" + totalItemsNeedingBackfill + "] Total elapsed time: [" + elapsedTime + "ms] Total batches: [" + batchNumber + "] Avg time/batch: [" + currentAvgBatchElapsedTime + "ms]");
        return new BackfillItemHashResult(elapsedTime, totalItems.get(), totalItemsNeedingBackfill.get(), recordsRead.get(), recordsUpdated.get(), flushSize, hashingErrors, otherErrors);
    }

    private int countItems(Map<String, String> hqlQueries, Session session) {
        List totalItemsResult = session.createQuery(hqlQueries.get(TOTAL_ITEM_COUNT_HQL)).setReadOnly(true).list();
        return (Integer)totalItemsResult.get(0);
    }

    private int countItemsNeedingHashBackfill(Map<String, String> hqlQueries, Session session) {
        List totalItemsNeedingBackfillResult = session.createQuery(hqlQueries.get(TOTAL_HASH_BACKFILLABLE_ITEM_COUNT_HQL)).setReadOnly(true).list();
        return (Integer)totalItemsNeedingBackfillResult.get(0);
    }

    private List<Long> itemIdsNeedingHashBackfill(Map<String, String> hqlQueries, int pageSize, int pageStart, Session session) {
        return session.createQuery(hqlQueries.get(ALL_HASH_BACKFILLABLE_ITEM_IDS_HQL)).setFirstResult(pageStart).setMaxResults(pageSize).list();
    }

    private List<ItemDataIfc> itemsById(List<Long> itemIds, Map<String, String> hqlQueries, Session session) {
        if (itemIds == null || itemIds.isEmpty()) {
            return new ArrayList<ItemDataIfc>(0);
        }
        String paramPlaceholders = StringUtils.repeat((String)"?", (String)",", (int)itemIds.size());
        Query query = session.createQuery(hqlQueries.get(ITEMS_BY_ID_HQL).replace(ID_PARAMS_PLACEHOLDER, paramPlaceholders));
        AtomicInteger position = new AtomicInteger(0);
        itemIds.forEach(id -> query.setParameter(position.getAndIncrement(), id));
        return query.list();
    }

    private TransactionDefinition requireNewTransaction() {
        return new DefaultTransactionDefinition(3);
    }

    private void quietlyClear(Session session) {
        if (session != null) {
            try {
                session.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    String hashItem(ItemDataIfc item) throws NoSuchAlgorithmException, IOException, ServerOverloadException {
        StringBuilder hashBase = this.hashBaseForItem(item);
        return this.hashString(hashBase.toString());
    }

    String hashItemUnchecked(ItemDataIfc item) {
        try {
            return this.hashItem(item);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    StringBuilder hashBaseForItem(ItemDataIfc item) throws NoSuchAlgorithmException, IOException, ServerOverloadException {
        StringBuilder hashBase = new StringBuilder();
        this.hashBaseForItemCoreProperties(item, hashBase);
        this.hashBaseForItemAttachments(item, hashBase);
        this.hashBaseForItemAnswers(item, hashBase);
        this.hashBaseForItemMetadata(item, hashBase);
        return hashBase;
    }

    StringBuilder hashBaseForItemCoreProperties(ItemDataIfc item, StringBuilder into) throws NoSuchAlgorithmException, IOException, ServerOverloadException {
        into.append("TypeId:" + item.getTypeId() + "::");
        if (item.getTypeId() == TypeIfc.EXTENDED_MATCHING_ITEMS) {
            into.append(this.normalizeResourceUrls("ThemeText", item.getThemeText())).append(this.normalizeResourceUrls("LeadInText", item.getLeadInText()));
        } else {
            into.append(this.normalizeResourceUrls("ItemText", item.getText())).append(this.normalizeResourceUrls("Instruction", item.getInstruction()));
        }
        return into.append(this.normalizeResourceUrls("CorrectItemFeedback", item.getCorrectItemFeedback())).append(this.normalizeResourceUrls("IncorrectItemFeedback", item.getInCorrectItemFeedback())).append(this.normalizeResourceUrls("GeneralCorrectItemFeedback", item.getGeneralItemFeedback())).append(this.normalizeResourceUrls("Description", item.getDescription()));
    }

    StringBuilder hashBaseForItemAttachments(ItemDataIfc item, StringBuilder into) throws NoSuchAlgorithmException, IOException, ServerOverloadException {
        AssessmentService service = new AssessmentService();
        List attachmentResourceIds = service.getItemResourceIdList(item);
        if (attachmentResourceIds == null) {
            return into;
        }
        return this.hashBaseForResourceIds(attachmentResourceIds, into);
    }

    StringBuilder hashBaseForItemAnswers(ItemDataIfc item, StringBuilder into) throws NoSuchAlgorithmException, IOException, ServerOverloadException {
        if (item.getTypeId() == TypeIfc.EXTENDED_MATCHING_ITEMS) {
            if (item.getIsAnswerOptionsSimple()) {
                for (AnswerIfc answerIfc : item.getEmiAnswerOptions()) {
                    into.append(this.normalizeResourceUrls("EmiLabel", answerIfc.getLabel()));
                }
            }
            if (item.getIsAnswerOptionsRich()) {
                into.append(this.normalizeResourceUrls("EmiAnswerOptionsRichText", item.getEmiAnswerOptionsRichText()));
            }
            for (ItemTextIfc itemTextIfc : item.getEmiQuestionAnswerCombinations()) {
                into.append(this.normalizeResourceUrls("EmiCorrectOptionLabels", itemTextIfc.getEmiCorrectOptionLabels()));
                into.append(this.normalizeResourceUrls("EmiSequence", Long.toString(itemTextIfc.getSequence())));
                into.append(this.normalizeResourceUrls("EmiText", itemTextIfc.getText()));
                if (!itemTextIfc.getHasAttachment() || !itemTextIfc.isEmiQuestionItemText()) continue;
                List<String> itemTextAttachmentIfcList = itemTextIfc.getItemTextAttachmentSet().stream().map(AttachmentIfc::getResourceId).collect(Collectors.toList());
                into = this.hashBaseForResourceIds(itemTextAttachmentIfcList, into);
            }
        } else {
            List itemTextArraySorted = item.getItemTextArraySorted();
            for (ItemTextIfc itemTextIfc : itemTextArraySorted) {
                if (item.getTypeId().equals(TypeIfc.MATCHING) || item.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY) || item.getTypeId().equals(TypeIfc.CALCULATED_QUESTION) || item.getTypeId().equals(TypeIfc.IMAGEMAP_QUESTION)) {
                    into.append(this.normalizeResourceUrls("ItemTextAnswer", itemTextIfc.getText()));
                }
                if (item.getTypeId() == TypeIfc.AUDIO_RECORDING || item.getTypeId() == TypeIfc.FILE_UPLOAD) continue;
                List answerArraySorted = itemTextIfc.getAnswerArraySorted();
                for (AnswerIfc answerIfc : answerArraySorted) {
                    String getIsCorrect = "" + answerIfc.getIsCorrect();
                    if (getIsCorrect.equals("null")) {
                        getIsCorrect = null;
                    }
                    into.append(this.normalizeResourceUrls("ItemTextAnswer", answerIfc.getText())).append(this.normalizeResourceUrls("CorrectAnswerFeedback", answerIfc.getCorrectAnswerFeedback())).append(this.normalizeResourceUrls("InCorrectAnswerFeedback", answerIfc.getInCorrectAnswerFeedback())).append(this.normalizeResourceUrls("GeneralAnswerFeedback", answerIfc.getGeneralAnswerFeedback())).append(this.normalizeResourceUrls("AnswerSequence", "" + answerIfc.getSequence())).append(this.normalizeResourceUrls("AnswerLabel", answerIfc.getLabel())).append(this.normalizeResourceUrls("AnswerIsCorrect", getIsCorrect));
                }
            }
        }
        return into;
    }

    StringBuilder hashBaseForResourceIds(List<String> resourceIdList, StringBuilder into) throws NoSuchAlgorithmException, IOException, ServerOverloadException {
        ArrayList<String> hashes = new ArrayList<String>(resourceIdList.size());
        for (String resourceId : resourceIdList) {
            String hash;
            ContentResource file = null;
            try {
                this.contentHostingService.checkResource(resourceId);
                file = this.contentHostingService.getResource(resourceId);
            }
            catch (Exception e) {
                log.debug("Failed to access resource by id " + resourceId, (Throwable)e);
            }
            if (file == null || (hash = this.hashResource(file, 1L)) == null) continue;
            hashes.add(hash);
        }
        if (hashes.size() > 0) {
            return into.append("Resources:" + hashes.stream().sorted().collect(Collectors.joining()) + "::");
        }
        return into;
    }

    StringBuilder hashBaseForItemMetadata(ItemDataIfc item, StringBuilder into) throws NoSuchAlgorithmException, IOException, ServerOverloadException {
        return into.append(this.normalizeMetadataUrl("RANDOMIZE", item.getItemMetaDataByLabel("RANDOMIZE"))).append(this.normalizeMetadataUrl("REQUIRE_ALL_OK", item.getItemMetaDataByLabel("REQUIRE_ALL_OK"))).append(this.normalizeMetadataUrl("IMAGE_MAP_SRC", item.getItemMetaDataByLabel("IMAGE_MAP_SRC"))).append(this.normalizeMetadataUrl("CASE_SENSITIVE", item.getItemMetaDataByLabel("CASE_SENSITIVE"))).append(this.normalizeMetadataUrl("MUTUALLY_EXCLUSIVE", item.getItemMetaDataByLabel("MUTUALLY_EXCLUSIVE"))).append(this.normalizeMetadataUrl("IGNORE_SPACES", item.getItemMetaDataByLabel("IGNORE_SPACES"))).append(this.normalizeMetadataUrl("MCMS_PARTIAL_CREDIT", item.getItemMetaDataByLabel("MCMS_PARTIAL_CREDIT"))).append(this.normalizeMetadataUrl("FORCE_RANKING", item.getItemMetaDataByLabel("FORCE_RANKING"))).append(this.normalizeMetadataUrl("MX_SURVEY_RELATIVE_WIDTH", item.getItemMetaDataByLabel("MX_SURVEY_RELATIVE_WIDTH"))).append(this.normalizeMetadataUrl("ADD_COMMENT_MATRIX", item.getItemMetaDataByLabel("ADD_COMMENT_MATRIX"))).append(this.normalizeResourceUrls("MX_SURVEY_QUESTION_COMMENTFIELD", item.getItemMetaDataByLabel("MX_SURVEY_QUESTION_COMMENTFIELD"))).append(this.normalizeMetadataUrl("PREDEFINED_SCALE", item.getItemMetaDataByLabel("PREDEFINED_SCALE"))).append(this.normalizeMetadataUrl("TIMEALLOWED", item.getItemMetaDataByLabel("TIMEALLOWED"))).append(this.normalizeMetadataUrl("NUMATTEMPTS", item.getItemMetaDataByLabel("NUMATTEMPTS"))).append(this.normalizeMetadataUrl("SCALENAME", item.getItemMetaDataByLabel("SCALENAME"))).append(this.normalizeMetadataUrl("ADD_TO_FAVORITES", item.getItemMetaDataByLabel("ADD_TO_FAVORITES"))).append(this.normalizeMetadataUrl("IMAGE_MAP_ALT_TEXT", item.getItemMetaDataByLabel("IMAGE_MAP_ALT_TEXT")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String hashResource(ContentResource cr, long lengthInKBToHash) throws NoSuchAlgorithmException, IOException, ServerOverloadException {
        if (cr == null) {
            return null;
        }
        String algorithm = "SHA-256";
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        if (lengthInKBToHash <= 0L) {
            lengthInKBToHash = Long.MAX_VALUE;
        }
        InputStream fis = cr.streamContent();
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            long lengthToRead = 0L;
            do {
                if ((numRead = fis.read(buffer)) <= 0) continue;
                md.update(buffer, 0, numRead);
                ++lengthToRead;
            } while (numRead != -1 && lengthToRead < lengthInKBToHash);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception buffer) {}
            }
        }
        md.update(("" + cr.getContentLength()).getBytes("UTF-8"));
        byte[] digest = md.digest();
        return Base64.encodeBase64String((byte[])digest);
    }

    String hashString(String textToHash) throws IOException, NoSuchAlgorithmException {
        String algorithm = "SHA-256";
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(textToHash.getBytes("UTF-8"));
        String rv = Base64.encodeBase64String((byte[])digest);
        return rv;
    }

    String normalizeResourceUrls(String label, String textToParse) throws IOException, NoSuchAlgorithmException, ServerOverloadException {
        if (StringUtils.isNotEmpty((String)textToParse)) {
            int beginIndex;
            String siteContentPath = "/access/content/";
            String startSrc = "src=\"";
            String endSrc = "\"";
            if (textToParse != null && (beginIndex = textToParse.indexOf(startSrc)) > 0) {
                String sakaiSiteResourcePath = ServerConfigurationService.getServerUrl() + siteContentPath;
                while (beginIndex > 0) {
                    String cleanResourceURL;
                    String resourceHash;
                    int endIndex;
                    String resourceURL;
                    int correctionIndex = 0;
                    if ((resourceURL = textToParse.substring(beginIndex += startSrc.length(), endIndex = textToParse.indexOf(endSrc, beginIndex))).contains(sakaiSiteResourcePath) && StringUtils.isNotEmpty((String)(resourceHash = this.hashBaseForResourceIds(Arrays.asList(cleanResourceURL = resourceURL.substring(sakaiSiteResourcePath.length() - 1)), new StringBuilder()).toString()))) {
                        textToParse = textToParse.replace(resourceURL, resourceHash);
                        correctionIndex = resourceHash.length() - resourceURL.length();
                    }
                    beginIndex = textToParse.indexOf(startSrc, endIndex + correctionIndex);
                }
            }
            return label + ":" + textToParse + "::";
        }
        return "";
    }

    String normalizeMetadataUrl(String label, String textToParse) throws IOException, NoSuchAlgorithmException, ServerOverloadException {
        String siteContentPath = "/access/content/";
        if (textToParse != null) {
            if (textToParse.startsWith(siteContentPath)) {
                String resourceId = textToParse.substring(siteContentPath.length() - 1);
                String resourceHash = this.hashBaseForResourceIds(Arrays.asList(resourceId), new StringBuilder()).toString();
                if (StringUtils.isNotEmpty((String)resourceHash)) {
                    textToParse = resourceHash;
                }
            }
            return label + ":" + textToParse + "::";
        }
        return "";
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

