/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.facade;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.Query;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionData;
import org.sakaiproject.tool.assessment.data.dao.assessment.SectionMetaData;
import org.sakaiproject.tool.assessment.data.ifc.assessment.SectionDataIfc;
import org.sakaiproject.tool.assessment.facade.SectionFacade;
import org.sakaiproject.tool.assessment.facade.SectionFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.osid.shared.impl.IdImpl;
import org.sakaiproject.tool.assessment.services.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public class SectionFacadeQueries
extends HibernateDaoSupport
implements SectionFacadeQueriesAPI {
    private static final Logger log = LoggerFactory.getLogger(SectionFacadeQueries.class);

    @Override
    public IdImpl getId(String id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getId(Long id) {
        return new IdImpl(id);
    }

    @Override
    public IdImpl getId(long id) {
        return new IdImpl(id);
    }

    @Override
    public SectionFacade get(Long sectionId) {
        SectionData section = (SectionData)this.getHibernateTemplate().load(SectionData.class, (Serializable)sectionId);
        return new SectionFacade((SectionDataIfc)section);
    }

    @Override
    public SectionData load(Long sectionId) {
        return (SectionData)this.getHibernateTemplate().load(SectionData.class, (Serializable)sectionId);
    }

    @Override
    public void addSectionMetaData(Long sectionId, String label, String value) {
        SectionData section = (SectionData)this.getHibernateTemplate().load(SectionData.class, (Serializable)sectionId);
        if (section != null) {
            SectionMetaData sectionmetadata = new SectionMetaData((SectionDataIfc)section, label, value);
            int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
            while (retryCount > 0) {
                try {
                    this.getHibernateTemplate().save((Object)sectionmetadata);
                    retryCount = 0;
                }
                catch (Exception e) {
                    log.warn("problem add section metadata: " + e.getMessage());
                    retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
                }
            }
        }
    }

    @Override
    public void deleteSectionMetaData(Long sectionId, String label) {
        String query = "from SectionMetaData imd where imd.section.sectionId = :id and imd.label = :label";
        HibernateCallback hcb = session -> {
            Query q = session.createQuery("from SectionMetaData imd where imd.section.sectionId = :id and imd.label = :label");
            q.setLong("id", sectionId.longValue());
            q.setString("label", label);
            return q.list();
        };
        List sectionmetadatalist = (List)this.getHibernateTemplate().execute(hcb);
        int retryCount = PersistenceService.getInstance().getPersistenceHelper().getRetryCount();
        while (retryCount > 0) {
            try {
                this.getHibernateTemplate().deleteAll((Collection)sectionmetadatalist);
                retryCount = 0;
            }
            catch (Exception e) {
                log.warn("problem delete section metadata: " + e.getMessage());
                retryCount = PersistenceService.getInstance().getPersistenceHelper().retryDeadlock(e, retryCount);
            }
        }
    }
}

