/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.sakaiproject.section.api.coursemanagement.EnrollmentRecord;

public class FacadeUtils {
    public static final Comparator ENROLLMENT_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            try {
                RuleBasedCollator r_collator = new RuleBasedCollator(((RuleBasedCollator)Collator.getInstance()).getRules().replaceAll("<'_'", "<' '<'_'"));
                return r_collator.compare(((EnrollmentRecord)o1).getUser().getSortName(), ((EnrollmentRecord)o2).getUser().getSortName());
            }
            catch (ParseException e) {
                return Collator.getInstance().compare(((EnrollmentRecord)o1).getUser().getSortName(), ((EnrollmentRecord)o2).getUser().getSortName());
            }
        }
    };
    public static final Comparator ENROLLMENT_DISPLAY_UID_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            try {
                RuleBasedCollator r_collator = new RuleBasedCollator(((RuleBasedCollator)Collator.getInstance()).getRules().replaceAll("<'_'", "<' '<'_'"));
                return r_collator.compare(((EnrollmentRecord)o1).getUser().getDisplayId(), ((EnrollmentRecord)o2).getUser().getDisplayId());
            }
            catch (ParseException e) {
                return Collator.getInstance().compare(((EnrollmentRecord)o1).getUser().getDisplayId(), ((EnrollmentRecord)o2).getUser().getDisplayId());
            }
        }
    };
    public static final Comparator ENROLLMENT_DISPLAY_UID_NUMERIC_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            long user1DisplayId = Long.parseLong(((EnrollmentRecord)o1).getUser().getDisplayId());
            long user2DisplayId = Long.parseLong(((EnrollmentRecord)o2).getUser().getDisplayId());
            return (int)(user1DisplayId - user2DisplayId);
        }
    };

    private FacadeUtils() {
    }

    public static Set getStudentUids(Collection enrollments) {
        HashSet<String> studentUids = new HashSet<String>();
        for (EnrollmentRecord enr : enrollments) {
            studentUids.add(enr.getUser().getUserUid());
        }
        return studentUids;
    }
}

