/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.integration.helper.integrated;

import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.assessment.integration.helper.ifc.GradebookHelper;
import org.sakaiproject.tool.cover.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradebookHelperImpl
implements GradebookHelper {
    private static final Logger log = LoggerFactory.getLogger(GradebookHelperImpl.class);

    @Override
    public String getGradebookUId(String siteId) {
        Placement placement = null;
        try {
            placement = ToolManager.getInstance().getCurrentPlacement();
        }
        catch (Exception ex) {
            log.warn(ex.getMessage(), (Throwable)ex);
            placement = null;
        }
        if (placement == null) {
            log.warn("getGradebookUId() - no tool placement found, probably taking an assessment via URL.");
            if (siteId == null) {
                log.warn("getGradebookUId() - siteId is null too.");
                return null;
            }
            return siteId;
        }
        String context = placement.getContext();
        return context;
    }

    @Override
    public String getDefaultGradebookUId() {
        return "Test Gradebook #1";
    }
}

