/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.services;

import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.samigo.api.SamigoETSProvider;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.assessment.services.GradingService;
import org.sakaiproject.tool.cover.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSubmitAssessmentsJob
implements StatefulJob {
    private static final Logger log = LoggerFactory.getLogger(AutoSubmitAssessmentsJob.class);
    protected String serverName = "unknown";
    private AuthzGroupService authzGroupService;
    private SamigoETSProvider etsProvider;

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setSamigoETSProvider(SamigoETSProvider value) {
        this.etsProvider = value;
    }

    public void init() {
        log.debug("AutoSubmitAssessmentsJob init()  ");
    }

    public void destroy() {
        log.debug("AutoSubmitAssessmentsJob destroy()");
    }

    public void execute(JobExecutionContext jobInfo) throws JobExecutionException {
        this.loginToSakai("admin");
        String jobName = jobInfo.getJobDetail().getKey().getName();
        String triggerName = jobInfo.getTrigger().getKey().getName();
        Date requestedFire = jobInfo.getScheduledFireTime();
        Date actualfire = jobInfo.getFireTime();
        StringBuffer whoAmI = new StringBuffer("AutoSubmitAssessmentsJob $");
        whoAmI.append(" Job: ");
        whoAmI.append(jobName);
        whoAmI.append(" Trigger: ");
        whoAmI.append(triggerName);
        if (requestedFire != null) {
            whoAmI.append(" Fire scheduled: ");
            whoAmI.append(requestedFire.toString());
        }
        if (actualfire != null) {
            whoAmI.append(" Fire actual: ");
            whoAmI.append(actualfire.toString());
        }
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.auto-submit.job", (String)AutoSubmitAssessmentsJob.safeEventLength(whoAmI.toString()), (boolean)true));
        log.info("Start Job: " + whoAmI.toString());
        GradingService gradingService = new GradingService();
        int failures = gradingService.autoSubmitAssessments();
        if (failures > 0) {
            this.etsProvider.notifyAutoSubmitFailures(failures);
        }
        log.info("End Job: " + whoAmI.toString() + " (" + failures + " failures)");
        this.logoutFromSakai();
    }

    protected void loginToSakai(String whoAs) {
        this.serverName = ServerConfigurationService.getServerName();
        log.debug(" AutoSubmitAssessmentsJob Logging into Sakai on " + this.serverName + " as " + whoAs);
        UsageSession session = UsageSessionService.startSession((String)whoAs, (String)this.serverName, (String)"AutoSubmitAssessmentsJob");
        if (session == null) {
            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"sam.auto-submit.job.error", (String)(whoAs + " unable to log into " + this.serverName), (boolean)true));
            return;
        }
        Session sakaiSession = SessionManager.getCurrentSession();
        sakaiSession.setUserId(whoAs);
        sakaiSession.setUserEid(whoAs);
        this.authzGroupService.refreshUser(whoAs);
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)UsageSessionService.EVENT_LOGIN, (String)(whoAs + " running " + this.serverName), (boolean)true));
    }

    protected void logoutFromSakai() {
        String serverName = ServerConfigurationService.getServerName();
        log.debug(" AutoSubmitAssessmentsJob Logging out of Sakai on " + serverName);
        EventTrackingService.post((Event)EventTrackingService.newEvent((String)UsageSessionService.EVENT_LOGOUT, null, (boolean)true));
        UsageSessionService.logout();
    }

    public static final String safeEventLength(String target) {
        return target.length() > 255 ? target.substring(0, 255) : target;
    }
}

