/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.assessment.entity.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.assessment.data.dao.assessment.ItemTag;
import org.sakaiproject.tool.assessment.data.ifc.assessment.AnswerIfc;
import org.sakaiproject.tool.assessment.data.ifc.assessment.ItemTextIfc;
import org.sakaiproject.tool.assessment.data.ifc.shared.TypeIfc;
import org.sakaiproject.tool.assessment.entity.api.ItemEntityProvider;
import org.sakaiproject.tool.assessment.facade.AssessmentFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.ItemFacade;
import org.sakaiproject.tool.assessment.facade.ItemFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.facade.QuestionPoolFacadeQueriesAPI;
import org.sakaiproject.tool.assessment.services.assessment.AssessmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemEntityProviderImpl
implements ItemEntityProvider,
CoreEntityProvider,
AutoRegisterEntityProvider {
    private static final Logger log = LoggerFactory.getLogger(ItemEntityProviderImpl.class);
    private ItemFacadeQueriesAPI itemFacadeQueries;
    private DeveloperHelperService developerHelperService;
    private QuestionPoolFacadeQueriesAPI questionPoolFacadeQueries;
    private AssessmentFacadeQueriesAPI assessmentFacadeQueries;
    private AssessmentService assessmentService = new AssessmentService();
    private SiteService siteService;
    public static final String ENTITY_PREFIX = "sam_item";

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public boolean entityExists(String ref) {
        try {
            long itemId = Long.parseLong(this.getItemIdFromOriginalReference(ref));
            return this.itemFacadeQueries.itemExists(itemId);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object getEntity(EntityReference ref) {
        try {
            if (this.entityExists(ref.getOriginalReference())) {
                long itemId = Long.parseLong(this.getItemIdFromOriginalReference(ref.getOriginalReference()));
                ItemFacade item = this.itemFacadeQueries.getItem(itemId);
                return item;
            }
            return null;
        }
        catch (Exception e) {
            log.warn("No entity found: " + ref);
            return null;
        }
    }

    private String getItemIdFromOriginalReference(String originalReference) {
        if (originalReference.contains("/sam_item/")) {
            return originalReference.substring(originalReference.indexOf("/sam_item/") + 10);
        }
        if (originalReference.contains(" itemId=")) {
            return originalReference.substring(originalReference.indexOf(" itemId=") + 8);
        }
        return originalReference;
    }

    public Map<String, String> getProperties(String reference) {
        HashMap<String, String> props = new HashMap<String, String>();
        return props;
    }

    public List<String> questionPoolIds(ItemFacade item) {
        Long itemID = item.getItemId();
        String itemIdSting = itemID.toString();
        List questionPoolIdsItem = this.questionPoolFacadeQueries.getPoolIdsByItem(itemIdSting);
        ArrayList<String> questionPoolIds = new ArrayList<String>();
        if (!questionPoolIdsItem.isEmpty()) {
            Iterator iterator = questionPoolIdsItem.iterator();
            while (iterator.hasNext()) {
                String qpi = iterator.next().toString();
                questionPoolIds.add(qpi);
            }
        }
        return questionPoolIds;
    }

    public List<String> siteIds(ItemFacade item) {
        Long assessmentId = this.itemFacadeQueries.getAssessmentId(item.getItemId());
        ArrayList<String> siteIds = new ArrayList<String>();
        String siteId = null;
        if (assessmentId > 0L) {
            siteId = this.assessmentFacadeQueries.getAssessmentSiteId(Long.toString(assessmentId));
        }
        if (siteId != null) {
            siteIds.add(siteId);
        }
        return siteIds;
    }

    public List<String> tags(ItemFacade item) {
        ArrayList<String> tags = new ArrayList<String>();
        Set itemTagSet = item.getItemTagSet();
        for (ItemTag tag : itemTagSet) {
            if (tags.contains(tag.getTagLabel())) continue;
            tags.add(tag.getTagLabel() + "(" + tag.getTagCollectionName() + ")");
        }
        return tags;
    }

    public String assessmentId(ItemFacade item) {
        Long assessmentId = this.itemFacadeQueries.getAssessmentId(item.getItemId());
        if (assessmentId > 0L) {
            return Long.toString(assessmentId);
        }
        return null;
    }

    public String content(ItemFacade item) {
        String content = "";
        if (item.getTypeId().equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) {
            if (!StringUtils.isEmpty((CharSequence)item.getThemeText())) {
                content = content + item.getThemeText();
            }
            if (!StringUtils.isEmpty((CharSequence)item.getLeadInText())) {
                content = content + this.separator(content) + item.getLeadInText();
            }
        } else if (!StringUtils.isEmpty((CharSequence)item.getInstruction())) {
            content = content + item.getInstruction();
        }
        if (!StringUtils.isEmpty((CharSequence)item.getDescription())) {
            content = content + this.separator(content) + item.getDescription();
        }
        if (item.getTypeId().equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) {
            if (item.getIsAnswerOptionsSimple()) {
                List emiAnswerOptions = item.getEmiAnswerOptions();
                for (AnswerIfc answerIfc : emiAnswerOptions) {
                    if (StringUtils.isEmpty((CharSequence)answerIfc.getText())) continue;
                    content = content + this.separator(content) + answerIfc.getText();
                }
            }
            if (item.getIsAnswerOptionsRich() && !StringUtils.isEmpty((CharSequence)item.getEmiAnswerOptionsRichText())) {
                content = content + this.separator(content) + item.getEmiAnswerOptionsRichText();
            }
            List itemTextIfcs = item.getEmiQuestionAnswerCombinations();
            for (ItemTextIfc itemTextIfc : itemTextIfcs) {
                if (StringUtils.isEmpty((CharSequence)itemTextIfc.getText())) continue;
                content = content + this.separator(content) + itemTextIfc.getText();
            }
        } else {
            ArrayList itemTextArraySorted = item.getItemTextArraySorted();
            for (ItemTextIfc itemTextIfc : itemTextArraySorted) {
                if (!item.getTypeId().equals(TypeIfc.CALCULATED_QUESTION) && !StringUtils.isEmpty((CharSequence)itemTextIfc.getText())) {
                    content = content + this.separator(content) + itemTextIfc.getText();
                }
                if (!item.getTypeId().equals(TypeIfc.MULTIPLE_CHOICE) && !item.getTypeId().equals(TypeIfc.FILL_IN_BLANK) && !item.getTypeId().equals(TypeIfc.MATCHING) && !item.getTypeId().equals(TypeIfc.FILL_IN_NUMERIC) && !item.getTypeId().equals(TypeIfc.MULTIPLE_CORRECT_SINGLE_SELECTION) && !item.getTypeId().equals(TypeIfc.MATRIX_CHOICES_SURVEY) && !item.getTypeId().equals(TypeIfc.EXTENDED_MATCHING_ITEMS)) continue;
                List answerArraySorted = itemTextIfc.getAnswerArraySorted();
                for (AnswerIfc answerIfc : answerArraySorted) {
                    if (StringUtils.isEmpty((CharSequence)answerIfc.getText()) || item.getTypeId().equals(TypeIfc.MATCHING) && !answerIfc.getIsCorrect().booleanValue()) continue;
                    content = content + this.separator(content) + answerIfc.getText();
                }
            }
        }
        log.debug("This is the questions content: " + content);
        return content;
    }

    public String separator(String content) {
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            return ". ";
        }
        return "";
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"json"};
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        return null;
    }

    public Object getSampleEntity() {
        return null;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
    }

    public String getPropertyValue(String reference, String name) {
        Map<String, String> props = this.getProperties(reference);
        return props.get(name);
    }

    public void setPropertyValue(String reference, String name, String value) {
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    public ItemFacadeQueriesAPI getItemFacadeQueries() {
        return this.itemFacadeQueries;
    }

    public void setItemFacadeQueries(ItemFacadeQueriesAPI itemFacadeQueries) {
        this.itemFacadeQueries = itemFacadeQueries;
    }

    public QuestionPoolFacadeQueriesAPI getQuestionPoolFacadeQueries() {
        return this.questionPoolFacadeQueries;
    }

    public void setQuestionPoolFacadeQueries(QuestionPoolFacadeQueriesAPI questionPoolFacadeQueries) {
        this.questionPoolFacadeQueries = questionPoolFacadeQueries;
    }

    public AssessmentFacadeQueriesAPI getAssessmentFacadeQueries() {
        return this.assessmentFacadeQueries;
    }

    public void setAssessmentFacadeQueries(AssessmentFacadeQueriesAPI assessmentFacadeQueries) {
        this.assessmentFacadeQueries = assessmentFacadeQueries;
    }

    public SiteService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

